/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.SpellDictionaryDichoDisk;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SpellDictionaryCachedDichoDisk
extends SpellDictionaryDichoDisk {
    public static int hits = 0;
    public static int codes = 0;
    public static final String JAZZY_DIR = ".jazzy";
    public static final String PRE_CACHE_FILE_EXT = ".pre";
    private static int MAX_CACHED = 10000;
    private HashMap suggestionCache = new HashMap(MAX_CACHED);
    private String preCacheFileName;
    private String preCacheDir;

    public SpellDictionaryCachedDichoDisk(File file) throws FileNotFoundException, IOException {
        super(file);
        this.loadPreCache(file);
    }

    public SpellDictionaryCachedDichoDisk(File file, String string) throws FileNotFoundException, IOException {
        super(file, string);
        this.loadPreCache(file);
    }

    public SpellDictionaryCachedDichoDisk(File file, File file2) throws FileNotFoundException, IOException {
        super(file, file2);
        this.loadPreCache(file);
    }

    public SpellDictionaryCachedDichoDisk(File file, File file2, String string) throws FileNotFoundException, IOException {
        super(file, file2, string);
        this.loadPreCache(file);
    }

    public void addWord(String string) {
        System.err.println("error: addWord is not implemented for SpellDictionaryCachedDichoDisk");
    }

    public void clearCache() {
        this.suggestionCache.clear();
    }

    public List getWords(String string) {
        ++codes;
        if (this.suggestionCache.containsKey(string)) {
            ++hits;
            List list = this.getCachedList(string);
            return list;
        }
        List list = super.getWords(string);
        this.addToCache(string, list);
        return list;
    }

    private List getCachedList(String string) {
        CacheObject cacheObject = (CacheObject)this.suggestionCache.get(string);
        cacheObject.setRefTime();
        return cacheObject.getSuggestionList();
    }

    private void addToCache(String string, List list) {
        String string22 = null;
        String string3 = null;
        long l = Long.MAX_VALUE;
        if (this.suggestionCache.size() >= MAX_CACHED) {
            for (String string22 : this.suggestionCache.keySet()) {
                CacheObject cacheObject = (CacheObject)this.suggestionCache.get(string22);
                if (cacheObject.getRefTime() == 0L) {
                    string3 = string22;
                    break;
                }
                if (l <= cacheObject.getRefTime()) continue;
                string3 = string22;
                l = cacheObject.getRefTime();
            }
            this.suggestionCache.remove(string3);
        }
        this.suggestionCache.put(string, new CacheObject(list));
    }

    private void loadPreCache(File file) throws IOException {
        this.preCacheDir = System.getProperty("user.home") + "/" + JAZZY_DIR;
        this.preCacheFileName = this.preCacheDir + "/" + file.getName() + PRE_CACHE_FILE_EXT;
        File file2 = new File(this.preCacheFileName);
        if (!file2.exists()) {
            System.err.println("No precache file");
            return;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file2));
        try {
            long l = objectInputStream.readLong();
            int n = 0;
            while ((long)n < l) {
                String string = (String)objectInputStream.readObject();
                long l2 = objectInputStream.readLong();
                List list = (List)objectInputStream.readObject();
                this.suggestionCache.put(string, new CacheObject(list, l2));
                ++n;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException.getMessage());
        }
        objectInputStream.close();
    }

    public void saveCache() throws IOException {
        if (this.preCacheFileName == null || this.preCacheDir == null) {
            System.err.println("Precache filename has not been set.");
            return;
        }
        File file = new File(this.preCacheDir);
        if (!file.exists()) {
            file.mkdir();
        }
        File file2 = new File(this.preCacheFileName);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
        Iterator iterator = this.suggestionCache.keySet().iterator();
        objectOutputStream.writeLong(this.suggestionCache.size());
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            CacheObject cacheObject = (CacheObject)this.suggestionCache.get(string);
            objectOutputStream.writeObject(string);
            objectOutputStream.writeLong(cacheObject.getRefTime());
            objectOutputStream.writeObject(cacheObject.getSuggestionList());
        }
        objectOutputStream.close();
    }

    private class CacheObject
    implements Serializable {
        private List suggestions = null;
        private long refTime = 0L;

        public CacheObject(List list) {
            this.suggestions = list;
        }

        public CacheObject(List list, long l) {
            this.suggestions = list;
            this.refTime = l;
        }

        public List getSuggestionList() {
            return this.suggestions;
        }

        public void setRefTime() {
            this.refTime = System.currentTimeMillis();
        }

        public long getRefTime() {
            return this.refTime;
        }
    }
}

