/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.apache.activemq.jms.pool.PooledSession;
import org.apache.activemq.jms.pool.PooledSessionEventListener;
import org.apache.activemq.jms.pool.SessionHolder;
import org.apache.activemq.jms.pool.SessionKey;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool
implements ExceptionListener {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConnectionPool.class);
    protected Connection connection;
    private int referenceCount;
    private long lastUsed;
    private final long firstUsed;
    private boolean hasExpired;
    private int idleTimeout;
    private long expiryTimeout;
    private boolean useAnonymousProducers;
    private final AtomicBoolean started;
    private final GenericKeyedObjectPool<SessionKey, SessionHolder> sessionPool;
    private final List<PooledSession> loanedSessions;
    private boolean reconnectOnException;
    private ExceptionListener parentExceptionListener;

    public ConnectionPool(Connection connection) {
        this.firstUsed = this.lastUsed = System.currentTimeMillis();
        this.idleTimeout = 30000;
        this.expiryTimeout = 0L;
        this.useAnonymousProducers = true;
        this.started = new AtomicBoolean(false);
        this.loanedSessions = new CopyOnWriteArrayList<PooledSession>();
        GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
        poolConfig.setJmxEnabled(false);
        this.connection = this.wrap(connection);
        try {
            this.connection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException ex) {
            LOG.warn("Could not set exception listener on create of ConnectionPool");
        }
        this.sessionPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new KeyedPooledObjectFactory<SessionKey, SessionHolder>(){

            public PooledObject<SessionHolder> makeObject(SessionKey sessionKey) throws Exception {
                return new DefaultPooledObject((Object)new SessionHolder(ConnectionPool.this.makeSession(sessionKey)));
            }

            public void destroyObject(SessionKey sessionKey, PooledObject<SessionHolder> pooledObject) throws Exception {
                ((SessionHolder)pooledObject.getObject()).close();
            }

            public boolean validateObject(SessionKey sessionKey, PooledObject<SessionHolder> pooledObject) {
                return true;
            }

            public void activateObject(SessionKey sessionKey, PooledObject<SessionHolder> pooledObject) throws Exception {
            }

            public void passivateObject(SessionKey sessionKey, PooledObject<SessionHolder> pooledObject) throws Exception {
            }
        }, poolConfig);
    }

    public void setHasExpired(boolean val) {
        this.hasExpired = val;
    }

    protected Session makeSession(SessionKey key) throws JMSException {
        return this.connection.createSession(key.isTransacted(), key.getAckMode());
    }

    protected Connection wrap(Connection connection) {
        return connection;
    }

    protected void unWrap(Connection connection) {
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                this.started.set(false);
                throw e;
            }
        }
    }

    public synchronized Connection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        PooledSession session;
        SessionKey key = new SessionKey(transacted, ackMode);
        try {
            session = new PooledSession(key, (SessionHolder)this.sessionPool.borrowObject((Object)key), (KeyedObjectPool<SessionKey, SessionHolder>)this.sessionPool, key.isTransacted(), this.useAnonymousProducers);
            session.addSessionEventListener(new PooledSessionEventListener(){

                @Override
                public void onTemporaryTopicCreate(TemporaryTopic tempTopic) {
                }

                @Override
                public void onTemporaryQueueCreate(TemporaryQueue tempQueue) {
                }

                @Override
                public void onSessionClosed(PooledSession session) {
                    ConnectionPool.this.loanedSessions.remove(session);
                }
            });
            this.loanedSessions.add(session);
        }
        catch (Exception e) {
            IllegalStateException illegalStateException = new IllegalStateException(e.toString());
            illegalStateException.initCause((Throwable)e);
            throw illegalStateException;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.connection != null) {
            try {
                this.sessionPool.close();
            }
            catch (Exception exception) {
                try {
                    this.connection.close();
                }
                catch (Exception exception2) {
                }
                finally {
                    this.connection = null;
                }
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
        if (this.referenceCount == 0) {
            for (PooledSession session : this.loanedSessions) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
            this.loanedSessions.clear();
            this.unWrap(this.getConnection());
            this.expiredCheck();
        }
    }

    public synchronized boolean expiredCheck() {
        boolean expired = false;
        if (this.connection == null) {
            return true;
        }
        if (this.hasExpired && this.referenceCount == 0) {
            this.close();
            expired = true;
        }
        if (this.expiryTimeout > 0L && System.currentTimeMillis() > this.firstUsed + this.expiryTimeout) {
            this.hasExpired = true;
            if (this.referenceCount == 0) {
                this.close();
                expired = true;
            }
        }
        if (this.referenceCount == 0 && this.idleTimeout > 0 && System.currentTimeMillis() > this.lastUsed + (long)this.idleTimeout) {
            this.hasExpired = true;
            this.close();
            expired = true;
        }
        return expired;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }

    public int getMaximumActiveSessionPerConnection() {
        return this.sessionPool.getMaxTotalPerKey();
    }

    public void setMaximumActiveSessionPerConnection(int maximumActiveSessionPerConnection) {
        this.sessionPool.setMaxTotalPerKey(maximumActiveSessionPerConnection);
    }

    public boolean isUseAnonymousProducers() {
        return this.useAnonymousProducers;
    }

    public void setUseAnonymousProducers(boolean value) {
        this.useAnonymousProducers = value;
    }

    public int getNumSessions() {
        return this.sessionPool.getNumIdle() + this.sessionPool.getNumActive();
    }

    public int getNumIdleSessions() {
        return this.sessionPool.getNumIdle();
    }

    public int getNumActiveSessions() {
        return this.sessionPool.getNumActive();
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.sessionPool.setBlockWhenExhausted(block);
    }

    public boolean isBlockIfSessionPoolIsFull() {
        return this.sessionPool.getBlockWhenExhausted();
    }

    public long getBlockIfSessionPoolIsFullTimeout() {
        return this.sessionPool.getMaxWaitMillis();
    }

    public void setBlockIfSessionPoolIsFullTimeout(long blockIfSessionPoolIsFullTimeout) {
        this.sessionPool.setMaxWaitMillis(blockIfSessionPoolIsFullTimeout);
    }

    public boolean isReconnectOnException() {
        return this.reconnectOnException;
    }

    public void setReconnectOnException(boolean reconnectOnException) {
        this.reconnectOnException = reconnectOnException;
    }

    ExceptionListener getParentExceptionListener() {
        return this.parentExceptionListener;
    }

    void setParentExceptionListener(ExceptionListener parentExceptionListener) {
        this.parentExceptionListener = parentExceptionListener;
    }

    public void onException(JMSException exception) {
        if (this.isReconnectOnException()) {
            this.close();
        }
        if (this.parentExceptionListener != null) {
            this.parentExceptionListener.onException(exception);
        }
    }

    public String toString() {
        return "ConnectionPool[" + this.connection + "]";
    }
}

