require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_EXTERN_H_)) {
    eval 'sub _UVM_UVM_EXTERN_H_ () {1;}' unless defined(&_UVM_UVM_EXTERN_H_);
    eval 'sub PROT_MASK () {( &PROT_READ |  &PROT_WRITE |  &PROT_EXEC);}' unless defined(&PROT_MASK);
    eval 'sub MAP_INHERIT_MASK () {0x3;}' unless defined(&MAP_INHERIT_MASK);
    eval 'sub MADV_MASK () {0x7;}' unless defined(&MADV_MASK);
    eval 'sub UVM_FLAG_FIXED () {0x10000;}' unless defined(&UVM_FLAG_FIXED);
    eval 'sub UVM_FLAG_OVERLAY () {0x20000;}' unless defined(&UVM_FLAG_OVERLAY);
    eval 'sub UVM_FLAG_NOMERGE () {0x40000;}' unless defined(&UVM_FLAG_NOMERGE);
    eval 'sub UVM_FLAG_COPYONW () {0x80000;}' unless defined(&UVM_FLAG_COPYONW);
    eval 'sub UVM_FLAG_TRYLOCK () {0x100000;}' unless defined(&UVM_FLAG_TRYLOCK);
    eval 'sub UVM_FLAG_HOLE () {0x200000;}' unless defined(&UVM_FLAG_HOLE);
    eval 'sub UVM_FLAG_QUERY () {0x400000;}' unless defined(&UVM_FLAG_QUERY);
    eval 'sub UVM_FLAG_NOFAULT () {0x800000;}' unless defined(&UVM_FLAG_NOFAULT);
    eval 'sub UVM_FLAG_UNMAP () {0x1000000;}' unless defined(&UVM_FLAG_UNMAP);
    eval 'sub UVM_PROTECTION {
        my($X) = @_;
	    eval q((($X) &  &PROT_MASK));
    }' unless defined(&UVM_PROTECTION);
    eval 'sub UVM_INHERIT {
        my($X) = @_;
	    eval q(((($X) >> 4) &  &MAP_INHERIT_MASK));
    }' unless defined(&UVM_INHERIT);
    eval 'sub UVM_MAXPROTECTION {
        my($X) = @_;
	    eval q(((($X) >> 8) &  &PROT_MASK));
    }' unless defined(&UVM_MAXPROTECTION);
    eval 'sub UVM_ADVICE {
        my($X) = @_;
	    eval q(((($X) >> 12) &  &MADV_MASK));
    }' unless defined(&UVM_ADVICE);
    eval 'sub UVM_MAPFLAG {
        my($prot, $maxprot, $inh, $advice, $flags) = @_;
	    eval q((($prot) | (($maxprot) << 8) | (($inh) << 4) | (($advice) << 12) | ($flags)));
    }' unless defined(&UVM_MAPFLAG);
    eval 'sub UVM_UNKNOWN_OFFSET () {(( &voff_t) -1);}' unless defined(&UVM_UNKNOWN_OFFSET);
    eval 'sub UVM_KMF_NOWAIT () {0x1;}' unless defined(&UVM_KMF_NOWAIT);
    eval 'sub UVM_KMF_VALLOC () {0x2;}' unless defined(&UVM_KMF_VALLOC);
    eval 'sub UVM_KMF_CANFAIL () {0x4;}' unless defined(&UVM_KMF_CANFAIL);
    eval 'sub UVM_KMF_ZERO () {0x8;}' unless defined(&UVM_KMF_ZERO);
    eval 'sub UVM_KMF_TRYLOCK () { &UVM_FLAG_TRYLOCK;}' unless defined(&UVM_KMF_TRYLOCK);
    eval 'sub UVM_PGA_USERESERVE () {0x1;}' unless defined(&UVM_PGA_USERESERVE);
    eval 'sub UVM_PGA_ZERO () {0x2;}' unless defined(&UVM_PGA_ZERO);
    eval 'sub UVM_PLA_WAITOK () {0x1;}' unless defined(&UVM_PLA_WAITOK);
    eval 'sub UVM_PLA_NOWAIT () {0x2;}' unless defined(&UVM_PLA_NOWAIT);
    eval 'sub UVM_PLA_ZERO () {0x4;}' unless defined(&UVM_PLA_ZERO);
    eval 'sub UVM_PLA_TRYCONTIG () {0x8;}' unless defined(&UVM_PLA_TRYCONTIG);
    eval 'sub UVM_PLA_FAILOK () {0x10;}' unless defined(&UVM_PLA_FAILOK);
    eval 'sub UVM_LK_ENTER () {0x1;}' unless defined(&UVM_LK_ENTER);
    eval 'sub UVM_LK_EXIT () {0x2;}' unless defined(&UVM_LK_EXIT);
    eval 'sub PHYSLOAD_DEVICE () {0x1;}' unless defined(&PHYSLOAD_DEVICE);
    require 'sys/queue.ph';
    require 'sys/tree.ph';
    require 'sys/mman.ph';
    if(defined(&_KERNEL)) {
    }
    require 'uvm/uvm_param.ph';
    require 'uvm/uvm_pmap.ph';
    require 'uvm/uvm_object.ph';
    require 'uvm/uvm_page.ph';
    require 'uvm/uvm_map.ph';
    if(defined(&_KERNEL)) {
	require 'uvm/uvm_fault.ph';
	require 'uvm/uvm_pager.ph';
    }
    eval 'sub vm_startcopy () { &vm_rssize;}' unless defined(&vm_startcopy);
    if(defined(&_KERNEL)) {
	require 'uvm/uvmexp.ph';
	eval 'sub UVM_COREDUMP_STACK () {0x1;}' unless defined(&UVM_COREDUMP_STACK);
	eval 'sub uvm_km_zalloc {
	    my($MAP,$SIZE) = @_;
    	    eval q( &uvm_km_alloc1($MAP,$SIZE,0, &TRUE));
	}' unless defined(&uvm_km_zalloc);
	eval 'sub uvm_km_alloc {
	    my($MAP,$SIZE) = @_;
    	    eval q( &uvm_km_alloc1($MAP,$SIZE,0, &FALSE));
	}' unless defined(&uvm_km_alloc);
	eval 'sub vm_resident_count {
	    my($vm) = @_;
    	    eval q(( &pmap_resident_count(($vm)-> ($vm_map->{pmap}))));
	}' unless defined(&vm_resident_count);
	if(defined(&KGDB)) {
	}
	eval 'sub UVM_IO_FIXPROT () {0x1;}' unless defined(&UVM_IO_FIXPROT);
	eval 'sub uvm_km_kmemalloc {
	    my($map, $obj, $sz, $flags) = @_;
    	    eval q( &uvm_km_kmemalloc_pla($map, $obj, $sz, 0, $flags, 0, ( &paddr_t)-1, 0, 0, 0));
	}' unless defined(&uvm_km_kmemalloc);
	eval 'sub KMEM_DYN_INITIALIZER () {{  &UVM_UNKNOWN_OFFSET,  &NULL, 0, 0};}' unless defined(&KMEM_DYN_INITIALIZER);
    }
}
1;
