require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_ARMREG_H)) {
    eval 'sub _ARM_ARMREG_H () {1;}' unless defined(&_ARM_ARMREG_H);
    eval 'sub PSR_FLAGS () {0xf0000000;}' unless defined(&PSR_FLAGS);
    eval 'sub PSR_N () {(1 << 31);}' unless defined(&PSR_N);
    eval 'sub PSR_Z () {(1<< 30);}' unless defined(&PSR_Z);
    eval 'sub PSR_C () {(1<< 29);}' unless defined(&PSR_C);
    eval 'sub PSR_V () {(1<< 28);}' unless defined(&PSR_V);
    eval 'sub PSR_Q () {(1<< 27);}' unless defined(&PSR_Q);
    eval 'sub PSR_A () {(1<< 8);}' unless defined(&PSR_A);
    eval 'sub PSR_I () {(1<< 7);}' unless defined(&PSR_I);
    eval 'sub PSR_F () {(1<< 6);}' unless defined(&PSR_F);
    eval 'sub PSR_T () {(1<< 5);}' unless defined(&PSR_T);
    eval 'sub PSR_J () {(1<< 24);}' unless defined(&PSR_J);
    eval 'sub PSR_MODE () {0x1f;}' unless defined(&PSR_MODE);
    eval 'sub PSR_USR26_MODE () {0x;}' unless defined(&PSR_USR26_MODE);
    eval 'sub PSR_FIQ26_MODE () {0x1;}' unless defined(&PSR_FIQ26_MODE);
    eval 'sub PSR_IRQ26_MODE () {0x2;}' unless defined(&PSR_IRQ26_MODE);
    eval 'sub PSR_SVC26_MODE () {0x3;}' unless defined(&PSR_SVC26_MODE);
    eval 'sub PSR_USR32_MODE () {0x10;}' unless defined(&PSR_USR32_MODE);
    eval 'sub PSR_FIQ32_MODE () {0x11;}' unless defined(&PSR_FIQ32_MODE);
    eval 'sub PSR_IRQ32_MODE () {0x12;}' unless defined(&PSR_IRQ32_MODE);
    eval 'sub PSR_SVC32_MODE () {0x13;}' unless defined(&PSR_SVC32_MODE);
    eval 'sub PSR_MON32_MODE () {0x16;}' unless defined(&PSR_MON32_MODE);
    eval 'sub PSR_ABT32_MODE () {0x17;}' unless defined(&PSR_ABT32_MODE);
    eval 'sub PSR_HYP32_MODE () {0x1a;}' unless defined(&PSR_HYP32_MODE);
    eval 'sub PSR_UND32_MODE () {0x1b;}' unless defined(&PSR_UND32_MODE);
    eval 'sub PSR_SYS32_MODE () {0x1f;}' unless defined(&PSR_SYS32_MODE);
    eval 'sub PSR_32_MODE () {0x10;}' unless defined(&PSR_32_MODE);
    eval 'sub PSR_IN_USR_MODE {
        my($psr) = @_;
	    eval q((!(($psr) & 3)));
    }' unless defined(&PSR_IN_USR_MODE);
    eval 'sub ARM_CP15_CPU_ID () {0;}' unless defined(&ARM_CP15_CPU_ID);
    eval 'sub CPU_ID_IMPLEMENTOR_MASK () {0xff000000;}' unless defined(&CPU_ID_IMPLEMENTOR_MASK);
    eval 'sub CPU_ID_ARM_LTD () {0x41000000;}' unless defined(&CPU_ID_ARM_LTD);
    eval 'sub CPU_ID_INTEL () {0x69000000;}' unless defined(&CPU_ID_INTEL);
    eval 'sub CPU_ID_ARCH_MASK () {0xf0000;}' unless defined(&CPU_ID_ARCH_MASK);
    eval 'sub CPU_ID_ARCH_V5TE () {0x50000;}' unless defined(&CPU_ID_ARCH_V5TE);
    eval 'sub CPU_ID_ARCH_V5TEJ () {0x60000;}' unless defined(&CPU_ID_ARCH_V5TEJ);
    eval 'sub CPU_ID_ARCH_V6 () {0x70000;}' unless defined(&CPU_ID_ARCH_V6);
    eval 'sub CPU_ID_ARCH_CPUID () {0xf0000;}' unless defined(&CPU_ID_ARCH_CPUID);
    eval 'sub CPU_ID_VARIANT_MASK () {0xf00000;}' unless defined(&CPU_ID_VARIANT_MASK);
    eval 'sub CPU_ID_PARTNO_MASK () {0xfff0;}' unless defined(&CPU_ID_PARTNO_MASK);
    eval 'sub CPU_ID_XSCALE_COREGEN_MASK () {0xe000;}' unless defined(&CPU_ID_XSCALE_COREGEN_MASK);
    eval 'sub CPU_ID_XSCALE_COREREV_MASK () {0x1c00;}' unless defined(&CPU_ID_XSCALE_COREREV_MASK);
    eval 'sub CPU_ID_XSCALE_PRODUCT_MASK () {0x3f0;}' unless defined(&CPU_ID_XSCALE_PRODUCT_MASK);
    eval 'sub CPU_ID_REVISION_MASK () {0xf;}' unless defined(&CPU_ID_REVISION_MASK);
    eval 'sub CPU_ID_CPU_MASK () {0xfffffff0;}' unless defined(&CPU_ID_CPU_MASK);
    eval 'sub CPU_ID_PXA250 () {0x69052100;}' unless defined(&CPU_ID_PXA250);
    eval 'sub CPU_ID_PXA210 () {0x69052120;}' unless defined(&CPU_ID_PXA210);
    eval 'sub CPU_ID_PXA250A () {0x69052100;}' unless defined(&CPU_ID_PXA250A);
    eval 'sub CPU_ID_PXA210A () {0x69052120;}' unless defined(&CPU_ID_PXA210A);
    eval 'sub CPU_ID_PXA250B () {0x69052900;}' unless defined(&CPU_ID_PXA250B);
    eval 'sub CPU_ID_PXA210B () {0x69052920;}' unless defined(&CPU_ID_PXA210B);
    eval 'sub CPU_ID_PXA250C () {0x69052d00;}' unless defined(&CPU_ID_PXA250C);
    eval 'sub CPU_ID_PXA210C () {0x69052d20;}' unless defined(&CPU_ID_PXA210C);
    eval 'sub CPU_ID_80219_400 () {0x69052e20;}' unless defined(&CPU_ID_80219_400);
    eval 'sub CPU_ID_80219_600 () {0x69052e30;}' unless defined(&CPU_ID_80219_600);
    eval 'sub CPU_ID_PXA27X () {0x69054110;}' unless defined(&CPU_ID_PXA27X);
    eval 'sub CPU_ID_80321_400 () {0x69052420;}' unless defined(&CPU_ID_80321_400);
    eval 'sub CPU_ID_80321_600 () {0x69052430;}' unless defined(&CPU_ID_80321_600);
    eval 'sub CPU_ID_80321_400_B0 () {0x69052c20;}' unless defined(&CPU_ID_80321_400_B0);
    eval 'sub CPU_ID_80321_600_B0 () {0x69052c30;}' unless defined(&CPU_ID_80321_600_B0);
    eval 'sub CPU_ID_CORTEX_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_MASK);
    eval 'sub CPU_ID_CORTEX_A5 () {0x410fc050;}' unless defined(&CPU_ID_CORTEX_A5);
    eval 'sub CPU_ID_CORTEX_A5_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_A5_MASK);
    eval 'sub CPU_ID_CORTEX_A7 () {0x410fc070;}' unless defined(&CPU_ID_CORTEX_A7);
    eval 'sub CPU_ID_CORTEX_A7_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_A7_MASK);
    eval 'sub CPU_ID_CORTEX_A8_R1 () {0x411fc080;}' unless defined(&CPU_ID_CORTEX_A8_R1);
    eval 'sub CPU_ID_CORTEX_A8_R2 () {0x412fc080;}' unless defined(&CPU_ID_CORTEX_A8_R2);
    eval 'sub CPU_ID_CORTEX_A8_R3 () {0x413fc080;}' unless defined(&CPU_ID_CORTEX_A8_R3);
    eval 'sub CPU_ID_CORTEX_A8 () {0x410fc080;}' unless defined(&CPU_ID_CORTEX_A8);
    eval 'sub CPU_ID_CORTEX_A8_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_A8_MASK);
    eval 'sub CPU_ID_CORTEX_A9 () {0x410fc090;}' unless defined(&CPU_ID_CORTEX_A9);
    eval 'sub CPU_ID_CORTEX_A9_R1 () {0x411fc090;}' unless defined(&CPU_ID_CORTEX_A9_R1);
    eval 'sub CPU_ID_CORTEX_A9_R2 () {0x412fc090;}' unless defined(&CPU_ID_CORTEX_A9_R2);
    eval 'sub CPU_ID_CORTEX_A9_R3 () {0x413fc090;}' unless defined(&CPU_ID_CORTEX_A9_R3);
    eval 'sub CPU_ID_CORTEX_A9_R4 () {0x414fc090;}' unless defined(&CPU_ID_CORTEX_A9_R4);
    eval 'sub CPU_ID_CORTEX_A9_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_A9_MASK);
    eval 'sub CPU_ID_CORTEX_A15 () {0x410fc0f0;}' unless defined(&CPU_ID_CORTEX_A15);
    eval 'sub CPU_ID_CORTEX_A15_R1 () {0x411fc0f0;}' unless defined(&CPU_ID_CORTEX_A15_R1);
    eval 'sub CPU_ID_CORTEX_A15_R2 () {0x412fc0f0;}' unless defined(&CPU_ID_CORTEX_A15_R2);
    eval 'sub CPU_ID_CORTEX_A15_R3 () {0x413fc0f0;}' unless defined(&CPU_ID_CORTEX_A15_R3);
    eval 'sub CPU_ID_CORTEX_A15_R4 () {0x414fc0f0;}' unless defined(&CPU_ID_CORTEX_A15_R4);
    eval 'sub CPU_ID_CORTEX_A15_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_A15_MASK);
    eval 'sub CPU_ID_CORTEX_A17 () {0x410fc0e0;}' unless defined(&CPU_ID_CORTEX_A17);
    eval 'sub CPU_ID_CORTEX_A17_R1 () {0x411fc0e0;}' unless defined(&CPU_ID_CORTEX_A17_R1);
    eval 'sub CPU_ID_CORTEX_A17_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_A17_MASK);
    eval 'sub CPU_ID_CORTEX_A53 () {0x410fd030;}' unless defined(&CPU_ID_CORTEX_A53);
    eval 'sub CPU_ID_CORTEX_A53_R1 () {0x411fd030;}' unless defined(&CPU_ID_CORTEX_A53_R1);
    eval 'sub CPU_ID_CORTEX_A53_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_A53_MASK);
    eval 'sub CPU_ID_CORTEX_A57 () {0x410fd070;}' unless defined(&CPU_ID_CORTEX_A57);
    eval 'sub CPU_ID_CORTEX_A57_R1 () {0x411fd070;}' unless defined(&CPU_ID_CORTEX_A57_R1);
    eval 'sub CPU_ID_CORTEX_A57_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_A57_MASK);
    eval 'sub CPU_ID_CORTEX_A72 () {0x410fd080;}' unless defined(&CPU_ID_CORTEX_A72);
    eval 'sub CPU_ID_CORTEX_A72_R1 () {0x411fd080;}' unless defined(&CPU_ID_CORTEX_A72_R1);
    eval 'sub CPU_ID_CORTEX_A72_MASK () {0xff0ffff0;}' unless defined(&CPU_ID_CORTEX_A72_MASK);
    eval 'sub CPU_CONTROL_MMU_ENABLE () {0x1;}' unless defined(&CPU_CONTROL_MMU_ENABLE);
    eval 'sub CPU_CONTROL_AFLT_ENABLE () {0x2;}' unless defined(&CPU_CONTROL_AFLT_ENABLE);
    eval 'sub CPU_CONTROL_DC_ENABLE () {0x4;}' unless defined(&CPU_CONTROL_DC_ENABLE);
    eval 'sub CPU_CONTROL_WBUF_ENABLE () {0x8;}' unless defined(&CPU_CONTROL_WBUF_ENABLE);
    eval 'sub CPU_CONTROL_32BP_ENABLE () {0x10;}' unless defined(&CPU_CONTROL_32BP_ENABLE);
    eval 'sub CPU_CONTROL_32BD_ENABLE () {0x20;}' unless defined(&CPU_CONTROL_32BD_ENABLE);
    eval 'sub CPU_CONTROL_LABT_ENABLE () {0x40;}' unless defined(&CPU_CONTROL_LABT_ENABLE);
    eval 'sub CPU_CONTROL_BEND_ENABLE () {0x80;}' unless defined(&CPU_CONTROL_BEND_ENABLE);
    eval 'sub CPU_CONTROL_SYST_ENABLE () {0x100;}' unless defined(&CPU_CONTROL_SYST_ENABLE);
    eval 'sub CPU_CONTROL_ROM_ENABLE () {0x200;}' unless defined(&CPU_CONTROL_ROM_ENABLE);
    eval 'sub CPU_CONTROL_CPCLK () {0x400;}' unless defined(&CPU_CONTROL_CPCLK);
    eval 'sub CPU_CONTROL_BPRD_ENABLE () {0x800;}' unless defined(&CPU_CONTROL_BPRD_ENABLE);
    eval 'sub CPU_CONTROL_IC_ENABLE () {0x1000;}' unless defined(&CPU_CONTROL_IC_ENABLE);
    eval 'sub CPU_CONTROL_VECRELOC () {0x2000;}' unless defined(&CPU_CONTROL_VECRELOC);
    eval 'sub CPU_CONTROL_ROUNDROBIN () {0x4000;}' unless defined(&CPU_CONTROL_ROUNDROBIN);
    eval 'sub CPU_CONTROL_V4COMPAT () {0x8000;}' unless defined(&CPU_CONTROL_V4COMPAT);
    eval 'sub CPU_CONTROL_FI () {(1<<21);}' unless defined(&CPU_CONTROL_FI);
    eval 'sub CPU_CONTROL_U () {(1<<22);}' unless defined(&CPU_CONTROL_U);
    eval 'sub CPU_CONTROL_VE () {(1<<24);}' unless defined(&CPU_CONTROL_VE);
    eval 'sub CPU_CONTROL_EE () {(1<<25);}' unless defined(&CPU_CONTROL_EE);
    eval 'sub CPU_CONTROL_L2 () {(1<<25);}' unless defined(&CPU_CONTROL_L2);
    eval 'sub CPU_CONTROL_NMFI () {(1<<27);}' unless defined(&CPU_CONTROL_NMFI);
    eval 'sub CPU_CONTROL_TRE () {(1<<28);}' unless defined(&CPU_CONTROL_TRE);
    eval 'sub CPU_CONTROL_AFE () {(1<<29);}' unless defined(&CPU_CONTROL_AFE);
    eval 'sub CPU_CONTROL_TE () {(1<<30);}' unless defined(&CPU_CONTROL_TE);
    eval 'sub CPU_CONTROL_IDC_ENABLE () { &CPU_CONTROL_DC_ENABLE;}' unless defined(&CPU_CONTROL_IDC_ENABLE);
    eval 'sub XSCALE_AUXCTL_K () {0x1;}' unless defined(&XSCALE_AUXCTL_K);
    eval 'sub XSCALE_AUXCTL_P () {0x2;}' unless defined(&XSCALE_AUXCTL_P);
    eval 'sub XSCALE_AUXCTL_MD_WB_RA () {0x;}' unless defined(&XSCALE_AUXCTL_MD_WB_RA);
    eval 'sub XSCALE_AUXCTL_MD_WB_RWA () {0x10;}' unless defined(&XSCALE_AUXCTL_MD_WB_RWA);
    eval 'sub XSCALE_AUXCTL_MD_WT () {0x20;}' unless defined(&XSCALE_AUXCTL_MD_WT);
    eval 'sub XSCALE_AUXCTL_MD_MASK () {0x30;}' unless defined(&XSCALE_AUXCTL_MD_MASK);
    eval 'sub CPU_CT_ISIZE {
        my($x) = @_;
	    eval q((($x) & 0xfff));
    }' unless defined(&CPU_CT_ISIZE);
    eval 'sub CPU_CT_DSIZE {
        my($x) = @_;
	    eval q(((($x) >> 12) & 0xfff));
    }' unless defined(&CPU_CT_DSIZE);
    eval 'sub CPU_CT_S () {(1 << 24);}' unless defined(&CPU_CT_S);
    eval 'sub CPU_CT_CTYPE {
        my($x) = @_;
	    eval q(((($x) >> 25) & 0xf));
    }' unless defined(&CPU_CT_CTYPE);
    eval 'sub CPU_CT_IMINLINE {
        my($x) = @_;
	    eval q((($x) & 0xf));
    }' unless defined(&CPU_CT_IMINLINE);
    eval 'sub CPU_CT_DMINLINE {
        my($x) = @_;
	    eval q(((($x) >> 16) & 0xf));
    }' unless defined(&CPU_CT_DMINLINE);
    eval 'sub CPU_CT_CTYPE_WT () {0;}' unless defined(&CPU_CT_CTYPE_WT);
    eval 'sub CPU_CT_CTYPE_WB1 () {1;}' unless defined(&CPU_CT_CTYPE_WB1);
    eval 'sub CPU_CT_CTYPE_WB2 () {2;}' unless defined(&CPU_CT_CTYPE_WB2);
    eval 'sub CPU_CT_CTYPE_WB6 () {6;}' unless defined(&CPU_CT_CTYPE_WB6);
    eval 'sub CPU_CT_CTYPE_WB7 () {7;}' unless defined(&CPU_CT_CTYPE_WB7);
    eval 'sub CPU_CT_xSIZE_LEN {
        my($x) = @_;
	    eval q((($x) & 0x3));
    }' unless defined(&CPU_CT_xSIZE_LEN);
    eval 'sub CPU_CT_xSIZE_M () {(1 << 2);}' unless defined(&CPU_CT_xSIZE_M);
    eval 'sub CPU_CT_xSIZE_ASSOC {
        my($x) = @_;
	    eval q(((($x) >> 3) & 0x7));
    }' unless defined(&CPU_CT_xSIZE_ASSOC);
    eval 'sub CPU_CT_xSIZE_SIZE {
        my($x) = @_;
	    eval q(((($x) >> 6) & 0x7));
    }' unless defined(&CPU_CT_xSIZE_SIZE);
    eval 'sub FAULT_USER () {0x20;}' unless defined(&FAULT_USER);
    eval 'sub FAULT_WRTBUF_0 () {0x;}' unless defined(&FAULT_WRTBUF_0);
    eval 'sub FAULT_WRTBUF_1 () {0x2;}' unless defined(&FAULT_WRTBUF_1);
    eval 'sub FAULT_BUSERR_0 () {0x4;}' unless defined(&FAULT_BUSERR_0);
    eval 'sub FAULT_BUSERR_1 () {0x6;}' unless defined(&FAULT_BUSERR_1);
    eval 'sub FAULT_BUSERR_2 () {0x8;}' unless defined(&FAULT_BUSERR_2);
    eval 'sub FAULT_BUSERR_3 () {0xa;}' unless defined(&FAULT_BUSERR_3);
    eval 'sub FAULT_BUSTRNL1 () {0xc;}' unless defined(&FAULT_BUSTRNL1);
    eval 'sub FAULT_BUSTRNL2 () {0xe;}' unless defined(&FAULT_BUSTRNL2);
    eval 'sub FAULT_ALIGN_0 () {0x1;}' unless defined(&FAULT_ALIGN_0);
    eval 'sub FAULT_ALIGN_1 () {0x3;}' unless defined(&FAULT_ALIGN_1);
    eval 'sub FAULT_TRANS_S () {0x5;}' unless defined(&FAULT_TRANS_S);
    eval 'sub FAULT_TRANS_P () {0x7;}' unless defined(&FAULT_TRANS_P);
    eval 'sub FAULT_DOMAIN_S () {0x9;}' unless defined(&FAULT_DOMAIN_S);
    eval 'sub FAULT_DOMAIN_P () {0xb;}' unless defined(&FAULT_DOMAIN_P);
    eval 'sub FAULT_PERM_S () {0xd;}' unless defined(&FAULT_PERM_S);
    eval 'sub FAULT_PERM_P () {0xf;}' unless defined(&FAULT_PERM_P);
    eval 'sub FAULT_IMPRECISE () {0x400;}' unless defined(&FAULT_IMPRECISE);
    eval 'sub FAULT_EXT () {0x1000;}' unless defined(&FAULT_EXT);
    eval 'sub FAULT_WNR () {0x800;}' unless defined(&FAULT_WNR);
    eval 'sub FAULT_TYPE {
        my($fsr) = @_;
	    eval q((($fsr) & 0xf));
    }' unless defined(&FAULT_TYPE);
    eval 'sub FAULT_TYPE_V7 {
        my($fsr) = @_;
	    eval q(((($fsr) & 0xf) | ((($fsr) & 0x400) >> 6)));
    }' unless defined(&FAULT_TYPE_V7);
    eval 'sub ARM_VECTORS_LOW () {0x;}' unless defined(&ARM_VECTORS_LOW);
    eval 'sub ARM_VECTORS_HIGH () {0xffff0000;}' unless defined(&ARM_VECTORS_HIGH);
    eval 'sub INSN_SIZE () {4;}' unless defined(&INSN_SIZE);
    eval 'sub INSN_COND_MASK () {0xf0000000;}' unless defined(&INSN_COND_MASK);
    eval 'sub INSN_COND_AL () {0xe0000000;}' unless defined(&INSN_COND_AL);
}
1;
