/*	$OpenBSD: param.h,v 1.20 2013/03/26 05:04:10 deraadt Exp $	*/

/*
 * Copyright (c) 1988-1994, The University of Utah and
 * the Computer Systems Laboratory at the University of Utah (CSL).
 * All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the
 * Computer Systems Laboratory at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSL ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSL DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSL requests users of this software to return to csl-dist@cs.utah.edu any
 * improvements that they make and grant CSL redistribution rights.
 */

#ifndef	_MACHINE_PARAM_H_
#define	_MACHINE_PARAM_H_

#ifdef _KERNEL
#include <machine/cpu.h>
#include <machine/intr.h>
#endif

#define	_MACHINE	hppa64
#define	MACHINE		"hppa64"
#define	_MACHINE_ARCH	hppa64
#define	MACHINE_ARCH	"hppa64"
#define	MID_MACHINE	MID_HPPA20

#define	PAGE_SHIFT	12
#define	PAGE_SIZE	(1 << PAGE_SHIFT)
#define	PAGE_MASK	(PAGE_SIZE - 1)

#define	KERNBASE	0x00000000		/* start of kernel virtual */

#ifdef _KERNEL

#define	NBPG		PAGE_SIZE		/* bytes/page */
#define	PGSHIFT		PAGE_SHIFT		/* LOG2(NBPG) */
#define	PGOFSET		PAGE_MASK		/* byte offset into page */

#define	UPAGES		5			/* pages of u-area */
#define	USPACE		(UPAGES * PAGE_SIZE)	/* total size of u-area */
#define	USPACE_ALIGN	0			/* u-area alignment 0-none */

#define	NMBCLUSTERS	4096			/* map size, max cluster allocation */

#ifndef	MSGBUFSIZE
#define	MSGBUFSIZE	(2 * PAGE_SIZE)		/* default message buffer size */
#endif

/*
 * Maximum size of the kernel malloc arena in PAGE_SIZE-sized
 * logical pages.
 */
#define	NKMEMPAGES_MAX_DEFAULT	((128 * 1024 * 1024) >> PAGE_SHIFT)

#endif /* _KERNEL */

#define	MACHINE_STACK_GROWS_UP	1		/* stack grows to higher addresses */
#define	__SWAP_BROKEN

#endif /* _MACHINE_PARAM_H_ */
