require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SCHED_H_)) {
    eval 'sub _SYS_SCHED_H_ () {1;}' unless defined(&_SYS_SCHED_H_);
    require 'sys/queue.ph';
    eval 'sub CP_USER () {0;}' unless defined(&CP_USER);
    eval 'sub CP_NICE () {1;}' unless defined(&CP_NICE);
    eval 'sub CP_SYS () {2;}' unless defined(&CP_SYS);
    eval 'sub CP_INTR () {3;}' unless defined(&CP_INTR);
    eval 'sub CP_IDLE () {4;}' unless defined(&CP_IDLE);
    eval 'sub CPUSTATES () {5;}' unless defined(&CPUSTATES);
    eval 'sub SCHED_NQS () {32;}' unless defined(&SCHED_NQS);
    if(defined(&notyet)) {
    }
    if(defined(&_KERNEL)) {
	eval 'sub SPCF_SEENRR () {0x1;}' unless defined(&SPCF_SEENRR);
	eval 'sub SPCF_SHOULDYIELD () {0x2;}' unless defined(&SPCF_SHOULDYIELD);
	eval 'sub SPCF_SWITCHCLEAR () {( &SPCF_SEENRR| &SPCF_SHOULDYIELD);}' unless defined(&SPCF_SWITCHCLEAR);
	eval 'sub SPCF_SHOULDHALT () {0x4;}' unless defined(&SPCF_SHOULDHALT);
	eval 'sub SPCF_HALTED () {0x8;}' unless defined(&SPCF_HALTED);
	eval 'sub SCHED_PPQ () {(128/  &SCHED_NQS);}' unless defined(&SCHED_PPQ);
	eval 'sub NICE_WEIGHT () {2;}' unless defined(&NICE_WEIGHT);
	eval 'sub ESTCPULIM {
	    my($e) = @_;
    	    eval q( &min(($e),  &NICE_WEIGHT *  &PRIO_MAX -  &SCHED_PPQ));
	}' unless defined(&ESTCPULIM);
	if(defined(&MULTIPROCESSOR)) {
	}
	eval 'sub curcpu_is_idle () {
	    eval q(( &curcpu()-> ($ci_schedstate->{spc_whichqs}) == 0));
	}' unless defined(&curcpu_is_idle);
	eval 'sub scheduler_fork_hook {
	    my($parent, $child) = @_;
    	    eval q( &do { ($child)-> &p_estcpu = ($parent)-> &p_estcpu; }  &while (0));
	}' unless defined(&scheduler_fork_hook);
	eval 'sub scheduler_wait_hook {
	    my($parent, $child) = @_;
    	    eval q( &do { ($parent)-> &p_estcpu =  &ESTCPULIM(($parent)-> &p_estcpu + ($child)-> &p_estcpu);}  &while (0));
	}' unless defined(&scheduler_wait_hook);
	eval 'sub sched_pause () {
	    eval q( &do {  &if ( &curcpu()-> ($ci_schedstate->{spc_schedflags}) &  &SPCF_SHOULDYIELD)  &yield(); }  &while (0));
	}' unless defined(&sched_pause);
	if(defined(&MULTIPROCESSOR)) {
	    require 'sys/lock.ph';
	    eval 'sub SCHED_ASSERT_LOCKED () {
	        eval q( &do {  &splassert( &IPL_SCHED);  &KASSERT( &__mp_lock_held( &sched_lock)); }  &while (0));
	    }' unless defined(&SCHED_ASSERT_LOCKED);
	    eval 'sub SCHED_ASSERT_UNLOCKED () {
	        eval q( &KASSERT( &__mp_lock_held( &sched_lock) == 0));
	    }' unless defined(&SCHED_ASSERT_UNLOCKED);
	    eval 'sub SCHED_LOCK_INIT () {
	        eval q( &__mp_lock_init( &sched_lock));
	    }' unless defined(&SCHED_LOCK_INIT);
	    eval 'sub SCHED_LOCK {
	        my($s) = @_;
    		eval q( &do { $s =  &splsched();  &__mp_lock( &sched_lock); }  &while ( 0));
	    }' unless defined(&SCHED_LOCK);
	    eval 'sub SCHED_UNLOCK {
	        my($s) = @_;
    		eval q( &do {  &__mp_unlock( &sched_lock);  &splx($s); }  &while ( 0));
	    }' unless defined(&SCHED_UNLOCK);
	} else {
	    eval 'sub SCHED_ASSERT_LOCKED () {
	        eval q( &splassert( &IPL_SCHED););
	    }' unless defined(&SCHED_ASSERT_LOCKED);
	    eval 'sub SCHED_ASSERT_UNLOCKED () {
	        eval q();
	    }' unless defined(&SCHED_ASSERT_UNLOCKED);
	    eval 'sub SCHED_LOCK_INIT () {
	        eval q();
	    }' unless defined(&SCHED_LOCK_INIT);
	    eval 'sub SCHED_LOCK {
	        my($s) = @_;
    		eval q($s =  &splsched());
	    }' unless defined(&SCHED_LOCK);
	    eval 'sub SCHED_UNLOCK {
	        my($s) = @_;
    		eval q( &splx($s));
	    }' unless defined(&SCHED_UNLOCK);
	}
    }
}
1;
