"""Generated message classes for genomics version v1.

An API to store, process, explore, and share genomic data. It supports
reference-based alignments, genetic variants, and reference genomes. This API
provides an implementation of the Global Alliance for Genomics and Health
(GA4GH) v0.5.1 API as well as several extensions.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages
from googlecloudsdk.third_party.apitools.base.py import encoding


package = 'genomics'


class Binding(_messages.Message):
  """Associates `members` with a `role`.

  Fields:
    members: Specifies the identities requesting access for a Cloud Platform
      resource. `members` can have the following values:  * `allUsers`: A
      special identifier that represents anyone who is    on the internet;
      with or without a Google account.  * `allAuthenticatedUsers`: A special
      identifier that represents anyone    who is authenticated with a Google
      account or a service account.  * `user:{emailid}`: An email address that
      represents a specific Google    account. For example, `alice@gmail.com`
      or `joe@example.com`.  * `serviceAccount:{emailid}`: An email address
      that represents a service    account. For example, `my-other-
      app@appspot.gserviceaccount.com`.  * `group:{emailid}`: An email address
      that represents a Google group.    For example, `admins@example.com`.  *
      `domain:{domain}`: A Google Apps domain name that represents all the
      users of that domain. For example, `google.com` or `example.com`.
    role: Role that is assigned to `members`. For example, `roles/viewer`,
      `roles/editor`, or `roles/owner`. Required
  """

  members = _messages.StringField(1, repeated=True)
  role = _messages.StringField(2)


class CallSet(_messages.Message):
  """A call set is a collection of variant calls, typically for one sample. It
  belongs to a variant set.  For more genomics resource definitions, see
  [Fundamentals of Google Genomics](https://cloud.google.com/genomics
  /fundamentals-of-google-genomics)

  Messages:
    InfoValue: A map of additional call set information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    created: The date this call set was created in milliseconds from the
      epoch.
    id: The server-generated call set ID, unique across all call sets.
    info: A map of additional call set information. This must be of the form
      map<string, string[]> (string key mapping to a list of string values).
    name: The call set name.
    sampleId: The sample ID this call set corresponds to.
    variantSetIds: The IDs of the variant sets this call set belongs to. This
      field must have exactly length one, as a call set belongs to a single
      variant set. This field is repeated for compatibility with the [GA4GH
      0.5.1 API](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resourc
      es/avro/variants.avdl#L76).
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    """A map of additional call set information. This must be of the form
    map<string, string[]> (string key mapping to a list of string values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  created = _messages.IntegerField(1)
  id = _messages.StringField(2)
  info = _messages.MessageField('InfoValue', 3)
  name = _messages.StringField(4)
  sampleId = _messages.StringField(5)
  variantSetIds = _messages.StringField(6, repeated=True)


class CancelOperationRequest(_messages.Message):
  """The request message for Operations.CancelOperation."""


class CigarUnit(_messages.Message):
  """A single CIGAR operation.

  Enums:
    OperationValueValuesEnum:

  Fields:
    operation: A OperationValueValuesEnum attribute.
    operationLength: The number of genomic bases that the operation runs for.
      Required.
    referenceSequence: `referenceSequence` is only used at mismatches
      (`SEQUENCE_MISMATCH`) and deletions (`DELETE`). Filling this field
      replaces SAM's MD tag. If the relevant information is not available,
      this field is unset.
  """

  class OperationValueValuesEnum(_messages.Enum):
    """OperationValueValuesEnum enum type.

    Values:
      OPERATION_UNSPECIFIED: <no description>
      ALIGNMENT_MATCH: An alignment match indicates that a sequence can be
        aligned to the reference without evidence of an INDEL. Unlike the
        `SEQUENCE_MATCH` and `SEQUENCE_MISMATCH` operators, the
        `ALIGNMENT_MATCH` operator does not indicate whether the reference and
        read sequences are an exact match. This operator is equivalent to
        SAM's `M`.
      INSERT: The insert operator indicates that the read contains evidence of
        bases being inserted into the reference. This operator is equivalent
        to SAM's `I`.
      DELETE: The delete operator indicates that the read contains evidence of
        bases being deleted from the reference. This operator is equivalent to
        SAM's `D`.
      SKIP: The skip operator indicates that this read skips a long segment of
        the reference, but the bases have not been deleted. This operator is
        commonly used when working with RNA-seq data, where reads may skip
        long segments of the reference between exons. This operator is
        equivalent to SAM's `N`.
      CLIP_SOFT: The soft clip operator indicates that bases at the start/end
        of a read have not been considered during alignment. This may occur if
        the majority of a read maps, except for low quality bases at the
        start/end of a read. This operator is equivalent to SAM's `S`. Bases
        that are soft clipped will still be stored in the read.
      CLIP_HARD: The hard clip operator indicates that bases at the start/end
        of a read have been omitted from this alignment. This may occur if
        this linear alignment is part of a chimeric alignment, or if the read
        has been trimmed (for example, during error correction or to trim
        poly-A tails for RNA-seq). This operator is equivalent to SAM's `H`.
      PAD: The pad operator indicates that there is padding in an alignment.
        This operator is equivalent to SAM's `P`.
      SEQUENCE_MATCH: This operator indicates that this portion of the aligned
        sequence exactly matches the reference. This operator is equivalent to
        SAM's `=`.
      SEQUENCE_MISMATCH: This operator indicates that this portion of the
        aligned sequence is an alignment match to the reference, but a
        sequence mismatch. This can indicate a SNP or a read error. This
        operator is equivalent to SAM's `X`.
    """
    OPERATION_UNSPECIFIED = 0
    ALIGNMENT_MATCH = 1
    INSERT = 2
    DELETE = 3
    SKIP = 4
    CLIP_SOFT = 5
    CLIP_HARD = 6
    PAD = 7
    SEQUENCE_MATCH = 8
    SEQUENCE_MISMATCH = 9

  operation = _messages.EnumField('OperationValueValuesEnum', 1)
  operationLength = _messages.IntegerField(2)
  referenceSequence = _messages.StringField(3)


class CoverageBucket(_messages.Message):
  """A bucket over which read coverage has been precomputed. A bucket
  corresponds to a specific range of the reference sequence.

  Fields:
    meanCoverage: The average number of reads which are aligned to each
      individual reference base in this bucket.
    range: The genomic coordinate range spanned by this bucket.
  """

  meanCoverage = _messages.FloatField(1, variant=_messages.Variant.FLOAT)
  range = _messages.MessageField('Range', 2)


class Dataset(_messages.Message):
  """A Dataset is a collection of genomic data.  For more genomics resource
  definitions, see [Fundamentals of Google
  Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

  Fields:
    createTime: The time this dataset was created, in seconds from the epoch.
    id: The server-generated dataset ID, unique across all datasets.
    name: The dataset name.
    projectId: The Google Developers Console project ID that this dataset
      belongs to.
  """

  createTime = _messages.StringField(1)
  id = _messages.StringField(2)
  name = _messages.StringField(3)
  projectId = _messages.StringField(4)


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class Experiment(_messages.Message):
  """A Experiment object.

  Fields:
    instrumentModel: The instrument model used as part of this experiment.
      This maps to sequencing technology in the SAM spec.
    libraryId: A client-supplied library identifier; a library is a collection
      of DNA fragments which have been prepared for sequencing from a sample.
      This field is important for quality control as error or bias can be
      introduced during sample preparation.
    platformUnit: The platform unit used as part of this experiment, for
      example flowcell-barcode.lane for Illumina or slide for SOLiD.
      Corresponds to the @RG PU field in the SAM spec.
    sequencingCenter: The sequencing center used as part of this experiment.
  """

  instrumentModel = _messages.StringField(1)
  libraryId = _messages.StringField(2)
  platformUnit = _messages.StringField(3)
  sequencingCenter = _messages.StringField(4)


class ExportReadGroupSetRequest(_messages.Message):
  """The read group set export request.

  Fields:
    exportUri: Required. A Google Cloud Storage URI for the exported BAM file.
      The currently authenticated user must have write access to the new file.
      An error will be returned if the URI already contains data.
    projectId: Required. The Google Developers Console project ID that owns
      this export. The caller must have WRITE access to this project.
    referenceNames: The reference names to export. If this is not specified,
      all reference sequences, including unmapped reads, are exported. Use `*`
      to export only unmapped reads.
  """

  exportUri = _messages.StringField(1)
  projectId = _messages.StringField(2)
  referenceNames = _messages.StringField(3, repeated=True)


class ExportVariantSetRequest(_messages.Message):
  """The variant data export request.

  Enums:
    FormatValueValuesEnum: The format for the exported data.

  Fields:
    bigqueryDataset: Required. The BigQuery dataset to export data to. This
      dataset must already exist. Note that this is distinct from the Genomics
      concept of "dataset".
    bigqueryTable: Required. The BigQuery table to export data to. If the
      table doesn't exist, it will be created. If it already exists, it will
      be overwritten.
    callSetIds: If provided, only variant call information from the specified
      call sets will be exported. By default all variant calls are exported.
    format: The format for the exported data.
    projectId: Required. The Google Cloud project ID that owns the destination
      BigQuery dataset. The caller must have WRITE access to this project.
      This project will also own the resulting export job.
  """

  class FormatValueValuesEnum(_messages.Enum):
    """The format for the exported data.

    Values:
      FORMAT_UNSPECIFIED: <no description>
      FORMAT_BIGQUERY: Export the data to Google BigQuery.
    """
    FORMAT_UNSPECIFIED = 0
    FORMAT_BIGQUERY = 1

  bigqueryDataset = _messages.StringField(1)
  bigqueryTable = _messages.StringField(2)
  callSetIds = _messages.StringField(3, repeated=True)
  format = _messages.EnumField('FormatValueValuesEnum', 4)
  projectId = _messages.StringField(5)


class GenomicsCallsetsDeleteRequest(_messages.Message):
  """A GenomicsCallsetsDeleteRequest object.

  Fields:
    callSetId: The ID of the call set to be deleted.
  """

  callSetId = _messages.StringField(1, required=True)


class GenomicsCallsetsGetRequest(_messages.Message):
  """A GenomicsCallsetsGetRequest object.

  Fields:
    callSetId: The ID of the call set.
  """

  callSetId = _messages.StringField(1, required=True)


class GenomicsCallsetsPatchRequest(_messages.Message):
  """A GenomicsCallsetsPatchRequest object.

  Fields:
    callSet: A CallSet resource to be passed as the request body.
    callSetId: The ID of the call set to be updated.
    updateMask: An optional mask specifying which fields to update. At this
      time, the only mutable field is name. The only acceptable value is
      "name". If unspecified, all mutable fields will be updated.
  """

  callSet = _messages.MessageField('CallSet', 1)
  callSetId = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GenomicsDatasetsDeleteRequest(_messages.Message):
  """A GenomicsDatasetsDeleteRequest object.

  Fields:
    datasetId: The ID of the dataset to be deleted.
  """

  datasetId = _messages.StringField(1, required=True)


class GenomicsDatasetsGetIamPolicyRequest(_messages.Message):
  """A GenomicsDatasetsGetIamPolicyRequest object.

  Fields:
    getIamPolicyRequest: A GetIamPolicyRequest resource to be passed as the
      request body.
    resource: REQUIRED: The resource for which policy is being specified.
      Format is `datasets/<dataset ID>`.
  """

  getIamPolicyRequest = _messages.MessageField('GetIamPolicyRequest', 1)
  resource = _messages.StringField(2, required=True)


class GenomicsDatasetsGetRequest(_messages.Message):
  """A GenomicsDatasetsGetRequest object.

  Fields:
    datasetId: The ID of the dataset.
  """

  datasetId = _messages.StringField(1, required=True)


class GenomicsDatasetsListRequest(_messages.Message):
  """A GenomicsDatasetsListRequest object.

  Fields:
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 50. The maximum value is 1024.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    projectId: Required. The project to list datasets for.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectId = _messages.StringField(3)


class GenomicsDatasetsPatchRequest(_messages.Message):
  """A GenomicsDatasetsPatchRequest object.

  Fields:
    dataset: A Dataset resource to be passed as the request body.
    datasetId: The ID of the dataset to be updated.
    updateMask: An optional mask specifying which fields to update. At this
      time, the only mutable field is name. The only acceptable value is
      "name". If unspecified, all mutable fields will be updated.
  """

  dataset = _messages.MessageField('Dataset', 1)
  datasetId = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GenomicsDatasetsSetIamPolicyRequest(_messages.Message):
  """A GenomicsDatasetsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which policy is being specified.
      Format is `datasets/<dataset ID>`.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class GenomicsDatasetsTestIamPermissionsRequest(_messages.Message):
  """A GenomicsDatasetsTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which policy is being specified.
      Format is `datasets/<dataset ID>`.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class GenomicsDatasetsUndeleteRequest(_messages.Message):
  """A GenomicsDatasetsUndeleteRequest object.

  Fields:
    datasetId: The ID of the dataset to be undeleted.
    undeleteDatasetRequest: A UndeleteDatasetRequest resource to be passed as
      the request body.
  """

  datasetId = _messages.StringField(1, required=True)
  undeleteDatasetRequest = _messages.MessageField('UndeleteDatasetRequest', 2)


class GenomicsOperationsCancelRequest(_messages.Message):
  """A GenomicsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class GenomicsOperationsGetRequest(_messages.Message):
  """A GenomicsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class GenomicsOperationsListRequest(_messages.Message):
  """A GenomicsOperationsListRequest object.

  Fields:
    filter: A string for filtering Operations. The following filter fields are
      supported&#58;  * projectId&#58; Required. Corresponds to
      OperationMetadata.projectId. * createTime&#58; The time this job was
      created, in seconds from the
      [epoch](http://en.wikipedia.org/wiki/Unix_time). Can use `>=` and/or
      `<=`   operators. * status&#58; Can be `RUNNING`, `SUCCESS`, `FAILURE`,
      or `CANCELED`. Only   one status may be specified.  Examples&#58;  *
      `projectId = my-project AND createTime >= 1432140000` * `projectId = my-
      project AND createTime >= 1432140000 AND createTime <= 1432150000 AND
      status = RUNNING`
    name: The name of the operation collection.
    pageSize: The maximum number of results to return. If unspecified,
      defaults to 256. The maximum value is 2048.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GenomicsReadgroupsetsCoveragebucketsListRequest(_messages.Message):
  """A GenomicsReadgroupsetsCoveragebucketsListRequest object.

  Fields:
    end: The end position of the range on the reference, 0-based exclusive. If
      specified, `referenceName` must also be specified. If unset or 0,
      defaults to the length of the reference.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024. The maximum value is 2048.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    readGroupSetId: Required. The ID of the read group set over which coverage
      is requested.
    referenceName: The name of the reference to query, within the reference
      set associated with this query. Optional.
    start: The start position of the range on the reference, 0-based
      inclusive. If specified, `referenceName` must also be specified.
      Defaults to 0.
    targetBucketWidth: The desired width of each reported coverage bucket in
      base pairs. This will be rounded down to the nearest precomputed bucket
      width; the value of which is returned as `bucketWidth` in the response.
      Defaults to infinity (each bucket spans an entire reference sequence) or
      the length of the target range, if specified. The smallest precomputed
      `bucketWidth` is currently 2048 base pairs; this is subject to change.
  """

  end = _messages.IntegerField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  readGroupSetId = _messages.StringField(4, required=True)
  referenceName = _messages.StringField(5)
  start = _messages.IntegerField(6)
  targetBucketWidth = _messages.IntegerField(7)


class GenomicsReadgroupsetsDeleteRequest(_messages.Message):
  """A GenomicsReadgroupsetsDeleteRequest object.

  Fields:
    readGroupSetId: The ID of the read group set to be deleted. The caller
      must have WRITE permissions to the dataset associated with this read
      group set.
  """

  readGroupSetId = _messages.StringField(1, required=True)


class GenomicsReadgroupsetsExportRequest(_messages.Message):
  """A GenomicsReadgroupsetsExportRequest object.

  Fields:
    exportReadGroupSetRequest: A ExportReadGroupSetRequest resource to be
      passed as the request body.
    readGroupSetId: Required. The ID of the read group set to export. The
      caller must have READ access to this read group set.
  """

  exportReadGroupSetRequest = _messages.MessageField('ExportReadGroupSetRequest', 1)
  readGroupSetId = _messages.StringField(2, required=True)


class GenomicsReadgroupsetsGetRequest(_messages.Message):
  """A GenomicsReadgroupsetsGetRequest object.

  Fields:
    readGroupSetId: The ID of the read group set.
  """

  readGroupSetId = _messages.StringField(1, required=True)


class GenomicsReadgroupsetsPatchRequest(_messages.Message):
  """A GenomicsReadgroupsetsPatchRequest object.

  Fields:
    readGroupSet: A ReadGroupSet resource to be passed as the request body.
    readGroupSetId: The ID of the read group set to be updated. The caller
      must have WRITE permissions to the dataset associated with this read
      group set.
    updateMask: An optional mask specifying which fields to update. Supported
      fields:  * name. * referenceSetId.  Leaving `updateMask` unset is
      equivalent to specifying all mutable fields.
  """

  readGroupSet = _messages.MessageField('ReadGroupSet', 1)
  readGroupSetId = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class GenomicsReferencesBasesListRequest(_messages.Message):
  """A GenomicsReferencesBasesListRequest object.

  Fields:
    end: The end position (0-based, exclusive) of this query. Defaults to the
      length of this reference.
    pageSize: The maximum number of bases to return in a single page. If
      unspecified, defaults to 200Kbp (kilo base pairs). The maximum value is
      10Mbp (mega base pairs).
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    referenceId: The ID of the reference.
    start: The start position (0-based) of this query. Defaults to 0.
  """

  end = _messages.IntegerField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  referenceId = _messages.StringField(4, required=True)
  start = _messages.IntegerField(5)


class GenomicsReferencesGetRequest(_messages.Message):
  """A GenomicsReferencesGetRequest object.

  Fields:
    referenceId: The ID of the reference.
  """

  referenceId = _messages.StringField(1, required=True)


class GenomicsReferencesetsGetRequest(_messages.Message):
  """A GenomicsReferencesetsGetRequest object.

  Fields:
    referenceSetId: The ID of the reference set.
  """

  referenceSetId = _messages.StringField(1, required=True)


class GenomicsVariantsDeleteRequest(_messages.Message):
  """A GenomicsVariantsDeleteRequest object.

  Fields:
    variantId: The ID of the variant to be deleted.
  """

  variantId = _messages.StringField(1, required=True)


class GenomicsVariantsGetRequest(_messages.Message):
  """A GenomicsVariantsGetRequest object.

  Fields:
    variantId: The ID of the variant.
  """

  variantId = _messages.StringField(1, required=True)


class GenomicsVariantsPatchRequest(_messages.Message):
  """A GenomicsVariantsPatchRequest object.

  Fields:
    updateMask: An optional mask specifying which fields to update. At this
      time, mutable fields are names and info. Acceptable values are "names"
      and "info". If unspecified, all mutable fields will be updated.
    variant: A Variant resource to be passed as the request body.
    variantId: The ID of the variant to be updated.
  """

  updateMask = _messages.StringField(1)
  variant = _messages.MessageField('Variant', 2)
  variantId = _messages.StringField(3, required=True)


class GenomicsVariantsetsDeleteRequest(_messages.Message):
  """A GenomicsVariantsetsDeleteRequest object.

  Fields:
    variantSetId: The ID of the variant set to be deleted.
  """

  variantSetId = _messages.StringField(1, required=True)


class GenomicsVariantsetsExportRequest(_messages.Message):
  """A GenomicsVariantsetsExportRequest object.

  Fields:
    exportVariantSetRequest: A ExportVariantSetRequest resource to be passed
      as the request body.
    variantSetId: Required. The ID of the variant set that contains variant
      data which should be exported. The caller must have READ access to this
      variant set.
  """

  exportVariantSetRequest = _messages.MessageField('ExportVariantSetRequest', 1)
  variantSetId = _messages.StringField(2, required=True)


class GenomicsVariantsetsGetRequest(_messages.Message):
  """A GenomicsVariantsetsGetRequest object.

  Fields:
    variantSetId: Required. The ID of the variant set.
  """

  variantSetId = _messages.StringField(1, required=True)


class GenomicsVariantsetsPatchRequest(_messages.Message):
  """A GenomicsVariantsetsPatchRequest object.

  Fields:
    updateMask: An optional mask specifying which fields to update. Supported
      fields:  * metadata.  Leaving `updateMask` unset is equivalent to
      specifying all mutable fields.
    variantSet: A VariantSet resource to be passed as the request body.
    variantSetId: The ID of the variant to be updated (must already exist).
  """

  updateMask = _messages.StringField(1)
  variantSet = _messages.MessageField('VariantSet', 2)
  variantSetId = _messages.StringField(3, required=True)


class GetIamPolicyRequest(_messages.Message):
  """Request message for `GetIamPolicy` method."""


class ImportReadGroupSetsRequest(_messages.Message):
  """The read group set import request.

  Enums:
    PartitionStrategyValueValuesEnum: The partition strategy describes how
      read groups are partitioned into read group sets.

  Fields:
    datasetId: Required. The ID of the dataset these read group sets will
      belong to. The caller must have WRITE permissions to this dataset.
    partitionStrategy: The partition strategy describes how read groups are
      partitioned into read group sets.
    referenceSetId: The reference set to which the imported read group sets
      are aligned to, if any. The reference names of this reference set must
      be a superset of those found in the imported file headers. If no
      reference set id is provided, a best effort is made to associate with a
      matching reference set.
    sourceUris: A list of URIs pointing at [BAM
      files](https://samtools.github.io/hts-specs/SAMv1.pdf) in Google Cloud
      Storage.
  """

  class PartitionStrategyValueValuesEnum(_messages.Enum):
    """The partition strategy describes how read groups are partitioned into
    read group sets.

    Values:
      PARTITION_STRATEGY_UNSPECIFIED: <no description>
      PER_FILE_PER_SAMPLE: In most cases, this strategy yields one read group
        set per file. This is the default behavior.  Allocate one read group
        set per file per sample. For BAM files, read groups are considered to
        share a sample if they have identical sample names. Furthermore, all
        reads for each file which do not belong to a read group, if any, will
        be grouped into a single read group set per-file.
      MERGE_ALL: Includes all read groups in all imported files into a single
        read group set. Requires that the headers for all imported files are
        equivalent. All reads which do not belong to a read group, if any,
        will be grouped into a separate read group set.
    """
    PARTITION_STRATEGY_UNSPECIFIED = 0
    PER_FILE_PER_SAMPLE = 1
    MERGE_ALL = 2

  datasetId = _messages.StringField(1)
  partitionStrategy = _messages.EnumField('PartitionStrategyValueValuesEnum', 2)
  referenceSetId = _messages.StringField(3)
  sourceUris = _messages.StringField(4, repeated=True)


class ImportReadGroupSetsResponse(_messages.Message):
  """The read group set import response.

  Fields:
    readGroupSetIds: IDs of the read group sets that were created.
  """

  readGroupSetIds = _messages.StringField(1, repeated=True)


class ImportVariantsRequest(_messages.Message):
  """The variant data import request.

  Enums:
    FormatValueValuesEnum: The format of the variant data being imported. If
      unspecified, defaults to to `VCF`.

  Fields:
    format: The format of the variant data being imported. If unspecified,
      defaults to to `VCF`.
    normalizeReferenceNames: Convert reference names to the canonical
      representation. hg19 haploytypes (those reference names containing
      "_hap") are not modified in any way. All other reference names are
      modified according to the following rules: The reference name is
      capitalized. The "chr" prefix is dropped for all autosomes and sex
      chromsomes. For example "chr17" becomes "17" and "chrX" becomes "X". All
      mitochondrial chromosomes ("chrM", "chrMT", etc) become "MT".
    sourceUris: A list of URIs referencing variant files in Google Cloud
      Storage. URIs can include wildcards [as described here](https://cloud.go
      ogle.com/storage/docs/gsutil/addlhelp/WildcardNames). Note that
      recursive wildcards ('**') are not supported.
    variantSetId: Required. The variant set to which variant data should be
      imported.
  """

  class FormatValueValuesEnum(_messages.Enum):
    """The format of the variant data being imported. If unspecified, defaults
    to to `VCF`.

    Values:
      FORMAT_UNSPECIFIED: <no description>
      FORMAT_VCF: VCF (Variant Call Format). The VCF files should be
        uncompressed. gVCF is also supported.
      FORMAT_COMPLETE_GENOMICS: Complete Genomics masterVarBeta format. The
        masterVarBeta files should be bzip2 compressed.
    """
    FORMAT_UNSPECIFIED = 0
    FORMAT_VCF = 1
    FORMAT_COMPLETE_GENOMICS = 2

  format = _messages.EnumField('FormatValueValuesEnum', 1)
  normalizeReferenceNames = _messages.BooleanField(2)
  sourceUris = _messages.StringField(3, repeated=True)
  variantSetId = _messages.StringField(4)


class ImportVariantsResponse(_messages.Message):
  """The variant data import response.

  Fields:
    callSetIds: IDs of the call sets created during the import.
  """

  callSetIds = _messages.StringField(1, repeated=True)


class LinearAlignment(_messages.Message):
  """A linear alignment can be represented by one CIGAR string. Describes the
  mapped position and local alignment of the read to the reference.

  Fields:
    cigar: Represents the local alignment of this sequence (alignment matches,
      indels, etc) against the reference.
    mappingQuality: The mapping quality of this alignment. Represents how
      likely the read maps to this position as opposed to other locations.
      Specifically, this is -10 log10 Pr(mapping position is wrong), rounded
      to the nearest integer.
    position: The position of this alignment.
  """

  cigar = _messages.MessageField('CigarUnit', 1, repeated=True)
  mappingQuality = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  position = _messages.MessageField('Position', 3)


class ListBasesResponse(_messages.Message):
  """A ListBasesResponse object.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    offset: The offset position (0-based) of the given `sequence` from the
      start of this `Reference`. This value will differ for each page in a
      paginated request.
    sequence: A substring of the bases that make up this reference.
  """

  nextPageToken = _messages.StringField(1)
  offset = _messages.IntegerField(2)
  sequence = _messages.StringField(3)


class ListCoverageBucketsResponse(_messages.Message):
  """A ListCoverageBucketsResponse object.

  Fields:
    bucketWidth: The length of each coverage bucket in base pairs. Note that
      buckets at the end of a reference sequence may be shorter. This value is
      omitted if the bucket width is infinity (the default behaviour, with no
      range or `targetBucketWidth`).
    coverageBuckets: The coverage buckets. The list of buckets is sparse; a
      bucket with 0 overlapping reads is not returned. A bucket never crosses
      more than one reference sequence. Each bucket has width `bucketWidth`,
      unless its end is the end of the reference sequence.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  bucketWidth = _messages.IntegerField(1)
  coverageBuckets = _messages.MessageField('CoverageBucket', 2, repeated=True)
  nextPageToken = _messages.StringField(3)


class ListDatasetsResponse(_messages.Message):
  """The dataset list response.

  Fields:
    datasets: The list of matching Datasets.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  datasets = _messages.MessageField('Dataset', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  """The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Operation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: An OperationMetadata object. This will always be returned
      with the Operation.
    ResponseValue: If importing ReadGroupSets, an ImportReadGroupSetsResponse
      is returned. If importing Variants, an ImportVariantsResponse is
      returned. For exports, an empty response is returned.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If true, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure.
    metadata: An OperationMetadata object. This will always be returned with
      the Operation.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. For example&#58; `operations
      /CJHU7Oi_ChDrveSpBRjfuL-qzoWAgEw`
    response: If importing ReadGroupSets, an ImportReadGroupSetsResponse is
      returned. If importing Variants, an ImportVariantsResponse is returned.
      For exports, an empty response is returned.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """An OperationMetadata object. This will always be returned with the
    Operation.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """If importing ReadGroupSets, an ImportReadGroupSetsResponse is returned.
    If importing Variants, an ImportVariantsResponse is returned. For exports,
    an empty response is returned.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationEvent(_messages.Message):
  """An event that occurred during an Operation.

  Fields:
    description: Required description of event.
  """

  description = _messages.StringField(1)


class OperationMetadata(_messages.Message):
  """Metadata describing an Operation.

  Messages:
    RequestValue: The original request that started the operation. Note that
      this will be in current version of the API. If the operation was started
      with v1beta2 API and a GetOperation is performed on v1 API, a v1 request
      will be returned.

  Fields:
    createTime: The time at which the job was submitted to the Genomics
      service.
    events: Optional event messages that were generated during the job's
      execution. This also contains any warnings that were generated during
      import or export.
    projectId: The Google Cloud Project in which the job is scoped.
    request: The original request that started the operation. Note that this
      will be in current version of the API. If the operation was started with
      v1beta2 API and a GetOperation is performed on v1 API, a v1 request will
      be returned.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestValue(_messages.Message):
    """The original request that started the operation. Note that this will be
    in current version of the API. If the operation was started with v1beta2
    API and a GetOperation is performed on v1 API, a v1 request will be
    returned.

    Messages:
      AdditionalProperty: An additional property for a RequestValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a RequestValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  events = _messages.MessageField('OperationEvent', 2, repeated=True)
  projectId = _messages.StringField(3)
  request = _messages.MessageField('RequestValue', 4)


class Policy(_messages.Message):
  """Defines an Identity and Access Management (IAM) policy. It is used to
  specify access control policies for Cloud Platform resources.   A `Policy`
  consists of a list of `bindings`. A `Binding` binds a list of `members` to a
  `role`, where the members can be user accounts, Google groups, Google
  domains, and service accounts. A `role` is a named list of permissions
  defined by IAM.  **Example**      {         "bindings": [          {
  "role": "roles/owner",              "members": [
  "user:mike@example.com",              "group:admins@example.com",
  "domain:google.com",              "serviceAccount:my-other-
  app@appspot.gserviceaccount.com"]          },          {
  "role": "roles/viewer",              "members": ["user:sean@example.com"]
  }          ]     }  For a description of IAM and its features, see the [IAM
  developer's guide](https://cloud.google.com/iam).

  Fields:
    bindings: Associates a list of `members` to a `role`. Multiple `bindings`
      must not be specified for the same `role`. `bindings` with no members
      will result in an error.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy.  If no `etag` is provided in the call to `setIamPolicy`, then
      the existing policy is overwritten blindly.
    version: Version of the `Policy`. The default version is 0.
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class Position(_messages.Message):
  """An abstraction for referring to a genomic position, in relation to some
  already known reference. For now, represents a genomic position as a
  reference name, a base number on that reference (0-based), and a
  determination of forward or reverse strand.

  Fields:
    position: The 0-based offset from the start of the forward strand for that
      reference.
    referenceName: The name of the reference in whatever reference set is
      being used.
    reverseStrand: Whether this position is on the reverse strand, as opposed
      to the forward strand.
  """

  position = _messages.IntegerField(1)
  referenceName = _messages.StringField(2)
  reverseStrand = _messages.BooleanField(3)


class Program(_messages.Message):
  """A Program object.

  Fields:
    commandLine: The command line used to run this program.
    id: The user specified locally unique ID of the program. Used along with
      `prevProgramId` to define an ordering between programs.
    name: The display name of the program. This is typically the colloquial
      name of the tool used, for example 'bwa' or 'picard'.
    prevProgramId: The ID of the program run before this one.
    version: The version of the program run.
  """

  commandLine = _messages.StringField(1)
  id = _messages.StringField(2)
  name = _messages.StringField(3)
  prevProgramId = _messages.StringField(4)
  version = _messages.StringField(5)


class Range(_messages.Message):
  """A 0-based half-open genomic coordinate range for search requests.

  Fields:
    end: The end position of the range on the reference, 0-based exclusive.
    referenceName: The reference sequence name, for example `chr1`, `1`, or
      `chrX`.
    start: The start position of the range on the reference, 0-based
      inclusive.
  """

  end = _messages.IntegerField(1)
  referenceName = _messages.StringField(2)
  start = _messages.IntegerField(3)


class Read(_messages.Message):
  """A read alignment describes a linear alignment of a string of DNA to a
  reference sequence, in addition to metadata about the fragment (the molecule
  of DNA sequenced) and the read (the bases which were read by the sequencer).
  A read is equivalent to a line in a SAM file. A read belongs to exactly one
  read group and exactly one read group set.  For more genomics resource
  definitions, see [Fundamentals of Google
  Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
  ### Reverse-stranded reads  Mapped reads (reads having a non-null
  `alignment`) can be aligned to either the forward or the reverse strand of
  their associated reference. Strandedness of a mapped read is encoded by
  `alignment.position.reverseStrand`.  If we consider the reference to be a
  forward-stranded coordinate space of `[0, reference.length)` with `0` as the
  left-most position and `reference.length` as the right-most position, reads
  are always aligned left to right. That is, `alignment.position.position`
  always refers to the left-most reference coordinate and `alignment.cigar`
  describes the alignment of this read to the reference from left to right.
  All per-base fields such as `alignedSequence` and `alignedQuality` share
  this same left-to-right orientation; this is true of reads which are aligned
  to either strand. For reverse-stranded reads, this means that
  `alignedSequence` is the reverse complement of the bases that were
  originally reported by the sequencing machine.  ### Generating a reference-
  aligned sequence string  When interacting with mapped reads, it's often
  useful to produce a string representing the local alignment of the read to
  reference. The following pseudocode demonstrates one way of doing this:
  out = ""     offset = 0     for c in read.alignment.cigar {       switch
  c.operation {       case "ALIGNMENT_MATCH", "SEQUENCE_MATCH",
  "SEQUENCE_MISMATCH":         out +=
  read.alignedSequence[offset:offset+c.operationLength]         offset +=
  c.operationLength         break       case "CLIP_SOFT", "INSERT":
  offset += c.operationLength         break       case "PAD":         out +=
  repeat("*", c.operationLength)         break       case "DELETE":
  out += repeat("-", c.operationLength)         break       case "SKIP":
  out += repeat(" ", c.operationLength)         break       case "CLIP_HARD":
  break       }     }     return out  ### Converting to SAM's CIGAR string
  The following pseudocode generates a SAM CIGAR string from the `cigar`
  field. Note that this is a lossy conversion (`cigar.referenceSequence` is
  lost).      cigarMap = {       "ALIGNMENT_MATCH": "M",       "INSERT": "I",
  "DELETE": "D",       "SKIP": "N",       "CLIP_SOFT": "S",       "CLIP_HARD":
  "H",       "PAD": "P",       "SEQUENCE_MATCH": "=",
  "SEQUENCE_MISMATCH": "X",     }     cigarStr = ""     for c in
  read.alignment.cigar {       cigarStr += c.operationLength +
  cigarMap[c.operation]     }     return cigarStr

  Messages:
    InfoValue: A map of additional read alignment information. This must be of
      the form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    alignedQuality: The quality of the read sequence contained in this
      alignment record (equivalent to QUAL in SAM). `alignedSequence` and
      `alignedQuality` may be shorter than the full read sequence and quality.
      This will occur if the alignment is part of a chimeric alignment, or if
      the read was trimmed. When this occurs, the CIGAR for this read will
      begin/end with a hard clip operator that will indicate the length of the
      excised sequence.
    alignedSequence: The bases of the read sequence contained in this
      alignment record, **without CIGAR operations applied** (equivalent to
      SEQ in SAM). `alignedSequence` and `alignedQuality` may be shorter than
      the full read sequence and quality. This will occur if the alignment is
      part of a chimeric alignment, or if the read was trimmed. When this
      occurs, the CIGAR for this read will begin/end with a hard clip operator
      that will indicate the length of the excised sequence.
    alignment: The linear alignment for this alignment record. This field is
      null for unmapped reads.
    duplicateFragment: The fragment is a PCR or optical duplicate (SAM flag
      0x400).
    failedVendorQualityChecks: Whether this read did not pass filters, such as
      platform or vendor quality controls (SAM flag 0x200).
    fragmentLength: The observed length of the fragment, equivalent to TLEN in
      SAM.
    fragmentName: The fragment name. Equivalent to QNAME (query template name)
      in SAM.
    id: The server-generated read ID, unique across all reads. This is
      different from the `fragmentName`.
    info: A map of additional read alignment information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).
    nextMatePosition: The mapping of the primary alignment of the
      `(readNumber+1)%numberReads` read in the fragment. It replaces mate
      position and mate strand in SAM.
    numberReads: The number of reads in the fragment (extension to SAM flag
      0x1).
    properPlacement: The orientation and the distance between reads from the
      fragment are consistent with the sequencing protocol (SAM flag 0x2).
    readGroupId: The ID of the read group this read belongs to. A read belongs
      to exactly one read group. This is a server-generated ID which is
      distinct from SAM's RG tag (for that value, see ReadGroup.name).
    readGroupSetId: The ID of the read group set this read belongs to. A read
      belongs to exactly one read group set.
    readNumber: The read number in sequencing. 0-based and less than
      numberReads. This field replaces SAM flag 0x40 and 0x80.
    secondaryAlignment: Whether this alignment is secondary. Equivalent to SAM
      flag 0x100. A secondary alignment represents an alternative to the
      primary alignment for this read. Aligners may return secondary
      alignments if a read can map ambiguously to multiple coordinates in the
      genome. By convention, each read has one and only one alignment where
      both `secondaryAlignment` and `supplementaryAlignment` are false.
    supplementaryAlignment: Whether this alignment is supplementary.
      Equivalent to SAM flag 0x800. Supplementary alignments are used in the
      representation of a chimeric alignment. In a chimeric alignment, a read
      is split into multiple linear alignments that map to different reference
      contigs. The first linear alignment in the read will be designated as
      the representative alignment; the remaining linear alignments will be
      designated as supplementary alignments. These alignments may have
      different mapping quality scores. In each linear alignment in a chimeric
      alignment, the read will be hard clipped. The `alignedSequence` and
      `alignedQuality` fields in the alignment record will only represent the
      bases for its respective linear alignment.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    """A map of additional read alignment information. This must be of the
    form map<string, string[]> (string key mapping to a list of string
    values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  alignedQuality = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)
  alignedSequence = _messages.StringField(2)
  alignment = _messages.MessageField('LinearAlignment', 3)
  duplicateFragment = _messages.BooleanField(4)
  failedVendorQualityChecks = _messages.BooleanField(5)
  fragmentLength = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  fragmentName = _messages.StringField(7)
  id = _messages.StringField(8)
  info = _messages.MessageField('InfoValue', 9)
  nextMatePosition = _messages.MessageField('Position', 10)
  numberReads = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  properPlacement = _messages.BooleanField(12)
  readGroupId = _messages.StringField(13)
  readGroupSetId = _messages.StringField(14)
  readNumber = _messages.IntegerField(15, variant=_messages.Variant.INT32)
  secondaryAlignment = _messages.BooleanField(16)
  supplementaryAlignment = _messages.BooleanField(17)


class ReadGroup(_messages.Message):
  """A read group is all the data that's processed the same way by the
  sequencer.

  Messages:
    InfoValue: A map of additional read group information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    datasetId: The dataset to which this read group belongs.
    description: A free-form text description of this read group.
    experiment: The experiment used to generate this read group.
    id: The server-generated read group ID, unique for all read groups. Note:
      This is different than the @RG ID field in the SAM spec. For that value,
      see name.
    info: A map of additional read group information. This must be of the form
      map<string, string[]> (string key mapping to a list of string values).
    name: The read group name. This corresponds to the @RG ID field in the SAM
      spec.
    predictedInsertSize: The predicted insert size of this read group. The
      insert size is the length the sequenced DNA fragment from end-to-end,
      not including the adapters.
    programs: The programs used to generate this read group. Programs are
      always identical for all read groups within a read group set. For this
      reason, only the first read group in a returned set will have this field
      populated.
    referenceSetId: The reference set the reads in this read group are aligned
      to.
    sampleId: A client-supplied sample identifier for the reads in this read
      group.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    """A map of additional read group information. This must be of the form
    map<string, string[]> (string key mapping to a list of string values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  datasetId = _messages.StringField(1)
  description = _messages.StringField(2)
  experiment = _messages.MessageField('Experiment', 3)
  id = _messages.StringField(4)
  info = _messages.MessageField('InfoValue', 5)
  name = _messages.StringField(6)
  predictedInsertSize = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  programs = _messages.MessageField('Program', 8, repeated=True)
  referenceSetId = _messages.StringField(9)
  sampleId = _messages.StringField(10)


class ReadGroupSet(_messages.Message):
  """A read group set is a logical collection of read groups, which are
  collections of reads produced by a sequencer. A read group set typically
  models reads corresponding to one sample, sequenced one way, and aligned one
  way.  * A read group set belongs to one dataset. * A read group belongs to
  one read group set. * A read belongs to one read group.  For more genomics
  resource definitions, see [Fundamentals of Google
  Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

  Messages:
    InfoValue: A map of additional read group set information.

  Fields:
    datasetId: The dataset to which this read group set belongs.
    filename: The filename of the original source file for this read group
      set, if any.
    id: The server-generated read group set ID, unique for all read group
      sets.
    info: A map of additional read group set information.
    name: The read group set name. By default this will be initialized to the
      sample name of the sequenced data contained in this set.
    readGroups: The read groups in this set. There are typically 1-10 read
      groups in a read group set.
    referenceSetId: The reference set to which the reads in this read group
      set are aligned.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    """A map of additional read group set information.

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  datasetId = _messages.StringField(1)
  filename = _messages.StringField(2)
  id = _messages.StringField(3)
  info = _messages.MessageField('InfoValue', 4)
  name = _messages.StringField(5)
  readGroups = _messages.MessageField('ReadGroup', 6, repeated=True)
  referenceSetId = _messages.StringField(7)


class Reference(_messages.Message):
  """A reference is a canonical assembled DNA sequence, intended to act as a
  reference coordinate space for other genomic annotations. A single reference
  might represent the human chromosome 1 or mitochandrial DNA, for instance. A
  reference belongs to one or more reference sets.  For more genomics resource
  definitions, see [Fundamentals of Google
  Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

  Fields:
    id: The server-generated reference ID, unique across all references.
    length: The length of this reference's sequence.
    md5checksum: MD5 of the upper-case sequence excluding all whitespace
      characters (this is equivalent to SQ:M5 in SAM). This value is
      represented in lower case hexadecimal format.
    name: The name of this reference, for example `22`.
    ncbiTaxonId: ID from http://www.ncbi.nlm.nih.gov/taxonomy. For example,
      9606 for human.
    sourceAccessions: All known corresponding accession IDs in INSDC
      (GenBank/ENA/DDBJ) ideally with a version number, for example
      `GCF_000001405.26`.
    sourceUri: The URI from which the sequence was obtained. Typically
      specifies a FASTA format file.
  """

  id = _messages.StringField(1)
  length = _messages.IntegerField(2)
  md5checksum = _messages.StringField(3)
  name = _messages.StringField(4)
  ncbiTaxonId = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  sourceAccessions = _messages.StringField(6, repeated=True)
  sourceUri = _messages.StringField(7)


class ReferenceBound(_messages.Message):
  """ReferenceBound records an upper bound for the starting coordinate of
  variants in a particular reference.

  Fields:
    referenceName: The name of the reference associated with this
      ReferenceBound.
    upperBound: An upper bound (inclusive) on the starting coordinate of any
      variant in the reference sequence.
  """

  referenceName = _messages.StringField(1)
  upperBound = _messages.IntegerField(2)


class ReferenceSet(_messages.Message):
  """A reference set is a set of references which typically comprise a
  reference assembly for a species, such as `GRCh38` which is representative
  of the human genome. A reference set defines a common coordinate space for
  comparing reference-aligned experimental data. A reference set contains 1 or
  more references.  For more genomics resource definitions, see [Fundamentals
  of Google Genomics](https://cloud.google.com/genomics/fundamentals-of-
  google-genomics)

  Fields:
    assemblyId: Public id of this reference set, such as `GRCh37`.
    description: Free text description of this reference set.
    id: The server-generated reference set ID, unique across all reference
      sets.
    md5checksum: Order-independent MD5 checksum which identifies this
      reference set. The checksum is computed by sorting all lower case
      hexidecimal string `reference.md5checksum` (for all reference in this
      set) in ascending lexicographic order, concatenating, and taking the MD5
      of that value. The resulting value is represented in lower case
      hexadecimal format.
    ncbiTaxonId: ID from http://www.ncbi.nlm.nih.gov/taxonomy (for example,
      9606 for human) indicating the species which this reference set is
      intended to model. Note that contained references may specify a
      different `ncbiTaxonId`, as assemblies may contain reference sequences
      which do not belong to the modeled species, for example EBV in a human
      reference genome.
    referenceIds: The IDs of the reference objects that are part of this set.
      `Reference.md5checksum` must be unique within this set.
    sourceAccessions: All known corresponding accession IDs in INSDC
      (GenBank/ENA/DDBJ) ideally with a version number, for example
      `NC_000001.11`.
    sourceUri: The URI from which the references were obtained.
  """

  assemblyId = _messages.StringField(1)
  description = _messages.StringField(2)
  id = _messages.StringField(3)
  md5checksum = _messages.StringField(4)
  ncbiTaxonId = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  referenceIds = _messages.StringField(6, repeated=True)
  sourceAccessions = _messages.StringField(7, repeated=True)
  sourceUri = _messages.StringField(8)


class SearchCallSetsRequest(_messages.Message):
  """The call set search request.

  Fields:
    name: Only return call sets for which a substring of the name matches this
      string.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    variantSetIds: Restrict the query to call sets within the given variant
      sets. At least one ID must be provided.
  """

  name = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  variantSetIds = _messages.StringField(4, repeated=True)


class SearchCallSetsResponse(_messages.Message):
  """The call set search response.

  Fields:
    callSets: The list of matching call sets.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  callSets = _messages.MessageField('CallSet', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SearchReadGroupSetsRequest(_messages.Message):
  """The read group set search request.

  Fields:
    datasetIds: Restricts this query to read group sets within the given
      datasets. At least one ID must be provided.
    name: Only return read group sets for which a substring of the name
      matches this string.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 256. The maximum value is 1024.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
  """

  datasetIds = _messages.StringField(1, repeated=True)
  name = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class SearchReadGroupSetsResponse(_messages.Message):
  """The read group set search response.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    readGroupSets: The list of matching read group sets.
  """

  nextPageToken = _messages.StringField(1)
  readGroupSets = _messages.MessageField('ReadGroupSet', 2, repeated=True)


class SearchReadsRequest(_messages.Message):
  """The read search request.

  Fields:
    end: The end position of the range on the reference, 0-based exclusive. If
      specified, `referenceName` must also be specified.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 256. The maximum value is 2048.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    readGroupIds: The IDs of the read groups within which to search for reads.
      All specified read groups must belong to the same read group sets. Must
      specify one of `readGroupSetIds` or `readGroupIds`.
    readGroupSetIds: The IDs of the read groups sets within which to search
      for reads. All specified read group sets must be aligned against a
      common set of reference sequences; this defines the genomic coordinates
      for the query. Must specify one of `readGroupSetIds` or `readGroupIds`.
    referenceName: The reference sequence name, for example `chr1`, `1`, or
      `chrX`. If set to `*`, only unmapped reads are returned. If unspecified,
      all reads (mapped and unmapped) are returned.
    start: The start position of the range on the reference, 0-based
      inclusive. If specified, `referenceName` must also be specified.
  """

  end = _messages.IntegerField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  readGroupIds = _messages.StringField(4, repeated=True)
  readGroupSetIds = _messages.StringField(5, repeated=True)
  referenceName = _messages.StringField(6)
  start = _messages.IntegerField(7)


class SearchReadsResponse(_messages.Message):
  """The read search response.

  Fields:
    alignments: The list of matching alignments sorted by mapped genomic
      coordinate, if any, ascending in position within the same reference.
      Unmapped reads, which have no position, are returned contiguously and
      are sorted in ascending lexicographic order by fragment name.
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
  """

  alignments = _messages.MessageField('Read', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class SearchReferenceSetsRequest(_messages.Message):
  """A SearchReferenceSetsRequest object.

  Fields:
    accessions: If present, return reference sets for which a prefix of any of
      sourceAccessions match any of these strings. Accession numbers typically
      have a main number and a version, for example `NC_000001.11`.
    assemblyId: If present, return reference sets for which a substring of
      their `assemblyId` matches this string (case insensitive).
    md5checksums: If present, return reference sets for which the md5checksum
      matches exactly.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024. The maximum value is 4096.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
  """

  accessions = _messages.StringField(1, repeated=True)
  assemblyId = _messages.StringField(2)
  md5checksums = _messages.StringField(3, repeated=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class SearchReferenceSetsResponse(_messages.Message):
  """A SearchReferenceSetsResponse object.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    referenceSets: The matching references sets.
  """

  nextPageToken = _messages.StringField(1)
  referenceSets = _messages.MessageField('ReferenceSet', 2, repeated=True)


class SearchReferencesRequest(_messages.Message):
  """A SearchReferencesRequest object.

  Fields:
    accessions: If present, return references for which a prefix of any of
      sourceAccessions match any of these strings. Accession numbers typically
      have a main number and a version, for example `GCF_000001405.26`.
    md5checksums: If present, return references for which the md5checksum
      matches exactly.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024. The maximum value is 4096.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    referenceSetId: If present, return only references which belong to this
      reference set.
  """

  accessions = _messages.StringField(1, repeated=True)
  md5checksums = _messages.StringField(2, repeated=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  referenceSetId = _messages.StringField(5)


class SearchReferencesResponse(_messages.Message):
  """A SearchReferencesResponse object.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    references: The matching references.
  """

  nextPageToken = _messages.StringField(1)
  references = _messages.MessageField('Reference', 2, repeated=True)


class SearchVariantSetsRequest(_messages.Message):
  """The search variant sets request.

  Fields:
    datasetIds: Exactly one dataset ID must be provided here. Only variant
      sets which belong to this dataset will be returned.
    pageSize: The maximum number of results to return in a single page. If
      unspecified, defaults to 1024.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
  """

  datasetIds = _messages.StringField(1, repeated=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class SearchVariantSetsResponse(_messages.Message):
  """The search variant sets response.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    variantSets: The variant sets belonging to the requested dataset.
  """

  nextPageToken = _messages.StringField(1)
  variantSets = _messages.MessageField('VariantSet', 2, repeated=True)


class SearchVariantsRequest(_messages.Message):
  """The variant search request.

  Fields:
    callSetIds: Only return variant calls which belong to call sets with these
      ids. Leaving this blank returns all variant calls. If a variant has no
      calls belonging to any of these call sets, it won't be returned at all.
      Currently, variants with no calls from any call set will never be
      returned.
    end: The end of the window, 0-based exclusive. If unspecified or 0,
      defaults to the length of the reference.
    maxCalls: The maximum number of calls to return in a single page. Note
      that this limit may be exceeded; at least one variant is always returned
      per page, even if it has more calls than this limit. If unspecified,
      defaults to 5000. The maximum value is 10000.
    pageSize: The maximum number of variants to return in a single page. If
      unspecified, defaults to 5000. The maximum value is 10000.
    pageToken: The continuation token, which is used to page through large
      result sets. To get the next page of results, set this parameter to the
      value of `nextPageToken` from the previous response.
    referenceName: Required. Only return variants in this reference sequence.
    start: The beginning of the window (0-based, inclusive) for which
      overlapping variants should be returned. If unspecified, defaults to 0.
    variantName: Only return variants which have exactly this name.
    variantSetIds: At most one variant set ID must be provided. Only variants
      from this variant set will be returned. If omitted, a call set id must
      be included in the request.
  """

  callSetIds = _messages.StringField(1, repeated=True)
  end = _messages.IntegerField(2)
  maxCalls = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  referenceName = _messages.StringField(6)
  start = _messages.IntegerField(7)
  variantName = _messages.StringField(8)
  variantSetIds = _messages.StringField(9, repeated=True)


class SearchVariantsResponse(_messages.Message):
  """The variant search response.

  Fields:
    nextPageToken: The continuation token, which is used to page through large
      result sets. Provide this value in a subsequent request to return the
      next page of results. This field will be empty if there aren't any
      additional results.
    variants: The list of matching Variants.
  """

  nextPageToken = _messages.StringField(1)
  variants = _messages.MessageField('Variant', 2, repeated=True)


class SetIamPolicyRequest(_messages.Message):
  """Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Cloud Platform services (such as Projects)
      might reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StreamReadsRequest(_messages.Message):
  """The stream reads request.

  Fields:
    end: The end position of the range on the reference, 0-based exclusive. If
      specified, `referenceName` must also be specified.
    projectId: The Google Developers Console project ID or number which will
      be billed for this access. The caller must have WRITE access to this
      project. Required.
    readGroupSetId: The ID of the read group set from which to stream reads.
    referenceName: The reference sequence name, for example `chr1`, `1`, or
      `chrX`. If set to *, only unmapped reads are returned.
    start: The start position of the range on the reference, 0-based
      inclusive. If specified, `referenceName` must also be specified.
  """

  end = _messages.IntegerField(1)
  projectId = _messages.StringField(2)
  readGroupSetId = _messages.StringField(3)
  referenceName = _messages.StringField(4)
  start = _messages.IntegerField(5)


class StreamReadsResponse(_messages.Message):
  """A StreamReadsResponse object.

  Fields:
    alignments: A Read attribute.
  """

  alignments = _messages.MessageField('Read', 1, repeated=True)


class StreamVariantsRequest(_messages.Message):
  """The stream variants request.

  Fields:
    callSetIds: Only return variant calls which belong to call sets with these
      IDs. Leaving this blank returns all variant calls.
    end: The end of the window (0-based, exclusive) for which overlapping
      variants should be returned.
    projectId: The Google Developers Console project ID or number which will
      be billed for this access. The caller must have WRITE access to this
      project. Required.
    referenceName: Required. Only return variants in this reference sequence.
    start: The beginning of the window (0-based, inclusive) for which
      overlapping variants should be returned.
    variantSetId: The variant set ID from which to stream variants.
  """

  callSetIds = _messages.StringField(1, repeated=True)
  end = _messages.IntegerField(2)
  projectId = _messages.StringField(3)
  referenceName = _messages.StringField(4)
  start = _messages.IntegerField(5)
  variantSetId = _messages.StringField(6)


class StreamVariantsResponse(_messages.Message):
  """A StreamVariantsResponse object.

  Fields:
    variants: A Variant attribute.
  """

  variants = _messages.MessageField('Variant', 1, repeated=True)


class TestIamPermissionsRequest(_messages.Message):
  """Request message for `TestIamPermissions` method.

  Fields:
    permissions: REQUIRED: The set of permissions to check for the 'resource'.
      Permissions with wildcards (such as '*' or 'storage.*') are not allowed.
      Allowed permissions are&#58;  * `genomics.datasets.create` *
      `genomics.datasets.delete` * `genomics.datasets.get` *
      `genomics.datasets.list` * `genomics.datasets.update` *
      `genomics.datasets.getIamPolicy` * `genomics.datasets.setIamPolicy`
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  """Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class UndeleteDatasetRequest(_messages.Message):
  """A UndeleteDatasetRequest object."""


class Variant(_messages.Message):
  """A variant represents a change in DNA sequence relative to a reference
  sequence. For example, a variant could represent a SNP or an insertion.
  Variants belong to a variant set.  For more genomics resource definitions,
  see [Fundamentals of Google Genomics](https://cloud.google.com/genomics
  /fundamentals-of-google-genomics)  Each of the calls on a variant represent
  a determination of genotype with respect to that variant. For example, a
  call might assign probability of 0.32 to the occurrence of a SNP named
  rs1234 in a sample named NA12345. A call belongs to a call set, which
  contains related calls typically from one sample.

  Messages:
    InfoValue: A map of additional variant information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    alternateBases: The bases that appear instead of the reference bases.
    calls: The variant calls for this particular variant. Each one represents
      the determination of genotype with respect to this variant.
    created: The date this variant was created, in milliseconds from the
      epoch.
    end: The end position (0-based) of this variant. This corresponds to the
      first base after the last base in the reference allele. So, the length
      of the reference allele is (end - start). This is useful for variants
      that don't explicitly give alternate bases, for example large deletions.
    filter: A list of filters (normally quality filters) this variant has
      failed. `PASS` indicates this variant has passed all filters.
    id: The server-generated variant ID, unique across all variants.
    info: A map of additional variant information. This must be of the form
      map<string, string[]> (string key mapping to a list of string values).
    names: Names for the variant, for example a RefSNP ID.
    quality: A measure of how likely this variant is to be real. A higher
      value is better.
    referenceBases: The reference bases for this variant. They start at the
      given position.
    referenceName: The reference on which this variant occurs. (such as
      `chr20` or `X`)
    start: The position at which this variant occurs (0-based). This
      corresponds to the first base of the string of reference bases.
    variantSetId: The ID of the variant set this variant belongs to.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    """A map of additional variant information. This must be of the form
    map<string, string[]> (string key mapping to a list of string values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  alternateBases = _messages.StringField(1, repeated=True)
  calls = _messages.MessageField('VariantCall', 2, repeated=True)
  created = _messages.IntegerField(3)
  end = _messages.IntegerField(4)
  filter = _messages.StringField(5, repeated=True)
  id = _messages.StringField(6)
  info = _messages.MessageField('InfoValue', 7)
  names = _messages.StringField(8, repeated=True)
  quality = _messages.FloatField(9)
  referenceBases = _messages.StringField(10)
  referenceName = _messages.StringField(11)
  start = _messages.IntegerField(12)
  variantSetId = _messages.StringField(13)


class VariantCall(_messages.Message):
  """A call represents the determination of genotype with respect to a
  particular variant. It may include associated information such as quality
  and phasing. For example, a call might assign a probability of 0.32 to the
  occurrence of a SNP named rs1234 in a call set with the name NA12345.

  Messages:
    InfoValue: A map of additional variant call information. This must be of
      the form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    callSetId: The ID of the call set this variant call belongs to.
    callSetName: The name of the call set this variant call belongs to.
    genotype: The genotype of this variant call. Each value represents either
      the value of the `referenceBases` field or a 1-based index into
      `alternateBases`. If a variant had a `referenceBases` value of `T` and
      an `alternateBases` value of `["A", "C"]`, and the `genotype` was `[2,
      1]`, that would mean the call represented the heterozygous value `CA`
      for this variant. If the `genotype` was instead `[0, 1]`, the
      represented value would be `TA`. Ordering of the genotype values is
      important if the `phaseset` is present. If a genotype is not called
      (that is, a `.` is present in the GT string) -1 is returned.
    genotypeLikelihood: The genotype likelihoods for this variant call. Each
      array entry represents how likely a specific genotype is for this call.
      The value ordering is defined by the GL tag in the VCF spec. If Phred-
      scaled genotype likelihood scores (PL) are available and log10(P)
      genotype likelihood scores (GL) are not, PL scores are converted to GL
      scores.  If both are available, PL scores are stored in `info`.
    info: A map of additional variant call information. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).
    phaseset: If this field is present, this variant call's genotype ordering
      implies the phase of the bases and is consistent with any other variant
      calls in the same reference sequence which have the same phaseset value.
      When importing data from VCF, if the genotype data was phased but no
      phase set was specified this field will be set to `*`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    """A map of additional variant call information. This must be of the form
    map<string, string[]> (string key mapping to a list of string values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  callSetId = _messages.StringField(1)
  callSetName = _messages.StringField(2)
  genotype = _messages.IntegerField(3, repeated=True, variant=_messages.Variant.INT32)
  genotypeLikelihood = _messages.FloatField(4, repeated=True)
  info = _messages.MessageField('InfoValue', 5)
  phaseset = _messages.StringField(6)


class VariantSet(_messages.Message):
  """A variant set is a collection of call sets and variants. It contains
  summary statistics of those contents. A variant set belongs to a dataset.
  For more genomics resource definitions, see [Fundamentals of Google
  Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)

  Fields:
    datasetId: The dataset to which this variant set belongs.
    id: The server-generated variant set ID, unique across all variant sets.
    metadata: The metadata associated with this variant set.
    referenceBounds: A list of all references used by the variants in a
      variant set with associated coordinate upper bounds for each one.
    referenceSetId: The reference set to which the variant set is mapped. The
      reference set describes the alignment provenance of the variant set,
      while the `referenceBounds` describe the shape of the actual variant
      data. The reference set's reference names are a superset of those found
      in the `referenceBounds`.  For example, given a variant set that is
      mapped to the GRCh38 reference set and contains a single variant on
      reference 'X', `referenceBounds` would contain only an entry for 'X',
      while the associated reference set enumerates all possible references:
      '1', '2', 'X', 'Y', 'MT', etc.
  """

  datasetId = _messages.StringField(1)
  id = _messages.StringField(2)
  metadata = _messages.MessageField('VariantSetMetadata', 3, repeated=True)
  referenceBounds = _messages.MessageField('ReferenceBound', 4, repeated=True)
  referenceSetId = _messages.StringField(5)


class VariantSetMetadata(_messages.Message):
  """Metadata describes a single piece of variant call metadata. These data
  include a top level key and either a single value string (value) or a list
  of key-value pairs (info.) Value and info are mutually exclusive.

  Enums:
    TypeValueValuesEnum: The type of data. Possible types include: Integer,
      Float, Flag, Character, and String.

  Messages:
    InfoValue: Remaining structured metadata key-value pairs. This must be of
      the form map<string, string[]> (string key mapping to a list of string
      values).

  Fields:
    description: A textual description of this metadata.
    id: User-provided ID field, not enforced by this API. Two or more pieces
      of structured metadata with identical id and key fields are considered
      equivalent.
    info: Remaining structured metadata key-value pairs. This must be of the
      form map<string, string[]> (string key mapping to a list of string
      values).
    key: The top-level key.
    number: The number of values that can be included in a field described by
      this metadata.
    type: The type of data. Possible types include: Integer, Float, Flag,
      Character, and String.
    value: The value field for simple metadata
  """

  class TypeValueValuesEnum(_messages.Enum):
    """The type of data. Possible types include: Integer, Float, Flag,
    Character, and String.

    Values:
      TYPE_UNSPECIFIED: <no description>
      INTEGER: <no description>
      FLOAT: <no description>
      FLAG: <no description>
      CHARACTER: <no description>
      STRING: <no description>
    """
    TYPE_UNSPECIFIED = 0
    INTEGER = 1
    FLOAT = 2
    FLAG = 3
    CHARACTER = 4
    STRING = 5

  @encoding.MapUnrecognizedFields('additionalProperties')
  class InfoValue(_messages.Message):
    """Remaining structured metadata key-value pairs. This must be of the form
    map<string, string[]> (string key mapping to a list of string values).

    Messages:
      AdditionalProperty: An additional property for a InfoValue object.

    Fields:
      additionalProperties: Additional properties of type InfoValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a InfoValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2, repeated=True)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  id = _messages.StringField(2)
  info = _messages.MessageField('InfoValue', 3)
  key = _messages.StringField(4)
  number = _messages.StringField(5)
  type = _messages.EnumField('TypeValueValuesEnum', 6)
  value = _messages.StringField(7)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'genomics')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'genomics')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'genomics')
