"""Generated message classes for appengine version v1beta4.

The Google App Engine Admin API enables developers to provision and manage
their App Engine applications.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages
from googlecloudsdk.third_party.apitools.base.py import encoding


package = 'appengine'


class ApiConfigHandler(_messages.Message):
  """API Serving configuration for Cloud Endpoints.

  Enums:
    AuthFailActionValueValuesEnum: For users not logged in, how to handle
      access to resources with required login. Defaults to "redirect".
    LoginValueValuesEnum: What level of login is required to access this
      resource. Default is "optional".
    SecurityLevelValueValuesEnum: Configures whether security (HTTPS) should
      be enforced for this URL.

  Fields:
    authFailAction: For users not logged in, how to handle access to resources
      with required login. Defaults to "redirect".
    login: What level of login is required to access this resource. Default is
      "optional".
    script: Specifies the path to the script from the application root
      directory.
    securityLevel: Configures whether security (HTTPS) should be enforced for
      this URL.
    url: URL to serve the endpoint at.
  """

  class AuthFailActionValueValuesEnum(_messages.Enum):
    """For users not logged in, how to handle access to resources with
    required login. Defaults to "redirect".

    Values:
      AUTH_FAIL_ACTION_UNSPECIFIED: Not specified. AUTH_FAIL_ACTION_REDIRECT
        is assumed if unspecified.
      AUTH_FAIL_ACTION_REDIRECT: Redirect user to accounts.google.com. The
        user is redirected back to the application URL after signing in or
        creating an account.
      AUTH_FAIL_ACTION_UNAUTHORIZED: The request is rejected with an HTTP
        status code of 401 and an error message.
    """
    AUTH_FAIL_ACTION_UNSPECIFIED = 0
    AUTH_FAIL_ACTION_REDIRECT = 1
    AUTH_FAIL_ACTION_UNAUTHORIZED = 2

  class LoginValueValuesEnum(_messages.Enum):
    """What level of login is required to access this resource. Default is
    "optional".

    Values:
      LOGIN_UNSPECIFIED: Not specified. LOGIN_OPTIONAL is assumed if
        unspecified.
      LOGIN_OPTIONAL: Does not require that the user is signed in.
      LOGIN_ADMIN: If the user is not signed in, the action given in
        auth_fail_action is taken. In addition, if the user is not an
        administrator for the application, they are given an error message
        (regardless of auth_fail_action setting). If the user is an
        administrator, the handler proceeds.
      LOGIN_REQUIRED: If the user has signed in, the handler proceeds
        normally. Otherwise, the action given in auth_fail_action is taken.
    """
    LOGIN_UNSPECIFIED = 0
    LOGIN_OPTIONAL = 1
    LOGIN_ADMIN = 2
    LOGIN_REQUIRED = 3

  class SecurityLevelValueValuesEnum(_messages.Enum):
    """Configures whether security (HTTPS) should be enforced for this URL.

    Values:
      SECURE_UNSPECIFIED: Not specified.
      SECURE_DEFAULT: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used, and respond accordingly.
      SECURE_NEVER: Requests for a URL that match this handler that use HTTPS
        are automatically redirected to the HTTP equivalent URL.
      SECURE_OPTIONAL: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used, and respond accordingly.
      SECURE_ALWAYS: Requests for a URL that match this handler that do not
        use HTTPS are automatically redirected to the HTTPS URL with the same
        path. Query parameters are reserved for the redirect.
    """
    SECURE_UNSPECIFIED = 0
    SECURE_DEFAULT = 1
    SECURE_NEVER = 2
    SECURE_OPTIONAL = 3
    SECURE_ALWAYS = 4

  authFailAction = _messages.EnumField('AuthFailActionValueValuesEnum', 1)
  login = _messages.EnumField('LoginValueValuesEnum', 2)
  script = _messages.StringField(3)
  securityLevel = _messages.EnumField('SecurityLevelValueValuesEnum', 4)
  url = _messages.StringField(5)


class ApiEndpointHandler(_messages.Message):
  """Use Google Cloud Endpoints to handle requests.

  Fields:
    scriptPath: Specifies the path to the script from the application root
      directory.
  """

  scriptPath = _messages.StringField(1)


class AppengineAppsGetRequest(_messages.Message):
  """A AppengineAppsGetRequest object.

  Fields:
    ensureResourcesExist: Certain resources associated with an application are
      created on-demand. Controls whether these resources should be created
      when performing the `GET` operation. If specified and any resources
      could not be created, the request will fail with an error code.
      Additionally, this parameter can cause the request to take longer to
      complete.
    name: Name of the application to get. For example: "apps/myapp".
  """

  ensureResourcesExist = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class AppengineAppsModulesDeleteRequest(_messages.Message):
  """A AppengineAppsModulesDeleteRequest object.

  Fields:
    name: Name of the resource requested. For example:
      "apps/myapp/modules/default".
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsModulesGetRequest(_messages.Message):
  """A AppengineAppsModulesGetRequest object.

  Fields:
    name: Name of the resource requested. For example:
      "apps/myapp/modules/default".
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsModulesListRequest(_messages.Message):
  """A AppengineAppsModulesListRequest object.

  Fields:
    name: Name of the resource requested. For example: "apps/myapp".
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
  """

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)


class AppengineAppsModulesPatchRequest(_messages.Message):
  """A AppengineAppsModulesPatchRequest object.

  Fields:
    mask: Standard field mask for the set of fields to be updated.
    migrateTraffic: Whether to use Traffic Migration to shift traffic
      gradually. Traffic can only be migrated from a single version to another
      single version.
    module: A Module resource to be passed as the request body.
    name: Name of the resource to update. For example:
      "apps/myapp/modules/default".
  """

  mask = _messages.StringField(1)
  migrateTraffic = _messages.BooleanField(2)
  module = _messages.MessageField('Module', 3)
  name = _messages.StringField(4, required=True)


class AppengineAppsModulesVersionsCreateRequest(_messages.Message):
  """A AppengineAppsModulesVersionsCreateRequest object.

  Fields:
    name: Name of the resource to update. For example:
      "apps/myapp/modules/default".
    version: A Version resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  version = _messages.MessageField('Version', 2)


class AppengineAppsModulesVersionsDeleteRequest(_messages.Message):
  """A AppengineAppsModulesVersionsDeleteRequest object.

  Fields:
    name: Name of the resource requested. For example:
      "apps/myapp/modules/default/versions/v1".
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsModulesVersionsGetRequest(_messages.Message):
  """A AppengineAppsModulesVersionsGetRequest object.

  Enums:
    ViewValueValuesEnum: Controls the set of fields returned in the `Get`
      response.

  Fields:
    name: Name of the resource requested. For example:
      "apps/myapp/modules/default/versions/v1".
    view: Controls the set of fields returned in the `Get` response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """Controls the set of fields returned in the `Get` response.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  name = _messages.StringField(1, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 2)


class AppengineAppsModulesVersionsListRequest(_messages.Message):
  """A AppengineAppsModulesVersionsListRequest object.

  Enums:
    ViewValueValuesEnum: Controls the set of fields returned in the `List`
      response.

  Fields:
    name: Name of the resource requested. For example:
      "apps/myapp/modules/default".
    pageSize: Maximum results to return per page.
    pageToken: Continuation token for fetching the next page of results.
    view: Controls the set of fields returned in the `List` response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    """Controls the set of fields returned in the `List` response.

    Values:
      BASIC: <no description>
      FULL: <no description>
    """
    BASIC = 0
    FULL = 1

  name = _messages.StringField(1, required=True)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  view = _messages.EnumField('ViewValueValuesEnum', 4)


class AppengineAppsOperationsGetRequest(_messages.Message):
  """A AppengineAppsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class AppengineAppsOperationsListRequest(_messages.Message):
  """A AppengineAppsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation collection.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class Application(_messages.Message):
  """An Application contains the top-level configuration of an App Engine
  application.

  Fields:
    codeBucket: A Google Cloud Storage bucket which can be used for storing
      files associated with an application. This bucket is associated with the
      application and can be used by the gcloud deployment commands.
      @OutputOnly
    defaultBucket: A Google Cloud Storage bucket which can be used by the
      application to store content.  @OutputOnly
    dispatchRules: HTTP path dispatch rules for requests to the app that do
      not explicitly target a module or version. The rules are order-
      dependent.
    id: The relative name/path of the application. Example: "myapp".
      @OutputOnly
    location: The location from which the application will be run. Choices are
      "us-central" for United States and "europe-west" for European Union.
      Application instances will run out of data centers in the chosen
      location and all of the application's End User Content will be stored at
      rest in the chosen location. The default is "us-central".
    name: The full path to the application in the API. Example: "apps/myapp".
      @OutputOnly
  """

  codeBucket = _messages.StringField(1)
  defaultBucket = _messages.StringField(2)
  dispatchRules = _messages.MessageField('UrlDispatchRule', 3, repeated=True)
  id = _messages.StringField(4)
  location = _messages.StringField(5)
  name = _messages.StringField(6)


class AutomaticScaling(_messages.Message):
  """Automatic scaling is the scaling policy that App Engine has used since
  its inception. It is based on request rate, response latencies, and other
  application metrics.

  Fields:
    coolDownPeriod: The amount of time that the
      [Autoscaler](https://cloud.google.com/compute/docs/autoscaler/) should
      wait between changes to the number of virtual machines. Applies only to
      the VM runtime.
    cpuUtilization: Target scaling by CPU usage.
    diskUtilization: Target scaling by disk usage.
    maxConcurrentRequests: The number of concurrent requests an automatic
      scaling instance can accept before the scheduler spawns a new instance.
      Default value is chosen based on the runtime.
    maxIdleInstances: The maximum number of idle instances that App Engine
      should maintain for this version.
    maxPendingLatency: The maximum amount of time that App Engine should allow
      a request to wait in the pending queue before starting a new instance to
      handle it.
    maxTotalInstances: Max number of instances that App Engine should start to
      handle requests.
    minIdleInstances: The minimum number of idle instances that App Engine
      should maintain for this version. Only applies to the default version of
      a module, since other versions are not expected to receive significant
      traffic.
    minPendingLatency: The minimum amount of time that App Engine should allow
      a request to wait in the pending queue before starting a new instance to
      handle it.
    minTotalInstances: Minimum number of instances that App Engine should
      maintain.
    networkUtilization: Target scaling by network usage.
    requestUtilization: Target scaling by request utilization.
  """

  coolDownPeriod = _messages.StringField(1)
  cpuUtilization = _messages.MessageField('CpuUtilization', 2)
  diskUtilization = _messages.MessageField('DiskUtilization', 3)
  maxConcurrentRequests = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  maxIdleInstances = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  maxPendingLatency = _messages.StringField(6)
  maxTotalInstances = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  minIdleInstances = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  minPendingLatency = _messages.StringField(9)
  minTotalInstances = _messages.IntegerField(10, variant=_messages.Variant.INT32)
  networkUtilization = _messages.MessageField('NetworkUtilization', 11)
  requestUtilization = _messages.MessageField('RequestUtilization', 12)


class BasicScaling(_messages.Message):
  """A module with basic scaling will create an instance when the application
  receives a request. The instance will be turned down when the app becomes
  idle. Basic scaling is ideal for work that is intermittent or driven by user
  activity.

  Fields:
    idleTimeout: The instance will be shut down this amount of time after
      receiving its last request.
    maxInstances: The maximum number of instances for App Engine to create for
      this version.
  """

  idleTimeout = _messages.StringField(1)
  maxInstances = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class ContainerInfo(_messages.Message):
  """A Docker (container) image which should be used to start the application.

  Fields:
    image: Reference to a hosted container image. Must be a URI to a resource
      in a Docker repository.  Must be fully qualified, including tag or
      digest. e.g. gcr.io/my-project/image:tag or gcr.io/my-
      project/image@digest
  """

  image = _messages.StringField(1)


class CpuUtilization(_messages.Message):
  """Target scaling by CPU usage.

  Fields:
    aggregationWindowLength: The period of time over which CPU utilization is
      calculated.
    targetUtilization: Target (0-1) CPU utilization ratio to maintain when
      scaling.
  """

  aggregationWindowLength = _messages.StringField(1)
  targetUtilization = _messages.FloatField(2)


class Deployment(_messages.Message):
  """Code and application artifacts used to deploy a version to App Engine.

  Messages:
    FilesValue: A manifest of files stored in Google Cloud Storage which
      should be included as part of this application. All files must be
      readable using the credentials supplied with this call.

  Fields:
    container: If supplied, a docker (container) image which should be used to
      start the application. Only applicable to the 'vm' runtime.
    files: A manifest of files stored in Google Cloud Storage which should be
      included as part of this application. All files must be readable using
      the credentials supplied with this call.
    sourceReferences: The origin of the source code for this deployment. There
      can be more than one source reference per Version if source code is
      distributed among multiple repositories.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FilesValue(_messages.Message):
    """A manifest of files stored in Google Cloud Storage which should be
    included as part of this application. All files must be readable using the
    credentials supplied with this call.

    Messages:
      AdditionalProperty: An additional property for a FilesValue object.

    Fields:
      additionalProperties: Additional properties of type FilesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a FilesValue object.

      Fields:
        key: Name of the additional property.
        value: A FileInfo attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('FileInfo', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  container = _messages.MessageField('ContainerInfo', 1)
  files = _messages.MessageField('FilesValue', 2)
  sourceReferences = _messages.MessageField('SourceReference', 3, repeated=True)


class DiskUtilization(_messages.Message):
  """Target scaling by disk usage (for VM runtimes only).

  Fields:
    targetReadBytesPerSec: Target bytes per second read.
    targetReadOpsPerSec: Target ops per second read.
    targetWriteBytesPerSec: Target bytes per second written.
    targetWriteOpsPerSec: Target ops per second written.
  """

  targetReadBytesPerSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetReadOpsPerSec = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  targetWriteBytesPerSec = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  targetWriteOpsPerSec = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ErrorHandler(_messages.Message):
  """A custom static error page to be served when an error occurs.

  Enums:
    ErrorCodeValueValuesEnum: The error condition this handler applies to.

  Fields:
    errorCode: The error condition this handler applies to.
    mimeType: MIME type of file. If unspecified, "text/html" is assumed.
    staticFile: Static file content to be served for this error.
  """

  class ErrorCodeValueValuesEnum(_messages.Enum):
    """The error condition this handler applies to.

    Values:
      ERROR_CODE_UNSPECIFIED: Not specified. ERROR_CODE_DEFAULT is assume if
        not specified.
      ERROR_CODE_DEFAULT: All other error types.
      ERROR_CODE_OVER_QUOTA: The app has exceeded a resource quota.
      ERROR_CODE_DOS_API_DENIAL: Served to any client blocked by an app's DoS
        Protection configuration.
      ERROR_CODE_TIMEOUT: Served if a deadline is reached before there is a
        response from the app.
    """
    ERROR_CODE_UNSPECIFIED = 0
    ERROR_CODE_DEFAULT = 1
    ERROR_CODE_OVER_QUOTA = 2
    ERROR_CODE_DOS_API_DENIAL = 3
    ERROR_CODE_TIMEOUT = 4

  errorCode = _messages.EnumField('ErrorCodeValueValuesEnum', 1)
  mimeType = _messages.StringField(2)
  staticFile = _messages.StringField(3)


class FileInfo(_messages.Message):
  """A single source file which is part of the application to be deployed.

  Fields:
    mimeType: The MIME type of the file; if unspecified, the value from Google
      Cloud Storage will be used.
    sha1Sum: The SHA1 (160 bits) hash of the file in hex.
    sourceUrl: The URL source to use to fetch this file. Must be a URL to a
      resource in Google Cloud Storage in the form
      'http(s)://storage.googleapis.com/\<bucket\>/\<object\>'.
  """

  mimeType = _messages.StringField(1)
  sha1Sum = _messages.StringField(2)
  sourceUrl = _messages.StringField(3)


class HealthCheck(_messages.Message):
  """Configure health checking for the VM instances. Unhealthy VM instances
  will be killed and replaced with new instances.

  Fields:
    checkInterval: The interval between health checks.
    disableHealthCheck: Whether to explicitly disable health checks for this
      instance.
    healthyThreshold: The number of consecutive successful health checks
      before receiving traffic.
    host: The host header to send when performing an HTTP health check (e.g.
      myapp.appspot.com)
    restartThreshold: The number of consecutive failed health checks before an
      instance is restarted.
    timeout: The amount of time before the health check is considered failed.
    unhealthyThreshold: The number of consecutive failed health checks before
      removing traffic.
  """

  checkInterval = _messages.StringField(1)
  disableHealthCheck = _messages.BooleanField(2)
  healthyThreshold = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  host = _messages.StringField(4)
  restartThreshold = _messages.IntegerField(5, variant=_messages.Variant.UINT32)
  timeout = _messages.StringField(6)
  unhealthyThreshold = _messages.IntegerField(7, variant=_messages.Variant.UINT32)


class Library(_messages.Message):
  """A Python runtime third-party library required by the application.

  Fields:
    name: The name of the library, e.g. "PIL" or "django".
    version: The version of the library to select, or "latest".
  """

  name = _messages.StringField(1)
  version = _messages.StringField(2)


class ListModulesResponse(_messages.Message):
  """Response message for `Modules.ListModules`.

  Fields:
    modules: The modules belonging to the requested application.
    nextPageToken: Continuation token for fetching the next page of results.
  """

  modules = _messages.MessageField('Module', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  """The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class ListVersionsResponse(_messages.Message):
  """Response message for `Versions.ListVersions`.

  Fields:
    nextPageToken: Continuation token for fetching the next page of results.
    versions: The versions belonging to the requested application module.
  """

  nextPageToken = _messages.StringField(1)
  versions = _messages.MessageField('Version', 2, repeated=True)


class ManualScaling(_messages.Message):
  """A module with manual scaling runs continuously, allowing you to perform
  complex initialization and rely on the state of its memory over time.

  Fields:
    instances: The number of instances to assign to the module at the start.
      This number can later be altered by using the [Modules
      API](https://cloud.google.com/appengine/docs/python/modules/functions)
      `set_num_instances()` function.
  """

  instances = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class Module(_messages.Message):
  """A module is a component of an application that provides a single service
  or configuration. A module has a collection of versions that define a
  specific set of code used to implement the functionality of that module.

  Fields:
    id: The relative name/path of the module within the application. Example:
      "default"  @OutputOnly
    name: The full path to the Module resource in the API. Example:
      "apps/myapp/modules/default"  @OutputOnly
    split: A mapping that defines fractional HTTP traffic diversion to
      different versions within the module.
  """

  id = _messages.StringField(1)
  name = _messages.StringField(2)
  split = _messages.MessageField('TrafficSplit', 3)


class Network(_messages.Message):
  """Used to specify extra network settings (for VM runtimes only).

  Fields:
    forwardedPorts: A list of ports (or port pairs) to forward from the VM
      into the app container.
    instanceTag: A tag to apply to the VM instance during creation.
    name: The Google Compute Engine network where the VMs will be created. If
      not specified, or empty, the network named "default" will be used. (The
      short name should be specified, not the resource path.)
  """

  forwardedPorts = _messages.StringField(1, repeated=True)
  instanceTag = _messages.StringField(2)
  name = _messages.StringField(3)


class NetworkUtilization(_messages.Message):
  """Target scaling by network usage (for VM runtimes only).

  Fields:
    targetReceivedBytesPerSec: Target bytes per second received.
    targetReceivedPacketsPerSec: Target packets per second received.
    targetSentBytesPerSec: Target bytes per second sent.
    targetSentPacketsPerSec: Target packets per second sent.
  """

  targetReceivedBytesPerSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetReceivedPacketsPerSec = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  targetSentBytesPerSec = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  targetSentPacketsPerSec = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class Operation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If true, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping
      above, the `name` should have the format of
      `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  """Metadata for the given google.longrunning.Operation.

  Fields:
    endTime: Timestamp that this operation was completed. (Not present if the
      operation is still in progress.)  @OutputOnly
    insertTime: Timestamp that this operation was received.  @OutputOnly
    method: API method name that initiated the operation. Example:
      "google.appengine.v1beta4.Version.CreateVersion".  @OutputOnly
    operationType: The type of the operation (deprecated, use method field
      instead). Example: "create_version".  @OutputOnly
    target: Resource that this operation is acting on. Example:
      "apps/myapp/modules/default".  @OutputOnly
    user: The user who requested this operation.  @OutputOnly
  """

  endTime = _messages.StringField(1)
  insertTime = _messages.StringField(2)
  method = _messages.StringField(3)
  operationType = _messages.StringField(4)
  target = _messages.StringField(5)
  user = _messages.StringField(6)


class OperationMetadataV1Beta5(_messages.Message):
  """Metadata for the given google.longrunning.Operation.

  Fields:
    endTime: Timestamp that this operation was completed. (Not present if the
      operation is still in progress.)  @OutputOnly
    insertTime: Timestamp that this operation was received.  @OutputOnly
    method: API method name that initiated the operation. Example:
      "google.appengine.v1beta5.Version.CreateVersion".  @OutputOnly
    target: Resource that this operation is acting on. Example:
      "apps/myapp/services/default".  @OutputOnly
    user: The user who requested this operation.  @OutputOnly
  """

  endTime = _messages.StringField(1)
  insertTime = _messages.StringField(2)
  method = _messages.StringField(3)
  target = _messages.StringField(4)
  user = _messages.StringField(5)


class RequestUtilization(_messages.Message):
  """Target scaling by request utilization (for VM runtimes only).

  Fields:
    targetConcurrentRequests: Target number of concurrent requests.
    targetRequestCountPerSec: Target requests per second.
  """

  targetConcurrentRequests = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  targetRequestCountPerSec = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Resources(_messages.Message):
  """Used to specify how many machine resources an app version needs.

  Fields:
    cpu: How many CPU cores an app version needs.
    diskGb: How much disk size, in GB, an app version needs.
    memoryGb: How much memory, in GB, an app version needs.
  """

  cpu = _messages.FloatField(1)
  diskGb = _messages.FloatField(2)
  memoryGb = _messages.FloatField(3)


class ScriptHandler(_messages.Message):
  """Executes a script to handle the request that matches the URL pattern.

  Fields:
    scriptPath: Specifies the path to the script from the application root
      directory.
  """

  scriptPath = _messages.StringField(1)


class SourceReference(_messages.Message):
  """A reference to a particular snapshot of the source tree used to build and
  deploy the application.

  Fields:
    repository: Optional. A URI string identifying the repository. Example:
      "https://source.developers.google.com/p/app-123/r/default"
    revisionId: The canonical (and persistent) identifier of the deployed
      revision, i.e. any kind of aliases including tags or branch names are
      not allowed. Example (git): "2198322f89e0bb2e25021667c2ed489d1fd34e6b"
  """

  repository = _messages.StringField(1)
  revisionId = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class StaticDirectoryHandler(_messages.Message):
  """Files served directly to the user for a given URL, such as images, CSS
  stylesheets, or JavaScript source files. Static directory handlers make it
  easy to serve the entire contents of a directory as static files.

  Messages:
    HttpHeadersValue: HTTP headers to use for all responses from these URLs.

  Fields:
    applicationReadable: By default, files declared in static file handlers
      are uploaded as static data and are only served to end users, they
      cannot be read by an application. If this field is set to true, the
      files are also uploaded as code data so your application can read them.
      Both uploads are charged against your code and static data storage
      resource quotas.
    directory: The path to the directory containing the static files, from the
      application root directory. Everything after the end of the matched url
      pattern is appended to static_dir to form the full path to the requested
      file.
    expiration: The length of time a static file served by this handler ought
      to be cached by web proxies and browsers.
    httpHeaders: HTTP headers to use for all responses from these URLs.
    mimeType: If specified, all files served by this handler will be served
      using the specified MIME type. If not specified, the MIME type for a
      file will be derived from the file's filename extension.
    requireMatchingFile: If true, this UrlMap entry does not match the request
      unless the file referenced by the handler also exists. If no such file
      exists, processing will continue with the next UrlMap that matches the
      requested URL.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HttpHeadersValue(_messages.Message):
    """HTTP headers to use for all responses from these URLs.

    Messages:
      AdditionalProperty: An additional property for a HttpHeadersValue
        object.

    Fields:
      additionalProperties: Additional properties of type HttpHeadersValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a HttpHeadersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  applicationReadable = _messages.BooleanField(1)
  directory = _messages.StringField(2)
  expiration = _messages.StringField(3)
  httpHeaders = _messages.MessageField('HttpHeadersValue', 4)
  mimeType = _messages.StringField(5)
  requireMatchingFile = _messages.BooleanField(6)


class StaticFilesHandler(_messages.Message):
  """Files served directly to the user for a given URL, such as images, CSS
  stylesheets, or JavaScript source files. Static file handlers describe which
  files in the application directory are static files, and which URLs serve
  them.

  Messages:
    HttpHeadersValue: HTTP headers to use for all responses from these URLs.

  Fields:
    applicationReadable: By default, files declared in static file handlers
      are uploaded as static data and are only served to end users, they
      cannot be read by an application. If this field is set to true, the
      files are also uploaded as code data so your application can read them.
      Both uploads are charged against your code and static data storage
      resource quotas.
    expiration: The length of time a static file served by this handler ought
      to be cached by web proxies and browsers.
    httpHeaders: HTTP headers to use for all responses from these URLs.
    mimeType: If specified, all files served by this handler will be served
      using the specified MIME type. If not specified, the MIME type for a
      file will be derived from the file's filename extension.
    path: The path to the static files matched by the URL pattern, from the
      application root directory. The path can refer to text matched in
      groupings in the URL pattern.
    requireMatchingFile: If true, this UrlMap entry does not match the request
      unless the file referenced by the handler also exists. If no such file
      exists, processing will continue with the next UrlMap that matches the
      requested URL.
    uploadPathRegex: A regular expression that matches the file paths for all
      files that will be referenced by this handler.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HttpHeadersValue(_messages.Message):
    """HTTP headers to use for all responses from these URLs.

    Messages:
      AdditionalProperty: An additional property for a HttpHeadersValue
        object.

    Fields:
      additionalProperties: Additional properties of type HttpHeadersValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a HttpHeadersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  applicationReadable = _messages.BooleanField(1)
  expiration = _messages.StringField(2)
  httpHeaders = _messages.MessageField('HttpHeadersValue', 3)
  mimeType = _messages.StringField(4)
  path = _messages.StringField(5)
  requireMatchingFile = _messages.BooleanField(6)
  uploadPathRegex = _messages.StringField(7)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TrafficSplit(_messages.Message):
  """Configuration for traffic splitting for versions within a single module.
  Traffic splitting allows traffic directed to the module to be assigned to
  one of several versions in a fractional way, enabling experiments and
  canarying new builds, for example.

  Enums:
    ShardByValueValuesEnum: Which mechanism should be used as a selector when
      choosing a version to send a request to. The traffic selection algorithm
      will be stable for either type until allocations are changed.

  Messages:
    AllocationsValue: Mapping from module version IDs within the module to
      fractional (0.000, 1] allocations of traffic for that version. Each
      version may only be specified once, but some versions in the module may
      not have any traffic allocation. Modules that have traffic allocated in
      this field may not be deleted until the module is deleted, or their
      traffic allocation is removed. Allocations must sum to 1. Supports
      precision up to two decimal places for IP-based splits and up to three
      decimal places for cookie-based splits.

  Fields:
    allocations: Mapping from module version IDs within the module to
      fractional (0.000, 1] allocations of traffic for that version. Each
      version may only be specified once, but some versions in the module may
      not have any traffic allocation. Modules that have traffic allocated in
      this field may not be deleted until the module is deleted, or their
      traffic allocation is removed. Allocations must sum to 1. Supports
      precision up to two decimal places for IP-based splits and up to three
      decimal places for cookie-based splits.
    shardBy: Which mechanism should be used as a selector when choosing a
      version to send a request to. The traffic selection algorithm will be
      stable for either type until allocations are changed.
  """

  class ShardByValueValuesEnum(_messages.Enum):
    """Which mechanism should be used as a selector when choosing a version to
    send a request to. The traffic selection algorithm will be stable for
    either type until allocations are changed.

    Values:
      UNSPECIFIED: Diversion method unspecified.
      COOKIE: Diversion based on a specially named cookie, "GOOGAPPUID." The
        cookie must be set by the app itself or else no diversion will occur.
      IP: Diversion based on applying the modulus operation to a fingerprint
        of the IP address.
    """
    UNSPECIFIED = 0
    COOKIE = 1
    IP = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AllocationsValue(_messages.Message):
    """Mapping from module version IDs within the module to fractional (0.000,
    1] allocations of traffic for that version. Each version may only be
    specified once, but some versions in the module may not have any traffic
    allocation. Modules that have traffic allocated in this field may not be
    deleted until the module is deleted, or their traffic allocation is
    removed. Allocations must sum to 1. Supports precision up to two decimal
    places for IP-based splits and up to three decimal places for cookie-based
    splits.

    Messages:
      AdditionalProperty: An additional property for a AllocationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AllocationsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a AllocationsValue object.

      Fields:
        key: Name of the additional property.
        value: A number attribute.
      """

      key = _messages.StringField(1)
      value = _messages.FloatField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allocations = _messages.MessageField('AllocationsValue', 1)
  shardBy = _messages.EnumField('ShardByValueValuesEnum', 2)


class UrlDispatchRule(_messages.Message):
  """Rules to match an HTTP request and dispatch that request to a module.

  Fields:
    domain: The domain name to match on. Supports '*' (glob) wildcarding on
      the left-hand side of a '.'. If empty, all domains will be matched (the
      same as '*').
    module: The resource id of a Module in this application that should
      service the matched request. The Module must already exist. Example:
      "default".
    path: The pathname within the host. This must start with a '/'. A single
      '*' (glob) can be included at the end of the path. The sum of the
      lengths of the domain and path may not exceed 100 characters.
  """

  domain = _messages.StringField(1)
  module = _messages.StringField(2)
  path = _messages.StringField(3)


class UrlMap(_messages.Message):
  """A URL pattern and description of how it should be handled. App Engine can
  handle URLs by executing application code, or by serving static files
  uploaded with the code, such as images, CSS or JavaScript.

  Enums:
    AuthFailActionValueValuesEnum: For users not logged in, how to handle
      access to resources with required login. Defaults to "redirect".
    LoginValueValuesEnum: What level of login is required to access this
      resource.
    RedirectHttpResponseCodeValueValuesEnum: `30x` code to use when performing
      redirects for the `secure` field. A `302` is used by default.
    SecurityLevelValueValuesEnum: Configures whether security (HTTPS) should
      be enforced for this URL.

  Fields:
    apiEndpoint: Use API Endpoints to handle requests.
    authFailAction: For users not logged in, how to handle access to resources
      with required login. Defaults to "redirect".
    login: What level of login is required to access this resource.
    redirectHttpResponseCode: `30x` code to use when performing redirects for
      the `secure` field. A `302` is used by default.
    script: Executes a script to handle the request that matches the URL
      pattern.
    securityLevel: Configures whether security (HTTPS) should be enforced for
      this URL.
    staticDirectory: Serves the entire contents of a directory as static
      files.  This attribute is deprecated. You can mimic the behavior of
      static directories using static files.
    staticFiles: Returns the contents of a file, such as an image, as the
      response.
    urlRegex: A URL prefix. This value uses regular expression syntax (and so
      regexp special characters must be escaped), but it should not contain
      groupings. All URLs that begin with this prefix are handled by this
      handler, using the portion of the URL after the prefix as part of the
      file path. This is always required.
  """

  class AuthFailActionValueValuesEnum(_messages.Enum):
    """For users not logged in, how to handle access to resources with
    required login. Defaults to "redirect".

    Values:
      AUTH_FAIL_ACTION_UNSPECIFIED: Not specified. AUTH_FAIL_ACTION_REDIRECT
        is assumed if unspecified.
      AUTH_FAIL_ACTION_REDIRECT: Redirect user to accounts.google.com. The
        user is redirected back to the application URL after signing in or
        creating an account.
      AUTH_FAIL_ACTION_UNAUTHORIZED: The request is rejected with an HTTP
        status code of 401 and an error message.
    """
    AUTH_FAIL_ACTION_UNSPECIFIED = 0
    AUTH_FAIL_ACTION_REDIRECT = 1
    AUTH_FAIL_ACTION_UNAUTHORIZED = 2

  class LoginValueValuesEnum(_messages.Enum):
    """What level of login is required to access this resource.

    Values:
      LOGIN_UNSPECIFIED: Not specified. LOGIN_OPTIONAL is assumed if
        unspecified.
      LOGIN_OPTIONAL: Does not require that the user is signed in.
      LOGIN_ADMIN: If the user is not signed in, the action given in
        auth_fail_action is taken. In addition, if the user is not an
        administrator for the application, they are given an error message
        (regardless of auth_fail_action setting). If the user is an
        administrator, the handler proceeds.
      LOGIN_REQUIRED: If the user has signed in, the handler proceeds
        normally. Otherwise, the action given in auth_fail_action is taken.
    """
    LOGIN_UNSPECIFIED = 0
    LOGIN_OPTIONAL = 1
    LOGIN_ADMIN = 2
    LOGIN_REQUIRED = 3

  class RedirectHttpResponseCodeValueValuesEnum(_messages.Enum):
    """`30x` code to use when performing redirects for the `secure` field. A
    `302` is used by default.

    Values:
      REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED: Not specified. A `302` is
        assumed if unspecified.
      REDIRECT_HTTP_RESPONSE_CODE_301: A `301 Moved Permanently` code.
      REDIRECT_HTTP_RESPONSE_CODE_302: A `302 Moved Temporarily` code.
      REDIRECT_HTTP_RESPONSE_CODE_303: A `303 See Other` code.
      REDIRECT_HTTP_RESPONSE_CODE_307: A `307 Temporary Redirect` code.
    """
    REDIRECT_HTTP_RESPONSE_CODE_UNSPECIFIED = 0
    REDIRECT_HTTP_RESPONSE_CODE_301 = 1
    REDIRECT_HTTP_RESPONSE_CODE_302 = 2
    REDIRECT_HTTP_RESPONSE_CODE_303 = 3
    REDIRECT_HTTP_RESPONSE_CODE_307 = 4

  class SecurityLevelValueValuesEnum(_messages.Enum):
    """Configures whether security (HTTPS) should be enforced for this URL.

    Values:
      SECURE_UNSPECIFIED: Not specified.
      SECURE_DEFAULT: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used, and respond accordingly.
      SECURE_NEVER: Requests for a URL that match this handler that use HTTPS
        are automatically redirected to the HTTP equivalent URL.
      SECURE_OPTIONAL: Both HTTP and HTTPS requests with URLs that match the
        handler succeed without redirects. The application can examine the
        request to determine which protocol was used, and respond accordingly.
      SECURE_ALWAYS: Requests for a URL that match this handler that do not
        use HTTPS are automatically redirected to the HTTPS URL with the same
        path. Query parameters are reserved for the redirect.
    """
    SECURE_UNSPECIFIED = 0
    SECURE_DEFAULT = 1
    SECURE_NEVER = 2
    SECURE_OPTIONAL = 3
    SECURE_ALWAYS = 4

  apiEndpoint = _messages.MessageField('ApiEndpointHandler', 1)
  authFailAction = _messages.EnumField('AuthFailActionValueValuesEnum', 2)
  login = _messages.EnumField('LoginValueValuesEnum', 3)
  redirectHttpResponseCode = _messages.EnumField('RedirectHttpResponseCodeValueValuesEnum', 4)
  script = _messages.MessageField('ScriptHandler', 5)
  securityLevel = _messages.EnumField('SecurityLevelValueValuesEnum', 6)
  staticDirectory = _messages.MessageField('StaticDirectoryHandler', 7)
  staticFiles = _messages.MessageField('StaticFilesHandler', 8)
  urlRegex = _messages.StringField(9)


class Version(_messages.Message):
  """A Version is a specific set of source code and configuration files
  deployed to a module.

  Enums:
    InboundServicesValueListEntryValuesEnum:
    ServingStatusValueValuesEnum: The current serving status of this version.
      Only `SERVING` versions will have instances created or billed for.  If
      this field is unset when a version is created, `SERVING` status will be
      assumed. It is an error to explicitly set this field to
      `SERVING_STATUS_UNSPECIFIED`.

  Messages:
    BetaSettingsValue: Beta settings supplied to the application via metadata.
    EnvVariablesValue: Environment variables made available to the
      application. Only returned in `GET` requests if `view=FULL` is set. May
      only be set on create requests; once created, is immutable.

  Fields:
    apiConfig: Serving configuration for Google Cloud Endpoints. Only returned
      in `GET` requests if `view=FULL` is set. May only be set on create
      requests; once created, is immutable.
    automaticScaling: Automatic scaling is the scaling policy that App Engine
      has used since its inception. It is based on request rate, response
      latencies, and other application metrics.
    basicScaling: A module with basic scaling will create an instance when the
      application receives a request. The instance will be turned down when
      the app becomes idle. Basic scaling is ideal for work that is
      intermittent or driven by user activity.
    betaSettings: Beta settings supplied to the application via metadata.
    creationTime: Creation time of this version. This will be between the
      start and end times of the operation that creates this version.
      @OutputOnly
    defaultExpiration: The length of time a static file served by a static
      file handler ought to be cached by web proxies and browsers, if the
      handler does not specify its own expiration. Only returned in `GET`
      requests if `view=FULL` is set. May only be set on create requests; once
      created, is immutable.
    deployer: The email address of the user who created this version.
      @OutputOnly
    deployment: Code and application artifacts that make up this version. Only
      returned in `GET` requests if `view=FULL` is set. May only be set on
      create requests; once created, is immutable.
    env: The App Engine execution environment to use for this version.
      Default: "1"
    envVariables: Environment variables made available to the application.
      Only returned in `GET` requests if `view=FULL` is set. May only be set
      on create requests; once created, is immutable.
    errorHandlers: Custom static error pages instead of these generic error
      pages, (limit 10 KB/page) Only returned in `GET` requests if `view=FULL`
      is set. May only be set on create requests; once created, is immutable.
    handlers: An ordered list of URL Matching patterns that should be applied
      to incoming requests. The first matching URL consumes the request, and
      subsequent handlers are not attempted. Only returned in `GET` requests
      if `view=FULL` is set. May only be set on create requests; once created,
      is immutable.
    healthCheck: Configure health checking for the VM instances. Unhealthy VM
      instances will be stopped and replaced with new instances. Only returned
      in `GET` requests if `view=FULL` is set. May only be set on create
      requests; once created, is immutable.
    id: The relative name/path of the Version within the module.  Example:
      "v1". Version specifiers can contain lowercase letters, digits, and
      hyphens. It cannot begin with the prefix `ah-` and the names `default`
      and `latest` are reserved and cannot be used.
    inboundServices: Before an application can receive email or XMPP messages,
      the application must be configured to enable the service.
    instanceClass: The frontend instance class to use to run this app. Valid
      values are `[F1, F2, F4, F4_1G]`.  Default: "F1"
    libraries: Configuration for Python runtime third-party libraries required
      by the application. Only returned in `GET` requests if `view=FULL` is
      set. May only be set on create requests; once created, is immutable.
    manualScaling: A module with manual scaling runs continuously, allowing
      you to perform complex initialization and rely on the state of its
      memory over time.
    name: The full path to the Version resource in the API.  Example:
      "apps/myapp/modules/default/versions/v1".  @OutputOnly
    network: Used to specify extra network settings (for VM runtimes only).
    nobuildFilesRegex: Go only. Files that match this pattern will not be
      built into the app. May only be set on create requests.
    resources: Used to specify how many machine resources an app version needs
      (for VM runtimes only).
    runtime: The desired runtime. Values can include python27, java7, go, etc.
    servingStatus: The current serving status of this version. Only `SERVING`
      versions will have instances created or billed for.  If this field is
      unset when a version is created, `SERVING` status will be assumed. It is
      an error to explicitly set this field to `SERVING_STATUS_UNSPECIFIED`.
    threadsafe: If true, multiple requests can be dispatched to the app at
      once.
    vm: Whether to deploy this app in a VM container.
  """

  class InboundServicesValueListEntryValuesEnum(_messages.Enum):
    """InboundServicesValueListEntryValuesEnum enum type.

    Values:
      INBOUND_SERVICE_UNSPECIFIED: <no description>
      INBOUND_SERVICE_MAIL: <no description>
      INBOUND_SERVICE_MAIL_BOUNCE: <no description>
      INBOUND_SERVICE_XMPP_ERROR: <no description>
      INBOUND_SERVICE_XMPP_MESSAGE: <no description>
      INBOUND_SERVICE_XMPP_SUBSCRIBE: <no description>
      INBOUND_SERVICE_XMPP_PRESENCE: <no description>
      INBOUND_SERVICE_CHANNEL_PRESENCE: <no description>
      INBOUND_SERVICE_WARMUP: <no description>
    """
    INBOUND_SERVICE_UNSPECIFIED = 0
    INBOUND_SERVICE_MAIL = 1
    INBOUND_SERVICE_MAIL_BOUNCE = 2
    INBOUND_SERVICE_XMPP_ERROR = 3
    INBOUND_SERVICE_XMPP_MESSAGE = 4
    INBOUND_SERVICE_XMPP_SUBSCRIBE = 5
    INBOUND_SERVICE_XMPP_PRESENCE = 6
    INBOUND_SERVICE_CHANNEL_PRESENCE = 7
    INBOUND_SERVICE_WARMUP = 8

  class ServingStatusValueValuesEnum(_messages.Enum):
    """The current serving status of this version. Only `SERVING` versions
    will have instances created or billed for.  If this field is unset when a
    version is created, `SERVING` status will be assumed. It is an error to
    explicitly set this field to `SERVING_STATUS_UNSPECIFIED`.

    Values:
      SERVING_STATUS_UNSPECIFIED: Not specified.
      SERVING: Currently serving. Instances will be created according to the
        version's scaling settings.
      STOPPED: Disabled from serving. No instances will run and any scaling
        settings will be ignored until the version is moved to the `SERVING`
        state.
    """
    SERVING_STATUS_UNSPECIFIED = 0
    SERVING = 1
    STOPPED = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class BetaSettingsValue(_messages.Message):
    """Beta settings supplied to the application via metadata.

    Messages:
      AdditionalProperty: An additional property for a BetaSettingsValue
        object.

    Fields:
      additionalProperties: Additional properties of type BetaSettingsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a BetaSettingsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class EnvVariablesValue(_messages.Message):
    """Environment variables made available to the application. Only returned
    in `GET` requests if `view=FULL` is set. May only be set on create
    requests; once created, is immutable.

    Messages:
      AdditionalProperty: An additional property for a EnvVariablesValue
        object.

    Fields:
      additionalProperties: Additional properties of type EnvVariablesValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a EnvVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  apiConfig = _messages.MessageField('ApiConfigHandler', 1)
  automaticScaling = _messages.MessageField('AutomaticScaling', 2)
  basicScaling = _messages.MessageField('BasicScaling', 3)
  betaSettings = _messages.MessageField('BetaSettingsValue', 4)
  creationTime = _messages.StringField(5)
  defaultExpiration = _messages.StringField(6)
  deployer = _messages.StringField(7)
  deployment = _messages.MessageField('Deployment', 8)
  env = _messages.StringField(9)
  envVariables = _messages.MessageField('EnvVariablesValue', 10)
  errorHandlers = _messages.MessageField('ErrorHandler', 11, repeated=True)
  handlers = _messages.MessageField('UrlMap', 12, repeated=True)
  healthCheck = _messages.MessageField('HealthCheck', 13)
  id = _messages.StringField(14)
  inboundServices = _messages.EnumField('InboundServicesValueListEntryValuesEnum', 15, repeated=True)
  instanceClass = _messages.StringField(16)
  libraries = _messages.MessageField('Library', 17, repeated=True)
  manualScaling = _messages.MessageField('ManualScaling', 18)
  name = _messages.StringField(19)
  network = _messages.MessageField('Network', 20)
  nobuildFilesRegex = _messages.StringField(21)
  resources = _messages.MessageField('Resources', 22)
  runtime = _messages.StringField(23)
  servingStatus = _messages.EnumField('ServingStatusValueValuesEnum', 24)
  threadsafe = _messages.BooleanField(25)
  vm = _messages.BooleanField(26)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'appengine')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'appengine')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'appengine')
