package Data::RandomPerson::Names::AncientGreekFemale;

use strict;
use warnings;

use base 'Data::RandomPerson::Names';

use Data::RandomPerson::Choice;

sub new {
    my ($class) = @_;

    my $self = bless {}, $class;

    $self->{choice} = Data::RandomPerson::Choice->new();

    my @names = <DATA>;
    close DATA;
    chomp (@names);
    $self->{choice}->add_list(@names);

    return $self;
}

1;

=pod

=head1 NAME

Data::RandomPerson::Names::AncientGreekFemale - A list of female names

=head1 SYNOPSIS

  use Data::RandomPerson::Names::AncientGreekFemale;

  my $n = Data::RandomPerson::Names::AncientGreekFemale->new();

  print $n->get();

=head1 DESCRIPTION

=head2 Overview

Returns a random element from a list of female names culled from Chris Pound's language machines
page at L<http://generators.christopherpound.com/>.

=head2 Constructors and initialization

=over 4

=item new( )

Create the Data::RandomPerson::Names::AncientGreekFemale object.

=back

=head2 Class and object methods

=over 4

=item get( )

Returns a random name from the list.

=item size( )

Returns the size of the list

=back

=head1 AUTHOR

Peter Hickman (peterhi@ntlworld.com)

=head1 COPYRIGHT

Copyright (c) 2005, Peter Hickman. This module is
free software. It may be used, redistributed and/or modified under the
same terms as Perl itself.

=cut

__DATA__
actaia
actoris
aegialeia
aerope
aethra
aethylla
aganippe
aglaia
alcimede
amphinome
anticlea
arne
astynome
astyoche
autolye
callianeira
canache
chione
chloe
circe
clytemnestra
clytie
creusa
cymodece
danae
daphne
deianara
deidameia
dirce
dynamene
eidyia
eriphyle
eurynome
galatea
halia
helen
hesione
hiera
ianassa
iaria
leda
leucippe
limnoraea
maera
mante
meda
melantho
melite
metaneira
nacippe
nemertes
nesaea
orithyia
otionia
panope
penthesilia
periboea
perimede
periopis
pero
pherusa
philomele
polymede
polymele
polypheme
polyxena
prote
protogoria
scarphe
sibyl
speio
tecmessa
thaleia
theano
thoe
xanthippe
xenoclea
