/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.python.core.Options;

class CommandLineOptions {
    public String filename = null;
    public boolean jar = false;
    public boolean interactive = true;
    public boolean notice = true;
    private boolean fixInteractive = false;
    public boolean help = false;
    public boolean version = false;
    public String[] argv;
    public Properties properties;
    public String command;
    public Vector warnoptions = new Vector();
    public String encoding;

    public void setProperty(String key, String value) {
        ((Hashtable)this.properties).put(key, value);
    }

    public boolean parse(String[] args) {
        int index = 0;
        while (index < args.length && args[index].startsWith("-")) {
            String arg = args[index];
            if (arg.equals("--help")) {
                this.help = true;
                return false;
            }
            if (arg.equals("--version")) {
                this.version = true;
                return false;
            }
            if (arg.equals("-")) {
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
                this.filename = "-";
            } else if (arg.equals("-i")) {
                this.fixInteractive = true;
                this.interactive = true;
            } else if (arg.equals("-jar")) {
                this.jar = true;
                if (!this.fixInteractive) {
                    this.interactive = false;
                }
            } else if (arg.equals("-v")) {
                ++Options.verbose;
            } else if (arg.equals("-vv")) {
                Options.verbose += 2;
            } else if (arg.equals("-vvv")) {
                Options.verbose += 3;
            } else if (arg.equals("-S")) {
                Options.importSite = false;
            } else {
                if (arg.equals("-c")) {
                    this.command = args[++index];
                    if (!this.fixInteractive) {
                        this.interactive = false;
                    }
                    ++index;
                    break;
                }
                if (arg.equals("-W")) {
                    this.warnoptions.addElement(args[++index]);
                } else if (arg.equals("-E")) {
                    this.encoding = args[++index];
                } else if (arg.startsWith("-D")) {
                    String key = null;
                    String value = null;
                    int equals = arg.indexOf("=");
                    if (equals == -1) {
                        String arg2 = args[++index];
                        key = arg.substring(2, arg.length());
                        value = arg2;
                    } else {
                        key = arg.substring(2, equals);
                        value = arg.substring(equals + 1, arg.length());
                    }
                    this.setProperty(key, value);
                } else {
                    String opt = args[index];
                    if (opt.startsWith("--")) {
                        opt = opt.substring(2);
                    } else if (opt.startsWith("-")) {
                        opt = opt.substring(1);
                    }
                    System.err.println("jython: illegal option -- " + opt);
                    return false;
                }
            }
            ++index;
        }
        this.notice = this.interactive;
        if (this.filename == null && index < args.length && this.command == null) {
            this.filename = args[index++];
            if (!this.fixInteractive) {
                this.interactive = false;
            }
            this.notice = false;
        }
        if (this.command != null) {
            this.notice = false;
        }
        int n = args.length - index + 1;
        this.argv = new String[n];
        this.argv[0] = this.filename != null ? this.filename : (this.command != null ? "-c" : "");
        int i = 1;
        while (i < n) {
            this.argv[i] = args[index];
            ++i;
            ++index;
        }
        return true;
    }

    public CommandLineOptions() {
        this.properties = new Properties();
    }
}

