/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.alignment;
import org.openoffice.xmerge.converter.xml.conversionAlgorithm;
import org.openoffice.xmerge.converter.xml.horizSize;
import org.openoffice.xmerge.converter.xml.lineHeight;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParaStyle
extends Style
implements Cloneable {
    private static final int TEXT_INDENT = 4;
    private static final int LINE_HEIGHT = 5;
    private static final int TEXT_ALIGN = 6;
    private static final int NR_PROPERTIES = 7;
    private boolean[] isSet = new boolean[7];
    private int[] value = new int[7];
    private final String[] attrName = new String[]{"fo:margin-left", "fo:margin-right", "fo:margin-top", "fo:margin-bottom", "fo:text-indent", "fo:line-height", "fo:text-align"};
    private final Class<?>[] algor = new Class[]{horizSize.class, horizSize.class, horizSize.class, horizSize.class, horizSize.class, lineHeight.class, alignment.class};
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_JUST = 3;
    public static final int ALIGN_LEFT = 4;
    public static final int LH_PCT = 0x40000000;
    private static final int LH_VALUEMASK = 0xFFFFFF;
    private static String[] ignored = new String[]{"style:font-name", "fo:font-size", "fo:font-weight", "fo:color", "fo:language", "fo:country", "style:font-name-asian", "style:font-size-asian", "style:language-asian", "style:country-asian", "style:font-name-complex", "style:font-size-complex", "style:language-complex", "style:country-complex", "style:text-autospace", "style:punctuation-wrap", "style:line-break", "fo:keep-with-next", "fo:font-style", "text:number-lines", "text:line-number"};

    public ParaStyle(Node node, StyleCatalog styleCatalog) {
        super(node, styleCatalog);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                NamedNodeMap namedNodeMap;
                Node node2 = nodeList.item(i);
                String string = node2.getNodeName();
                if (!string.equals("style:properties") || (namedNodeMap = node2.getAttributes()) == null) continue;
                int n2 = namedNodeMap.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node3 = namedNodeMap.item(j);
                    this.setAttribute(node3.getNodeName(), node3.getNodeValue());
                }
            }
        }
    }

    public ParaStyle(String string, String string2, String string3, String[] stringArray, String[] stringArray2, StyleCatalog styleCatalog) {
        super(string, string2, string3, styleCatalog);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.setAttribute(stringArray[i], stringArray2[i]);
            }
        }
    }

    public ParaStyle(String string, String string2, String string3, int[] nArray, String[] stringArray, StyleCatalog styleCatalog) {
        super(string, string2, string3, styleCatalog);
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                this.setAttribute(nArray[i], stringArray[i]);
            }
        }
    }

    private boolean isIgnored(String string) {
        for (int i = 0; i < ignored.length; ++i) {
            if (!ignored[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private void setAttribute(String string, String string2) {
        for (int i = 0; i < 7; ++i) {
            if (!string.equals(this.attrName[i])) continue;
            this.setAttribute(i, string2);
            return;
        }
        if (!this.isIgnored(string)) {
            Debug.log(1, "ParaStyle Unhandled: " + string + "=" + string2);
        }
    }

    private void setAttribute(int n, String string) {
        this.isSet[n] = true;
        try {
            this.value[n] = ((conversionAlgorithm)this.algor[n].newInstance()).I(string);
        }
        catch (Exception exception) {
            Debug.log(2, "Instantiation error", exception);
        }
    }

    public Style getResolved() {
        ParaStyle paraStyle = null;
        try {
            paraStyle = (ParaStyle)this.clone();
        }
        catch (Exception exception) {
            Debug.log(2, "Can't clone", exception);
        }
        ParaStyle paraStyle2 = null;
        if (this.sc != null) {
            if (this.parent != null) {
                paraStyle2 = (ParaStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (paraStyle2 == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    paraStyle2 = (ParaStyle)paraStyle2.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                paraStyle2 = (ParaStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (paraStyle2 != null) {
            paraStyle2 = (ParaStyle)paraStyle2.getResolved();
            for (int i = 0; i < 7; ++i) {
                if (this.isSet[i] || !paraStyle2.isSet[i]) continue;
                paraStyle.isSet[i] = true;
                paraStyle.value[i] = paraStyle2.value[i];
            }
        }
        return paraStyle;
    }

    private static String toCSV(String string) {
        if (string != null) {
            return "\"" + string + "\",";
        }
        return "\"\",";
    }

    private static String toLastCSV(String string) {
        if (string != null) {
            return "\"" + string + "\"";
        }
        return "\"\"";
    }

    public static void dumpHdr() {
        System.out.println(ParaStyle.toCSV("Name") + ParaStyle.toCSV("Family") + ParaStyle.toCSV("parent") + ParaStyle.toCSV("left mgn") + ParaStyle.toCSV("right mgn") + ParaStyle.toCSV("top mgn") + ParaStyle.toCSV("bottom mgn") + ParaStyle.toCSV("txt indent") + ParaStyle.toCSV("line height") + ParaStyle.toLastCSV("txt align"));
    }

    public void dumpCSV() {
        String string = "";
        for (int i = 0; i <= 6; ++i) {
            string = this.isSet[i] ? string + ParaStyle.toCSV("" + this.value[i]) : string + ParaStyle.toCSV(null);
        }
        System.out.println(ParaStyle.toCSV(this.name) + ParaStyle.toCSV(this.family) + ParaStyle.toCSV(this.parent) + string + ParaStyle.toLastCSV(null));
    }

    public Node createNode(Document document, String string) {
        Element element = document.createElement(string);
        this.writeAttributes(element);
        return element;
    }

    public boolean isSubset(Style style) {
        if (!super.isSubset(style)) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(style.getClass())) {
            return false;
        }
        ParaStyle paraStyle = (ParaStyle)style;
        for (int i = 0; i < 7; ++i) {
            int n;
            if (!paraStyle.isSet[i] || !(i < 6 ? (n = this.value[i] > paraStyle.value[i] ? this.value[i] - paraStyle.value[i] : paraStyle.value[i] - this.value[i]) > 32 : (i != 6 || this.value[i] != 0 || paraStyle.value[i] != 4) && this.value[i] != paraStyle.value[i])) continue;
            return false;
        }
        return true;
    }

    private void writeAttributes(Element element) {
        double d;
        for (int i = 0; i <= 4; ++i) {
            if (!this.isSet[i]) continue;
            d = (double)this.value[i] / 100.0;
            String string = Double.toString(d) + "mm";
            element.setAttribute(this.attrName[i], string);
        }
        if (this.isSet[5]) {
            String string;
            if ((this.value[5] & 0x40000000) != 0) {
                string = Integer.toString(this.value[5] & 0xFFFFFF) + "%";
            } else {
                d = (double)(this.value[5] & 0xFFFFFF) / 100.0;
                string = Double.toString(d) + "mm";
            }
            element.setAttribute(this.attrName[5], string);
        }
        if (this.isSet[6]) {
            String string;
            switch (this.value[6]) {
                case 1: {
                    string = "end";
                    break;
                }
                case 2: {
                    string = "center";
                    break;
                }
                case 3: {
                    string = "justify";
                    break;
                }
                case 4: {
                    string = "left";
                    break;
                }
                default: {
                    string = "unknown";
                }
            }
            element.setAttribute(this.attrName[6], string);
        }
    }
}

