/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.uno.XComponentContext;
import com.sun.star.wiki.EditPageParser;
import com.sun.star.wiki.Helper;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiEditSettingDialog;
import com.sun.star.wiki.WikiPropDialog;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Map;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiArticle {
    private final XComponentContext m_xContext;
    private String m_sEditTime = "";
    private String m_sEditToken = "";
    private String m_sHTMLCode;
    private boolean m_bNoArticle = true;
    private String m_sWikiUser;
    private String m_sWikiPass;
    private final String m_sTitle;
    private final URI m_aMainURI;
    private HostConfiguration m_aHostConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikiArticle(XComponentContext xComponentContext, String string, Map<String, String> map, boolean bl, WikiPropDialog wikiPropDialog) throws MalformedURLException, IOException, WikiCancelException {
        this.m_xContext = xComponentContext;
        String string2 = map.get("Url");
        this.m_sWikiUser = map.get("Username");
        this.m_sWikiPass = map.get("Password");
        this.m_sTitle = string;
        this.m_aMainURI = new URI(string2, false);
        if (bl) {
            WikiEditSettingDialog wikiEditSettingDialog = new WikiEditSettingDialog(this.m_xContext, "vnd.sun.star.script:WikiEditor.EditSetting?location=application", map, false);
            try {
                while (!this.Login()) {
                    if (wikiPropDialog != null) {
                        wikiPropDialog.SetThrobberActive(false);
                    }
                    if (!MainThreadDialogExecutor.Show(xComponentContext, wikiEditSettingDialog)) {
                        throw new WikiCancelException();
                    }
                    this.m_sWikiUser = map.get("Username");
                    this.m_sWikiPass = map.get("Password");
                    if (wikiPropDialog == null) continue;
                    wikiPropDialog.SetThrobberActive(true);
                    Thread.yield();
                }
            }
            finally {
                wikiEditSettingDialog.DisposeDialog();
            }
        }
        this.InitArticleHTML();
    }

    public String GetMainURL() {
        return this.m_aMainURI.toString();
    }

    public String GetTitle() {
        return this.m_sTitle;
    }

    private String getArticleWiki() throws IOException, WikiCancelException {
        String string = null;
        if (this.m_aHostConfig != null) {
            URI uRI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle + "&action=edit", false);
            GetMethod getMethod = new GetMethod(uRI.getEscapedPathQuery());
            Helper.ExecuteMethod((HttpMethodBase)getMethod, this.m_aHostConfig, uRI, this.m_xContext, false);
            int n = getMethod.getStatusCode();
            String string2 = null;
            if (n == 200) {
                string2 = getMethod.getResponseBodyAsString();
            }
            getMethod.releaseConnection();
            if (string2 != null) {
                StringReader stringReader = new StringReader(string2);
                HTMLEditorKit.Parser parser = Helper.GetHTMLParser();
                EditPageParser editPageParser = new EditPageParser();
                parser.parse(stringReader, editPageParser, true);
                this.m_sEditTime = editPageParser.m_sEditTime;
                this.m_sEditToken = editPageParser.m_sEditToken;
                int n2 = editPageParser.m_nWikiArticleStart;
                int n3 = editPageParser.m_nWikiArticleEnd;
                if (n2 >= 0 && n3 > 0) {
                    String string3 = string2.substring(n2, n3);
                    n2 = string3.indexOf(62) + 1;
                    string = string3.substring(n2, string3.length());
                }
            }
        }
        return string;
    }

    private void InitArticleHTML() throws IOException, WikiCancelException {
        if (this.m_aHostConfig != null) {
            URI uRI = new URI(this.m_aMainURI.toString() + "index.php?title=" + this.m_sTitle, false);
            GetMethod getMethod = new GetMethod(uRI.getEscapedPathQuery());
            Helper.ExecuteMethod((HttpMethodBase)getMethod, this.m_aHostConfig, uRI, this.m_xContext, false);
            int n = getMethod.getStatusCode();
            String string = null;
            if (n == 200) {
                string = getMethod.getResponseBodyAsString();
            }
            if (string != null) {
                StringReader stringReader = new StringReader(string);
                HTMLEditorKit.Parser parser = Helper.GetHTMLParser();
                EditPageParser editPageParser = new EditPageParser();
                parser.parse(stringReader, editPageParser, true);
                int n2 = editPageParser.m_nHTMLArticleStart;
                int n3 = editPageParser.m_nHTMLArticleEnd;
                int n4 = editPageParser.m_nNoArticleInd;
                if (n2 >= 0 && n3 > 0) {
                    this.m_sHTMLCode = string.substring(n2, n3);
                    this.m_bNoArticle = n4 >= 0 && n4 >= n2 && n4 <= n3;
                }
            }
        }
    }

    protected boolean setArticle(String string, String string2, boolean bl) throws IOException, WikiCancelException {
        boolean bl2 = false;
        if (this.m_aHostConfig != null && string != null && string2 != null) {
            this.getArticleWiki();
            URI uRI = new URI(this.m_aMainURI.getPath() + "index.php?title=" + this.m_sTitle + "&action=submit", false);
            PostMethod postMethod = new PostMethod();
            postMethod.setPath(uRI.getEscapedPathQuery());
            postMethod.addParameter("wpTextbox1", string);
            postMethod.addParameter("wpSummary", string2);
            postMethod.addParameter("wpSection", "");
            postMethod.addParameter("wpEdittime", this.m_sEditTime);
            postMethod.addParameter("wpSave", "Save page");
            postMethod.addParameter("wpEditToken", this.m_sEditToken);
            if (bl) {
                postMethod.addParameter("wpMinoredit", "1");
            }
            Helper.ExecuteMethod((HttpMethodBase)postMethod, this.m_aHostConfig, uRI, this.m_xContext, false);
            int n = postMethod.getStatusCode();
            if (n < 400) {
                bl2 = true;
            }
            String string3 = postMethod.getResponseBodyAsString();
            System.out.print("nSubmitCode = " + n + "\n===\n" + string3);
        }
        return bl2;
    }

    private boolean Login() throws IOException, WikiCancelException {
        this.m_aHostConfig = Helper.Login(this.m_aMainURI, this.m_sWikiUser, this.m_sWikiPass, this.m_xContext);
        return this.m_aHostConfig != null;
    }

    protected boolean NotExist() {
        boolean bl = true;
        if (this.m_sHTMLCode != null) {
            bl = this.m_bNoArticle;
        }
        return bl;
    }
}

