/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report;

import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.graphic.XGraphicProvider;
import com.sun.star.io.IOException;
import com.sun.star.io.XInputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.adapter.ByteArrayToXInputStreamAdapter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Toolkit;
import org.libreoffice.report.ImageService;
import org.libreoffice.report.ReportExecutionException;

public class SOImageService
implements ImageService {
    private final XGraphicProvider m_xGraphicProvider;

    public SOImageService(XComponentContext xComponentContext) throws ReportExecutionException, com.sun.star.uno.Exception {
        if (xComponentContext == null) {
            throw new ReportExecutionException("SOImageService constructed with null Component Context");
        }
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        this.m_xGraphicProvider = (XGraphicProvider)UnoRuntime.queryInterface(XGraphicProvider.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.graphic.GraphicProvider", xComponentContext));
        if (this.m_xGraphicProvider == null) {
            throw new ReportExecutionException("There is no graphic-provider available for SOImageService.");
        }
    }

    private Size getImageSize(XInputStream xInputStream) throws ReportExecutionException {
        Size size = new Size();
        try {
            PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "InputStream";
            propertyValueArray[0].Value = xInputStream;
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xGraphicProvider.queryGraphic(propertyValueArray));
            if (xPropertySet != null) {
                XPropertySetInfo xPropertySetInfo = xPropertySet.getPropertySetInfo();
                if (xPropertySetInfo.hasPropertyByName("Size100thMM")) {
                    Size size2 = (Size)xPropertySet.getPropertyValue("Size100thMM");
                    size.Width = size2.Width;
                    size.Height = size2.Height;
                    if (size.Height == 0 && size.Width == 0) {
                        size2 = (Size)xPropertySet.getPropertyValue("SizePixel");
                        int n = Toolkit.getDefaultToolkit().getScreenResolution();
                        double d = 2540.0 / (double)n;
                        size.Width = (int)((double)size2.Width * d);
                        size.Height = (int)((double)size2.Height * d);
                    }
                } else if (xPropertySetInfo.hasPropertyByName("SizePixel")) {
                    Size size3 = (Size)xPropertySet.getPropertyValue("SizePixel");
                    int n = Toolkit.getDefaultToolkit().getScreenResolution();
                    double d = 2540.0 / (double)n;
                    size.Width = (int)((double)size3.Width * d);
                    size.Height = (int)((double)size3.Height * d);
                }
            }
        }
        catch (Exception exception) {
            throw new ReportExecutionException("Failed to query Image-Size", exception);
        }
        return size;
    }

    public Size getImageSize(byte[] byArray) throws ReportExecutionException {
        return this.getImageSize((XInputStream)new ByteArrayToXInputStreamAdapter(byArray));
    }

    private String getMimeType(XInputStream xInputStream) throws ReportExecutionException {
        try {
            XPropertySetInfo xPropertySetInfo;
            PropertyValue[] propertyValueArray = new PropertyValue[]{new PropertyValue()};
            propertyValueArray[0].Name = "InputStream";
            propertyValueArray[0].Value = xInputStream;
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.m_xGraphicProvider.queryGraphic(propertyValueArray));
            if (xPropertySet != null && (xPropertySetInfo = xPropertySet.getPropertySetInfo()).hasPropertyByName("MimeType")) {
                return (String)xPropertySet.getPropertyValue("MimeType");
            }
        }
        catch (UnknownPropertyException unknownPropertyException) {
            throw new ReportExecutionException(unknownPropertyException);
        }
        catch (WrappedTargetException wrappedTargetException) {
            throw new ReportExecutionException(wrappedTargetException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReportExecutionException(illegalArgumentException);
        }
        catch (IOException iOException) {
            throw new ReportExecutionException(iOException);
        }
        return null;
    }

    public String getMimeType(byte[] byArray) throws ReportExecutionException {
        return this.getMimeType((XInputStream)new ByteArrayToXInputStreamAdapter(byArray));
    }
}

