/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.history;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.history.Alias;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class AliasManager {
    private ArrayList aliases = new ArrayList();

    public AliasManager(IResource resource) {
        Object[] aliasArray = this.getAliases(resource);
        Arrays.sort(aliasArray);
        int i = 0;
        while (i < aliasArray.length) {
            this.aliases.add(aliasArray[i]);
            ++i;
        }
    }

    public AliasManager(IResource resource, boolean checkParents) {
        Object[] aliasArray = this.getAliases(resource, checkParents);
        Arrays.sort(aliasArray);
        int i = 0;
        while (i < aliasArray.length) {
            this.aliases.add(aliasArray[i]);
            ++i;
        }
    }

    public AliasManager(SVNUrl url) {
        Object[] aliasArray = this.getAliases(url);
        Arrays.sort(aliasArray);
        int i = 0;
        while (i < aliasArray.length) {
            this.aliases.add(aliasArray[i]);
            ++i;
        }
    }

    public Alias[] getTags(int revision) {
        ArrayList<Alias> revisionAliases = new ArrayList<Alias>();
        Iterator iter = this.aliases.iterator();
        while (iter.hasNext()) {
            Alias alias = (Alias)iter.next();
            if (alias.getRevision() < revision || alias.isBranch()) continue;
            revisionAliases.add(alias);
        }
        Alias[] aliasArray = new Alias[revisionAliases.size()];
        revisionAliases.toArray(aliasArray);
        int i = 0;
        while (i < aliasArray.length) {
            this.aliases.remove(aliasArray[i]);
            ++i;
        }
        return aliasArray;
    }

    public Alias[] getTags() {
        ArrayList<Alias> tags = new ArrayList<Alias>();
        Iterator iter = this.aliases.iterator();
        while (iter.hasNext()) {
            Alias tag = (Alias)iter.next();
            if (tag.isBranch()) continue;
            tags.add(tag);
        }
        Alias[] tagArray = new Alias[tags.size()];
        tags.toArray(tagArray);
        return tagArray;
    }

    public Alias[] getBranches() {
        ArrayList<Alias> branches = new ArrayList<Alias>();
        Iterator iter = this.aliases.iterator();
        while (iter.hasNext()) {
            Alias branch = (Alias)iter.next();
            if (!branch.isBranch()) continue;
            branches.add(branch);
        }
        Alias[] branchArray = new Alias[branches.size()];
        branches.toArray(branchArray);
        return branchArray;
    }

    public Alias getAlias(String revisionNamePathBranch, String url) {
        String name;
        int revision;
        boolean branch = false;
        Alias alias = null;
        int index = revisionNamePathBranch.indexOf(",");
        if (index == -1) {
            return null;
        }
        String rev = revisionNamePathBranch.substring(0, index);
        try {
            int revNo;
            revision = revNo = Integer.parseInt(rev);
        }
        catch (Exception exception) {
            return null;
        }
        revisionNamePathBranch = revisionNamePathBranch.substring(index + 1);
        index = revisionNamePathBranch.indexOf(",");
        String relativePath = null;
        if (index == -1) {
            name = revisionNamePathBranch;
        } else {
            name = revisionNamePathBranch.substring(0, index);
            if (revisionNamePathBranch.length() > index + 1) {
                if ((index = (revisionNamePathBranch = revisionNamePathBranch.substring(index + 1)).indexOf(",")) == -1) {
                    relativePath = revisionNamePathBranch;
                } else {
                    relativePath = revisionNamePathBranch.substring(0, index);
                    if (revisionNamePathBranch.length() > index + 1) {
                        branch = revisionNamePathBranch.substring(index + 1).equalsIgnoreCase("branch");
                    }
                }
            }
        }
        alias = new Alias(revision, name, relativePath, url);
        alias.setBranch(branch);
        return alias;
    }

    public static String getAliasesAsString(Alias[] aliases) {
        if (aliases == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < aliases.length) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(aliases[i].getName());
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String transformUrl(IResource resource, Alias alias) {
        String aliasUrl = alias.getUrl();
        ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor(resource);
        ISVNRepositoryLocation repository = svnResource.getRepository();
        String a = svnResource.getUrl().toString().length() <= aliasUrl.length() ? "" : svnResource.getUrl().toString().substring(aliasUrl.length());
        String b = repository.getUrl().toString();
        String c = alias.getRelativePath() == null ? "" : alias.getRelativePath();
        return String.valueOf(b) + c + a;
    }

    public Alias[] getAliases(IResource resource) {
        Object[] aliases = this.getAliases(resource, true);
        Arrays.sort(aliases);
        return aliases;
    }

    private Alias[] getAliases(IResource resource, boolean checkParents) {
        ArrayList<Alias> aliases = new ArrayList<Alias>();
        if (resource != null) {
            ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor(resource);
            try {
                if (svnResource.isManaged()) {
                    ISVNProperty property = null;
                    property = svnResource.getSvnProperty("subclipse:tags");
                    if (property != null && property.getValue() != null) {
                        this.getAliases(aliases, property.getValue(), svnResource.getUrl().toString());
                    }
                    if (checkParents) {
                        IResource checkResource = resource;
                        while (checkResource.getParent() != null) {
                            checkResource = checkResource.getParent();
                            Alias[] parentAliases = this.getAliases(checkResource, false);
                            int i = 0;
                            while (i < parentAliases.length) {
                                if (aliases.contains(parentAliases[i])) {
                                    Alias checkAlias = (Alias)aliases.get(aliases.indexOf(parentAliases[i]));
                                    if (parentAliases[i].getRevision() < checkAlias.getRevision()) {
                                        aliases.remove(checkAlias);
                                        aliases.add(parentAliases[i]);
                                    }
                                } else {
                                    aliases.add(parentAliases[i]);
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
            catch (SVNException sVNException) {}
        }
        Alias[] aliasArray = new Alias[aliases.size()];
        aliases.toArray(aliasArray);
        return aliasArray;
    }

    public Alias[] getAliases(SVNUrl url) {
        Object[] aliases = this.getAliases(url, true);
        Arrays.sort(aliases);
        return aliases;
    }

    private Alias[] getAliases(SVNUrl url, boolean checkParents) {
        ArrayList aliases = new ArrayList();
        try {
            ISVNClientAdapter client = SVNProviderPlugin.getPlugin().createSVNClient();
            ISVNProperty property = null;
            property = client.propertyGet(url, "subclipse:tags");
            if (property != null && property.getValue() != null) {
                this.getAliases(aliases, property.getValue(), url.toString());
            } else if (url.getParent() != null && checkParents) {
                return this.getAliases(url.getParent(), checkParents);
            }
        }
        catch (SVNClientException sVNClientException) {
        }
        catch (SVNException sVNException) {}
        Alias[] aliasArray = new Alias[aliases.size()];
        aliases.toArray(aliasArray);
        return aliasArray;
    }

    private void getAliases(ArrayList aliases, String propertyValue, String url) {
        StringReader reader = new StringReader(propertyValue);
        BufferedReader bReader = new BufferedReader(reader);
        try {
            String line = bReader.readLine();
            while (line != null) {
                Alias alias = this.getAlias(line, url);
                if (aliases.contains(alias)) {
                    Alias checkAlias = (Alias)aliases.get(aliases.indexOf(alias));
                    if (alias.getRevision() < checkAlias.getRevision()) {
                        aliases.remove(checkAlias);
                        aliases.add(alias);
                    }
                } else {
                    aliases.add(alias);
                }
                line = bReader.readLine();
            }
            bReader.close();
        }
        catch (Exception exception) {}
    }
}

