# Evaluates the current config and makes recommendations
our (%gui, %vmc);

sub eval_config() {
    &busy_pointer($gui{dialogEdit}, 1);
    $gui{liststoreEvalConfig}->clear();
    my $vhost = &vhost();
    my $osver = &osver();
    my @IUSBController = IMachine_getUSBControllers($vmc{IMachine});
    my $usb = 0;

    foreach (@IUSBController) {
        if (IUSBController_getType($_) eq 'OHCI') { $usb = 1; }
    }

    my $chipset  = IMachine_getChipsetType($vmc{IMachine});
    my $os       = IMachine_getOSTypeId($vmc{IMachine});
    my $fam      = $$osver{$os}{familyId};
    my $ioapic   = IBIOSSettings_getIOAPICEnabled($vmc{IBIOSSettings});
    my $is64bit  = $$osver{$os}{is64Bit};
    my $cpus     = IMachine_getCPUCount($vmc{IMachine});
    my $firmware = IMachine_getFirmwareType($vmc{IMachine});
    my $point    = IMachine_getPointingHIDType($vmc{IMachine});
    my $keyboard = IMachine_getKeyboardHIDType($vmc{IMachine});
    my $fusion   = IMachine_getPageFusionEnabled($vmc{IMachine});
    my $largep   = IMachine_getHWVirtExProperty($vmc{IMachine}, 'LargePages');
    my $nested   = IMachine_getHWVirtExProperty($vmc{IMachine}, 'NestedPaging');
    my $vtx      = IMachine_getHWVirtExProperty($vmc{IMachine}, 'Enabled');
    my $pae      = IMachine_getCPUProperty($vmc{IMachine}, 'PAE');
    my $vpid     = IMachine_getHWVirtExProperty($vmc{IMachine}, 'VPID');
    my $threed   = IMachine_getAccelerate3DEnabled($vmc{IMachine});
    my $twod     = IMachine_getAccelerate2DVideoEnabled($vmc{IMachine});
    my $rdp      = IVRDEServer_getEnabled($vmc{IVRDEServer});

    if ($os =~ m/MacOS/) {
        if ($chipset ne 'ICH9') { &addrow_ec(0, 'ICH9 chipset is recommended for MacOS X guests', 1, 'Select ICH9 chipset', 2, 800); }
        if ($firmware !~ m /^EFI/) { &addrow_ec(0, 'EFI is recommended for MacOS X guests', 1, 'Enable EFI', 2, 800); }
    }
    else { 
        &addrow_ec(0, 'ICH9 chipset is recommended for MacOS X guests only', 1, 'Consider selecting PIIX3 chipset', 2, 800) if ($chipset eq 'ICH9');
        &addrow_ec(0, 'EFI is recommended for MacOS X guests only', 1, 'Consider disabling EFI', 2, 800) if ($firmware =~ m/^EFI/);
    }

    if ($ioapic ne 'true') {
        &addrow_ec(0, 'IO APIC disabled for ICH9 chipset', 1, 'Enable IO APIC', 2, 800) if ($chipset eq 'ICH9');
        &addrow_ec(0, 'IO APIC disabled for 64bit guest', 1, 'Enable IO APIC', 2, 800) if ($is64bit eq 'true');
        &addrow_ec(0, 'IO APIC disabled for SMP guest', 1, "Enable IO APIC\nor Set CPU count to 1", 2, 800) if ($cpus > 1);
    }

    if (!$usb) {
        &addrow_ec(0, 'USB Mouse selected but USB disabled', 1, 'Enable USB *or* select PS2 Mouse', 2, 800) if ($point ne 'PS2Mouse' and $point ne 'None');
        &addrow_ec(0, 'USB Keyboard selected but USB disabled', 1, 'Enable USB *or* select PS2 Keyboard', 2, 800) if ($keyboard ne 'PS2Keyboard' and $keyboard ne 'None');
    }

    if ($fusion eq 'true') {
        &addrow_ec(0, 'Page Fusion supported only on Windows (2000 and later) guests', 1, 'Disable Page Fusion', 2, 800) if ($fam !~ m/Windows/);
        &addrow_ec(0, 'Page Fusion not supported on Mac OS X virtualization hosts', 1, 'Disable Page Fusion', 2, 800) if ($$vhost{os} =~ m/darwin/i);
    }

    if ($largep eq 'true') {
        &addrow_ec(0, 'Large Pages enabled but Nested Paging disabled', 1, "Enable Nested Paging\nor Disable Large Pages", 2, 800) if ($nested eq 'false');
        &addrow_ec(0, 'Large Pages enabled but VT-x/AMD-V is disabled', 1, "Enable VT-x/AMD-V\nor Disable Large Pages", 2, 800) if ($vtx eq 'false');
    }

    if ($vtx eq 'false') {
        &addrow_ec(0, 'Nest Paging enabled but VT-x/AMD-V is disabled', 1, "Disable Nested Paging\nor Enable VT-x/AMD-V", 2, 800) if ($nested eq 'true');
        &addrow_ec(0, 'VT-x/AMD-V disabled for SMP guest', 1, "Enable VT-x/AMD-V\nor Set CPU count to 1", 2, 800) if ($cpus > 1);
        &addrow_ec(0, 'VPID enabled but VT-x/AMD-V is disabled', 1, "Enable VT-x/AMD-V\nor Disable VPID", 2, 800) if ($vpid eq 'true');
        &addrow_ec(0, 'VT-x/AMD-V is disabled but the virtualization host supports it', 1, 'Enable VT-x/AMD-V', 2, 800) if ($$vhost{vtx} eq 'true');
    }
    else {
        &addrow_ec(0, 'VT-x/AMD-V is enabled but virtualization host does not support it', 1, 'Disable VT-x/AMD-V', 2, 800) if ($$vhost{vtx} eq 'false');
    }

    if ($pae eq 'true' and $$vhost{pae} eq 'false') { &addrow_ec(0, 'PAE enabled but virtualization host does not support it', 1, 'Disable PAE/NX', 2, 800); }
    if ($threed eq 'true' and $fam ne 'Linux' and $fam ne 'Solaris' and $fam ne 'Windows') { &addrow_ec(0, '3D Acceleration enabled but is for Linux, Windows, Solaris guests only', 1, 'Disable 3D Acceleration', 2, 800); }
    if ($twod eq 'true' and $fam ne 'Windows') { &addrow_ec(0, '2D Acceleration enabled but is for Windows guests (2000 or later) only', 1, 'Disable 2D Acceleration', 2, 800); }
    &addrow_ec(0, 'RemoteBox will not be able to open the guest display', 1, 'Enable Remote Display Server', 2, 800) if ($rdp eq 'false');
    $gui{dialogEvalConfig}->run;
    $gui{dialogEvalConfig}->hide;
    &busy_pointer($gui{dialogEdit}, 0);
}

1;