/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAVLDiskLarge;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDisk
extends RowStoreAVL
implements PersistentStore {
    DataFileCache cache;
    RowOutputInterface rowOut;
    boolean largeData;

    public RowStoreAVLDisk(PersistentStoreCollection persistentStoreCollection, DataFileCache dataFileCache, Table table) {
        this.database = table.database;
        this.manager = persistentStoreCollection;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.cache = dataFileCache;
        if (dataFileCache != null) {
            this.rowOut = dataFileCache.rowOut.duplicate();
            dataFileCache.adjustStoreCount(1);
        }
        persistentStoreCollection.setStore(table, this);
        this.largeData = this.database.logger.getDataFileFactor() > 1;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public int getAccessCount() {
        return this.cache.getAccessCount();
    }

    @Override
    public void set(CachedObject cachedObject) {
        Row row = (Row)cachedObject;
        this.database.txManager.setTransactionInfo(row);
    }

    @Override
    public CachedObject get(long l) {
        CachedObject cachedObject = this.cache.get(l, (PersistentStore)this, false);
        return cachedObject;
    }

    @Override
    public CachedObject get(long l, boolean bl) {
        CachedObject cachedObject = this.cache.get(l, (PersistentStore)this, bl);
        return cachedObject;
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        cachedObject = this.cache.get(cachedObject, (PersistentStore)this, bl);
        return cachedObject;
    }

    @Override
    public int getStorageSize(long l) {
        return this.cache.get(l, (PersistentStore)this, false).getStorageSize();
    }

    @Override
    public void add(CachedObject cachedObject) {
        int n = cachedObject.getRealSize(this.rowOut);
        n += this.indexList.length * 16;
        n = this.rowOut.getStorageSize(n);
        cachedObject.setStorageSize(n);
        this.cache.add(cachedObject);
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            if (this.largeData) {
                return new RowAVLDiskLarge(this.table, rowInputInterface);
            }
            return new RowAVLDisk(this.table, rowInputInterface);
        }
        catch (IOException iOException) {
            throw Error.error(466, iOException);
        }
    }

    @Override
    public CachedObject getNewInstance(int n) {
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        RowAVLDisk rowAVLDisk = this.largeData ? new RowAVLDiskLarge(this.table, (Object[])object, this) : new RowAVLDisk(this.table, (Object[])object, this);
        this.add(rowAVLDisk);
        if (bl) {
            RowAction rowAction;
            rowAVLDisk.rowAction = rowAction = new RowAction(session, this.table, 1, rowAVLDisk, null);
        }
        return rowAVLDisk;
    }

    @Override
    public void indexRow(Session session, Row row) {
        try {
            super.indexRow(session, row);
        }
        catch (HsqlException hsqlException) {
            this.database.txManager.removeTransactionInfo(row);
            throw hsqlException;
        }
    }

    @Override
    public void removeAll() {
        this.elementCount = 0L;
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(long l) {
        this.cache.remove(l, this);
    }

    @Override
    public void removePersistence(long l) {
    }

    @Override
    public void release(long l) {
        this.cache.release(l);
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        Object[] objectArray = row.getData();
        switch (n) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, objectArray);
                if (n2 != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
                break;
            }
            case 3: {
                this.delete(session, row);
                this.database.txManager.removeTransactionInfo(row);
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                row = (Row)this.get((CachedObject)row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row.getPos());
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row.getPos());
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.cache.adjustStoreCount(-1);
        this.cache = null;
        this.elementCount = 0L;
    }

    @Override
    public CachedObject getAccessor(Index index) {
        NodeAVL nodeAVL = (NodeAVL)this.accessorList[index.getPosition()];
        if (nodeAVL == null) {
            return null;
        }
        return nodeAVL;
    }

    @Override
    public void setAccessor(Index index, CachedObject cachedObject) {
        Index index2 = index;
        this.accessorList[index2.getPosition()] = cachedObject;
    }

    @Override
    public void setAccessor(Index index, long l) {
        CachedObject cachedObject = this.get(l, false);
        if (cachedObject != null) {
            NodeAVL nodeAVL = ((RowAVL)cachedObject).getNode(index.getPosition());
            cachedObject = nodeAVL;
        }
        this.setAccessor(index, cachedObject);
    }

    @Override
    public void resetAccessorKeys(Index[] indexArray) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void setReadOnly(boolean bl) {
    }

    @Override
    public void writeLock() {
        this.cache.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.cache.writeLock.unlock();
    }
}

