/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ClassLoaderUtil {
    private static Logger log = Logger.getLogger(ClassLoaderUtil.class);
    private static final Class<?>[] parameters = new Class[]{URL.class};

    public static void addFile(String string) throws IOException {
        File file = new File(string);
        ClassLoaderUtil.addFile(file);
    }

    public static void addFile(File file) throws IOException {
        ClassLoaderUtil.addURL(file.toURI().toURL());
    }

    public static void addURL(URL uRL) throws IOException {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] uRLArray = uRLClassLoader.getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            if (!StringUtils.equalsIgnoreCase((String)uRLArray[i].toString(), (String)uRL.toString())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("URL " + uRL + " is already in the CLASSPATH"));
            }
            return;
        }
        Class<URLClassLoader> clazz = URLClassLoader.class;
        try {
            Method method = clazz.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)uRLClassLoader, uRL);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }
}

