/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.utils.XMLStringUtil;

public class ApiResponseElement
extends ApiResponse {
    public static final ApiResponseElement OK = new ApiResponseElement("Result", "OK");
    public static final ApiResponseElement FAIL = new ApiResponseElement("Result", "FAIL");
    private String value = null;
    private ApiResponse apiResponse;

    public ApiResponseElement(String string) {
        super(string);
    }

    public ApiResponseElement(String string, String string2) {
        super(string);
        this.value = string2;
    }

    public ApiResponseElement(ApiResponse apiResponse) {
        super(apiResponse.getName());
        this.apiResponse = apiResponse;
    }

    public ApiResponseElement(Node node, ApiResponse apiResponse) {
        super(node.getNodeName());
        this.value = node.getTextContent();
    }

    public ApiResponseElement(Node node) {
        super(node.getNodeName());
        this.value = node.getTextContent();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public JSON toJSON() {
        if (this.value == null && this.apiResponse == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        if (this.apiResponse == null) {
            jSONObject.put((Object)this.getName(), (Object)this.value);
        } else {
            jSONObject.put((Object)this.getName(), (Object)this.apiResponse.toJSON());
        }
        return jSONObject;
    }

    @Override
    public void toXML(Document document, Element element) {
        if (this.apiResponse == null) {
            element.appendChild(document.createTextNode(XMLStringUtil.escapeControlChrs(this.getValue())));
        } else {
            this.apiResponse.toXML(document, element);
        }
    }

    @Override
    public void toHTML(StringBuilder stringBuilder) {
        if (this.apiResponse == null) {
            stringBuilder.append("<table border=\"1\">\n");
            stringBuilder.append("<tr><td>\n");
            stringBuilder.append(StringEscapeUtils.escapeHtml((String)this.getName()));
            stringBuilder.append("</td><td>\n");
            stringBuilder.append(StringEscapeUtils.escapeHtml((String)this.getValue()));
            stringBuilder.append("</td></tr>\n");
            stringBuilder.append("</table>\n");
        } else {
            this.apiResponse.toHTML(stringBuilder);
        }
    }

    @Override
    public String toString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("\t");
        }
        stringBuilder.append("ApiResponseElement ");
        stringBuilder.append(this.getName());
        stringBuilder.append(" = ");
        if (this.apiResponse == null) {
            stringBuilder.append(this.getValue());
        } else {
            stringBuilder.append(this.apiResponse.toString(n + 1));
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

