/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.HelpUtilities;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.CoreFunctionality;
import org.zaproxy.zap.extension.help.ExtensionHelp;

public class ExtensionFactory {
    private static Logger log = Logger.getLogger(ExtensionFactory.class);
    private static Vector<Extension> listAllExtension = new Vector();
    private static TreeMap<String, Extension> mapAllExtension = new TreeMap();
    private static TreeMap<Integer, Extension> mapOrderToExtension = new TreeMap();
    private static List<Extension> unorderedExtensions = new ArrayList<Extension>();
    private static AddOnLoader addOnLoader = null;

    public static AddOnLoader getAddOnLoader() {
        if (addOnLoader == null) {
            addOnLoader = new AddOnLoader(new File[]{new File(Constant.getZapInstall(), "plugin"), new File(Constant.getZapHome(), "plugin")});
        }
        return addOnLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadAllExtension(ExtensionLoader extensionLoader, Configuration configuration) {
        log.info((Object)"Loading extensions");
        ArrayList<Extension> arrayList = new ArrayList<Extension>(CoreFunctionality.getBuiltInExtensions());
        arrayList.addAll(ExtensionFactory.getAddOnLoader().getExtensions());
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            mapAllExtension.clear();
            for (int i = 0; i < arrayList.size(); ++i) {
                Extension object = (Extension)arrayList.get(i);
                if (mapAllExtension.containsKey(object.getName())) {
                    if (mapAllExtension.get(object.getName()).getClass().equals(object.getClass())) {
                        log.error((Object)("Duplicate extension: " + object.getName() + " " + object.getClass().getCanonicalName()));
                        continue;
                    }
                    log.error((Object)("Duplicate extension name: " + object.getName() + " " + object.getClass().getCanonicalName() + " " + mapAllExtension.get(object.getName()).getClass().getCanonicalName()));
                }
                if (object.isDepreciated()) {
                    log.debug((Object)("Depreciated extension " + object.getName()));
                    continue;
                }
                object.setEnabled(configuration.getBoolean("ext." + object.getName(), true));
                listAllExtension.add(object);
                mapAllExtension.put(object.getName(), object);
                int n = object.getOrder();
                if (n == 0) {
                    unorderedExtensions.add(object);
                    continue;
                }
                if (mapOrderToExtension.containsKey(n)) {
                    log.error((Object)("Duplicate order " + n + " " + mapOrderToExtension.get(n).getName() + "/" + mapOrderToExtension.get(n).getClass().getCanonicalName() + " already registered, " + object.getName() + "/" + object.getClass().getCanonicalName() + " will be added as an unordered extension"));
                    unorderedExtensions.add(object);
                    continue;
                }
                mapOrderToExtension.put(n, object);
            }
            for (Integer n : mapOrderToExtension.keySet()) {
                Extension extension = mapOrderToExtension.get(n);
                if (extension.isEnabled()) {
                    log.debug((Object)("Ordered extension " + n + " " + extension.getName()));
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, extension);
            }
            for (Extension extension : unorderedExtensions) {
                if (extension.isEnabled()) {
                    log.debug((Object)("Unordered extension " + extension.getName()));
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, extension);
            }
        }
        log.info((Object)"Extensions loaded");
    }

    private static void loadMessagesAndAddExtension(ExtensionLoader extensionLoader, Extension extension) {
        ExtensionFactory.loadMessages(extension);
        if (extension.isEnabled() && extension.supportsDb(Model.getSingleton().getDb().getType()) && (extension.supportsLowMemory() || !Constant.isLowMemoryOptionSet())) {
            extensionLoader.addExtension(extension);
            ExtensionFactory.intitializeHelpSet(extension);
        } else if (!extension.supportsDb(Model.getSingleton().getDb().getType())) {
            log.debug((Object)("Not loading extension " + extension.getName() + ": doesnt support " + Model.getSingleton().getDb().getType()));
        } else if (extension.supportsLowMemory() || !Constant.isLowMemoryOptionSet()) {
            log.debug((Object)("Not loading extension " + extension.getName() + ": doesnt support low memory option"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addAddOnExtension(ExtensionLoader extensionLoader, Configuration configuration, Extension extension) {
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionFactory.addExtensionImpl(configuration, extension);
            if (extension.isEnabled()) {
                log.debug((Object)("Adding new extension " + extension.getName()));
            }
            ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, extension);
        }
    }

    private static void addExtensionImpl(Configuration configuration, Extension extension) {
        if (mapAllExtension.containsKey(extension.getName())) {
            if (mapAllExtension.get(extension.getName()).getClass().equals(extension.getClass())) {
                log.debug((Object)("Duplicate extension: " + extension.getName() + " " + extension.getClass().getCanonicalName()));
                extension.setEnabled(false);
                return;
            }
            log.error((Object)("Duplicate extension name: " + extension.getName() + " " + extension.getClass().getCanonicalName() + " " + mapAllExtension.get(extension.getName()).getClass().getCanonicalName()));
        }
        if (extension.isDepreciated()) {
            log.debug((Object)("Depreciated extension " + extension.getName()));
            return;
        }
        extension.setEnabled(configuration.getBoolean("ext." + extension.getName(), true));
        listAllExtension.add(extension);
        mapAllExtension.put(extension.getName(), extension);
        int n = extension.getOrder();
        if (n == 0) {
            unorderedExtensions.add(extension);
        } else if (mapOrderToExtension.containsKey(n)) {
            log.error((Object)("Duplicate order " + n + " " + mapOrderToExtension.get(n).getName() + "/" + mapOrderToExtension.get(n).getClass().getCanonicalName() + " already registered, " + extension.getName() + "/" + extension.getClass().getCanonicalName() + " will be added as an unordered extension"));
            unorderedExtensions.add(extension);
        } else {
            mapOrderToExtension.put(n, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized List<Extension> loadAddOnExtensions(ExtensionLoader extensionLoader, Configuration configuration, AddOn addOn) {
        List<Extension> list = ExtensionFactory.getAddOnLoader().getExtensions(addOn);
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            for (Extension extension : list) {
                ExtensionFactory.addExtensionImpl(configuration, extension);
            }
            for (Extension extension : list) {
                if (extension.isEnabled()) {
                    log.debug((Object)("Adding new extension " + extension.getName()));
                }
                ExtensionFactory.loadMessagesAndAddExtension(extensionLoader, extension);
            }
        }
        return list;
    }

    private static void loadMessages(Extension extension) {
        ResourceBundle resourceBundle = ExtensionFactory.getExtensionResourceBundle(extension);
        if (resourceBundle != null) {
            extension.setMessages(resourceBundle);
            Constant.messages.addMessageBundle(extension.getI18nPrefix(), extension.getMessages());
        }
    }

    private static ResourceBundle getExtensionResourceBundle(Extension extension) {
        String string = extension.getClass().getPackage().getName();
        ClassLoader classLoader = extension.getClass().getClassLoader();
        try {
            String string2 = string + ".resources." + "Messages";
            return ExtensionFactory.getPropertiesResourceBundle(string2, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            String string3 = string + "." + "Messages";
            try {
                return ExtensionFactory.getPropertiesResourceBundle(string3, classLoader);
            }
            catch (MissingResourceException missingResourceException2) {
                return null;
            }
        }
    }

    private static ResourceBundle getPropertiesResourceBundle(String string, ClassLoader classLoader) throws MissingResourceException {
        return ResourceBundle.getBundle(string, Constant.getLocale(), classLoader, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    }

    private static void intitializeHelpSet(Extension extension) {
        HelpBroker helpBroker = ExtensionHelp.getHelpBroker();
        if (helpBroker == null) {
            return;
        }
        URL uRL = ExtensionFactory.getExtensionHelpSetUrl(extension);
        if (uRL != null) {
            try {
                log.debug((Object)("Load help files for extension '" + extension.getName() + "' and merge with core help."));
                HelpSet helpSet = new HelpSet(extension.getClass().getClassLoader(), uRL);
                helpBroker.getHelpSet().add(helpSet);
            }
            catch (HelpSetException helpSetException) {
                log.error((Object)("An error occured while adding help file of extension '" + extension.getName() + "': " + helpSetException.getMessage()), (Throwable)helpSetException);
            }
        }
    }

    private static URL getExtensionHelpSetUrl(Extension extension) {
        String string = extension.getClass().getPackage().getName().replace('.', '/') + "/";
        URL uRL = ExtensionFactory.findResource(extension.getClass().getClassLoader(), string + "resources/help", "helpset", ".hs", Constant.getLocale());
        if (uRL == null) {
            uRL = ExtensionFactory.findResource(extension.getClass().getClassLoader(), string + "resource/help", "helpset", ".hs", Constant.getLocale());
        }
        return uRL;
    }

    public static List<Extension> getAllExtensions() {
        return listAllExtension;
    }

    public static Extension getExtension(String string) {
        Extension extension = mapAllExtension.get(string);
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadAddOnExtension(Extension extension) {
        TreeMap<String, Extension> treeMap = mapAllExtension;
        synchronized (treeMap) {
            ExtensionFactory.unloadMessages(extension);
            ExtensionFactory.unloadHelpSet(extension);
            mapAllExtension.remove(extension.getName());
            listAllExtension.remove(extension);
            boolean bl = true;
            Iterator<Extension> iterator = mapOrderToExtension.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != extension) continue;
                iterator.remove();
                bl = false;
                break;
            }
            if (bl) {
                unorderedExtensions.remove(extension);
            }
        }
    }

    private static void unloadMessages(Extension extension) {
        ResourceBundle resourceBundle = extension.getMessages();
        if (resourceBundle != null) {
            Constant.messages.removeMessageBundle(extension.getI18nPrefix());
        }
    }

    private static void unloadHelpSet(Extension extension) {
        HelpBroker helpBroker = ExtensionHelp.getHelpBroker();
        if (helpBroker == null) {
            return;
        }
        URL uRL = ExtensionFactory.getExtensionHelpSetUrl(extension);
        if (uRL != null) {
            HelpSet helpSet = helpBroker.getHelpSet();
            Enumeration enumeration = helpSet.getHelpSets();
            while (enumeration.hasMoreElements()) {
                HelpSet helpSet2 = (HelpSet)enumeration.nextElement();
                if (!uRL.equals(helpSet2.getHelpSetURL())) continue;
                helpSet.remove(helpSet2);
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL findResource(ClassLoader classLoader, String string, String string2, String string3, Locale locale) {
        Enumeration enumeration = HelpUtilities.getCandidates((Locale)locale);
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            String string5 = string + string4 + '/' + string2 + string4 + string3;
            URL uRL2 = classLoader == null ? ClassLoader.getSystemResource(string5) : classLoader.getResource(string5);
            if (uRL2 == null) continue;
            try {
                InputStream inputStream = uRL2.openConnection().getInputStream();
                Throwable throwable = null;
                try {
                    if (inputStream == null || inputStream.read() == -1) continue;
                    URL uRL = uRL2;
                    return uRL;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Throwable throwable7) {}
        }
        return null;
    }
}

