/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.User;

public abstract class AuthenticationMethod {
    public static final String CONTEXT_CONFIG_AUTH = "context.authentication";
    public static final String CONTEXT_CONFIG_AUTH_TYPE = "context.authentication.type";
    public static final String CONTEXT_CONFIG_AUTH_LOGGEDIN = "context.authentication.loggedin";
    public static final String CONTEXT_CONFIG_AUTH_LOGGEDOUT = "context.authentication.loggedout";
    protected Pattern loggedInIndicatorPattern = null;
    protected Pattern loggedOutIndicatorPattern = null;

    public abstract boolean isConfigured();

    public AuthenticationMethod clone() {
        AuthenticationMethod authenticationMethod = this.duplicate();
        authenticationMethod.loggedInIndicatorPattern = this.loggedInIndicatorPattern;
        authenticationMethod.loggedOutIndicatorPattern = this.loggedOutIndicatorPattern;
        return authenticationMethod;
    }

    protected abstract AuthenticationMethod duplicate();

    public abstract AuthenticationCredentials createAuthenticationCredentials();

    public abstract AuthenticationMethodType getType();

    public abstract WebSession authenticate(SessionManagementMethod var1, AuthenticationCredentials var2, User var3) throws UnsupportedAuthenticationCredentialsException;

    public abstract ApiResponse getApiResponseRepresentation();

    public void onMethodPersisted() {
    }

    public void onMethodDiscarded() {
    }

    public boolean isAuthenticated(HttpMessage httpMessage) {
        if (httpMessage == null || httpMessage.getResponseBody() == null) {
            return false;
        }
        if (this.loggedInIndicatorPattern == null && this.loggedOutIndicatorPattern == null) {
            if (View.isInitialised()) {
                View.getSingleton().getOutputPanel().append(Constant.messages.getString("authentication.output.indicatorsNotSet", httpMessage.getRequestHeader().getURI()) + "\n");
            }
            return true;
        }
        String string = httpMessage.getResponseBody().toString();
        String string2 = httpMessage.getResponseHeader().toString();
        if (this.loggedInIndicatorPattern != null && (this.loggedInIndicatorPattern.matcher(string).find() || this.loggedInIndicatorPattern.matcher(string2).find())) {
            return true;
        }
        return this.loggedOutIndicatorPattern != null && !this.loggedOutIndicatorPattern.matcher(string).find() && !this.loggedOutIndicatorPattern.matcher(string2).find();
    }

    public Pattern getLoggedInIndicatorPattern() {
        return this.loggedInIndicatorPattern;
    }

    public void setLoggedInIndicatorPattern(String string) {
        this.loggedInIndicatorPattern = string == null || string.trim().length() == 0 ? null : Pattern.compile(string);
    }

    public Pattern getLoggedOutIndicatorPattern() {
        return this.loggedOutIndicatorPattern;
    }

    public void setLoggedOutIndicatorPattern(String string) {
        this.loggedOutIndicatorPattern = string == null || string.trim().length() == 0 ? null : Pattern.compile(string);
    }

    public boolean isSameType(AuthenticationMethod authenticationMethod) {
        if (authenticationMethod == null) {
            return false;
        }
        return authenticationMethod.getClass().equals(this.getClass());
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.loggedInIndicatorPattern == null ? 0 : this.loggedInIndicatorPattern.pattern().hashCode());
        n = 31 * n + (this.loggedOutIndicatorPattern == null ? 0 : this.loggedOutIndicatorPattern.pattern().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AuthenticationMethod authenticationMethod = (AuthenticationMethod)object;
        if (this.loggedInIndicatorPattern == null ? authenticationMethod.loggedInIndicatorPattern != null : !this.loggedInIndicatorPattern.pattern().equals(authenticationMethod.loggedInIndicatorPattern.pattern())) {
            return false;
        }
        return !(this.loggedOutIndicatorPattern == null ? authenticationMethod.loggedOutIndicatorPattern != null : !this.loggedOutIndicatorPattern.pattern().equals(authenticationMethod.loggedOutIndicatorPattern.pattern()));
    }

    public static class UnsupportedAuthenticationCredentialsException
    extends RuntimeException {
        private static final long serialVersionUID = 4802501809913124766L;

        public UnsupportedAuthenticationCredentialsException(String string) {
            super(string);
        }
    }
}

