/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import sun.awt.image.IntegerComponentRaster;

public class SwingFXUtils {
    private SwingFXUtils() {
    }

    public static WritableImage toFXImage(BufferedImage object, WritableImage writableImage) {
        int[] nArray;
        Object object2;
        Object object3;
        int n = ((BufferedImage)object).getWidth();
        int n2 = ((BufferedImage)object).getHeight();
        switch (((BufferedImage)object).getType()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                object3 = new BufferedImage(n, n2, 3);
                object2 = ((BufferedImage)object3).createGraphics();
                ((Graphics)object2).drawImage((Image)object, 0, 0, null);
                ((Graphics)object2).dispose();
                object = object3;
            }
        }
        if (writableImage != null) {
            int n3 = (int)writableImage.getWidth();
            int n4 = (int)writableImage.getHeight();
            if (n3 < n || n4 < n2) {
                writableImage = null;
            } else if (n < n3 || n2 < n4) {
                nArray = new int[n3];
                PixelWriter pixelWriter = writableImage.getPixelWriter();
                WritablePixelFormat<IntBuffer> writablePixelFormat = PixelFormat.getIntArgbPreInstance();
                if (n < n3) {
                    pixelWriter.setPixels(n, 0, n3 - n, n2, writablePixelFormat, nArray, 0, 0);
                }
                if (n2 < n4) {
                    pixelWriter.setPixels(0, n2, n3, n4 - n2, writablePixelFormat, nArray, 0, 0);
                }
            }
        }
        if (writableImage == null) {
            writableImage = new WritableImage(n, n2);
        }
        object3 = writableImage.getPixelWriter();
        object2 = (IntegerComponentRaster)((BufferedImage)object).getRaster();
        nArray = ((IntegerComponentRaster)object2).getDataStorage();
        int n5 = ((IntegerComponentRaster)object2).getDataOffset(0);
        int n6 = ((IntegerComponentRaster)object2).getScanlineStride();
        WritablePixelFormat<IntBuffer> writablePixelFormat = ((BufferedImage)object).isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        object3.setPixels(0, 0, n, n2, writablePixelFormat, nArray, n5, n6);
        return writableImage;
    }

    public static BufferedImage fromFXImage(javafx.scene.image.Image image, BufferedImage bufferedImage) {
        Object object;
        int n;
        int n2;
        PixelReader pixelReader = image.getPixelReader();
        if (pixelReader == null) {
            return null;
        }
        int n3 = (int)image.getWidth();
        int n4 = (int)image.getHeight();
        if (bufferedImage != null) {
            int n5 = bufferedImage.getType();
            n2 = bufferedImage.getWidth();
            n = bufferedImage.getHeight();
            if (n2 < n3 || n < n4 || n5 != 2 && n5 != 3) {
                bufferedImage = null;
            } else if (n3 < n2 || n4 < n) {
                object = bufferedImage.createGraphics();
                ((Graphics2D)object).setComposite(AlphaComposite.Clear);
                ((Graphics)object).fillRect(0, 0, n2, n);
                ((Graphics)object).dispose();
            }
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n3, n4, 3);
        }
        IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)bufferedImage.getRaster();
        n2 = integerComponentRaster.getDataOffset(0);
        n = integerComponentRaster.getScanlineStride();
        object = integerComponentRaster.getDataStorage();
        WritablePixelFormat<IntBuffer> writablePixelFormat = bufferedImage.isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        pixelReader.getPixels(0, 0, n3, n4, writablePixelFormat, (int[])object, n2, n);
        return bufferedImage;
    }
}

