/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

public class FontConfigManager {
    static boolean debugFonts = false;
    static boolean fontConfigFailed = false;
    static boolean useEmbeddedFontSupport = false;
    private static final String[] fontConfigNames;
    private static FcCompFont[] fontConfigFonts;
    private static String defaultFontFile;

    private FontConfigManager() {
    }

    private static String[] getFontConfigNames() {
        return fontConfigNames;
    }

    private static String getFCLocaleStr() {
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        if (!string2.equals("")) {
            string = string + "-" + string2;
        }
        return string;
    }

    private static native boolean getFontConfig(String var0, FcCompFont[] var1, boolean var2);

    private static synchronized void initFontConfigLogFonts() {
        int n;
        if (fontConfigFonts != null || fontConfigFailed) {
            return;
        }
        long l = 0L;
        if (debugFonts) {
            l = System.nanoTime();
        }
        String[] stringArray = FontConfigManager.getFontConfigNames();
        FcCompFont[] fcCompFontArray = new FcCompFont[stringArray.length];
        for (int i = 0; i < fcCompFontArray.length; ++i) {
            fcCompFontArray[i] = new FcCompFont();
            fcCompFontArray[i].fcName = stringArray[i];
            n = fcCompFontArray[i].fcName.indexOf(58);
            fcCompFontArray[i].fcFamily = fcCompFontArray[i].fcName.substring(0, n);
            fcCompFontArray[i].style = i % 4;
        }
        if (useEmbeddedFontSupport || !FontConfigManager.getFontConfig(FontConfigManager.getFCLocaleStr(), fcCompFontArray, true)) {
            EmbeddedFontSupport.initLogicalFonts(fcCompFontArray);
        }
        FontConfigFont fontConfigFont = null;
        for (n = 0; n < fcCompFontArray.length; ++n) {
            FcCompFont fcCompFont = fcCompFontArray[n];
            if (fcCompFont.firstFont == null) {
                if (debugFonts) {
                    System.err.println("Fontconfig returned no font for " + fcCompFontArray[n].fcName);
                }
                fontConfigFailed = true;
                continue;
            }
            if (fontConfigFont != null) continue;
            fontConfigFont = fcCompFont.firstFont;
            defaultFontFile = fontConfigFont.fontFile;
        }
        if (fontConfigFont == null) {
            if (debugFonts) {
                System.err.println("Fontconfig returned no fonts at all.");
            }
            fontConfigFailed = true;
            return;
        }
        if (fontConfigFailed) {
            for (n = 0; n < fcCompFontArray.length; ++n) {
                if (fcCompFontArray[n].firstFont != null) continue;
                fcCompFontArray[n].firstFont = fontConfigFont;
            }
        }
        fontConfigFonts = fcCompFontArray;
        if (debugFonts) {
            long l2 = System.nanoTime();
            System.err.println("Time spent accessing fontconfig=" + (l2 - l) / 1000000L + "ms.");
            for (int i = 0; i < fontConfigFonts.length; ++i) {
                FcCompFont fcCompFont = fontConfigFonts[i];
                System.err.println("FC font " + fcCompFont.fcName + " maps to " + fcCompFont.firstFont.fullName + " in file " + fcCompFont.firstFont.fontFile);
                if (fcCompFont.allFonts == null) continue;
                for (int j = 0; j < fcCompFont.allFonts.length; ++j) {
                    FontConfigFont fontConfigFont2 = fcCompFont.allFonts[j];
                    System.err.println(" " + j + ") Family=" + fontConfigFont2.familyName + ", Style=" + fontConfigFont2.styleStr + ", Fullname=" + fontConfigFont2.fullName + ", File=" + fontConfigFont2.fontFile);
                }
            }
        }
    }

    private static native boolean populateMapsNative(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    public static void populateMaps(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
        if (fontConfigFailed || useEmbeddedFontSupport || !FontConfigManager.populateMapsNative(hashMap, hashMap2, hashMap3, locale)) {
            EmbeddedFontSupport.populateMaps(hashMap, hashMap2, hashMap3, locale);
        }
    }

    private static String mapFxToFcLogicalFamilyName(String string) {
        if (string.equals("serif")) {
            return "serif";
        }
        if (string.equals("monospaced")) {
            return "monospace";
        }
        return "sans";
    }

    public static FcCompFont getFontConfigFont(String string, boolean bl, boolean bl2) {
        int n;
        FontConfigManager.initFontConfigLogFonts();
        if (fontConfigFonts == null) {
            return null;
        }
        String string2 = FontConfigManager.mapFxToFcLogicalFamilyName(string.toLowerCase());
        int n2 = n = bl ? 1 : 0;
        if (bl2) {
            n += 2;
        }
        FcCompFont fcCompFont = null;
        for (int i = 0; i < fontConfigFonts.length; ++i) {
            if (!string2.equals(FontConfigManager.fontConfigFonts[i].fcFamily) || n != FontConfigManager.fontConfigFonts[i].style) continue;
            fcCompFont = fontConfigFonts[i];
            break;
        }
        if (fcCompFont == null) {
            fcCompFont = fontConfigFonts[0];
        }
        if (debugFonts) {
            System.err.println("FC name=" + string2 + " style=" + n + " uses " + fcCompFont.firstFont.fullName + " in file: " + fcCompFont.firstFont.fontFile);
        }
        return fcCompFont;
    }

    public static String getDefaultFontPath() {
        if (fontConfigFonts == null && !fontConfigFailed) {
            FontConfigManager.getFontConfigFont("System", false, false);
        }
        return defaultFontFile;
    }

    public static ArrayList<String> getFileNames(FcCompFont fcCompFont, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fcCompFont.allFonts != null) {
            int n;
            for (int i = n = bl ? 1 : 0; i < fcCompFont.allFonts.length; ++i) {
                arrayList.add(fcCompFont.allFonts[i].fontFile);
            }
        }
        return arrayList;
    }

    public static ArrayList<String> getFontNames(FcCompFont fcCompFont, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (fcCompFont.allFonts != null) {
            int n;
            for (int i = n = bl ? 1 : 0; i < fcCompFont.allFonts.length; ++i) {
                arrayList.add(fcCompFont.allFonts[i].fullName);
            }
        }
        return arrayList;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String string = System.getProperty("prism.debugfonts", "");
                debugFonts = "true".equals(string);
                String string2 = System.getProperty("prism.embeddedfonts", "");
                useEmbeddedFontSupport = "true".equals(string2);
                return null;
            }
        });
        fontConfigNames = new String[]{"sans:regular:roman", "sans:bold:roman", "sans:regular:italic", "sans:bold:italic", "serif:regular:roman", "serif:bold:roman", "serif:regular:italic", "serif:bold:italic", "monospace:regular:roman", "monospace:bold:roman", "monospace:regular:italic", "monospace:bold:italic"};
    }

    private static class EmbeddedFontSupport {
        private static String fontDirProp = null;
        private static String fontDir;

        private EmbeddedFontSupport() {
        }

        private static void initEmbeddedFonts() {
            fontDirProp = System.getProperty("prism.fontdir");
            if (fontDirProp != null) {
                fontDir = fontDirProp;
            } else {
                try {
                    Class<FontConfigManager> clazz = FontConfigManager.class;
                    String string = "FontConfigManager.class";
                    String string2 = clazz.getResource(string).toString();
                    if (debugFonts) {
                        System.err.println("Class URL is " + string2);
                    }
                    if (string2 == null) {
                        return;
                    }
                    int n = string2.indexOf("!");
                    if (string2.startsWith("jar:file:") || n != -1) {
                        string2 = string2.substring(9, n);
                        int n2 = Math.max(string2.lastIndexOf("/"), string2.lastIndexOf("\\"));
                        string2 = string2.substring(0, n2);
                    }
                    File file = new File(string2, "fonts");
                    fontDir = file.getPath();
                    if (debugFonts) {
                        System.err.println("Font Dir is " + file + " exists = " + file.exists());
                    }
                }
                catch (Exception exception) {
                    if (debugFonts) {
                        exception.printStackTrace();
                    }
                    fontDir = "/";
                }
            }
        }

        private static String getStyleStr(int n) {
            switch (n) {
                case 0: {
                    return "regular";
                }
                case 1: {
                    return "bold";
                }
                case 2: {
                    return "italic";
                }
                case 3: {
                    return "bolditalic";
                }
            }
            return "regular";
        }

        private static boolean exists(final File file) {
            return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return file.exists();
                }
            });
        }

        static void initLogicalFonts(FcCompFont[] fcCompFontArray) {
            Object object;
            Properties properties;
            block5: {
                properties = new Properties();
                try {
                    String string = fontDir + "/logicalfonts.properties";
                    object = new FileInputStream(string);
                    properties.load((InputStream)object);
                    ((FileInputStream)object).close();
                }
                catch (IOException iOException) {
                    if (!debugFonts) break block5;
                    System.err.println(iOException);
                    return;
                }
            }
            for (int i = 0; i < fcCompFontArray.length; ++i) {
                object = fcCompFontArray[i].fcFamily;
                String string = EmbeddedFontSupport.getStyleStr(fcCompFontArray[i].style);
                String string2 = (String)object + "." + string + ".";
                ArrayList<FontConfigFont> arrayList = new ArrayList<FontConfigFont>();
                int n = 0;
                while (true) {
                    String string3 = properties.getProperty(string2 + n + ".file");
                    String string4 = properties.getProperty(string2 + n + ".font");
                    ++n;
                    if (string3 == null) break;
                    File file = new File(fontDir, string3);
                    if (!EmbeddedFontSupport.exists(file)) continue;
                    FontConfigFont fontConfigFont = new FontConfigFont();
                    fontConfigFont.fontFile = file.getPath();
                    fontConfigFont.fullName = string4;
                    fontConfigFont.familyName = null;
                    fontConfigFont.styleStr = null;
                    if (fcCompFontArray[i].firstFont == null) {
                        fcCompFontArray[i].firstFont = fontConfigFont;
                    }
                    arrayList.add(fontConfigFont);
                }
                if (arrayList.size() <= 0) continue;
                fcCompFontArray[i].allFonts = new FontConfigFont[arrayList.size()];
                arrayList.toArray(fcCompFontArray[i].allFonts);
            }
        }

        static void populateMaps(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
            boolean bl;
            Properties properties;
            block8: {
                properties = new Properties();
                bl = false;
                try {
                    String string = fontDir + "/allfonts.properties";
                    FileInputStream fileInputStream = new FileInputStream(string);
                    properties.load(fileInputStream);
                    bl = true;
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    if (!debugFonts) break block8;
                    System.err.println(iOException);
                    System.err.println("Fall back to opening the files");
                }
            }
            if (bl) {
                int n = Integer.MAX_VALUE;
                try {
                    n = Integer.parseInt(properties.getProperty("maxFont", ""));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n <= 0) {
                    n = Integer.MAX_VALUE;
                }
                for (int i = 0; i < n; ++i) {
                    String string = properties.getProperty("family." + i);
                    String string2 = properties.getProperty("font." + i);
                    String string3 = properties.getProperty("file." + i);
                    if (string3 == null) break;
                    File file = new File(fontDir, string3);
                    if (!EmbeddedFontSupport.exists(file) || string == null || string2 == null) continue;
                    String string4 = string2.toLowerCase(Locale.ENGLISH);
                    String string5 = string.toLowerCase(Locale.ENGLISH);
                    hashMap.put(string4, file.getPath());
                    hashMap2.put(string4, string);
                    ArrayList<String> arrayList = hashMap3.get(string5);
                    if (arrayList == null) {
                        arrayList = new ArrayList(4);
                        hashMap3.put(string5, arrayList);
                    }
                    arrayList.add(string2);
                }
            }
        }

        static {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    EmbeddedFontSupport.initEmbeddedFonts();
                    return null;
                }
            });
        }
    }

    public static class FcCompFont {
        public String fcName;
        public String fcFamily;
        public int style;
        public FontConfigFont firstFont;
        public FontConfigFont[] allFonts;
    }

    public static class FontConfigFont {
        public String familyName;
        public String styleStr;
        public String fullName;
        public String fontFile;
    }
}

