/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EventManager;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectProperties;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.TableContainer;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.View;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.common.DateHelper;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.common.Pair;
import net.sf.mpxj.mpp.AvailabilityFactory;
import net.sf.mpxj.mpp.ConstraintFactory;
import net.sf.mpxj.mpp.CostRateTableFactory;
import net.sf.mpxj.mpp.CustomFieldAliasReader;
import net.sf.mpxj.mpp.CustomFieldValueItem;
import net.sf.mpxj.mpp.CustomFieldValueReader14;
import net.sf.mpxj.mpp.DocumentInputStreamFactory;
import net.sf.mpxj.mpp.FieldMap;
import net.sf.mpxj.mpp.FieldMap14;
import net.sf.mpxj.mpp.FilterReader14;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FixedMeta;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.GraphicalIndicatorReader;
import net.sf.mpxj.mpp.GroupReader14;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.MPPVariantReader;
import net.sf.mpxj.mpp.MppBitFlag;
import net.sf.mpxj.mpp.ProjectPropertiesReader;
import net.sf.mpxj.mpp.Props;
import net.sf.mpxj.mpp.Props14;
import net.sf.mpxj.mpp.RecurringTaskReader;
import net.sf.mpxj.mpp.ResourceAssignmentFactory;
import net.sf.mpxj.mpp.TableFactory14;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.mpp.VarMeta;
import net.sf.mpxj.mpp.VarMeta12;
import net.sf.mpxj.mpp.ViewFactory14;
import net.sf.mpxj.mpp.ViewStateReader12;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MPP14Reader
implements MPPVariantReader {
    private MPPReader m_reader;
    private ProjectFile m_file;
    private EventManager m_eventManager;
    private DirectoryEntry m_root;
    private HashMap<Integer, ProjectCalendar> m_resourceMap;
    private Var2Data m_outlineCodeVarData;
    private VarMeta m_outlineCodeVarMeta;
    private FixedData m_outlineCodeFixedData;
    private FixedMeta m_outlineCodeFixedMeta;
    private FixedData m_outlineCodeFixedData2;
    private FixedMeta m_outlineCodeFixedMeta2;
    private Props14 m_projectProps;
    private Map<Integer, FontBase> m_fontBases;
    private Map<Integer, SubProject> m_taskSubProjects;
    private DirectoryEntry m_projectDir;
    private DirectoryEntry m_viewDir;
    private Map<Integer, Integer> m_parentTasks;
    private Map<Long, Integer> m_taskOrder;
    private Map<Integer, Integer> m_nullTaskOrder;
    private DocumentInputStreamFactory m_inputStreamFactory;
    private static final int SUBPROJECT_TASKUNIQUEID0 = 0;
    private static final int SUBPROJECT_TASKUNIQUEID1 = 187957248;
    private static final int SUBPROJECT_TASKUNIQUEID2 = 0xABB0000;
    private static final int SUBPROJECT_TASKUNIQUEID3 = 94437376;
    private static final int SUBPROJECT_TASKUNIQUEID4 = 198508544;
    private static final int SUBPROJECT_TASKUNIQUEID5 = 64356352;
    private static final int SUBPROJECT_TASKUNIQUEID6 = 108986368;
    private static final int SUBPROJECT_TASKUNIQUEID7 = 108855296;
    private static final int SUBPROJECT_TASKUNIQUEID8 = 0x540000;
    private static final Integer CALENDAR_NAME = 1;
    private static final Integer CALENDAR_DATA = 8;
    private static final Integer TABLE_COLUMN_DATA_STANDARD = 6;
    private static final Integer TABLE_COLUMN_DATA_ENTERPRISE = 7;
    private static final Integer TABLE_COLUMN_DATA_BASELINE = 8;
    private static final Integer OUTLINECODE_DATA = 22;
    private static final int VALUE_LIST_MASK = 1792;
    private static final int DURATION_CONFIRMED_MASK = 32;
    private static final Integer RESOURCE_FIELD_NAME_ALIASES = 0x4400001;
    private static final Integer TASK_FIELD_NAME_ALIASES = 0x4400001;
    private static final int TASK_UNIQUE_ID_FIXED_OFFSET = 0;
    private static final int TASK_ID_FIXED_OFFSET = 4;
    private static final int NULL_TASK_BLOCK_SIZE = 16;
    private static final boolean[] DEFAULT_WORKING_WEEK = new boolean[]{false, true, true, true, true, true, false};
    private static final MppBitFlag[] PROJECT2010_TASK_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.FLAG1, 35, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG2, 35, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG3, 35, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG4, 35, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG5, 35, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG6, 35, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG7, 35, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG8, 35, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG9, 35, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG10, 35, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG11, 35, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG12, 35, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG13, 35, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG14, 35, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG15, 35, 0x100000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG16, 35, 0x200000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG17, 35, 0x400000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG18, 35, 0x800000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG19, 35, 0x1000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG20, 35, 0x2000000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MILESTONE, 8, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MARKED, 9, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.IGNORE_RESOURCE_CALENDAR, 10, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.ROLLUP, 10, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.HIDE_BAR, 10, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.EFFORT_DRIVEN, 11, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVEL_ASSIGNMENTS, 13, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVELING_CAN_SPLIT, 13, 2, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2013_TASK_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.FLAG1, 24, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG2, 24, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG3, 24, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG4, 24, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG5, 24, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG6, 24, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG7, 24, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG8, 24, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG9, 24, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG10, 24, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG11, 33, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG12, 33, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG13, 33, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG14, 33, 16, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG15, 33, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG16, 33, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG17, 33, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG18, 33, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG19, 33, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.FLAG20, 33, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MILESTONE, 10, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.MARKED, 12, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.ROLLUP, 12, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.HIDE_BAR, 12, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.EFFORT_DRIVEN, 13, 8, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVEL_ASSIGNMENTS, 16, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.LEVELING_CAN_SPLIT, 16, 2, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.IGNORE_RESOURCE_CALENDAR, 17, 32, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2010_TASK_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.ACTIVE, 8, 4, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.TASK_MODE, 8, 8, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2013_TASK_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(TaskField.ACTIVE, 8, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(TaskField.TASK_MODE, 8, 128, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2010_RESOURCE_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(ResourceField.BUDGET, 8, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.TYPE, 8, 16, ResourceType.MATERIAL, ResourceType.COST)};
    private static final MppBitFlag[] PROJECT2013_RESOURCE_META_DATA2_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(ResourceField.BUDGET, 8, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.TYPE, 4, 8, ResourceType.COST, ResourceType.MATERIAL)};
    private static final MppBitFlag[] PROJECT2010_RESOURCE_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(ResourceField.FLAG10, 28, 32, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG1, 28, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG2, 28, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG3, 28, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG4, 28, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG5, 28, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG6, 28, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG7, 28, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG8, 28, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG9, 28, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG11, 28, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG12, 28, 65536, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG13, 28, 131072, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG14, 28, 262144, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG15, 28, 524288, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG16, 28, 0x100000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG17, 28, 0x200000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG18, 28, 0x400000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG19, 28, 0x800000, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG20, 28, 0x1000000, Boolean.FALSE, Boolean.TRUE)};
    private static final MppBitFlag[] PROJECT2013_RESOURCE_META_DATA_BIT_FLAGS = new MppBitFlag[]{new MppBitFlag(ResourceField.FLAG10, 19, 64, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG1, 19, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG2, 19, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG3, 19, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG4, 19, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG5, 19, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG6, 19, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG7, 19, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG8, 19, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG9, 19, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG11, 24, 128, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG12, 24, 256, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG13, 24, 512, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG14, 24, 1024, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG15, 24, 2048, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG16, 24, 4096, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG17, 24, 8192, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG18, 24, 16384, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG19, 24, 32768, Boolean.FALSE, Boolean.TRUE), new MppBitFlag(ResourceField.FLAG20, 24, 65536, Boolean.FALSE, Boolean.TRUE)};

    MPP14Reader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws MPXJException, IOException {
        try {
            this.populateMemberData(mPPReader, projectFile, directoryEntry);
            this.processProjectProperties();
            if (!mPPReader.getReadPropertiesOnly()) {
                this.processSubProjectData();
                this.processGraphicalIndicators();
                this.processCustomValueLists();
                this.processCalendarData();
                this.processResourceData();
                this.processTaskData();
                this.processConstraintData();
                this.processAssignmentData();
                this.postProcessTasks();
                if (mPPReader.getReadPresentationData()) {
                    this.processViewPropertyData();
                    this.processTableData();
                    this.processViewData();
                    this.processFilterData();
                    this.processGroupData();
                    this.processSavedViewState();
                }
            }
        }
        finally {
            this.clearMemberData();
        }
    }

    private void populateMemberData(MPPReader mPPReader, ProjectFile projectFile, DirectoryEntry directoryEntry) throws FileNotFoundException, IOException, MPXJException {
        this.m_reader = mPPReader;
        this.m_file = projectFile;
        this.m_eventManager = projectFile.getEventManager();
        this.m_root = directoryEntry;
        Props14 props14 = new Props14(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Props14")));
        projectFile.getProjectProperties().setProjectFilePath(props14.getUnicodeString(Props.PROJECT_FILE_PATH));
        this.m_inputStreamFactory = new DocumentInputStreamFactory(props14);
        if ((props14.getByte(Props.PASSWORD_FLAG) & 1) != 0) {
            throw new MPXJException("File is password protected");
        }
        this.m_resourceMap = new HashMap();
        this.m_projectDir = (DirectoryEntry)directoryEntry.getEntry("   114");
        this.m_viewDir = (DirectoryEntry)directoryEntry.getEntry("   214");
        DirectoryEntry directoryEntry2 = (DirectoryEntry)this.m_projectDir.getEntry("TBkndOutlCode");
        this.m_outlineCodeVarMeta = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("VarMeta")));
        this.m_outlineCodeVarData = new Var2Data(this.m_outlineCodeVarMeta, new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("Var2Data")));
        this.m_outlineCodeFixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("FixedMeta")), 10);
        this.m_outlineCodeFixedData = new FixedData(this.m_outlineCodeFixedMeta, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("FixedData")));
        this.m_outlineCodeFixedMeta2 = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("Fixed2Meta")), 10);
        this.m_outlineCodeFixedData2 = new FixedData(this.m_outlineCodeFixedMeta2, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry2.getEntry("Fixed2Data")));
        this.m_projectProps = new Props14(this.m_inputStreamFactory.getInstance(this.m_projectDir, "Props"));
        this.m_fontBases = new HashMap<Integer, FontBase>();
        this.m_taskSubProjects = new HashMap<Integer, SubProject>();
        this.m_parentTasks = new HashMap<Integer, Integer>();
        this.m_taskOrder = new TreeMap<Long, Integer>();
        this.m_nullTaskOrder = new TreeMap<Integer, Integer>();
        this.m_file.getProjectProperties().setMppFileType(14);
        this.m_file.getProjectProperties().setAutoFilter(props14.getBoolean(Props.AUTO_FILTER));
    }

    private void clearMemberData() {
        this.m_reader = null;
        this.m_eventManager = null;
        this.m_file = null;
        this.m_root = null;
        this.m_resourceMap = null;
        this.m_projectDir = null;
        this.m_viewDir = null;
        this.m_outlineCodeVarData = null;
        this.m_outlineCodeVarMeta = null;
        this.m_projectProps = null;
        this.m_fontBases = null;
        this.m_taskSubProjects = null;
        this.m_parentTasks = null;
        this.m_taskOrder = null;
        this.m_nullTaskOrder = null;
    }

    private void processCustomValueLists() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        Props14 props14 = new Props14(this.m_inputStreamFactory.getInstance(directoryEntry, "Props"));
        CustomFieldValueReader14 customFieldValueReader14 = new CustomFieldValueReader14(this.m_file.getProjectProperties(), this.m_file.getCustomFields(), this.m_outlineCodeVarMeta, this.m_outlineCodeVarData, this.m_outlineCodeFixedData, this.m_outlineCodeFixedData2, props14);
        customFieldValueReader14.process();
    }

    private void processProjectProperties() throws MPXJException {
        ProjectPropertiesReader projectPropertiesReader = new ProjectPropertiesReader();
        projectPropertiesReader.process(this.m_file, this.m_projectProps, this.m_root);
    }

    private void processGraphicalIndicators() {
        GraphicalIndicatorReader graphicalIndicatorReader = new GraphicalIndicatorReader();
        graphicalIndicatorReader.process(this.m_file.getCustomFields(), this.m_file.getProjectProperties(), this.m_projectProps);
    }

    private void processSubProjectData() {
        byte[] byArray = this.m_projectProps.getByteArray(Props.SUBPROJECT_DATA);
        if (byArray != null) {
            int n = 0;
            int n2 = 0;
            byte[] byArray2 = new byte[20];
            n2 += 4;
            int n3 = MPPUtility.getInt(byArray, n2 += 4);
            n2 += 4;
            block16: while (n2 < n3) {
                ++n;
                int n4 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                n2 += 4;
                MPPUtility.getByteArray(byArray, n4, byArray2.length, byArray2, 0);
                byte by = byArray2[16];
                switch (by) {
                    case 0: 
                    case 16: {
                        n2 += 8;
                        continue block16;
                    }
                    case -103: 
                    case 9: 
                    case 13: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        n2 += 4;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case -111: 
                    case 3: 
                    case 17: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case -127: 
                    case -125: 
                    case 65: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case 1: 
                    case 8: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case -64: {
                        int n5 = n4;
                        int n6 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case 5: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.m_file.getSubProjects().setResourceSubProject(this.readSubProject(byArray, n5, n6, n7, n));
                        continue block16;
                    }
                    case 69: {
                        int n5 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n6 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        n2 += 4;
                        this.m_file.getSubProjects().setResourceSubProject(this.readSubProject(byArray, n5, n6, n7, n));
                        continue block16;
                    }
                    case 2: {
                        n2 += 4;
                        n2 += 4;
                        continue block16;
                    }
                    case 4: {
                        int n6 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.m_file.getSubProjects().setResourceSubProject(this.readSubProject(byArray, -1, n6, n7, n));
                        continue block16;
                    }
                    case -115: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 8);
                        int n7 = MPPUtility.getShort(byArray, n2 += 8);
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case 10: {
                        int n5 = MPPUtility.getShort(byArray, n2);
                        int n6 = MPPUtility.getShort(byArray, n2 += 4);
                        int n7 = MPPUtility.getShort(byArray, n2 += 4);
                        n2 += 4;
                        this.readSubProjects(byArray, n5, n6, n7, n);
                        continue block16;
                    }
                    case 68: {
                        int n6 = MPPUtility.getInt(byArray, n2) & 0x1FFFF;
                        n2 += 4;
                        int n7 = MPPUtility.getInt(byArray, n2 += 4) & 0x1FFFF;
                        n2 += 4;
                        this.readSubProjects(byArray, -1, n6, n7, n);
                        continue block16;
                    }
                    case -128: {
                        n2 += 12;
                        continue block16;
                    }
                }
                n2 += 12;
            }
        }
    }

    private void readSubProjects(byte[] byArray, int n, int n2, int n3, int n4) {
        while (n < n2) {
            this.readSubProject(byArray, n, n2, n3, n4++);
            n += 4;
        }
    }

    private SubProject readSubProject(byte[] byArray, int n, int n2, int n3, int n4) {
        try {
            int n5;
            SubProject subProject = new SubProject();
            int n6 = 0;
            if (n != -1) {
                n5 = MPPUtility.getInt(byArray, n);
                n6 = MPPUtility.getInt(byArray, n + 4);
                switch (n6) {
                    case 0: 
                    case 0x540000: 
                    case 64356352: 
                    case 94437376: 
                    case 108855296: 
                    case 108986368: 
                    case 0xABB0000: 
                    case 187957248: 
                    case 198508544: {
                        subProject.setTaskUniqueID(n5);
                        this.m_taskSubProjects.put(subProject.getTaskUniqueID(), subProject);
                        break;
                    }
                    default: {
                        if (n5 == 0) break;
                        subProject.addExternalTaskUniqueID(n5);
                        this.m_taskSubProjects.put(n5, subProject);
                    }
                }
                n5 = 0x800000 + (n4 - 1) * 0x400000;
                subProject.setUniqueIDOffset(n5);
            }
            if (n6 == 198508544) {
                subProject.setFullPath(MPPUtility.getUnicodeString(byArray, n2));
            } else {
                n2 += 18;
                subProject.setDosFullPath(MPPUtility.getString(byArray, n2 += 4));
                n2 += subProject.getDosFullPath().length() + 1;
                n5 = MPPUtility.getInt(byArray, n2 += 24);
                n2 += 4;
                if (n5 == 0) {
                    subProject.setFullPath(subProject.getDosFullPath());
                } else {
                    n5 = MPPUtility.getInt(byArray, n2);
                    n2 += 4;
                    subProject.setFullPath(MPPUtility.getUnicodeString(byArray, n2 += 2, n5));
                }
                n3 += 18;
                subProject.setDosFileName(MPPUtility.getString(byArray, n3 += 4));
                n3 += subProject.getDosFileName().length() + 1;
                n5 = MPPUtility.getInt(byArray, n3 += 24);
                n3 += 4;
                if (n5 == 0) {
                    subProject.setFileName(subProject.getDosFileName());
                } else {
                    n5 = MPPUtility.getInt(byArray, n3);
                    n3 += 4;
                    subProject.setFileName(MPPUtility.getUnicodeString(byArray, n3 += 2, n5));
                }
            }
            this.m_file.getSubProjects().add(subProject);
            return subProject;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private void processViewPropertyData() throws IOException {
        Props14 props14 = new Props14(this.m_inputStreamFactory.getInstance(this.m_viewDir, "Props"));
        byte[] byArray = props14.getByteArray(Props.FONT_BASES);
        if (byArray != null) {
            this.processBaseFonts(byArray);
        }
        ProjectProperties projectProperties = this.m_file.getProjectProperties();
        projectProperties.setShowProjectSummaryTask(props14.getBoolean(Props.SHOW_PROJECT_SUMMARY_TASK));
    }

    private void processBaseFonts(byte[] byArray) {
        int n = 0;
        int n2 = MPPUtility.getShort(byArray, 0);
        n += 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = MPPUtility.getShort(byArray, n += 2);
            String string = MPPUtility.getUnicodeString(byArray, n += 2);
            n += 64;
            if (string.length() == 0) continue;
            FontBase fontBase = new FontBase(i, string, n3);
            this.m_fontBases.put(fontBase.getIndex(), fontBase);
        }
    }

    private TreeMap<Integer, Integer> createTaskMap(FieldMap fieldMap, FixedMeta fixedMeta, FixedData fixedData) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = fieldMap.getFixedDataOffset(TaskField.UNIQUE_ID);
        int n2 = fixedMeta.getAdjustedItemCount();
        for (int i = 3; i < n2; ++i) {
            Integer n3;
            int n4;
            byte[] byArray = fixedData.getByteArrayValue(i);
            if (byArray == null) continue;
            byte[] byArray2 = fixedMeta.getByteArrayValue(i);
            int n5 = MPPUtility.getInt(byArray2, 0);
            if ((n5 & 2) != 0) {
                n4 = MPPUtility.getShort(byArray, 0);
                n3 = n4;
                if (treeMap.containsKey(n3)) continue;
                treeMap.put(n3, null);
                continue;
            }
            if (byArray.length == 16) {
                n4 = MPPUtility.getInt(byArray, 0);
                n3 = n4;
                if (treeMap.containsKey(n3)) continue;
                treeMap.put(n3, i);
                continue;
            }
            int n6 = fieldMap.getMaxFixedDataSize(0);
            if (n6 != 0 && byArray.length * 100 / n6 <= 75 || treeMap.containsKey(n3 = Integer.valueOf(n4 = MPPUtility.getInt(byArray, n)))) continue;
            treeMap.put(n3, i);
        }
        return treeMap;
    }

    private TreeMap<Integer, Integer> createResourceMap(FieldMap fieldMap, FixedMeta fixedMeta, FixedData fixedData) {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = fixedMeta.getAdjustedItemCount();
        int n2 = fieldMap.getMaxFixedDataSize(0);
        int n3 = fieldMap.getFixedDataOffset(ResourceField.UNIQUE_ID);
        for (int i = 0; i < n; ++i) {
            Integer n4;
            byte[] byArray = fixedData.getByteArrayValue(i);
            if (byArray == null || byArray.length < n2 || treeMap.containsKey(n4 = Integer.valueOf(MPPUtility.getShort(byArray, n3)))) continue;
            treeMap.put(n4, i);
        }
        return treeMap;
    }

    private void processCalendarData() throws IOException {
        int n;
        int n2;
        int n3;
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndCal");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"), 12);
        HashMap<Integer, ProjectCalendar> hashMap = new HashMap<Integer, ProjectCalendar>();
        int n4 = fixedData.getItemCount();
        LinkedList<Pair<ProjectCalendar, Integer>> linkedList = new LinkedList<Pair<ProjectCalendar, Integer>>();
        byte[] byArray = this.m_projectProps.getByteArray(Props.DEFAULT_CALENDAR_HOURS);
        ProjectCalendar projectCalendar = new ProjectCalendar(this.m_file);
        this.processCalendarHours(byArray, null, projectCalendar, true);
        if (this.m_file.getProjectProperties().getFullApplicationName().equals("Microsoft.Project 15.0")) {
            n3 = 8;
            n2 = 0;
            n = 4;
        } else {
            n3 = 0;
            n2 = 4;
            n = 8;
        }
        for (int i = 0; i < n4; ++i) {
            byte[] byArray2 = fixedData.getByteArrayValue(i);
            if (byArray2 == null || byArray2.length < 8) continue;
            int n5 = 0;
            while (n5 + 12 <= byArray2.length) {
                Integer n6 = MPPUtility.getInt(byArray2, n5 + n3);
                int n7 = MPPUtility.getInt(byArray2, n5 + n2);
                if (n6 > 0 && !hashMap.containsKey(n6)) {
                    ProjectCalendar projectCalendar2;
                    byte[] byArray3 = var2Data.getByteArray(n6, CALENDAR_DATA);
                    if (n7 == 0 || n7 == -1 || n7 == n6) {
                        if (byArray3 != null || byArray != null) {
                            projectCalendar2 = this.m_file.addCalendar();
                            if (byArray3 == null) {
                                byArray3 = byArray;
                            }
                        } else {
                            projectCalendar2 = this.m_file.addDefaultBaseCalendar();
                        }
                        projectCalendar2.setName(var2Data.getUnicodeString(n6, CALENDAR_NAME));
                    } else {
                        projectCalendar2 = byArray3 != null ? this.m_file.addCalendar() : this.m_file.addDefaultDerivedCalendar();
                        linkedList.add(new Pair<ProjectCalendar, Integer>(projectCalendar2, n7));
                        Integer n8 = MPPUtility.getInt(byArray2, n5 + n);
                        this.m_resourceMap.put(n8, projectCalendar2);
                    }
                    projectCalendar2.setUniqueID(n6);
                    if (byArray3 != null) {
                        this.processCalendarHours(byArray3, projectCalendar, projectCalendar2, n7 == -1);
                        this.processCalendarExceptions(byArray3, projectCalendar2);
                    }
                    hashMap.put(n6, projectCalendar2);
                    this.m_eventManager.fireCalendarReadEvent(projectCalendar2);
                }
                n5 += 12;
            }
        }
        this.updateBaseCalendarNames(linkedList, hashMap);
    }

    private void processCalendarHours(byte[] byArray, ProjectCalendar projectCalendar, ProjectCalendar projectCalendar2, boolean bl) {
        ArrayList<DateRange> arrayList = new ArrayList<DateRange>(5);
        for (int i = 0; i < 7; ++i) {
            int n;
            ProjectCalendarHours projectCalendarHours;
            int n2 = 60 * i;
            int n3 = byArray == null ? 1 : MPPUtility.getShort(byArray, n2);
            Day day = Day.getInstance(i + 1);
            if (n3 == 1) {
                if (bl) {
                    if (projectCalendar == null) {
                        projectCalendar2.setWorkingDay(day, DEFAULT_WORKING_WEEK[i]);
                        if (!projectCalendar2.isWorkingDay(day)) continue;
                        projectCalendarHours = projectCalendar2.addCalendarHours(Day.getInstance(i + 1));
                        projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_MORNING);
                        projectCalendarHours.addRange(ProjectCalendarWeek.DEFAULT_WORKING_AFTERNOON);
                        continue;
                    }
                    n = projectCalendar.isWorkingDay(day);
                    projectCalendar2.setWorkingDay(day, n != 0);
                    if (n == 0) continue;
                    projectCalendarHours = projectCalendar2.addCalendarHours(Day.getInstance(i + 1));
                    for (Comparable<DateRange> comparable : projectCalendar.getHours(day)) {
                        projectCalendarHours.addRange((DateRange)comparable);
                    }
                    continue;
                }
                projectCalendar2.setWorkingDay(day, DayType.DEFAULT);
                continue;
            }
            arrayList.clear();
            int n4 = MPPUtility.getShort(byArray, n2 + 2);
            for (int j = 0; j < n4; ++j) {
                Comparable<DateRange> comparable;
                n = n2 + 8 + j * 2;
                Date date = MPPUtility.getTime(byArray, n);
                int n5 = n2 + 20 + j * 4;
                long l = MPPUtility.getDuration(byArray, n5);
                comparable = new Date(date.getTime() + l);
                arrayList.add(new DateRange(date, (Date)comparable));
            }
            if (arrayList.isEmpty()) {
                projectCalendar2.setWorkingDay(day, false);
                continue;
            }
            projectCalendar2.setWorkingDay(day, true);
            projectCalendarHours = projectCalendar2.addCalendarHours(Day.getInstance(i + 1));
            for (DateRange dateRange : arrayList) {
                projectCalendarHours.addRange(dateRange);
            }
        }
    }

    private void processCalendarExceptions(byte[] byArray, ProjectCalendar projectCalendar) {
        int n;
        int n2;
        if (byArray.length > 420 && (n2 = MPPUtility.getShort(byArray, n = 420)) != 0) {
            n += 4;
            for (int i = 0; i < n2; ++i) {
                int n3;
                Date date = MPPUtility.getDate(byArray, n);
                Date date2 = MPPUtility.getDate(byArray, n + 2);
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
                int n4 = MPPUtility.getShort(byArray, n + 14);
                if (n4 != 0) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        Date date3 = MPPUtility.getTime(byArray, n + 20 + n3 * 2);
                        long l = MPPUtility.getDuration(byArray, n + 32 + n3 * 4);
                        projectCalendarException.addRange(new DateRange(date3, new Date(date3.getTime() + l)));
                    }
                }
                if ((n3 = MPPUtility.getInt(byArray, n + 88)) % 4 != 0) {
                    n3 = (n3 / 4 + 1) * 4;
                }
                n += 92 + n3;
            }
        }
    }

    private void updateBaseCalendarNames(List<Pair<ProjectCalendar, Integer>> list, HashMap<Integer, ProjectCalendar> hashMap) {
        for (Pair<ProjectCalendar, Integer> pair : list) {
            ProjectCalendar projectCalendar = pair.getFirst();
            Integer n = pair.getSecond();
            ProjectCalendar projectCalendar2 = hashMap.get(n);
            if (projectCalendar2 != null && projectCalendar2.getName() != null) {
                projectCalendar.setParent(projectCalendar2);
                continue;
            }
            this.m_file.removeCalendar(projectCalendar);
        }
    }

    private void processTaskData() throws IOException {
        MppBitFlag[] mppBitFlagArray;
        MppBitFlag[] mppBitFlagArray2;
        FieldMap14 fieldMap14 = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap14.createTaskFieldMap(this.m_projectProps);
        FieldMap14 fieldMap142 = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap142.createEnterpriseCustomFieldMap(this.m_projectProps, TaskField.class);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndTask");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 47);
        FixedData fixedData = new FixedData(fixedMeta, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedData")), fieldMap14.getMaxFixedDataSize(0));
        FixedMeta fixedMeta2 = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Fixed2Meta")), 92, 93);
        FixedData fixedData2 = new FixedData(fixedMeta2, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Fixed2Data")));
        Props14 props14 = new Props14(this.m_inputStreamFactory.getInstance(directoryEntry, "Props"));
        new CustomFieldAliasReader(this.m_file.getCustomFields(), props14.getByteArray(TASK_FIELD_NAME_ALIASES)).process();
        TreeMap<Integer, Integer> treeMap = this.createTaskMap(fieldMap14, fixedMeta, fixedData);
        Object[] objectArray = treeMap.keySet().toArray();
        boolean bl = true;
        LinkedList<Task> linkedList = new LinkedList<Task>();
        RecurringTaskReader recurringTaskReader = null;
        if (this.m_file.getProjectProperties().getFullApplicationName().equals("Microsoft.Project 15.0")) {
            mppBitFlagArray2 = PROJECT2013_TASK_META_DATA_BIT_FLAGS;
            mppBitFlagArray = PROJECT2013_TASK_META_DATA2_BIT_FLAGS;
        } else {
            mppBitFlagArray2 = PROJECT2010_TASK_META_DATA_BIT_FLAGS;
            mppBitFlagArray = PROJECT2010_TASK_META_DATA2_BIT_FLAGS;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            byte[] byArray;
            Task task;
            Integer n = (Integer)objectArray[i];
            Integer n2 = treeMap.get(n);
            if (!fixedData.isValidOffset(n2)) continue;
            byte[] byArray2 = fixedData.getByteArrayValue(n2);
            byte[] byArray3 = fixedMeta.getByteArrayValue(n2);
            Integer n3 = MPPUtility.getInt(byArray2, fieldMap14.getFixedDataOffset(TaskField.ID));
            if (byArray2.length == 16) {
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(MPPUtility.getShort(byArray2, 0));
                task.setID(MPPUtility.getShort(byArray2, 4));
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
                continue;
            }
            if (byArray2.length < fieldMap14.getMaxFixedDataSize(0)) {
                byArray = new byte[fieldMap14.getMaxFixedDataSize(0) + 8];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            byte[] byArray4 = fixedMeta2.getByteArrayValue(n2);
            byArray = fixedData2.getByteArrayValue(n2);
            byte[] byArray5 = var2Data.getByteArray(n, fieldMap14.getVarDataKey(TaskField.RECURRING_DATA));
            Task task2 = this.m_file.getTaskByID(n3);
            if (task2 != null) {
                if (!varMeta12.getUniqueIdentifierSet().contains(n)) continue;
                if (task2.getName() == null) {
                    this.m_file.removeTask(task2);
                }
            }
            task = this.m_file.addTask();
            task.disableEvents();
            fieldMap14.populateContainer(TaskField.class, task, n, new byte[][]{byArray2, byArray}, var2Data);
            fieldMap142.populateContainer(TaskField.class, task, n, null, var2Data);
            task.enableEvents();
            task.setEstimated(this.getDurationEstimated(MPPUtility.getShort(byArray2, fieldMap14.getFixedDataOffset(TaskField.ACTUAL_DURATION_UNITS))));
            Integer n4 = task.getSubprojectTaskID();
            if (n4 != null && n4 != 0) {
                task.setExternalTask(true);
                linkedList.add(task);
            }
            this.processHyperlinkData(task, var2Data.getByteArray(n, fieldMap14.getVarDataKey(TaskField.HYPERLINK_DATA)));
            task.setID(n3);
            task.setOutlineCode(1, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE1_INDEX)));
            task.setOutlineCode(2, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE2_INDEX)));
            task.setOutlineCode(3, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE3_INDEX)));
            task.setOutlineCode(4, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE4_INDEX)));
            task.setOutlineCode(5, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE5_INDEX)));
            task.setOutlineCode(6, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE6_INDEX)));
            task.setOutlineCode(7, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE7_INDEX)));
            task.setOutlineCode(8, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE8_INDEX)));
            task.setOutlineCode(9, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE9_INDEX)));
            task.setOutlineCode(10, this.getCustomFieldOutlineCodeValue(var2Data, this.m_outlineCodeVarData, n, fieldMap14.getVarDataKey(TaskField.OUTLINE_CODE10_INDEX)));
            task.setRecurring(MPPUtility.getShort(byArray2, 40) == 2);
            task.setUniqueID(n);
            task.setExpanded((byArray3[12] & 2) == 0);
            this.readBitFields(mppBitFlagArray2, task, byArray3);
            this.readBitFields(mppBitFlagArray, task, byArray4);
            this.m_parentTasks.put(task.getUniqueID(), (Integer)task.getCachedValue(TaskField.PARENT_TASK_UNIQUE_ID));
            if (task.getStart() == null || task.getCachedValue(TaskField.SCHEDULED_START) != null && task.getTaskMode() == TaskMode.AUTO_SCHEDULED) {
                task.setStart((Date)task.getCachedValue(TaskField.SCHEDULED_START));
            }
            if (task.getFinish() == null || task.getCachedValue(TaskField.SCHEDULED_FINISH) != null && task.getTaskMode() == TaskMode.AUTO_SCHEDULED) {
                task.setFinish((Date)task.getCachedValue(TaskField.SCHEDULED_FINISH));
            }
            if (task.getDuration() == null || task.getCachedValue(TaskField.SCHEDULED_DURATION) != null && task.getTaskMode() == TaskMode.AUTO_SCHEDULED) {
                task.setDuration((Duration)task.getCachedValue(TaskField.SCHEDULED_DURATION));
            }
            switch (task.getConstraintType()) {
                case AS_LATE_AS_POSSIBLE: {
                    if (DateHelper.compare(task.getStart(), task.getLateStart()) < 0) {
                        task.setStart(task.getLateStart());
                    }
                    if (DateHelper.compare(task.getFinish(), task.getLateFinish()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
                case START_NO_LATER_THAN: 
                case FINISH_NO_LATER_THAN: {
                    if (DateHelper.compare(task.getFinish(), task.getStart()) >= 0) break;
                    task.setFinish(task.getLateFinish());
                    break;
                }
            }
            if (byArray5 != null) {
                if (recurringTaskReader == null) {
                    recurringTaskReader = new RecurringTaskReader(this.m_file.getProjectProperties());
                }
                recurringTaskReader.processRecurringTask(task, byArray5);
                task.setRecurring(true);
            }
            String string = task.getNotes();
            task.setNotes(string);
            Integer n5 = (Integer)task.getCachedValue(TaskField.CALENDAR_UNIQUE_ID);
            if (n5 != null && n5 != -1 && (object = this.m_file.getCalendarByUniqueID(n5)) != null) {
                task.setCalendar((ProjectCalendar)object);
            }
            object = this.m_taskSubProjects.get(task.getUniqueID());
            task.setSubProject((SubProject)object);
            if (object != null) {
                task.setExternalTask(((SubProject)object).isExternalTask(task.getUniqueID()));
                if (task.getExternalTask()) {
                    task.setExternalTaskProject(((SubProject)object).getFullPath());
                }
            }
            if (task.getWBS() != null) {
                bl = false;
            }
            if ((byArray3[9] & 0x80) == 0) {
                task.setSplits(new LinkedList<DateRange>());
            }
            if (task.getTaskMode() != TaskMode.MANUALLY_SCHEDULED) {
                task.setManualDuration(null);
            }
            this.processTaskEnterpriseColumns(n, task, var2Data, byArray4);
            if (task.getName() == null && (task.getStart() == null || task.getStart().getTime() == MPPUtility.getEpochDate().getTime() || task.getFinish() == null || task.getFinish().getTime() == MPPUtility.getEpochDate().getTime() || task.getCreateDate() == null || task.getCreateDate().getTime() == MPPUtility.getEpochDate().getTime())) {
                this.m_file.removeTask(task);
                task = this.m_file.addTask();
                task.setNull(true);
                task.setUniqueID(n);
                task.setID(n3);
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
                continue;
            }
            if (byArray == null || byArray.length < 24) {
                this.m_nullTaskOrder.put(task.getID(), task.getUniqueID());
            } else {
                Long l = MPPUtility.getLong(byArray, 16);
                this.m_taskOrder.put(l, task.getUniqueID());
            }
            this.m_eventManager.fireTaskReadEvent(task);
        }
        this.m_file.getProjectConfig().setAutoWBS(bl);
        if (!linkedList.isEmpty()) {
            this.processExternalTasks(linkedList);
        }
    }

    private void postProcessTasks() throws MPXJException {
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        int n = 1000;
        int n2 = this.m_file.getTaskByUniqueID(0) == null ? n : 0;
        for (Map.Entry<Long, Integer> iterator : this.m_taskOrder.entrySet()) {
            treeMap.put(n2, iterator.getValue());
            n2 += n;
        }
        int n3 = 0;
        for (Map.Entry<Integer, Integer> entry : this.m_nullTaskOrder.entrySet()) {
            int n4;
            int n5 = entry.getKey();
            int n6 = n4 = (n5 - n3) * n;
            int n7 = 0;
            ++n3;
            while (treeMap.containsKey(n6)) {
                if (++n7 == n) {
                    throw new MPXJException("Unable to fix task order");
                }
                n6 = n4 - (n - n7);
            }
            treeMap.put(n6, entry.getValue());
        }
        n2 = this.m_file.getTaskByUniqueID(0) == null ? 1 : 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            Task task = this.m_file.getTaskByUniqueID((Integer)entry.getValue());
            if (task != null) {
                task.setID(n2);
            }
            ++n2;
        }
    }

    private void processTaskEnterpriseColumns(Integer n, Task task, Var2Data var2Data, byte[] byArray) {
        if (byArray != null) {
            int n2 = MPPUtility.getInt(byArray, 29);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG1, (n2 & 0x800) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG2, (n2 & 0x1000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG3, (n2 & 0x2000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG4, (n2 & 0x4000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG5, (n2 & 0x8000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG6, (n2 & 0x1000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG7, (n2 & 0x2000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG8, (n2 & 0x4000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG9, (n2 & 0x8000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG10, (n2 & 0x10000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG11, (n2 & 0x20000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG12, (n2 & 0x40000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG13, (n2 & 0x80000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG14, (n2 & 0x100000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG15, (n2 & 0x200000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG16, (n2 & 0x400000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG17, (n2 & 0x800000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG18, (n2 & 0x1000000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG19, (n2 & 0x2000000) != 0 ? 1 : 0);
            task.set((FieldType)TaskField.ENTERPRISE_FLAG20, (n2 & 0x4000000) != 0 ? 1 : 0);
        }
    }

    private void processResourceEnterpriseColumns(Integer n, Resource resource, Var2Data var2Data, byte[] byArray) {
        if (byArray != null) {
            int n2 = MPPUtility.getInt(byArray, 16);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG1, (n2 & 0x10) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG2, (n2 & 0x20) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG3, (n2 & 0x40) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG4, (n2 & 0x80) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG5, (n2 & 0x100) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG6, (n2 & 0x200) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG7, (n2 & 0x400) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG8, (n2 & 0x800) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG9, (n2 & 0x1000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG10, (n2 & 0x2000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG11, (n2 & 0x4000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG12, (n2 & 0x8000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG13, (n2 & 0x10000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG14, (n2 & 0x20000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG15, (n2 & 0x40000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG16, (n2 & 0x80000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG17, (n2 & 0x100000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG18, (n2 & 0x200000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG19, (n2 & 0x400000) != 0 ? 1 : 0);
            resource.set((FieldType)ResourceField.ENTERPRISE_FLAG20, (n2 & 0x800000) != 0 ? 1 : 0);
        }
    }

    private void processExternalTasks(List<Task> list) {
        Collections.sort(list);
        SubProject subProject = null;
        for (Task task : list) {
            SubProject subProject2 = task.getSubProject();
            if (subProject2 == null) {
                task.setSubProject(subProject);
                if (subProject != null) {
                    task.setExternalTaskProject(subProject.getFullPath());
                }
            } else {
                subProject = subProject2;
            }
            if (subProject == null) continue;
            task.setProject(subProject.getFullPath());
        }
    }

    private void processHyperlinkData(Task task, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            task.setHyperlink(string);
            task.setHyperlinkAddress(string2);
            task.setHyperlinkSubAddress(string3);
        }
    }

    private void processHyperlinkData(Resource resource, byte[] byArray) {
        if (byArray != null) {
            int n = 12;
            String string = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string.length() + 1) * 2;
            String string2 = MPPUtility.getUnicodeString(byArray, n += 12);
            n += (string2.length() + 1) * 2;
            String string3 = MPPUtility.getUnicodeString(byArray, n += 12);
            resource.setHyperlink(string);
            resource.setHyperlinkAddress(string2);
            resource.setHyperlinkSubAddress(string3);
        }
    }

    private void processConstraintData() throws IOException {
        ConstraintFactory constraintFactory = new ConstraintFactory();
        constraintFactory.process(this.m_projectDir, this.m_file, this.m_inputStreamFactory);
    }

    private void processResourceData() throws IOException {
        MppBitFlag[] mppBitFlagArray;
        MppBitFlag[] mppBitFlagArray2;
        FieldMap14 fieldMap14 = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap14.createResourceFieldMap(this.m_projectProps);
        FieldMap14 fieldMap142 = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap142.createEnterpriseCustomFieldMap(this.m_projectProps, ResourceField.class);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndRsc");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 37);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        FixedMeta fixedMeta2 = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Fixed2Meta")), 50);
        FixedData fixedData2 = new FixedData(fixedMeta2, this.m_inputStreamFactory.getInstance(directoryEntry, "Fixed2Data"));
        Props14 props14 = new Props14(this.m_inputStreamFactory.getInstance(directoryEntry, "Props"));
        new CustomFieldAliasReader(this.m_file.getCustomFields(), props14.getByteArray(RESOURCE_FIELD_NAME_ALIASES)).process();
        TreeMap<Integer, Integer> treeMap = this.createResourceMap(fieldMap14, fixedMeta, fixedData);
        Integer[] integerArray = varMeta12.getUniqueIdentifierArray();
        if (this.m_file.getProjectProperties().getFullApplicationName().equals("Microsoft.Project 15.0")) {
            mppBitFlagArray2 = PROJECT2013_RESOURCE_META_DATA_BIT_FLAGS;
            mppBitFlagArray = PROJECT2013_RESOURCE_META_DATA2_BIT_FLAGS;
        } else {
            mppBitFlagArray2 = PROJECT2010_RESOURCE_META_DATA_BIT_FLAGS;
            mppBitFlagArray = PROJECT2010_RESOURCE_META_DATA2_BIT_FLAGS;
        }
        for (int i = 0; i < integerArray.length; ++i) {
            Integer n = integerArray[i];
            Integer n2 = treeMap.get(n);
            if (n2 == null) continue;
            byte[] byArray = fixedData.getByteArrayValue(n2);
            byte[] byArray2 = fixedMeta2.getByteArrayValue(n2);
            byte[] byArray3 = fixedData2.getByteArrayValue(n2);
            Resource resource = this.m_file.addResource();
            resource.disableEvents();
            fieldMap14.populateContainer(ResourceField.class, resource, n, new byte[][]{byArray, byArray3}, var2Data);
            fieldMap142.populateContainer(ResourceField.class, resource, n, null, var2Data);
            resource.enableEvents();
            this.processHyperlinkData(resource, var2Data.getByteArray(n, fieldMap14.getVarDataKey(ResourceField.HYPERLINK_DATA)));
            resource.setID(MPPUtility.getInt(byArray, fieldMap14.getFixedDataOffset(ResourceField.ID)));
            resource.setOutlineCode1(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE1_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode2(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE2_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode3(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE3_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode4(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE4_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode5(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE5_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode6(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE6_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode7(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE7_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode8(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE8_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode9(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE9_INDEX)), OUTLINECODE_DATA));
            resource.setOutlineCode10(this.m_outlineCodeVarData.getUnicodeString(var2Data.getInt(n, 2, fieldMap14.getVarDataKey(ResourceField.OUTLINE_CODE10_INDEX)), OUTLINECODE_DATA));
            byte[] byArray4 = fixedMeta.getByteArrayValue(n2);
            this.readBitFields(mppBitFlagArray2, resource, byArray4);
            this.readBitFields(mppBitFlagArray, resource, byArray2);
            ResourceType resourceType = resource.getWorkGroup() == WorkGroup.DEFAULT ? ResourceType.WORK : (resource.getStandardRateUnits() == TimeUnit.ELAPSED_MINUTES ? ResourceType.MATERIAL : ResourceType.COST);
            resource.setType(resourceType);
            resource.setUniqueID(n);
            String string = resource.getNotes();
            resource.setNotes(string);
            resource.setResourceCalendar(this.m_resourceMap.get(n));
            this.processResourceEnterpriseColumns(n, resource, var2Data, byArray2);
            CostRateTableFactory costRateTableFactory = new CostRateTableFactory();
            costRateTableFactory.process(resource, 0, var2Data.getByteArray(n, fieldMap14.getVarDataKey(ResourceField.COST_RATE_A)));
            costRateTableFactory.process(resource, 1, var2Data.getByteArray(n, fieldMap14.getVarDataKey(ResourceField.COST_RATE_B)));
            costRateTableFactory.process(resource, 2, var2Data.getByteArray(n, fieldMap14.getVarDataKey(ResourceField.COST_RATE_C)));
            costRateTableFactory.process(resource, 3, var2Data.getByteArray(n, fieldMap14.getVarDataKey(ResourceField.COST_RATE_D)));
            costRateTableFactory.process(resource, 4, var2Data.getByteArray(n, fieldMap14.getVarDataKey(ResourceField.COST_RATE_E)));
            AvailabilityFactory availabilityFactory = new AvailabilityFactory();
            availabilityFactory.process(resource.getAvailability(), var2Data.getByteArray(n, fieldMap14.getVarDataKey(ResourceField.AVAILABILITY_DATA)));
            this.m_eventManager.fireResourceReadEvent(resource);
        }
    }

    private void processAssignmentData() throws IOException {
        FieldMap14 fieldMap14 = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap14.createAssignmentFieldMap(this.m_projectProps);
        FieldMap14 fieldMap142 = new FieldMap14(this.m_file.getProjectProperties(), this.m_file.getCustomFields());
        fieldMap142.createEnterpriseCustomFieldMap(this.m_projectProps, AssignmentField.class);
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_projectDir.getEntry("TBkndAssn");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 34);
        FixedData fixedData = new FixedData(110, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        FixedData fixedData2 = new FixedData(48, this.m_inputStreamFactory.getInstance(directoryEntry, "Fixed2Data"));
        ResourceAssignmentFactory resourceAssignmentFactory = new ResourceAssignmentFactory();
        resourceAssignmentFactory.process(this.m_file, fieldMap14, fieldMap142, this.m_reader.getUseRawTimephasedData(), this.m_reader.getPreserveNoteFormatting(), varMeta12, var2Data, fixedMeta, fixedData, fixedData2, fixedMeta.getItemCount());
    }

    private boolean getDurationEstimated(int n) {
        return (n & 0x20) != 0;
    }

    private void processViewData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CV_iew");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(138, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        int n = fixedMeta.getAdjustedItemCount();
        ViewFactory14 viewFactory14 = new ViewFactory14();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedMeta.getByteArrayValue(i);
            int n3 = MPPUtility.getShort(byArray, 4);
            if (n3 <= n2) continue;
            byte[] byArray2 = fixedData.getByteArrayValue(fixedData.getIndexFromOffset(n3));
            if (byArray2 != null) {
                View view = viewFactory14.createView(this.m_file, byArray, byArray2, var2Data, this.m_fontBases);
                this.m_file.getViews().add(view);
            }
            n2 = n3;
        }
    }

    private void processTableData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CTable");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FixedData fixedData = new FixedData(230, (InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedData")));
        TableContainer tableContainer = this.m_file.getTables();
        TableFactory14 tableFactory14 = new TableFactory14(TABLE_COLUMN_DATA_STANDARD, TABLE_COLUMN_DATA_ENTERPRISE, TABLE_COLUMN_DATA_BASELINE);
        int n = fixedData.getItemCount();
        for (int i = 0; i < n; ++i) {
            byte[] byArray = fixedData.getByteArrayValue(i);
            Table table = tableFactory14.createTable(this.m_file, byArray, varMeta12, var2Data);
            tableContainer.add(table);
        }
    }

    private void processFilterData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CFilter");
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        FilterReader14 filterReader14 = new FilterReader14();
        filterReader14.process(this.m_file.getProjectProperties(), this.m_file.getFilters(), fixedData, var2Data);
    }

    private void processSavedViewState() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CEdl");
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        DocumentInputStream documentInputStream = new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedData"));
        byte[] byArray = new byte[((InputStream)documentInputStream).available()];
        ((InputStream)documentInputStream).read(byArray);
        ((InputStream)documentInputStream).close();
        ViewStateReader12 viewStateReader12 = new ViewStateReader12();
        viewStateReader12.process(this.m_file, var2Data, byArray);
    }

    private void processGroupData() throws IOException {
        DirectoryEntry directoryEntry = (DirectoryEntry)this.m_viewDir.getEntry("CGrouping");
        FixedMeta fixedMeta = new FixedMeta((InputStream)new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("FixedMeta")), 10);
        FixedData fixedData = new FixedData(fixedMeta, this.m_inputStreamFactory.getInstance(directoryEntry, "FixedData"));
        VarMeta12 varMeta12 = new VarMeta12(new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("VarMeta")));
        Var2Data var2Data = new Var2Data(varMeta12, new DocumentInputStream((DocumentEntry)directoryEntry.getEntry("Var2Data")));
        GroupReader14 groupReader14 = new GroupReader14();
        groupReader14.process(this.m_file, fixedData, var2Data, this.m_fontBases);
    }

    private String getCustomFieldOutlineCodeValue(Var2Data var2Data, Var2Data var2Data2, Integer n, Integer n2) {
        String string = null;
        int n3 = var2Data.getShort(n, n2);
        if ((n3 & 0xFF00) != 1792) {
            string = var2Data2.getUnicodeString(var2Data.getInt(n, 2, n2), OUTLINECODE_DATA);
        } else {
            int n4 = var2Data.getInt(n, 2, n2);
            CustomFieldValueItem customFieldValueItem = this.m_file.getCustomFields().getCustomFieldValueItemByUniqueID(n4);
            if (customFieldValueItem != null) {
                Object object = customFieldValueItem.getValue();
                if (object instanceof String) {
                    string = (String)object;
                }
                String string2 = this.getCustomFieldOutlineCodeValue(var2Data, var2Data2, customFieldValueItem.getParent());
                if (string != null && string2 != null && !string2.isEmpty()) {
                    string = string2 + "." + string;
                }
            }
        }
        return string;
    }

    private String getCustomFieldOutlineCodeValue(Var2Data var2Data, Var2Data var2Data2, Integer n) {
        String string = null;
        int n2 = n;
        if (n2 == 0) {
            return "";
        }
        CustomFieldValueItem customFieldValueItem = this.m_file.getCustomFields().getCustomFieldValueItemByUniqueID(n2);
        if (customFieldValueItem != null) {
            String string2;
            Object object = customFieldValueItem.getValue();
            if (object instanceof String) {
                string = (String)object;
            }
            if (string != null && !NumberHelper.equals(n, customFieldValueItem.getParent()) && (string2 = this.getCustomFieldOutlineCodeValue(var2Data, var2Data2, customFieldValueItem.getParent())) != null && !string2.isEmpty()) {
                string = string2 + "." + string;
            }
        }
        return string;
    }

    private void readBitFields(MppBitFlag[] mppBitFlagArray, FieldContainer fieldContainer, byte[] byArray) {
        for (MppBitFlag mppBitFlag : mppBitFlagArray) {
            mppBitFlag.setValue(fieldContainer, byArray);
        }
    }
}

