/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.i18n;

import de.escape.quincunx.i18n.I18n;
import de.escape.quincunx.i18n.Localizable;
import java.awt.Button;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.util.Locale;

public class RButton
extends Button
implements Localizable {
    protected boolean localeUnknown = true;
    protected String resTag;

    public RButton(String tag) {
        this.setLabel(I18n.getString(tag, this.getLocale()));
        this.resTag = tag;
    }

    public void setLocale(Locale l) {
        super.setLocale(l);
        super.setLabel(I18n.getString(this.resTag, l));
        this.invalidate();
    }

    public Locale getLocale() {
        try {
            this.localeUnknown = false;
            return super.getLocale();
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            this.localeUnknown = true;
            return null;
        }
    }

    public void update(Graphics g) {
        if (this.localeUnknown) {
            this.setLocale(this.getLocale());
        } else {
            super.update(g);
        }
    }
}

