/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XFramesSupplier;
import com.sun.star.i18n.ParseResult;
import com.sun.star.i18n.XCharacterClassification;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;

public class Desktop {
    public static XDesktop getDesktop(XMultiServiceFactory xMultiServiceFactory) {
        XInterface xInterface = null;
        XDesktop xDesktop = null;
        if (xMultiServiceFactory != null) {
            try {
                xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.frame.Desktop");
                xDesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)xInterface);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        } else {
            System.out.println("Can't create a desktop. null pointer !");
        }
        return xDesktop;
    }

    public static XFrame getActiveFrame(XMultiServiceFactory xMultiServiceFactory) {
        XDesktop xDesktop = Desktop.getDesktop(xMultiServiceFactory);
        XFramesSupplier xFramesSupplier = (XFramesSupplier)UnoRuntime.queryInterface(XFramesSupplier.class, (Object)xDesktop);
        return xFramesSupplier.getActiveFrame();
    }

    private static XDispatch getDispatcher(XFrame xFrame, String string, URL uRL) {
        try {
            URL[] uRLArray = new URL[]{uRL};
            XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xFrame);
            return xDispatchProvider.queryDispatch(uRLArray[0], string, 23);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private static URL getDispatchURL(XMultiServiceFactory xMultiServiceFactory, String string) {
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.util.URLTransformer");
            XURLTransformer xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, (Object)object);
            URL[] uRLArray = new URL[]{new URL()};
            uRLArray[0].Complete = string;
            xURLTransformer.parseStrict(uRLArray);
            return uRLArray[0];
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    private static void dispatchURL(XMultiServiceFactory xMultiServiceFactory, String string, XFrame xFrame, String string2) {
        URL uRL = Desktop.getDispatchURL(xMultiServiceFactory, string);
        XDispatch xDispatch = Desktop.getDispatcher(xFrame, string2, uRL);
        Desktop.dispatchURL(xDispatch, uRL);
    }

    public static void dispatchURL(XMultiServiceFactory xMultiServiceFactory, String string, XFrame xFrame) {
        Desktop.dispatchURL(xMultiServiceFactory, string, xFrame, PropertyNames.EMPTY_STRING);
    }

    private static void dispatchURL(XDispatch xDispatch, URL uRL) {
        PropertyValue[] propertyValueArray = new PropertyValue[]{};
        xDispatch.dispatch(uRL, propertyValueArray);
    }

    private static XMultiComponentFactory getMultiComponentFactory() throws com.sun.star.uno.Exception, java.lang.RuntimeException, Exception {
        XComponentContext xComponentContext = Bootstrap.createInitialComponentContext(null);
        return xComponentContext.getServiceManager();
    }

    public static XMultiServiceFactory connect(String string) throws com.sun.star.uno.Exception, RuntimeException, Exception {
        XMultiComponentFactory xMultiComponentFactory = Desktop.getMultiComponentFactory();
        Object object = xMultiComponentFactory.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", null);
        XUnoUrlResolver xUnoUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)object);
        return (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xUnoUrlResolver.resolve(string));
    }

    public static String getIncrementSuffix(XNameAccess xNameAccess, String string) {
        boolean bl = true;
        int n = 1;
        String string2 = PropertyNames.EMPTY_STRING;
        String string3 = string;
        while (bl) {
            bl = xNameAccess.hasByName(string);
            if (!bl) continue;
            string = string3 + Integer.toString(++n);
        }
        if (n > 1) {
            string2 = Integer.toString(n);
        }
        return string2;
    }

    private static String getIncrementSuffix(XHierarchicalNameAccess xHierarchicalNameAccess, String string) {
        boolean bl = true;
        int n = 1;
        String string2 = PropertyNames.EMPTY_STRING;
        String string3 = string;
        while (bl) {
            bl = xHierarchicalNameAccess.hasByHierarchicalName(string);
            if (!bl) continue;
            string = string3 + Integer.toString(++n);
        }
        if (n > 1) {
            string2 = Integer.toString(n);
        }
        return string2;
    }

    private static int checkforfirstSpecialCharacter(XMultiServiceFactory xMultiServiceFactory, String string, Locale locale) {
        try {
            int n = 1044495;
            Object object = xMultiServiceFactory.createInstance("com.sun.star.i18n.CharacterClassification");
            XCharacterClassification xCharacterClassification = (XCharacterClassification)UnoRuntime.queryInterface(XCharacterClassification.class, (Object)object);
            ParseResult parseResult = xCharacterClassification.parsePredefinedToken(4, string, 0, locale, n, PropertyNames.EMPTY_STRING, n, PropertyNames.SPACE);
            return parseResult.EndPos;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public static String removeSpecialCharacters(XMultiServiceFactory xMultiServiceFactory, Locale locale, String string) {
        String string2 = string;
        int n = 0;
        while (n < string2.length()) {
            n = Desktop.checkforfirstSpecialCharacter(xMultiServiceFactory, string2, locale);
            if (n >= string2.length()) continue;
            String string3 = string2.substring(n, n + 1);
            string2 = JavaTools.replaceSubString(string2, PropertyNames.EMPTY_STRING, string3);
        }
        return string2;
    }

    public static String getUniqueName(XNameAccess xNameAccess, String string) {
        String string2 = Desktop.getIncrementSuffix(xNameAccess, string);
        return string + string2;
    }

    public static String getUniqueName(XHierarchicalNameAccess xHierarchicalNameAccess, String string) {
        String string2 = Desktop.getIncrementSuffix(xHierarchicalNameAccess, string);
        return string + string2;
    }

    public static String getUniqueName(String[] stringArray, String string, String string2) {
        int n = 2;
        String string3 = string;
        boolean bl = true;
        if (stringArray == null) {
            return string;
        }
        if (stringArray.length == 0) {
            return string;
        }
        while (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (JavaTools.FieldInList(stringArray, string3) != -1) continue;
                return string3;
            }
            string3 = string + string2 + n++;
        }
        return PropertyNames.EMPTY_STRING;
    }

    private static String getTemplatePath(XMultiServiceFactory xMultiServiceFactory) {
        try {
            return FileAccess.getOfficePath(xMultiServiceFactory, "Template", "share", "/wizard");
        }
        catch (NoValidPathException noValidPathException) {
            return PropertyNames.EMPTY_STRING;
        }
    }

    public static String getBitmapPath(XMultiServiceFactory xMultiServiceFactory) {
        try {
            return FileAccess.combinePaths(xMultiServiceFactory, Desktop.getTemplatePath(xMultiServiceFactory), "/../wizard/bitmap");
        }
        catch (NoValidPathException noValidPathException) {
            return PropertyNames.EMPTY_STRING;
        }
    }
}

