/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.UnboundMethodLayout;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class UnboundMethodLayoutImpl
extends BasicObjectLayoutImpl
implements UnboundMethodLayout {
    public static final UnboundMethodLayout INSTANCE = new UnboundMethodLayoutImpl();
    protected static final Shape.Allocator UNBOUND_METHOD_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ORIGIN_IDENTIFIER = new HiddenKey("origin");
    protected static final Property ORIGIN_PROPERTY = Property.create(ORIGIN_IDENTIFIER, UNBOUND_METHOD_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey METHOD_IDENTIFIER = new HiddenKey("method");
    protected static final Property METHOD_PROPERTY = Property.create(METHOD_IDENTIFIER, UNBOUND_METHOD_ALLOCATOR.locationForType(InternalMethod.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected UnboundMethodLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createUnboundMethodShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new UnboundMethodType(logicalClass, metaClass)).addProperty(ORIGIN_PROPERTY).addProperty(METHOD_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createUnboundMethod(DynamicObjectFactory factory, DynamicObject origin, InternalMethod method) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsUnboundMethod(factory));
        assert (factory.getShape().hasProperty(ORIGIN_IDENTIFIER));
        assert (factory.getShape().hasProperty(METHOD_IDENTIFIER));
        assert (origin != null);
        assert (method != null);
        return factory.newInstance(origin, method);
    }

    @Override
    public boolean isUnboundMethod(Object object) {
        return object instanceof DynamicObject && this.isUnboundMethod((DynamicObject)object);
    }

    @Override
    public boolean isUnboundMethod(DynamicObject object) {
        return this.isUnboundMethod(object.getShape().getObjectType());
    }

    private boolean isUnboundMethod(ObjectType objectType) {
        return objectType instanceof UnboundMethodType;
    }

    private boolean createsUnboundMethod(DynamicObjectFactory factory) {
        return this.isUnboundMethod(factory.getShape().getObjectType());
    }

    @Override
    public DynamicObject getOrigin(DynamicObject object) {
        assert (this.isUnboundMethod(object));
        assert (object.getShape().hasProperty(ORIGIN_IDENTIFIER));
        return (DynamicObject)ORIGIN_PROPERTY.get(object, true);
    }

    @Override
    public InternalMethod getMethod(DynamicObject object) {
        assert (this.isUnboundMethod(object));
        assert (object.getShape().hasProperty(METHOD_IDENTIFIER));
        return (InternalMethod)METHOD_PROPERTY.get(object, true);
    }

    protected static class UnboundMethodType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public UnboundMethodType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public UnboundMethodType setLogicalClass(DynamicObject logicalClass) {
            return new UnboundMethodType(logicalClass, this.metaClass);
        }

        @Override
        public UnboundMethodType setMetaClass(DynamicObject metaClass) {
            return new UnboundMethodType(this.logicalClass, metaClass);
        }
    }
}

