/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.core.SymbolCodeRangeableWrapper;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.SymbolLayout;
import org.jruby.util.ByteList;

public class SymbolLayoutImpl
extends BasicObjectLayoutImpl
implements SymbolLayout {
    public static final SymbolLayout INSTANCE = new SymbolLayoutImpl();
    protected static final Shape.Allocator SYMBOL_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey STRING_IDENTIFIER = new HiddenKey("string");
    protected static final Property STRING_PROPERTY = Property.create(STRING_IDENTIFIER, SYMBOL_ALLOCATOR.locationForType(String.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey BYTE_LIST_IDENTIFIER = new HiddenKey("byteList");
    protected static final Property BYTE_LIST_PROPERTY = Property.create(BYTE_LIST_IDENTIFIER, SYMBOL_ALLOCATOR.locationForType(ByteList.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey HASH_CODE_IDENTIFIER = new HiddenKey("hashCode");
    protected static final Property HASH_CODE_PROPERTY = Property.create(HASH_CODE_IDENTIFIER, SYMBOL_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey CODE_RANGE_IDENTIFIER = new HiddenKey("codeRange");
    protected static final Property CODE_RANGE_PROPERTY = Property.create(CODE_RANGE_IDENTIFIER, SYMBOL_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey CODE_RANGEABLE_WRAPPER_IDENTIFIER = new HiddenKey("codeRangeableWrapper");
    protected static final Property CODE_RANGEABLE_WRAPPER_PROPERTY = Property.create(CODE_RANGEABLE_WRAPPER_IDENTIFIER, SYMBOL_ALLOCATOR.locationForType(SymbolCodeRangeableWrapper.class), 0);

    protected SymbolLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createSymbolShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new SymbolType(logicalClass, metaClass)).addProperty(STRING_PROPERTY).addProperty(BYTE_LIST_PROPERTY).addProperty(HASH_CODE_PROPERTY).addProperty(CODE_RANGE_PROPERTY).addProperty(CODE_RANGEABLE_WRAPPER_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createSymbol(DynamicObjectFactory factory, String string, ByteList byteList, int hashCode, int codeRange, SymbolCodeRangeableWrapper codeRangeableWrapper) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsSymbol(factory));
        assert (factory.getShape().hasProperty(STRING_IDENTIFIER));
        assert (factory.getShape().hasProperty(BYTE_LIST_IDENTIFIER));
        assert (factory.getShape().hasProperty(HASH_CODE_IDENTIFIER));
        assert (factory.getShape().hasProperty(CODE_RANGE_IDENTIFIER));
        assert (factory.getShape().hasProperty(CODE_RANGEABLE_WRAPPER_IDENTIFIER));
        assert (string != null);
        assert (byteList != null);
        return factory.newInstance(string, byteList, hashCode, codeRange, codeRangeableWrapper);
    }

    @Override
    public boolean isSymbol(Object object) {
        return object instanceof DynamicObject && this.isSymbol((DynamicObject)object);
    }

    @Override
    public boolean isSymbol(DynamicObject object) {
        return this.isSymbol(object.getShape().getObjectType());
    }

    private boolean isSymbol(ObjectType objectType) {
        return objectType instanceof SymbolType;
    }

    private boolean createsSymbol(DynamicObjectFactory factory) {
        return this.isSymbol(factory.getShape().getObjectType());
    }

    @Override
    public String getString(DynamicObject object) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(STRING_IDENTIFIER));
        return (String)STRING_PROPERTY.get(object, true);
    }

    @Override
    public ByteList getByteList(DynamicObject object) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(BYTE_LIST_IDENTIFIER));
        return (ByteList)BYTE_LIST_PROPERTY.get(object, true);
    }

    @Override
    public int getHashCode(DynamicObject object) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(HASH_CODE_IDENTIFIER));
        return (Integer)HASH_CODE_PROPERTY.get(object, true);
    }

    @Override
    public int getCodeRange(DynamicObject object) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(CODE_RANGE_IDENTIFIER));
        return (Integer)CODE_RANGE_PROPERTY.get(object, true);
    }

    @Override
    public void setCodeRange(DynamicObject object, int value) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(CODE_RANGE_IDENTIFIER));
        try {
            CODE_RANGE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public SymbolCodeRangeableWrapper getCodeRangeableWrapper(DynamicObject object) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(CODE_RANGEABLE_WRAPPER_IDENTIFIER));
        return (SymbolCodeRangeableWrapper)CODE_RANGEABLE_WRAPPER_PROPERTY.get(object, true);
    }

    @Override
    public void setCodeRangeableWrapper(DynamicObject object, SymbolCodeRangeableWrapper value) {
        assert (this.isSymbol(object));
        assert (object.getShape().hasProperty(CODE_RANGEABLE_WRAPPER_IDENTIFIER));
        try {
            CODE_RANGEABLE_WRAPPER_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class SymbolType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public SymbolType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public SymbolType setLogicalClass(DynamicObject logicalClass) {
            return new SymbolType(logicalClass, this.metaClass);
        }

        @Override
        public SymbolType setMetaClass(DynamicObject metaClass) {
            return new SymbolType(this.logicalClass, metaClass);
        }
    }
}

