/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.MethodLayout;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class MethodLayoutImpl
extends BasicObjectLayoutImpl
implements MethodLayout {
    public static final MethodLayout INSTANCE = new MethodLayoutImpl();
    protected static final Shape.Allocator METHOD_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey RECEIVER_IDENTIFIER = new HiddenKey("receiver");
    protected static final Property RECEIVER_PROPERTY = Property.create(RECEIVER_IDENTIFIER, METHOD_ALLOCATOR.locationForType(Object.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey METHOD_IDENTIFIER = new HiddenKey("method");
    protected static final Property METHOD_PROPERTY = Property.create(METHOD_IDENTIFIER, METHOD_ALLOCATOR.locationForType(InternalMethod.class, EnumSet.of(LocationModifier.NonNull)), 0);

    protected MethodLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createMethodShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new MethodType(logicalClass, metaClass)).addProperty(RECEIVER_PROPERTY).addProperty(METHOD_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createMethod(DynamicObjectFactory factory, Object receiver, InternalMethod method) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsMethod(factory));
        assert (factory.getShape().hasProperty(RECEIVER_IDENTIFIER));
        assert (factory.getShape().hasProperty(METHOD_IDENTIFIER));
        assert (receiver != null);
        assert (method != null);
        return factory.newInstance(receiver, method);
    }

    @Override
    public boolean isMethod(Object object) {
        return object instanceof DynamicObject && this.isMethod((DynamicObject)object);
    }

    @Override
    public boolean isMethod(DynamicObject object) {
        return this.isMethod(object.getShape().getObjectType());
    }

    private boolean isMethod(ObjectType objectType) {
        return objectType instanceof MethodType;
    }

    private boolean createsMethod(DynamicObjectFactory factory) {
        return this.isMethod(factory.getShape().getObjectType());
    }

    @Override
    public Object getReceiver(DynamicObject object) {
        assert (this.isMethod(object));
        assert (object.getShape().hasProperty(RECEIVER_IDENTIFIER));
        return RECEIVER_PROPERTY.get(object, true);
    }

    @Override
    public InternalMethod getMethod(DynamicObject object) {
        assert (this.isMethod(object));
        assert (object.getShape().hasProperty(METHOD_IDENTIFIER));
        return (InternalMethod)METHOD_PROPERTY.get(object, true);
    }

    protected static class MethodType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public MethodType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public MethodType setLogicalClass(DynamicObject logicalClass) {
            return new MethodType(logicalClass, this.metaClass);
        }

        @Override
        public MethodType setMetaClass(DynamicObject metaClass) {
            return new MethodType(this.logicalClass, metaClass);
        }
    }
}

