/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayReadDenormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayReadNormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceDenormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNodeGen;
import org.jruby.truffle.nodes.core.fixnum.FixnumLiteralNode;
import org.jruby.truffle.runtime.RubyContext;

public abstract class PrimitiveArrayNodeFactory {
    public static RubyNode read(RubyContext context, SourceSection sourceSection, RubyNode array, int index) {
        FixnumLiteralNode.IntegerFixnumLiteralNode literalIndex = new FixnumLiteralNode.IntegerFixnumLiteralNode(context, sourceSection, index);
        if (index >= 0) {
            return ArrayReadNormalizedNodeGen.create(context, sourceSection, array, literalIndex);
        }
        return ArrayReadDenormalizedNodeGen.create(context, sourceSection, array, literalIndex);
    }

    public static RubyNode readSlice(RubyContext context, SourceSection sourceSection, RubyNode array, int start, int exclusiveEnd) {
        FixnumLiteralNode.IntegerFixnumLiteralNode literalStart = new FixnumLiteralNode.IntegerFixnumLiteralNode(context, sourceSection, start);
        FixnumLiteralNode.IntegerFixnumLiteralNode literalExclusiveEnd = new FixnumLiteralNode.IntegerFixnumLiteralNode(context, sourceSection, exclusiveEnd);
        if (start >= 0 && exclusiveEnd >= 0) {
            return ArrayReadSliceNormalizedNodeGen.create(context, sourceSection, array, literalStart, literalExclusiveEnd);
        }
        return ArrayReadSliceDenormalizedNodeGen.create(context, sourceSection, array, literalStart, literalExclusiveEnd);
    }
}

