/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayWriteDenormalizedNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=ArrayWriteDenormalizedNode.class)
public final class ArrayWriteDenormalizedNodeGen
extends ArrayWriteDenormalizedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode index_;
    @Node.Child
    private RubyNode value_;

    private ArrayWriteDenormalizedNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        super(context, sourceSection);
        this.array_ = array;
        this.index_ = index;
        this.value_ = value;
    }

    @Override
    public NodeCost getCost() {
        return NodeCost.MONOMORPHIC;
    }

    @Override
    public Object executeWrite(VirtualFrame frameValue, DynamicObject arrayValue, int indexValue, Object valueValue) {
        if (RubyGuards.isRubyArray(arrayValue)) {
            return this.write(frameValue, arrayValue, indexValue, valueValue);
        }
        throw this.unsupported(arrayValue, indexValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int indexValue_;
        DynamicObject arrayValue_;
        try {
            arrayValue_ = this.array_.executeDynamicObject(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object indexValue = this.index_.execute(frameValue);
            Object valueValue = this.value_.execute(frameValue);
            throw this.unsupported(ex.getResult(), indexValue, valueValue);
        }
        try {
            indexValue_ = this.index_.executeInteger(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object valueValue = this.value_.execute(frameValue);
            throw this.unsupported(arrayValue_, ex.getResult(), valueValue);
        }
        Object valueValue_ = this.value_.execute(frameValue);
        if (RubyGuards.isRubyArray(arrayValue_)) {
            return this.write(frameValue, arrayValue_, indexValue_, valueValue_);
        }
        throw this.unsupported(arrayValue_, indexValue_, valueValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    protected UnsupportedSpecializationException unsupported(Object arrayValue, Object indexValue, Object valueValue) {
        return new UnsupportedSpecializationException(this, new Node[]{this.array_, this.index_, this.value_}, arrayValue, indexValue, valueValue);
    }

    public static ArrayWriteDenormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        return new ArrayWriteDenormalizedNodeGen(context, sourceSection, array, index, value);
    }
}

