/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RegexpOptions;

public class BuildDynRegExpInstr
extends NOperandResultBaseInstr {
    private final RegexpOptions options;
    private volatile RubyRegexp rubyRegexp;
    private static final AtomicReferenceFieldUpdater<BuildDynRegExpInstr, RubyRegexp> UPDATER = AtomicReferenceFieldUpdater.newUpdater(BuildDynRegExpInstr.class, RubyRegexp.class, "rubyRegexp");

    public BuildDynRegExpInstr(Variable result2, Operand[] pieces, RegexpOptions options2) {
        super(Operation.BUILD_DREGEXP, result2, pieces);
        this.options = options2;
    }

    public Operand[] getPieces() {
        return this.getOperands();
    }

    public RegexpOptions getOptions() {
        return this.options;
    }

    public RubyRegexp getRegexp() {
        return this.rubyRegexp;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"options: " + this.options};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new BuildDynRegExpInstr(ii.getRenamedVariable(this.result), this.cloneOperands(ii), this.options);
    }

    private RubyString[] retrievePieces(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        Operand[] operands = this.getOperands();
        int length2 = operands.length;
        RubyString[] strings = new RubyString[length2];
        for (int i2 = 0; i2 < length2; ++i2) {
            strings[i2] = (RubyString)operands[i2].retrieve(context, self2, currScope, currDynScope, temp);
        }
        return strings;
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getPieces());
        e.encode(this.getOptions().toEmbeddedOptions());
    }

    public static BuildDynRegExpInstr decode(IRReaderDecoder d) {
        return new BuildDynRegExpInstr(d.decodeVariable(), d.decodeOperandArray(), RegexpOptions.fromEmbeddedOptions(d.decodeInt()));
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        if (this.rubyRegexp == null || !this.options.isOnce() || context.runtime.getKCode() != this.rubyRegexp.getKCode()) {
            IRubyObject[] pieces = this.retrievePieces(context, self2, currScope, currDynScope, temp);
            RubyString pattern = RubyRegexp.preprocessDRegexp(context.runtime, pieces, this.options);
            RubyRegexp re = RubyRegexp.newDRegexp(context.runtime, pattern, this.options);
            re.setLiteral();
            if (this.options.isOnce()) {
                UPDATER.compareAndSet(this, null, re);
            } else {
                this.rubyRegexp = re;
            }
        }
        return this.rubyRegexp;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.BuildDynRegExpInstr(this);
    }
}

