"""Generated message classes for logging version v1beta3.

The Google Cloud Logging API lets you write log entries and manage your logs,
log sinks and logs-based metrics.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages
from googlecloudsdk.third_party.apitools.base.py import encoding


package = 'logging'


class Empty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class HttpRequest(_messages.Message):
  """A common proto for logging HTTP requests.

  Fields:
    cacheHit: Whether or not an entity was served from cache (with or without
      validation).
    referer: The referer URL of the request, as defined in [HTTP/1.1 Header
      Field
      Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
    remoteIp: The IP address (IPv4 or IPv6) of the client that issued the HTTP
      request. Examples: `"192.168.1.1"`, `"FE80::0202:B3FF:FE1E:8329"`.
    requestMethod: The request method. Examples: `"GET"`, `"HEAD"`, `"PUT"`,
      `"POST"`.
    requestSize: The size of the HTTP request message in bytes, including the
      request headers and the request body.
    requestUrl: The scheme (http, https), the host name, the path and the
      query portion of the URL that was requested. Example:
      `"http://example.com/some/info?color=red"`.
    responseSize: The size of the HTTP response message sent back to the
      client, in bytes, including the response headers and the response body.
    status: The response code indicating the status of response. Examples:
      200, 404.
    userAgent: The user agent sent by the client. Example: `"Mozilla/4.0
      (compatible; MSIE 6.0; Windows 98; Q312461; .NET CLR 1.0.3705)"`.
    validatedWithOriginServer: Whether or not the response was validated with
      the origin server before being served from cache. This field is only
      meaningful if `cache_hit` is True.
  """

  cacheHit = _messages.BooleanField(1)
  referer = _messages.StringField(2)
  remoteIp = _messages.StringField(3)
  requestMethod = _messages.StringField(4)
  requestSize = _messages.IntegerField(5)
  requestUrl = _messages.StringField(6)
  responseSize = _messages.IntegerField(7)
  status = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  userAgent = _messages.StringField(9)
  validatedWithOriginServer = _messages.BooleanField(10)


class ListLogEntriesRequest(_messages.Message):
  """The parameters to `ListLogEntries`.

  Fields:
    filter: An [advanced logs filter](/logging/docs/view/advanced_filters).
      The response includes only entries that match the filter. If `filter` is
      empty, then all entries in all logs are retrieved.
    orderBy: Sort order of the results, consisting of a `LogEntry` field
      optionally followed by a space and `desc`.  Examples:
      `"metadata.timestamp"`, `"metadata.timestamp desc"`.  The only
      `LogEntry` field supported for sorting is `metadata.timestamp`. The
      default sort order is ascending (from older to newer entries) unless
      `desc` is appended.
    pageSize: The maximum number of entries to return per request.  Fewer
      entries may be returned, but that is not an indication that there are no
      more entries.
    pageToken: An opaque token, returned as `nextPageToken` by a prior
      `ListLogEntries` operation. If a page token is specified, other request
      parameters must match the parameters from the request that generated the
      page token.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.BytesField(4)


class ListLogEntriesResponse(_messages.Message):
  """Result returned from `ListLogEntries`.

  Fields:
    entries: A list of log entries.  Fewer than `pageSize` entries may be
      returned, but that is not an indication that there are no more entries.
    nextPageToken: If there are more results, then `nextPageToken` is returned
      in the response.  To get the next batch of entries, use the value of
      `nextPageToken` as `pageToken` in the next call of `ListLogEntries`. If
      `nextPageToken` is empty, then there are no more results.
  """

  entries = _messages.MessageField('LogEntry', 1, repeated=True)
  nextPageToken = _messages.BytesField(2)


class ListLogMetricsResponse(_messages.Message):
  """Result returned from ListLogMetrics.

  Fields:
    metrics: The list of metrics that was requested.
    nextPageToken: If there are more results, then `nextPageToken` is returned
      in the response.  To get the next batch of entries, use the value of
      `nextPageToken` as `pageToken` in the next call of `ListLogMetrics`. If
      `nextPageToken` is empty, then there are no more results.
  """

  metrics = _messages.MessageField('LogMetric', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLogServiceIndexesResponse(_messages.Message):
  """Result returned from ListLogServiceIndexesRequest.

  Fields:
    nextPageToken: If there are more results, then `nextPageToken` is returned
      in the response.  To get the next batch of indexes, use the value of
      `nextPageToken` as `pageToken` in the next call of
      `ListLogServiceIndexes`. If `nextPageToken` is empty, then there are no
      more results.
    serviceIndexPrefixes: A list of log service index values. Each index value
      has the form `"/value1/value2/..."`, where `value1` is a value in the
      primary index, `value2` is a value in the secondary index, and so forth.
  """

  nextPageToken = _messages.StringField(1)
  serviceIndexPrefixes = _messages.StringField(2, repeated=True)


class ListLogServiceSinksResponse(_messages.Message):
  """Result returned from `ListLogServiceSinks`.

  Fields:
    sinks: The requested log service sinks. If a returned `LogSink` object has
      an empty `destination` field, the client can retrieve the complete
      `LogSink` object by calling `logServices.sinks.get`.
  """

  sinks = _messages.MessageField('LogSink', 1, repeated=True)


class ListLogServicesResponse(_messages.Message):
  """Result returned from `ListLogServicesRequest`.

  Fields:
    logServices: A list of log services.
    nextPageToken: If there are more results, then `nextPageToken` is returned
      in the response.  To get the next batch of services, use the value of
      `nextPageToken` as `pageToken` in the next call of `ListLogServices`. If
      `nextPageToken` is empty, then there are no more results.
  """

  logServices = _messages.MessageField('LogService', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLogSinksResponse(_messages.Message):
  """Result returned from `ListLogSinks`.

  Fields:
    sinks: The requested log sinks. If a returned `LogSink` object has an
      empty `destination` field, the client can retrieve the complete
      `LogSink` object by calling `log.sinks.get`.
  """

  sinks = _messages.MessageField('LogSink', 1, repeated=True)


class ListLogsResponse(_messages.Message):
  """Result returned from ListLogs.

  Fields:
    logs: A list of log descriptions matching the criteria.
    nextPageToken: If there are more results, then `nextPageToken` is returned
      in the response.  To get the next batch of logs, use the value of
      `nextPageToken` as `pageToken` in the next call of `ListLogs`. If
      `nextPageToken` is empty, then there are no more results.
  """

  logs = _messages.MessageField('Log', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListSinksResponse(_messages.Message):
  """Result returned from `ListSinks`.

  Fields:
    sinks: The requested sinks.  If a returned `LogSink` object has an empty
      `destination` field, the client can retrieve the complete `LogSink`
      object by calling `projects.sinks.get`.
  """

  sinks = _messages.MessageField('LogSink', 1, repeated=True)


class Log(_messages.Message):
  """_Output only._ Describes a log, which is a named stream of log entries.

  Fields:
    displayName: _Optional._ The common name of the log.  Example:
      `"request_log"`.
    name: The resource name of the log. Example: `"/projects/my-gcp-project-
      id/logs/LOG_NAME"`, where `LOG_NAME` is the URL-encoded given name of
      the log.  The log includes those log entries whose `LogEntry.log` field
      contains this given name. To avoid name collisions, it is a best
      practice to prefix the given log name with the service name, but this is
      not required. Examples of log given names:
      `"appengine.googleapis.com/request_log"`, `"apache-access"`.
    payloadType: _Optional_. A URI representing the expected payload type for
      log entries.
  """

  displayName = _messages.StringField(1)
  name = _messages.StringField(2)
  payloadType = _messages.StringField(3)


class LogEntry(_messages.Message):
  """An individual entry in a log.

  Messages:
    ProtoPayloadValue: The log entry payload, represented as a protocol buffer
      that is expressed as a JSON object. You can only pass `protoPayload`
      values that belong to a set of approved types.
    StructPayloadValue: The log entry payload, represented as a structure that
      is expressed as a JSON object.

  Fields:
    httpRequest: Information about the HTTP request associated with this log
      entry, if applicable.
    insertId: A unique ID for the log entry. If you provide this field, the
      logging service considers other log entries in the same log with the
      same ID as duplicates which can be removed.
    log: The log to which this entry belongs. When a log entry is ingested,
      the value of this field is set by the logging system.
    metadata: Information about the log entry.
    operation: Optional. Information about an operation associated with the
      log entry, if applicable.
    protoPayload: The log entry payload, represented as a protocol buffer that
      is expressed as a JSON object. You can only pass `protoPayload` values
      that belong to a set of approved types.
    structPayload: The log entry payload, represented as a structure that is
      expressed as a JSON object.
    textPayload: The log entry payload, represented as a Unicode string
      (UTF-8).
    writerEmailAddress: A string attribute.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ProtoPayloadValue(_messages.Message):
    """The log entry payload, represented as a protocol buffer that is
    expressed as a JSON object. You can only pass `protoPayload` values that
    belong to a set of approved types.

    Messages:
      AdditionalProperty: An additional property for a ProtoPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ProtoPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class StructPayloadValue(_messages.Message):
    """The log entry payload, represented as a structure that is expressed as
    a JSON object.

    Messages:
      AdditionalProperty: An additional property for a StructPayloadValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a StructPayloadValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  httpRequest = _messages.MessageField('HttpRequest', 1)
  insertId = _messages.StringField(2)
  log = _messages.StringField(3)
  metadata = _messages.MessageField('LogEntryMetadata', 4)
  operation = _messages.MessageField('LogEntryOperation', 5)
  protoPayload = _messages.MessageField('ProtoPayloadValue', 6)
  structPayload = _messages.MessageField('StructPayloadValue', 7)
  textPayload = _messages.StringField(8)
  writerEmailAddress = _messages.StringField(9)


class LogEntryMetadata(_messages.Message):
  """Additional data that is associated with a log entry, set by the service
  creating the log entry.

  Enums:
    SeverityValueValuesEnum: The severity of the log entry.

  Messages:
    LabelsValue: A set of (key, value) data that provides additional
      information about the log entry. If the log entry is from one of the
      Google Cloud Platform sources listed below, the indicated (key, value)
      information must be provided:  Google App Engine, service_name
      `appengine.googleapis.com`:        "appengine.googleapis.com/module_id",
      <module ID>       "appengine.googleapis.com/version_id", <version ID>
      and one of:       "appengine.googleapis.com/replica_index", <instance
      index>       "appengine.googleapis.com/clone_id", <instance ID>      or
      else provide the following Compute Engine labels:  Google Compute
      Engine, service_name `compute.googleapis.com`:
      "compute.googleapis.com/resource_type", "instance"
      "compute.googleapis.com/resource_id", <instance ID>

  Fields:
    labels: A set of (key, value) data that provides additional information
      about the log entry. If the log entry is from one of the Google Cloud
      Platform sources listed below, the indicated (key, value) information
      must be provided:  Google App Engine, service_name
      `appengine.googleapis.com`:        "appengine.googleapis.com/module_id",
      <module ID>       "appengine.googleapis.com/version_id", <version ID>
      and one of:       "appengine.googleapis.com/replica_index", <instance
      index>       "appengine.googleapis.com/clone_id", <instance ID>      or
      else provide the following Compute Engine labels:  Google Compute
      Engine, service_name `compute.googleapis.com`:
      "compute.googleapis.com/resource_type", "instance"
      "compute.googleapis.com/resource_id", <instance ID>
    projectId: The project ID of the Google Cloud Platform service that
      created the log entry.
    projectNumber: This field is populated by the API at ingestion time.
    region: The region name of the Google Cloud Platform service that created
      the log entry.  For example, `"us-central1"`.
    serviceName: The API name of the Google Cloud Platform service that
      created the log entry.  For example, `"compute.googleapis.com"`.
    severity: The severity of the log entry.
    timestamp: The time the event described by the log entry occurred.
      Timestamps must be later than January 1, 1970.
    userId: The fully-qualified email address of the authenticated user that
      performed or requested the action represented by the log entry. If the
      log entry does not apply to an action taken by an authenticated user,
      then the field should be empty.
    zone: The zone of the Google Cloud Platform service that created the log
      entry. For example, `"us-central1-a"`.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    """The severity of the log entry.

    Values:
      DEFAULT: The log entry has no assigned severity level.
      DEBUG: Debug or trace information.
      INFO: Routine information, such as ongoing status or performance.
      NOTICE: Normal but significant events, such as start up, shut down, or
        configuration.
      WARNING: Warning events might cause problems.
      ERROR: Error events are likely to cause problems.
      CRITICAL: Critical events cause more severe problems or brief outages.
      ALERT: A person must take an action immediately.
      EMERGENCY: One or more systems are unusable.
    """
    DEFAULT = 0
    DEBUG = 1
    INFO = 2
    NOTICE = 3
    WARNING = 4
    ERROR = 5
    CRITICAL = 6
    ALERT = 7
    EMERGENCY = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    """A set of (key, value) data that provides additional information about
    the log entry. If the log entry is from one of the Google Cloud Platform
    sources listed below, the indicated (key, value) information must be
    provided:  Google App Engine, service_name `appengine.googleapis.com`:
    "appengine.googleapis.com/module_id", <module ID>
    "appengine.googleapis.com/version_id", <version ID>           and one of:
    "appengine.googleapis.com/replica_index", <instance index>
    "appengine.googleapis.com/clone_id", <instance ID>      or else provide
    the following Compute Engine labels:  Google Compute Engine, service_name
    `compute.googleapis.com`:         "compute.googleapis.com/resource_type",
    "instance"        "compute.googleapis.com/resource_id", <instance ID>

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  labels = _messages.MessageField('LabelsValue', 1)
  projectId = _messages.StringField(2)
  projectNumber = _messages.IntegerField(3)
  region = _messages.StringField(4)
  serviceName = _messages.StringField(5)
  severity = _messages.EnumField('SeverityValueValuesEnum', 6)
  timestamp = _messages.StringField(7)
  userId = _messages.StringField(8)
  zone = _messages.StringField(9)


class LogEntryOperation(_messages.Message):
  """Additional information about a potentially long running operation with
  which a log entry is associated.

  Fields:
    first: True for the first entry associated with `id`.
    id: An opaque identifier. A producer of log entries should ensure that
      `id` is only reused for entries related to one operation.
    last: True for the last entry associated with `id`.
    producer: Ensures the operation can be uniquely identified. The
      combination of `id` and `producer` should be made globally unique by
      filling `producer` with a value that disambiguates the service that
      created `id`.
  """

  first = _messages.BooleanField(1)
  id = _messages.StringField(2)
  last = _messages.BooleanField(3)
  producer = _messages.StringField(4)


class LogError(_messages.Message):
  """Describes a problem with a logging resource or operation.

  Fields:
    resource: A resource name associated with this error. For example, the
      name of a Cloud Storage bucket that has insufficient permissions to be a
      destination for log entries.
    status: The error description, including a classification code, an error
      message, and other details.
    timeNanos: The time the error was observed, in nanoseconds since the Unix
      epoch.
  """

  resource = _messages.StringField(1)
  status = _messages.MessageField('Status', 2)
  timeNanos = _messages.IntegerField(3)


class LogLine(_messages.Message):
  """Application log line emitted while processing a request.

  Enums:
    SeverityValueValuesEnum: Severity of this log entry.

  Fields:
    logMessage: App-provided log message.
    severity: Severity of this log entry.
    sourceLocation: Where in the source code this log message was written.
    time: Approximate time when this log entry was made.
  """

  class SeverityValueValuesEnum(_messages.Enum):
    """Severity of this log entry.

    Values:
      DEFAULT: The log entry has no assigned severity level.
      DEBUG: Debug or trace information.
      INFO: Routine information, such as ongoing status or performance.
      NOTICE: Normal but significant events, such as start up, shut down, or
        configuration.
      WARNING: Warning events might cause problems.
      ERROR: Error events are likely to cause problems.
      CRITICAL: Critical events cause more severe problems or brief outages.
      ALERT: A person must take an action immediately.
      EMERGENCY: One or more systems are unusable.
    """
    DEFAULT = 0
    DEBUG = 1
    INFO = 2
    NOTICE = 3
    WARNING = 4
    ERROR = 5
    CRITICAL = 6
    ALERT = 7
    EMERGENCY = 8

  logMessage = _messages.StringField(1)
  severity = _messages.EnumField('SeverityValueValuesEnum', 2)
  sourceLocation = _messages.MessageField('SourceLocation', 3)
  time = _messages.StringField(4)


class LogMetric(_messages.Message):
  """Describes a logs-based metric. The value of the metric is the number of
  log entries in your project that match a logs filter.

  Fields:
    description: A description of this metric.
    filter: An [advanced logs filter](/logging/docs/view/advanced_filters).
      Example: `"log:syslog AND metadata.severity>=ERROR"`.
    name: The client-assigned name for this metric, such as `"severe_errors"`.
      Metric names are limited to 1000 characters and can include only the
      following characters: `A-Z`, `a-z`, `0-9`, and the special characters
      `_-.,+!*',()%/\`.  The slash character (`/`) denotes a hierarchy of name
      pieces, and it cannot be the first character of the name.
  """

  description = _messages.StringField(1)
  filter = _messages.StringField(2)
  name = _messages.StringField(3)


class LogService(_messages.Message):
  """_Output only._ Describes a service that writes log entries.

  Fields:
    indexKeys: A list of the names of the keys used to index and label
      individual log entries from this service.  The first two keys are used
      as the primary and secondary index, respectively. Additional keys may be
      used to label the entries.  For example, App Engine indexes its entries
      by module and by version, so its `indexKeys` field is the following:
      [ "appengine.googleapis.com/module_id",
      "appengine.googleapis.com/version_id" ]
    name: The service's name. Example: `"appengine.googleapis.com"`. Log names
      beginning with this string are reserved for this service. This value can
      appear in the `LogEntry.metadata.serviceName` field of log entries
      associated with this log service.
  """

  indexKeys = _messages.StringField(1, repeated=True)
  name = _messages.StringField(2)


class LogSink(_messages.Message):
  """Describes where log entries are written outside of Cloud Logging.

  Fields:
    destination: The resource name of the destination. Cloud Logging writes
      designated log entries to this destination. For example,
      `"storage.googleapis.com/my-output-bucket"`.
    errors: _Output only._ If any errors occur when invoking a sink method,
      then this field contains descriptions of the errors.
    filter: An advanced logs filter. If present, only log entries matching the
      filter are written.  Only project sinks use this field; log sinks and
      log service sinks must not include a filter.
    name: The client-assigned name of this sink. For example, `"my-syslog-
      sink"`.  The name must be unique among the sinks of a similar kind in
      the project.
  """

  destination = _messages.StringField(1)
  errors = _messages.MessageField('LogError', 2, repeated=True)
  filter = _messages.StringField(3)
  name = _messages.StringField(4)


class LoggingProjectsEntriesListRequest(_messages.Message):
  """A LoggingProjectsEntriesListRequest object.

  Fields:
    listLogEntriesRequest: A ListLogEntriesRequest resource to be passed as
      the request body.
    projectsId: Part of `projectName`. The resource name of the project from
      which to retrieve log entries.  The log service or log containing the
      entries is specified in the `filter` parameter.  Example:
      `projects/my_project_id`.
  """

  listLogEntriesRequest = _messages.MessageField('ListLogEntriesRequest', 1)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsLogEntriesListRequest(_messages.Message):
  """A LoggingProjectsLogEntriesListRequest object.

  Fields:
    filter: An [advanced logs filter](/logging/docs/view/advanced_filters).
      The response includes only entries that match the filter. If `filter` is
      empty, then all entries in all logs are retrieved.
    orderBy: Sort order of the results, consisting of a `LogEntry` field
      optionally followed by a space and `desc`.  Examples:
      `"metadata.timestamp"`, `"metadata.timestamp desc"`.  The only
      `LogEntry` field supported for sorting is `metadata.timestamp`. The
      default sort order is ascending (from older to newer entries) unless
      `desc` is appended.
    pageSize: The maximum number of entries to return per request.  Fewer
      entries may be returned, but that is not an indication that there are no
      more entries.
    pageToken: An opaque token, returned as `nextPageToken` by a prior
      `ListLogEntries` operation. If a page token is specified, other request
      parameters must match the parameters from the request that generated the
      page token.
    projectsId: Part of `projectName`. The resource name of the project from
      which to retrieve log entries.  The log service or log containing the
      entries is specified in the `filter` parameter.  Example:
      `projects/my_project_id`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.BytesField(4)
  projectsId = _messages.StringField(5, required=True)


class LoggingProjectsLogServicesIndexesListRequest(_messages.Message):
  """A LoggingProjectsLogServicesIndexesListRequest object.

  Fields:
    depth: A non-negative integer that limits the number of levels of the
      index hierarchy that are returned. If `depth` is 1 (default), only the
      first index key value is returned. If `depth` is 2, both primary and
      secondary key values are returned. If `depth` is 0, the depth is the
      number of slash-separators in the `indexPrefix` field, not counting a
      slash appearing as the last character of the prefix. If the
      `indexPrefix` field is empty, the default depth is 1. It is an error for
      `depth` to be any positive value less than the number of components in
      `indexPrefix`.
    indexPrefix: Restricts the index values returned to be those with a
      specified prefix for each index key. This field has the form
      `"/prefix1/prefix2/..."`, in order corresponding to the `LogService
      indexKeys`. Non-empty prefixes must begin with `/`. For example, App
      Engine's two keys are the module ID and the version ID. Following is the
      effect of using various values for `indexPrefix`:  +  `"/Mod/"`
      retrieves `/Mod/10` and `/Mod/11` but not `/ModA/10`. +  `"/Mod`
      retrieves `/Mod/10`, `/Mod/11` and `/ModA/10` but not `/XXX/33`. +
      `"/Mod/1"` retrieves `/Mod/10` and `/Mod/11` but not `/ModA/10`. +
      `"/Mod/10/"` retrieves `/Mod/10` only. +  An empty prefix or `"/"`
      retrieves all values.
    logServicesId: Part of `serviceName`. See documentation of `projectsId`.
    pageSize: The maximum number of log service index resources to return in
      one operation.
    pageToken: An opaque token, returned as `nextPageToken` by a prior
      `ListLogServiceIndexes` operation.  If `pageToken` is supplied, then the
      other fields of this request are ignored, and instead the previous
      `ListLogServiceIndexes` operation is continued.
    projectsId: Part of `serviceName`. The resource name of a log service
      whose service indexes are requested. Example: `"projects/my-project-
      id/logServices/appengine.googleapis.com"`.
  """

  depth = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  indexPrefix = _messages.StringField(2)
  logServicesId = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)
  projectsId = _messages.StringField(6, required=True)


class LoggingProjectsLogServicesListRequest(_messages.Message):
  """A LoggingProjectsLogServicesListRequest object.

  Fields:
    pageSize: The maximum number of `LogService` objects to return in one
      operation.
    pageToken: An opaque token, returned as `nextPageToken` by a prior
      `ListLogServices` operation.  If `pageToken` is supplied, then the other
      fields of this request are ignored, and instead the previous
      `ListLogServices` operation is continued.
    projectsId: Part of `projectName`. The resource name of the project whose
      services are to be listed.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectsId = _messages.StringField(3, required=True)


class LoggingProjectsLogServicesSinksCreateRequest(_messages.Message):
  """A LoggingProjectsLogServicesSinksCreateRequest object.

  Fields:
    logServicesId: Part of `serviceName`. See documentation of `projectsId`.
    logSink: A LogSink resource to be passed as the request body.
    projectsId: Part of `serviceName`. The resource name of the log service to
      which the sink is bound.
  """

  logServicesId = _messages.StringField(1, required=True)
  logSink = _messages.MessageField('LogSink', 2)
  projectsId = _messages.StringField(3, required=True)


class LoggingProjectsLogServicesSinksDeleteRequest(_messages.Message):
  """A LoggingProjectsLogServicesSinksDeleteRequest object.

  Fields:
    logServicesId: Part of `sinkName`. See documentation of `projectsId`.
    projectsId: Part of `sinkName`. The resource name of the log service sink
      to delete.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  logServicesId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)
  sinksId = _messages.StringField(3, required=True)


class LoggingProjectsLogServicesSinksGetRequest(_messages.Message):
  """A LoggingProjectsLogServicesSinksGetRequest object.

  Fields:
    logServicesId: Part of `sinkName`. See documentation of `projectsId`.
    projectsId: Part of `sinkName`. The resource name of the log service sink
      to return.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  logServicesId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)
  sinksId = _messages.StringField(3, required=True)


class LoggingProjectsLogServicesSinksListRequest(_messages.Message):
  """A LoggingProjectsLogServicesSinksListRequest object.

  Fields:
    logServicesId: Part of `serviceName`. See documentation of `projectsId`.
    projectsId: Part of `serviceName`. The log service whose sinks are wanted.
  """

  logServicesId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsLogServicesSinksUpdateRequest(_messages.Message):
  """A LoggingProjectsLogServicesSinksUpdateRequest object.

  Fields:
    logServicesId: Part of `sinkName`. See documentation of `projectsId`.
    logSink: A LogSink resource to be passed as the request body.
    projectsId: Part of `sinkName`. The resource name of the log service sink
      to update.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  logServicesId = _messages.StringField(1, required=True)
  logSink = _messages.MessageField('LogSink', 2)
  projectsId = _messages.StringField(3, required=True)
  sinksId = _messages.StringField(4, required=True)


class LoggingProjectsLogsDeleteRequest(_messages.Message):
  """A LoggingProjectsLogsDeleteRequest object.

  Fields:
    logsId: Part of `logName`. See documentation of `projectsId`.
    projectsId: Part of `logName`. The resource name of the log to be deleted.
  """

  logsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsLogsEntriesWriteRequest(_messages.Message):
  """A LoggingProjectsLogsEntriesWriteRequest object.

  Fields:
    logsId: Part of `logName`. See documentation of `projectsId`.
    projectsId: Part of `logName`. The resource name of the log that will
      receive the log entries.
    writeLogEntriesRequest: A WriteLogEntriesRequest resource to be passed as
      the request body.
  """

  logsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)
  writeLogEntriesRequest = _messages.MessageField('WriteLogEntriesRequest', 3)


class LoggingProjectsLogsListRequest(_messages.Message):
  """A LoggingProjectsLogsListRequest object.

  Fields:
    pageSize: The maximum number of results to return.
    pageToken: An opaque token, returned as `nextPageToken` by a prior
      `ListLogs` operation.  If `pageToken` is supplied, then the other fields
      of this request are ignored, and instead the previous `ListLogs`
      operation is continued.
    projectsId: Part of `projectName`. The resource name of the project whose
      logs are requested. If both `serviceName` and `serviceIndexPrefix` are
      empty, then all logs with entries in this project are listed.
    serviceIndexPrefix: The purpose of this field is to restrict the listed
      logs to those with entries of a certain kind. If `serviceName` is the
      name of a log service, then this field may contain values for the log
      service's indexes. Only logs that have entries whose indexes include the
      values are listed. The format for this field is `"/val1/val2.../valN"`,
      where `val1` is a value for the first index, `val2` for the second
      index, etc. An empty value (a single slash) for an index matches all
      values, and you can omit values for later indexes entirely.
    serviceName: If not empty, this field must be a log service name such as
      `"compute.googleapis.com"`. Only logs associated with that that log
      service are listed.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectsId = _messages.StringField(3, required=True)
  serviceIndexPrefix = _messages.StringField(4)
  serviceName = _messages.StringField(5)


class LoggingProjectsLogsSinksCreateRequest(_messages.Message):
  """A LoggingProjectsLogsSinksCreateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    logsId: Part of `logName`. See documentation of `projectsId`.
    projectsId: Part of `logName`. The resource name of the log to which to
      the sink is bound.
  """

  logSink = _messages.MessageField('LogSink', 1)
  logsId = _messages.StringField(2, required=True)
  projectsId = _messages.StringField(3, required=True)


class LoggingProjectsLogsSinksDeleteRequest(_messages.Message):
  """A LoggingProjectsLogsSinksDeleteRequest object.

  Fields:
    logsId: Part of `sinkName`. See documentation of `projectsId`.
    projectsId: Part of `sinkName`. The resource name of the log sink to
      delete.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  logsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)
  sinksId = _messages.StringField(3, required=True)


class LoggingProjectsLogsSinksGetRequest(_messages.Message):
  """A LoggingProjectsLogsSinksGetRequest object.

  Fields:
    logsId: Part of `sinkName`. See documentation of `projectsId`.
    projectsId: Part of `sinkName`. The resource name of the log sink to
      return.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  logsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)
  sinksId = _messages.StringField(3, required=True)


class LoggingProjectsLogsSinksListRequest(_messages.Message):
  """A LoggingProjectsLogsSinksListRequest object.

  Fields:
    logsId: Part of `logName`. See documentation of `projectsId`.
    projectsId: Part of `logName`. The log whose sinks are wanted. For
      example, `"compute.google.com/syslog"`.
  """

  logsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsLogsSinksUpdateRequest(_messages.Message):
  """A LoggingProjectsLogsSinksUpdateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    logsId: Part of `sinkName`. See documentation of `projectsId`.
    projectsId: Part of `sinkName`. The resource name of the sink to update.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  logSink = _messages.MessageField('LogSink', 1)
  logsId = _messages.StringField(2, required=True)
  projectsId = _messages.StringField(3, required=True)
  sinksId = _messages.StringField(4, required=True)


class LoggingProjectsMetricsCreateRequest(_messages.Message):
  """A LoggingProjectsMetricsCreateRequest object.

  Fields:
    logMetric: A LogMetric resource to be passed as the request body.
    projectsId: Part of `projectName`. The resource name of the project in
      which to create the metric.
  """

  logMetric = _messages.MessageField('LogMetric', 1)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsMetricsDeleteRequest(_messages.Message):
  """A LoggingProjectsMetricsDeleteRequest object.

  Fields:
    metricsId: Part of `metricName`. See documentation of `projectsId`.
    projectsId: Part of `metricName`. The resource name of the metric to
      delete.
  """

  metricsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsMetricsGetRequest(_messages.Message):
  """A LoggingProjectsMetricsGetRequest object.

  Fields:
    metricsId: Part of `metricName`. See documentation of `projectsId`.
    projectsId: Part of `metricName`. The resource name of the desired metric.
  """

  metricsId = _messages.StringField(1, required=True)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsMetricsListRequest(_messages.Message):
  """A LoggingProjectsMetricsListRequest object.

  Fields:
    pageSize: The maximum number of `LogMetric` objects to return in one
      operation.
    pageToken: An opaque token, returned as `nextPageToken` by a prior
      `ListLogMetrics` operation.  If `pageToken` is supplied, then the other
      fields of this request are ignored, and instead the previous
      `ListLogMetrics` operation is continued.
    projectsId: Part of `projectName`. The resource name for the project whose
      metrics are wanted.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  projectsId = _messages.StringField(3, required=True)


class LoggingProjectsMetricsUpdateRequest(_messages.Message):
  """A LoggingProjectsMetricsUpdateRequest object.

  Fields:
    logMetric: A LogMetric resource to be passed as the request body.
    metricsId: Part of `metricName`. See documentation of `projectsId`.
    projectsId: Part of `metricName`. The resource name of the metric to
      update.
  """

  logMetric = _messages.MessageField('LogMetric', 1)
  metricsId = _messages.StringField(2, required=True)
  projectsId = _messages.StringField(3, required=True)


class LoggingProjectsSinksCreateRequest(_messages.Message):
  """A LoggingProjectsSinksCreateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    projectsId: Part of `projectName`. The resource name of the project to
      which the sink is bound.
  """

  logSink = _messages.MessageField('LogSink', 1)
  projectsId = _messages.StringField(2, required=True)


class LoggingProjectsSinksDeleteRequest(_messages.Message):
  """A LoggingProjectsSinksDeleteRequest object.

  Fields:
    projectsId: Part of `sinkName`. The resource name of the project sink to
      delete.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  projectsId = _messages.StringField(1, required=True)
  sinksId = _messages.StringField(2, required=True)


class LoggingProjectsSinksGetRequest(_messages.Message):
  """A LoggingProjectsSinksGetRequest object.

  Fields:
    projectsId: Part of `sinkName`. The resource name of the project sink to
      return.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  projectsId = _messages.StringField(1, required=True)
  sinksId = _messages.StringField(2, required=True)


class LoggingProjectsSinksListRequest(_messages.Message):
  """A LoggingProjectsSinksListRequest object.

  Fields:
    projectsId: Part of `projectName`. The project whose sinks are wanted.
  """

  projectsId = _messages.StringField(1, required=True)


class LoggingProjectsSinksUpdateRequest(_messages.Message):
  """A LoggingProjectsSinksUpdateRequest object.

  Fields:
    logSink: A LogSink resource to be passed as the request body.
    projectsId: Part of `sinkName`. The resource name of the project sink to
      update.
    sinksId: Part of `sinkName`. See documentation of `projectsId`.
  """

  logSink = _messages.MessageField('LogSink', 1)
  projectsId = _messages.StringField(2, required=True)
  sinksId = _messages.StringField(3, required=True)


class RequestLog(_messages.Message):
  """Complete log information about a single HTTP request to an App Engine
  application.

  Fields:
    appEngineRelease: App Engine release version.
    appId: Application that handled this request.
    cost: An indication of the relative cost of serving this request.
    endTime: Time when the request finished.
    finished: Whether this request is finished or active.
    host: Internet host and port number of the resource being requested.
    httpVersion: HTTP version of request. Example: `"HTTP/1.1"`.
    instanceId: An identifier for the instance that handled the request.
    instanceIndex: If the instance processing this request belongs to a
      manually scaled module, then this is the 0-based index of the instance.
      Otherwise, this value is -1.
    ip: Origin IP address.
    latency: Latency of the request.
    line: A list of log lines emitted by the application while serving this
      request.
    megaCycles: Number of CPU megacycles used to process request.
    method: Request method. Example: `"GET"`, `"HEAD"`, `"PUT"`, `"POST"`,
      `"DELETE"`.
    moduleId: Module of the application that handled this request.
    nickname: The logged-in user who made the request.  Most likely, this is
      the part of the user's email before the `@` sign.  The field value is
      the same for different requests from the same user, but different users
      can have similar names.  This information is also available to the
      application via the App Engine Users API.  This field will be populated
      starting with App Engine 1.9.21.
    pendingTime: Time this request spent in the pending request queue.
    referrer: Referrer URL of request.
    requestId: Globally unique identifier for a request, which is based on the
      request start time.  Request IDs for requests which started later will
      compare greater as strings than those for requests which started
      earlier.
    resource: Contains the path and query portion of the URL that was
      requested. For example, if the URL was
      "http://example.com/app?name=val", the resource would be
      "/app?name=val".  The fragment identifier, which is identified by the
      `#` character, is not included.
    responseSize: Size in bytes sent back to client by request.
    sourceReference: Source code for the application that handled this
      request. There can be more than one source reference per deployed
      application if source code is distributed among multiple repositories.
    startTime: Time when the request started.
    status: HTTP response status code. Example: 200, 404.
    taskName: Task name of the request, in the case of an offline request.
    taskQueueName: Queue name of the request, in the case of an offline
      request.
    traceId: Cloud Trace identifier for this request.
    urlMapEntry: File or class that handled the request.
    userAgent: User agent that made the request.
    versionId: Version of the application that handled this request.
    wasLoadingRequest: Whether this was a loading request for the instance.
  """

  appEngineRelease = _messages.StringField(1)
  appId = _messages.StringField(2)
  cost = _messages.FloatField(3)
  endTime = _messages.StringField(4)
  finished = _messages.BooleanField(5)
  host = _messages.StringField(6)
  httpVersion = _messages.StringField(7)
  instanceId = _messages.StringField(8)
  instanceIndex = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  ip = _messages.StringField(10)
  latency = _messages.StringField(11)
  line = _messages.MessageField('LogLine', 12, repeated=True)
  megaCycles = _messages.IntegerField(13)
  method = _messages.StringField(14)
  moduleId = _messages.StringField(15)
  nickname = _messages.StringField(16)
  pendingTime = _messages.StringField(17)
  referrer = _messages.StringField(18)
  requestId = _messages.StringField(19)
  resource = _messages.StringField(20)
  responseSize = _messages.IntegerField(21)
  sourceReference = _messages.MessageField('SourceReference', 22, repeated=True)
  startTime = _messages.StringField(23)
  status = _messages.IntegerField(24, variant=_messages.Variant.INT32)
  taskName = _messages.StringField(25)
  taskQueueName = _messages.StringField(26)
  traceId = _messages.StringField(27)
  urlMapEntry = _messages.StringField(28)
  userAgent = _messages.StringField(29)
  versionId = _messages.StringField(30)
  wasLoadingRequest = _messages.BooleanField(31)


class SourceLocation(_messages.Message):
  """Specifies a location in a source code file.

  Fields:
    file: Source file name. Depending on the runtime environment, this might
      be a simple name or a fully-qualified name.
    functionName: Human-readable name of the function or method being invoked,
      with optional context such as the class or package name. This
      information is used in contexts such as the logs viewer, where a file
      and line number are less meaningful. The format can vary by language.
      For example: `qual.if.ied.Class.method` (Java), `dir/package.func` (Go),
      `function` (Python).
    line: Line within the source file.
  """

  file = _messages.StringField(1)
  functionName = _messages.StringField(2)
  line = _messages.IntegerField(3)


class SourceReference(_messages.Message):
  """A reference to a particular snapshot of the source tree used to build and
  deploy an application.

  Fields:
    repository: Optional. A URI string identifying the repository. Example:
      "https://github.com/GoogleCloudPlatform/kubernetes.git"
    revisionId: The canonical and persistent identifier of the deployed
      revision. Example (git): "0035781c50ec7aa23385dc841529ce8a4b70db1b"
  """

  repository = _messages.StringField(1)
  revisionId = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


class Status(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @ype with
        type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class WriteLogEntriesRequest(_messages.Message):
  """The parameters to WriteLogEntries.

  Messages:
    CommonLabelsValue: Metadata labels that apply to all log entries in this
      request, so that you don't have to repeat them in each log entry's
      `metadata.labels` field.  If any of the log entries contains a (key,
      value) with the same key that is in `commonLabels`, then the entry's
      (key, value) overrides the one in `commonLabels`.

  Fields:
    commonLabels: Metadata labels that apply to all log entries in this
      request, so that you don't have to repeat them in each log entry's
      `metadata.labels` field.  If any of the log entries contains a (key,
      value) with the same key that is in `commonLabels`, then the entry's
      (key, value) overrides the one in `commonLabels`.
    entries: Log entries to insert.
    partialSuccess: Optional. Whether valid entries should be written even if
      some other entries fail due to INVALID_ARGUMENT or PERMISSION_DENIED
      errors. If any entry is not written, the response status will be the
      error associated with one of the failed entries and include error
      details in the form of WriteLogEntriesPartialErrors.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class CommonLabelsValue(_messages.Message):
    """Metadata labels that apply to all log entries in this request, so that
    you don't have to repeat them in each log entry's `metadata.labels` field.
    If any of the log entries contains a (key, value) with the same key that
    is in `commonLabels`, then the entry's (key, value) overrides the one in
    `commonLabels`.

    Messages:
      AdditionalProperty: An additional property for a CommonLabelsValue
        object.

    Fields:
      additionalProperties: Additional properties of type CommonLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a CommonLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  commonLabels = _messages.MessageField('CommonLabelsValue', 1)
  entries = _messages.MessageField('LogEntry', 2, repeated=True)
  partialSuccess = _messages.BooleanField(3)


class WriteLogEntriesResponse(_messages.Message):
  """Result returned from WriteLogEntries.
empty"""


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'logging')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'logging')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'logging')
