"""Generated message classes for autoscaler version v1beta2.

The Google Compute Engine Autoscaler API provides autoscaling for groups of
Cloud VMs.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from googlecloudsdk.third_party.apitools.base.protorpclite import messages as _messages


package = 'autoscaler'


class Autoscaler(_messages.Message):
  """Cloud Autoscaler resource.

  Fields:
    autoscalingPolicy: Configuration parameters for autoscaling algorithm.
    creationTimestamp: [Output Only] Creation timestamp in RFC3339 text
      format.
    description: An optional textual description of the resource provided by
      the client.
    id: [Output Only] Unique identifier for the resource; defined by the
      server.
    kind: Type of resource.
    name: Name of the Autoscaler resource. Must be unique per project and
      zone.
    selfLink: [Output Only] A self-link to the Autoscaler configuration
      resource.
    target: URL to the entity which will be autoscaled. Currently the only
      supported value is ReplicaPool?s URL. Note: it is illegal to specify
      multiple Autoscalers for the same target.
  """

  autoscalingPolicy = _messages.MessageField('AutoscalingPolicy', 1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'compute#autoscaler')
  name = _messages.StringField(6)
  selfLink = _messages.StringField(7)
  target = _messages.StringField(8)


class AutoscalerAutoscalersDeleteRequest(_messages.Message):
  """A AutoscalerAutoscalersDeleteRequest object.

  Fields:
    autoscaler: Name of the Autoscaler resource.
    project: Project ID of Autoscaler resource.
    zone: Zone name of Autoscaler resource.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class AutoscalerAutoscalersGetRequest(_messages.Message):
  """A AutoscalerAutoscalersGetRequest object.

  Fields:
    autoscaler: Name of the Autoscaler resource.
    project: Project ID of Autoscaler resource.
    zone: Zone name of Autoscaler resource.
  """

  autoscaler = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class AutoscalerAutoscalersInsertRequest(_messages.Message):
  """A AutoscalerAutoscalersInsertRequest object.

  Fields:
    autoscaler: A Autoscaler resource to be passed as the request body.
    project: Project ID of Autoscaler resource.
    zone: Zone name of Autoscaler resource.
  """

  autoscaler = _messages.MessageField('Autoscaler', 1)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class AutoscalerAutoscalersListRequest(_messages.Message):
  """A AutoscalerAutoscalersListRequest object.

  Fields:
    filter: A string attribute.
    maxResults: A integer attribute.
    pageToken: A string attribute.
    project: Project ID of Autoscaler resource.
    zone: Zone name of Autoscaler resource.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class AutoscalerAutoscalersPatchRequest(_messages.Message):
  """A AutoscalerAutoscalersPatchRequest object.

  Fields:
    autoscaler: Name of the Autoscaler resource.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID of Autoscaler resource.
    zone: Zone name of Autoscaler resource.
  """

  autoscaler = _messages.StringField(1, required=True)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class AutoscalerAutoscalersUpdateRequest(_messages.Message):
  """A AutoscalerAutoscalersUpdateRequest object.

  Fields:
    autoscaler: Name of the Autoscaler resource.
    autoscalerResource: A Autoscaler resource to be passed as the request
      body.
    project: Project ID of Autoscaler resource.
    zone: Zone name of Autoscaler resource.
  """

  autoscaler = _messages.StringField(1, required=True)
  autoscalerResource = _messages.MessageField('Autoscaler', 2)
  project = _messages.StringField(3, required=True)
  zone = _messages.StringField(4, required=True)


class AutoscalerListResponse(_messages.Message):
  """A AutoscalerListResponse object.

  Fields:
    items: Autoscaler resources.
    kind: Type of resource.
    nextPageToken: [Output only] A token used to continue a truncated list
      request.
  """

  items = _messages.MessageField('Autoscaler', 1, repeated=True)
  kind = _messages.StringField(2, default=u'compute#autoscalerList')
  nextPageToken = _messages.StringField(3)


class AutoscalerZoneOperationsDeleteRequest(_messages.Message):
  """A AutoscalerZoneOperationsDeleteRequest object.

  Fields:
    operation: A string attribute.
    project: A string attribute.
    zone: A string attribute.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class AutoscalerZoneOperationsDeleteResponse(_messages.Message):
  """An empty AutoscalerZoneOperationsDelete response."""


class AutoscalerZoneOperationsGetRequest(_messages.Message):
  """A AutoscalerZoneOperationsGetRequest object.

  Fields:
    operation: A string attribute.
    project: A string attribute.
    zone: A string attribute.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  zone = _messages.StringField(3, required=True)


class AutoscalerZoneOperationsListRequest(_messages.Message):
  """A AutoscalerZoneOperationsListRequest object.

  Fields:
    filter: A string attribute.
    maxResults: A integer attribute.
    pageToken: A string attribute.
    project: A string attribute.
    zone: A string attribute.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)
  zone = _messages.StringField(5, required=True)


class AutoscalerZonesListRequest(_messages.Message):
  """A AutoscalerZonesListRequest object.

  Fields:
    filter: A string attribute.
    maxResults: A integer attribute.
    pageToken: A string attribute.
    project: A string attribute.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32, default=500)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class AutoscalingPolicy(_messages.Message):
  """Cloud Autoscaler policy.

  Fields:
    coolDownPeriodSec: The number of seconds that the Autoscaler should wait
      between two succeeding changes to the number of virtual machines. You
      should define an interval that is at least as long as the initialization
      time of a virtual machine and the time it may take for replica pool to
      create the virtual machine. The default is 60 seconds.
    cpuUtilization: Configuration parameters of CPU based autoscaling policy.
    customMetricUtilizations: Configuration parameters of autoscaling based on
      custom metric.
    loadBalancingUtilization: Configuration parameters of autoscaling based on
      load balancer.
    maxNumReplicas: The maximum number of replicas that the Autoscaler can
      scale up to.
    minNumReplicas: The minimum number of replicas that the Autoscaler can
      scale down to.
  """

  coolDownPeriodSec = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  cpuUtilization = _messages.MessageField('AutoscalingPolicyCpuUtilization', 2)
  customMetricUtilizations = _messages.MessageField('AutoscalingPolicyCustomMetricUtilization', 3, repeated=True)
  loadBalancingUtilization = _messages.MessageField('AutoscalingPolicyLoadBalancingUtilization', 4)
  maxNumReplicas = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  minNumReplicas = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class AutoscalingPolicyCpuUtilization(_messages.Message):
  """CPU utilization policy.

  Fields:
    utilizationTarget: The target utilization that the Autoscaler should
      maintain. It is represented as a fraction of used cores. For example: 6
      cores used in 8-core VM are represented here as 0.75. Must be a float
      value between (0, 1]. If not defined, the default is 0.8.
  """

  utilizationTarget = _messages.FloatField(1)


class AutoscalingPolicyCustomMetricUtilization(_messages.Message):
  """Custom utilization metric policy.

  Fields:
    metric: Identifier of the metric. It should be a Cloud Monitoring metric.
      The metric can not have negative values. The metric should be an
      utilization metric (increasing number of VMs handling requests x times
      should reduce average value of the metric roughly x times). For example
      you could use:
      compute.googleapis.com/instance/network/received_bytes_count.
    utilizationTarget: Target value of the metric which Autoscaler should
      maintain. Must be a positive value.
    utilizationTargetType: Defines type in which utilization_target is
      expressed.
  """

  metric = _messages.StringField(1)
  utilizationTarget = _messages.FloatField(2)
  utilizationTargetType = _messages.StringField(3)


class AutoscalingPolicyLoadBalancingUtilization(_messages.Message):
  """Load balancing utilization policy.

  Fields:
    utilizationTarget: Fraction of backend capacity utilization (set in HTTP
      load balancing configuration) that Autoscaler should maintain. Must be a
      positive float value. If not defined, the default is 0.8. For example if
      your maxRatePerInstance capacity (in HTTP Load Balancing configuration)
      is set at 10 and you would like to keep number of instances such that
      each instance receives 7 QPS on average, set this to 0.7.
  """

  utilizationTarget = _messages.FloatField(1)


class DeprecationStatus(_messages.Message):
  """A DeprecationStatus object.

  Fields:
    deleted: A string attribute.
    deprecated: A string attribute.
    obsolete: A string attribute.
    replacement: A string attribute.
    state: A string attribute.
  """

  deleted = _messages.StringField(1)
  deprecated = _messages.StringField(2)
  obsolete = _messages.StringField(3)
  replacement = _messages.StringField(4)
  state = _messages.StringField(5)


class Operation(_messages.Message):
  """A Operation object.

  Messages:
    ErrorValue: A ErrorValue object.
    WarningsValueListEntry: A WarningsValueListEntry object.

  Fields:
    clientOperationId: A string attribute.
    creationTimestamp: A string attribute.
    description: A string attribute.
    endTime: A string attribute.
    error: A ErrorValue attribute.
    httpErrorMessage: A string attribute.
    httpErrorStatusCode: A integer attribute.
    id: A string attribute.
    insertTime: A string attribute.
    kind: [Output Only] Type of the resource. Always compute#operation for
      Operation resources.
    name: A string attribute.
    operationType: A string attribute.
    progress: A integer attribute.
    region: A string attribute.
    selfLink: A string attribute.
    startTime: A string attribute.
    status: A string attribute.
    statusMessage: A string attribute.
    targetId: A string attribute.
    targetLink: A string attribute.
    user: A string attribute.
    warnings: A WarningsValueListEntry attribute.
    zone: A string attribute.
  """

  class ErrorValue(_messages.Message):
    """A ErrorValue object.

    Messages:
      ErrorsValueListEntry: A ErrorsValueListEntry object.

    Fields:
      errors: A ErrorsValueListEntry attribute.
    """

    class ErrorsValueListEntry(_messages.Message):
      """A ErrorsValueListEntry object.

      Fields:
        code: A string attribute.
        location: A string attribute.
        message: A string attribute.
      """

      code = _messages.StringField(1)
      location = _messages.StringField(2)
      message = _messages.StringField(3)

    errors = _messages.MessageField('ErrorsValueListEntry', 1, repeated=True)

  class WarningsValueListEntry(_messages.Message):
    """A WarningsValueListEntry object.

    Messages:
      DataValueListEntry: A DataValueListEntry object.

    Fields:
      code: A string attribute.
      data: A DataValueListEntry attribute.
      message: A string attribute.
    """

    class DataValueListEntry(_messages.Message):
      """A DataValueListEntry object.

      Fields:
        key: A string attribute.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    code = _messages.StringField(1)
    data = _messages.MessageField('DataValueListEntry', 2, repeated=True)
    message = _messages.StringField(3)

  clientOperationId = _messages.StringField(1)
  creationTimestamp = _messages.StringField(2)
  description = _messages.StringField(3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('ErrorValue', 5)
  httpErrorMessage = _messages.StringField(6)
  httpErrorStatusCode = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  id = _messages.IntegerField(8, variant=_messages.Variant.UINT64)
  insertTime = _messages.StringField(9)
  kind = _messages.StringField(10, default=u'autoscaler#operation')
  name = _messages.StringField(11)
  operationType = _messages.StringField(12)
  progress = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  region = _messages.StringField(14)
  selfLink = _messages.StringField(15)
  startTime = _messages.StringField(16)
  status = _messages.StringField(17)
  statusMessage = _messages.StringField(18)
  targetId = _messages.IntegerField(19, variant=_messages.Variant.UINT64)
  targetLink = _messages.StringField(20)
  user = _messages.StringField(21)
  warnings = _messages.MessageField('WarningsValueListEntry', 22, repeated=True)
  zone = _messages.StringField(23)


class OperationList(_messages.Message):
  """A OperationList object.

  Fields:
    id: A string attribute.
    items: A Operation attribute.
    kind: [Output Only] Type of resource. Always compute#operations for
      Operations resource.
    nextPageToken: A string attribute.
    selfLink: A string attribute.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Operation', 2, repeated=True)
  kind = _messages.StringField(3, default=u'autoscaler#operationList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    AltValueValuesEnum: Data format for the response.

  Fields:
    alt: Data format for the response.
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters. Overrides userIp if both are provided.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    userIp: IP address of the site where the request originates. Use this if
      you want to enforce per-user limits.
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for the response.

    Values:
      json: Responses with Content-Type of application/json
    """
    json = 0

  alt = _messages.EnumField('AltValueValuesEnum', 1, default=u'json')
  fields = _messages.StringField(2)
  key = _messages.StringField(3)
  oauth_token = _messages.StringField(4)
  prettyPrint = _messages.BooleanField(5, default=True)
  quotaUser = _messages.StringField(6)
  trace = _messages.StringField(7)
  userIp = _messages.StringField(8)


class Zone(_messages.Message):
  """A Zone object.

  Messages:
    MaintenanceWindowsValueListEntry: A MaintenanceWindowsValueListEntry
      object.

  Fields:
    creationTimestamp: A string attribute.
    deprecated: A DeprecationStatus attribute.
    description: A string attribute.
    id: A string attribute.
    kind: [Output Only] Type of the resource. Always compute#zone for zones.
    maintenanceWindows: A MaintenanceWindowsValueListEntry attribute.
    name: A string attribute.
    region: A string attribute.
    selfLink: [Output Only] Server-defined URL for the resource.
    status: A string attribute.
  """

  class MaintenanceWindowsValueListEntry(_messages.Message):
    """A MaintenanceWindowsValueListEntry object.

    Fields:
      beginTime: A string attribute.
      description: A string attribute.
      endTime: A string attribute.
      name: A string attribute.
    """

    beginTime = _messages.StringField(1)
    description = _messages.StringField(2)
    endTime = _messages.StringField(3)
    name = _messages.StringField(4)

  creationTimestamp = _messages.StringField(1)
  deprecated = _messages.MessageField('DeprecationStatus', 2)
  description = _messages.StringField(3)
  id = _messages.IntegerField(4, variant=_messages.Variant.UINT64)
  kind = _messages.StringField(5, default=u'autoscaler#zone')
  maintenanceWindows = _messages.MessageField('MaintenanceWindowsValueListEntry', 6, repeated=True)
  name = _messages.StringField(7)
  region = _messages.StringField(8)
  selfLink = _messages.StringField(9)
  status = _messages.StringField(10)


class ZoneList(_messages.Message):
  """A ZoneList object.

  Fields:
    id: A string attribute.
    items: A Zone attribute.
    kind: Type of resource.
    nextPageToken: A string attribute.
    selfLink: [Output Only] Server-defined URL for this resource.
  """

  id = _messages.StringField(1)
  items = _messages.MessageField('Zone', 2, repeated=True)
  kind = _messages.StringField(3, default=u'autoscaler#zoneList')
  nextPageToken = _messages.StringField(4)
  selfLink = _messages.StringField(5)


