/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.core.model.JDIVariable;

public abstract class JDIModificationVariable
extends JDIVariable {
    private static final ArrayList fgValidSignatures = new ArrayList(9);

    static {
        fgValidSignatures.add("B");
        fgValidSignatures.add("C");
        fgValidSignatures.add("D");
        fgValidSignatures.add("F");
        fgValidSignatures.add("I");
        fgValidSignatures.add("J");
        fgValidSignatures.add("S");
        fgValidSignatures.add("Z");
        fgValidSignatures.add("Ljava/lang/String;");
    }

    public JDIModificationVariable(JDIDebugTarget target) {
        super(target);
    }

    public boolean supportsValueModification() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Value generateVMValue(String expression) throws DebugException {
        String signature = null;
        Value cValue = this.getCurrentValue();
        VirtualMachine vm = this.getVM();
        if (vm == null) {
            this.requestFailed(JDIDebugModelMessages.JDIModificationVariable_Unable_to_generate_value___VM_disconnected__1, null);
        }
        if ((signature = cValue == null ? "Ljava/lang/String;" : cValue.type().signature()).length() > 1 && !signature.equals("Ljava/lang/String;")) {
            return null;
        }
        Value vmValue = null;
        try {
            switch (signature.charAt(0)) {
                case 'Z': {
                    String flse = Boolean.FALSE.toString();
                    String tre = Boolean.TRUE.toString();
                    if (!expression.equals(tre)) {
                        if (!expression.equals(flse)) return vmValue;
                    }
                    boolean booleanValue = Boolean.valueOf(expression);
                    return vm.mirrorOf(booleanValue);
                }
                case 'B': {
                    byte byteValue = Byte.valueOf(expression);
                    return vm.mirrorOf(byteValue);
                }
                case 'C': {
                    if (expression.length() == 1) {
                        char charValue = expression.charAt(0);
                        return vm.mirrorOf(charValue);
                    }
                    if (expression.length() != 2) return vmValue;
                    if (expression.charAt(0) != '\\') {
                        return null;
                    }
                    switch (expression.charAt(1)) {
                        case 'b': {
                            char charValue = '\b';
                            return vm.mirrorOf(charValue);
                        }
                        case 'f': {
                            char charValue = '\f';
                            return vm.mirrorOf(charValue);
                        }
                        case 'n': {
                            char charValue = '\n';
                            return vm.mirrorOf(charValue);
                        }
                        case 'r': {
                            char charValue = '\r';
                            return vm.mirrorOf(charValue);
                        }
                        case 't': {
                            char charValue = '\t';
                            return vm.mirrorOf(charValue);
                        }
                        case '\'': {
                            char charValue = '\'';
                            return vm.mirrorOf(charValue);
                        }
                        case '\"': {
                            char charValue = '\"';
                            return vm.mirrorOf(charValue);
                        }
                        case '\\': {
                            char charValue = '\\';
                            return vm.mirrorOf(charValue);
                        }
                        default: {
                            return null;
                        }
                    }
                }
                case 'S': {
                    short shortValue = Short.valueOf(expression);
                    return vm.mirrorOf(shortValue);
                }
                case 'I': {
                    int intValue = Integer.valueOf(expression);
                    return vm.mirrorOf(intValue);
                }
                case 'J': {
                    long longValue = Long.valueOf(expression);
                    return vm.mirrorOf(longValue);
                }
                case 'F': {
                    float floatValue = Float.valueOf(expression).floatValue();
                    return vm.mirrorOf(floatValue);
                }
                case 'D': {
                    double doubleValue = Double.valueOf(expression);
                    return vm.mirrorOf(doubleValue);
                }
                case 'L': {
                    if (expression.equals("null")) {
                        return null;
                    }
                    if (!expression.equals("\"null\"")) return vm.mirrorOf(expression);
                    return vm.mirrorOf("null");
                }
            }
            return vmValue;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public boolean verifyValue(String expression) {
        try {
            JDIValue value = JDIValue.createValue(this.getJavaDebugTarget(), this.generateVMValue(expression));
            return this.verifyValue(value);
        }
        catch (DebugException debugException) {
            return false;
        }
    }

    public boolean verifyValue(IValue value) {
        return value instanceof IJavaValue && value.getDebugTarget().equals(this.getDebugTarget());
    }

    public final void setValue(String expression) throws DebugException {
        Value value = this.generateVMValue(expression);
        this.setJDIValue(value);
    }

    protected abstract void setJDIValue(Value var1) throws DebugException;
}

