/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class BrowsersPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button alwaysExternal;
    private static final String WBROWSER_PAGE_ID = "org.eclipse.ui.browser.preferencePage";
    private Button whelpAsViewButton;
    private Button whelpAsInfopopButton;
    private Button dhelpAsTrayButton;
    private Button dhelpAsInfopopButton;
    private Button openInPlaceButton;
    private Button openInEditorButton;
    private Button showPotentialHitsButton;
    private Button showActualHitsButton;

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageBrowsers");
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComposite.setLayout((Layout)layout);
        Label description = new Label(mainComposite, 0);
        description.setText(Messages.select_browser);
        if (BrowserManager.getInstance().isEmbeddedBrowserPresent()) {
            this.alwaysExternal = new Button(mainComposite, 32);
            this.alwaysExternal.setLayoutData((Object)new GridData(512));
            this.alwaysExternal.setText(Messages.use_only_external_browser);
            this.alwaysExternal.setSelection(HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("always_external_browser"));
        }
        this.createLinkArea(mainComposite);
        this.createSpacer(mainComposite);
        this.createDynamicHelpArea(mainComposite);
        this.createSpacer(mainComposite);
        this.createSearchArea(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
        return mainComposite;
    }

    private void createLinkArea(Composite parent) {
        IPreferenceNode node = this.getPreferenceNode(WBROWSER_PAGE_ID);
        if (node != null) {
            PreferenceLinkArea linkArea = new PreferenceLinkArea(parent, 64, WBROWSER_PAGE_ID, Messages.BrowsersPreferencePage_message, (IWorkbenchPreferenceContainer)this.getContainer(), null);
            GridData data = new GridData(768);
            linkArea.getControl().setLayoutData((Object)data);
        }
    }

    private void createDynamicHelpArea(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.BrowsersPreferencePage_wgroup);
        this.whelpAsViewButton = new Button((Composite)group, 16);
        this.whelpAsViewButton.setText(Messages.BrowsersPreferencePage_view);
        this.whelpAsInfopopButton = new Button((Composite)group, 16);
        this.whelpAsInfopopButton.setText(Messages.BrowsersPreferencePage_winfopop);
        boolean winfopop = HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("window_infopop");
        this.whelpAsViewButton.setSelection(!winfopop);
        this.whelpAsInfopopButton.setSelection(winfopop);
        this.createSpacer(parent);
        layout = new GridLayout();
        layout.numColumns = 2;
        group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)layout);
        group.setText(Messages.BrowsersPreferencePage_dgroup);
        this.dhelpAsTrayButton = new Button((Composite)group, 16);
        this.dhelpAsTrayButton.setText(Messages.BrowsersPreferencePage_tray);
        this.dhelpAsInfopopButton = new Button((Composite)group, 16);
        this.dhelpAsInfopopButton.setText(Messages.BrowsersPreferencePage_dinfopop);
        boolean dinfopop = HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("dialog_infopop");
        this.dhelpAsTrayButton.setSelection(!dinfopop);
        this.dhelpAsInfopopButton.setSelection(dinfopop);
        if (PlatformUI.getWorkbench().getBrowserSupport().isInternalWebBrowserAvailable()) {
            this.createSpacer(parent);
            layout = new GridLayout();
            layout.numColumns = 2;
            group = new Group(parent, 0);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)layout);
            group.setText(Messages.BrowsersPreferencePage_openModeGroup);
            this.openInPlaceButton = new Button((Composite)group, 16);
            this.openInPlaceButton.setText(Messages.BrowsersPreferencePage_openInPlace);
            this.openInEditorButton = new Button((Composite)group, 16);
            this.openInEditorButton.setText(Messages.BrowsersPreferencePage_openInEditor);
            boolean openInBrowser = HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("open_in_browser");
            this.openInPlaceButton.setSelection(!openInBrowser);
            this.openInEditorButton.setSelection(openInBrowser);
        }
    }

    private void createSearchArea(Composite parent) {
        Group searchGroup = new Group(parent, 0);
        searchGroup.setText(Messages.BrowsersPreferencePage_search);
        searchGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        searchGroup.setLayout((Layout)new GridLayout());
        this.showPotentialHitsButton = new Button((Composite)searchGroup, 16);
        this.showPotentialHitsButton.setText(Messages.BrowsersPreferencePage_searchPotentialHits);
        this.showActualHitsButton = new Button((Composite)searchGroup, 16);
        this.showActualHitsButton.setText(Messages.BrowsersPreferencePage_searchActualHits);
        boolean showPotentialHits = HelpBasePlugin.getDefault().getPluginPreferences().getBoolean("show_potential_hits");
        this.showPotentialHitsButton.setSelection(showPotentialHits);
        this.showActualHitsButton.setSelection(!showPotentialHits);
    }

    private IPreferenceNode getPreferenceNode(String pageId) {
        for (IPreferenceNode next : PlatformUI.getWorkbench().getPreferenceManager().getElements(0)) {
            if (!next.getId().equals(pageId)) continue;
            return next;
        }
        return null;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        boolean winfopop;
        if (this.alwaysExternal != null) {
            this.alwaysExternal.setSelection(HelpBasePlugin.getDefault().getPluginPreferences().getDefaultBoolean("always_external_browser"));
        }
        this.whelpAsViewButton.setSelection(!(winfopop = HelpBasePlugin.getDefault().getPluginPreferences().getDefaultBoolean("window_infopop")));
        this.whelpAsInfopopButton.setSelection(winfopop);
        boolean dinfopop = HelpBasePlugin.getDefault().getPluginPreferences().getDefaultBoolean("dialog_infopop");
        this.dhelpAsTrayButton.setSelection(!dinfopop);
        this.dhelpAsInfopopButton.setSelection(dinfopop);
        if (this.openInPlaceButton != null) {
            boolean openInEditor = HelpBasePlugin.getDefault().getPluginPreferences().getDefaultBoolean("open_in_browser");
            this.openInPlaceButton.setSelection(!openInEditor);
            this.openInEditorButton.setSelection(openInEditor);
        }
        boolean showPotentialHits = HelpBasePlugin.getDefault().getPluginPreferences().getDefaultBoolean("show_potential_hits");
        this.showPotentialHitsButton.setSelection(showPotentialHits);
        this.showActualHitsButton.setSelection(!showPotentialHits);
        super.performDefaults();
    }

    public boolean performOk() {
        Preferences pref = HelpBasePlugin.getDefault().getPluginPreferences();
        if (this.alwaysExternal != null) {
            pref.setValue("always_external_browser", this.alwaysExternal.getSelection());
            BrowserManager.getInstance().setAlwaysUseExternal(this.alwaysExternal.getSelection());
        }
        pref.setValue("window_infopop", this.whelpAsInfopopButton.getSelection());
        pref.setValue("dialog_infopop", this.dhelpAsInfopopButton.getSelection());
        if (this.openInEditorButton != null) {
            pref.setValue("open_in_browser", this.openInEditorButton.getSelection());
        }
        pref.setValue("show_potential_hits", this.showPotentialHitsButton.getSelection());
        HelpBasePlugin.getDefault().savePluginPreferences();
        return true;
    }

    private void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }
}

