/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;

class DefaultErrorHandler
implements ErrorHandler {
    private ErrorDispatcher err;

    DefaultErrorHandler(ErrorDispatcher err) {
        this.err = err;
    }

    public void jspError(String fname, int line, int column, String errMsg, Exception ex) throws JasperException {
        throw new JasperException(fname + "(" + line + "," + column + ")" + " " + errMsg, (Throwable)ex);
    }

    public void jspError(String errMsg, Exception ex) throws JasperException {
        throw new JasperException(errMsg, (Throwable)ex);
    }

    public void javacError(JavacErrorDetail[] details) throws JasperException {
        Object[] args = null;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < details.length; ++i) {
            args = new Object[]{new Integer(details[i].getJspBeginLineNumber()), details[i].getJspFileName()};
            buf.append(this.err.getString("jsp.error.single.line.number", args));
            buf.append(this.err.getString("jsp.error.corresponding.servlet"));
            buf.append(details[i].getErrorMessage());
            buf.append('\n');
        }
        throw new JasperException(this.err.getString("jsp.error.unable.compile") + buf);
    }
}

