/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringContributionManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class RefactoringSessionReader
extends DefaultHandler {
    private String fComment = null;
    private final boolean fProjects;
    private List fRefactoringDescriptors = null;
    private String fVersion = null;

    public RefactoringSessionReader(boolean projects) {
        this.fProjects = projects;
    }

    private SAXParser createParser(SAXParserFactory factory) throws ParserConfigurationException, SAXException {
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        try {
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
        return parser;
    }

    /*
     * Loose catch block
     */
    public RefactoringSessionDescriptor readSession(InputSource source) throws CoreException {
        block10: {
            source.setSystemId("/");
            this.createParser(SAXParserFactory.newInstance()).parse(source, (DefaultHandler)this);
            if (this.fRefactoringDescriptors != null) {
                if (this.fVersion == null || "".equals(this.fVersion)) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10004, RefactoringCoreMessages.RefactoringSessionReader_missing_version_information, null));
                }
                if (!"1.0".equals(this.fVersion)) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10005, RefactoringCoreMessages.RefactoringSessionReader_unsupported_version_information, null));
                }
                RefactoringSessionDescriptor refactoringSessionDescriptor = new RefactoringSessionDescriptor(this.fRefactoringDescriptors.toArray(new RefactoringDescriptor[this.fRefactoringDescriptors.size()]), this.fVersion, this.fComment);
                return refactoringSessionDescriptor;
            }
            break block10;
            {
                catch (IOException exception) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10006, exception.getLocalizedMessage(), null));
                }
                catch (ParserConfigurationException exception) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10006, exception.getLocalizedMessage(), null));
                }
                catch (SAXException exception) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10006, exception.getLocalizedMessage(), null));
                }
            }
            finally {
                this.fRefactoringDescriptors = null;
                this.fVersion = null;
                this.fComment = null;
            }
        }
        return null;
    }

    public void startElement(String uri, String localName, String qualifiedName, Attributes attributes) throws SAXException {
        if ("refactoring".equals(qualifiedName)) {
            int length = attributes.getLength();
            HashMap<String, String> map = new HashMap<String, String>(length);
            String id = "";
            String stamp = "";
            String description = "";
            String comment = null;
            String flags = "0";
            String project = null;
            int index = 0;
            while (index < length) {
                String name = attributes.getQName(index);
                String value = attributes.getValue(index);
                if ("id".equals(name)) {
                    id = value;
                } else if ("stamp".equals(name)) {
                    stamp = value;
                } else if ("description".equals(name)) {
                    description = value;
                } else if ("flags".equals(name)) {
                    flags = value;
                } else if ("comment".equals(name)) {
                    if (!"".equals(value)) {
                        comment = value;
                    }
                } else if (this.fProjects && "project".equals(name)) {
                    project = value;
                } else if (!"".equals(name) && !"".equals(value)) {
                    map.put(name, value);
                }
                ++index;
            }
            int flag = 0;
            try {
                flag = Integer.parseInt(flags);
            }
            catch (NumberFormatException numberFormatException) {}
            RefactoringDescriptor descriptor = RefactoringContributionManager.getInstance().createDescriptor(id, project, description, comment, map, flag);
            if (descriptor != null) {
                try {
                    descriptor.setTimeStamp(Long.valueOf(stamp));
                }
                catch (NumberFormatException numberFormatException) {}
                if (this.fRefactoringDescriptors == null) {
                    this.fRefactoringDescriptors = new ArrayList();
                }
                this.fRefactoringDescriptors.add(descriptor);
            }
        } else if ("session".equals(qualifiedName)) {
            String version = attributes.getValue("version");
            if (version != null && !"".equals(version)) {
                this.fVersion = version;
            }
            this.fComment = attributes.getValue("comment");
        }
    }
}

