/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.views.memory.renderings.AbstractBaseTableRendering;
import org.eclipse.debug.internal.ui.views.memory.renderings.TableRenderingContentDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PrintTableRenderingAction
extends Action {
    private AbstractBaseTableRendering fRendering;
    private StructuredViewer fViewer;
    private static final String COLUMN_SEPERATOR = "  ";

    public PrintTableRenderingAction(AbstractBaseTableRendering rendering, StructuredViewer viewer) {
        super(DebugUIMessages.PrintViewTabAction_title);
        this.fRendering = rendering;
        this.fViewer = viewer;
        this.setToolTipText(DebugUIMessages.PrintViewTabAction_tooltip);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_PRINT_TOP_VIEW_TAB"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_PRINT_TOP_VIEW_TAB"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_PRINT_TOP_VIEW_TAB"));
    }

    protected void printTable(TableItem[] itemList, GC printGC, Printer printer) {
        int numColumns = ((Table)this.fViewer.getControl()).getColumnCount();
        ITableLabelProvider labelProvider = (ITableLabelProvider)this.fViewer.getLabelProvider();
        int lineNum = 1;
        int charsPerByte = this.fRendering.getNumCharsPerByte();
        if (charsPerByte < 0) {
            charsPerByte = 4;
        }
        lineNum = this.printColumnLabels(printGC, lineNum);
        int i = 0;
        while (i < itemList.length) {
            StringBuffer tableContents = new StringBuffer();
            int j = 0;
            while (j < numColumns) {
                String columnText = labelProvider.getColumnText(itemList[i].getData(), j);
                while (columnText.length() < this.fRendering.getBytesPerColumn() * charsPerByte) {
                    columnText = String.valueOf(columnText) + " ";
                }
                tableContents.append(COLUMN_SEPERATOR);
                tableContents.append(columnText);
                ++j;
            }
            printGC.drawString(tableContents.toString(), 10, 10 + lineNum * printGC.getFontMetrics().getHeight());
            if (20 + ++lineNum * printGC.getFontMetrics().getHeight() > printer.getClientArea().height) {
                lineNum = 1;
                printer.endPage();
                printer.startPage();
                lineNum = this.printColumnLabels(printGC, lineNum);
            }
            ++i;
        }
    }

    private int printColumnLabels(GC printGC, int lineNum) {
        StringBuffer tableContents = new StringBuffer();
        int numColumns = ((Table)this.fViewer.getControl()).getColumnCount();
        TableColumn[] columns = ((Table)this.fViewer.getControl()).getColumns();
        int charsPerByte = this.fRendering.getNumCharsPerByte();
        if (charsPerByte < 0) {
            charsPerByte = 4;
        }
        int addressSizeInBytes = 0;
        TableRenderingContentDescriptor descriptor = (TableRenderingContentDescriptor)this.fRendering.getAdapter(TableRenderingContentDescriptor.class);
        if (descriptor == null) {
            IMemoryBlock memBlock = this.fRendering.getMemoryBlock();
            if (memBlock instanceof IMemoryBlockExtension) {
                try {
                    addressSizeInBytes = ((IMemoryBlockExtension)memBlock).getAddressSize();
                }
                catch (DebugException debugException) {
                    addressSizeInBytes = 0;
                }
                if (addressSizeInBytes <= 0) {
                    addressSizeInBytes = 4;
                }
            } else {
                addressSizeInBytes = 4;
            }
        } else {
            addressSizeInBytes = descriptor.getAddressSize();
        }
        int k = 0;
        while (k < numColumns) {
            StringBuffer columnLabel = new StringBuffer(columns[k].getText());
            int numBytes = 0;
            numBytes = k > 0 ? this.fRendering.getBytesPerColumn() : addressSizeInBytes;
            while (columnLabel.length() < numBytes * charsPerByte) {
                columnLabel.append(" ");
            }
            tableContents.append(COLUMN_SEPERATOR);
            tableContents.append(columnLabel);
            ++k;
        }
        printGC.drawString(tableContents.toString(), 10, 10 + lineNum * printGC.getFontMetrics().getHeight());
        return ++lineNum;
    }

    public void run() {
        if (!(this.fViewer.getControl() instanceof Table)) {
            return;
        }
        PrintDialog printDialog = new PrintDialog(this.fViewer.getControl().getDisplay().getActiveShell());
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            this.setChecked(false);
            return;
        }
        Printer printer = new Printer(printerData);
        GC gc = new GC((Drawable)printer);
        TableItem[] tableItems = ((Table)this.fViewer.getControl()).getItems();
        printer.startJob(String.valueOf(DebugUIMessages.PrintViewTabAction_jobtitle) + this.fRendering.getLabel());
        printer.startPage();
        this.printTable(tableItems, gc, printer);
        printer.endPage();
        printer.endJob();
        gc.dispose();
        printer.dispose();
        this.setChecked(false);
    }
}

