/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.ui.extract;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.wst.rdb.data.internal.ui.DataUIPlugin;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class ExtractDataAction implements IViewActionDelegate {

    protected Table table = null;
    
    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        
        if (table==null)
            return;
        
        ExtractDataWizard wiz = new ExtractDataWizard(table);
        WizardDialog dialog = new WizardDialog(org.eclipse.swt.widgets.Display.getCurrent().getActiveShell(), wiz);
        dialog.create();
        dialog.open();

    }

    public void selectionChanged(IAction action, ISelection selection)
    {
        table = null;
        
        if (selection instanceof IStructuredSelection)
            if (  ((IStructuredSelection)selection).getFirstElement() instanceof Table )
                table = (Table) ((IStructuredSelection)selection).getFirstElement();
        
        if (action.isEnabled() && table!=null)
            action.setEnabled( DataUIPlugin.isGroupIDOK(table) );
    }

}
