/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.common.ui.properties.internal.provisional;

/**
 * Allows property sheet page contributors to remap the effective type of 
 * an input object. 
 * <p>Frequently used to return the model object when selecting a view 
 * object in a workbench part.
 * </p>
 * 
 * @author Anthony Hunter
 * @deprecated Use org.eclipse.ui.views.properties.tabbed
 */
public interface ITypeMapper {

	/**
	 * Remap the effective type of an input object. Unless the filter 
	 * determines that a different type is more appropriate, it should 
	 * return effectiveType as its result.
	 * @param object the input object.
	 * @param effectiveType the effective type of the input object.
	 * @return the effective type of the input object.
	 */
	public Class remapType(Object object, Class effectiveType);
}
