/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editparts;

import java.util.Iterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.xsd.ui.internal.adapters.XSDSimpleTypeDefinitionAdapter;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseTypeConnectingEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.CenteredConnectionAnchor;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ColumnEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.TypeReferenceConnection;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.ADTDirectEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.ADTSelectionFeedbackEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IStructureFigure;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IType;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures.HeadingFigure;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures.RoundedLineBorder;
import org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures.StructureFigure;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.wst.xsd.ui.internal.design.editparts.ReferenceConnection;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class XSDSimpleTypeEditPart
extends BaseTypeConnectingEditPart {
    StructureFigure figure;
    protected ADTDirectEditPolicy adtDirectEditPolicy = new ADTDirectEditPolicy();

    public XSDSimpleTypeDefinition getXSDSimpleTypeDefinition() {
        return (XSDSimpleTypeDefinition)((XSDSimpleTypeDefinitionAdapter)this.getModel()).getTarget();
    }

    protected IFigure createFigure() {
        this.figure = new StructureFigure();
        this.figure.setBorder((Border)new RoundedLineBorder(1, 10));
        ToolbarLayout toolbarLayout = new ToolbarLayout();
        toolbarLayout.setStretchMinorAxis(true);
        this.figure.setLayoutManager((LayoutManager)toolbarLayout);
        return this.figure;
    }

    protected void refreshVisuals() {
        XSDSimpleTypeDefinitionAdapter adapter = (XSDSimpleTypeDefinitionAdapter)this.getModel();
        String name = adapter.getDisplayName();
        HeadingFigure headingFigure = this.figure.getHeadingFigure();
        headingFigure.setIsReadOnly(adapter.isReadOnly());
        Label label = headingFigure.getLabel();
        label.setText(name);
        label.setIcon(XSDCommonUIUtils.getUpdatedImage((XSDConcreteComponent)adapter.getXSDTypeDefinition(), adapter.getImage(), adapter.isReadOnly()));
    }

    public IStructureFigure getStructureFigure() {
        return (IStructureFigure)this.getFigure();
    }

    public IFigure getContentPane() {
        return this.getStructureFigure().getContentPane();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ADTSelectionFeedbackEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.adtDirectEditPolicy);
    }

    public void addFeedback() {
        this.getStructureFigure().addSelectionFeedback();
        super.addFeedback();
    }

    public void removeFeedback() {
        this.getStructureFigure().removeSelectionFeedback();
        super.removeFeedback();
    }

    public ReferenceConnection createConnectionFigure(BaseEditPart child) {
        return null;
    }

    public TypeReferenceConnection createConnectionFigure() {
        AbstractGraphicalEditPart referenceTypePart;
        TypeReferenceConnection connectionFigure = null;
        XSDSimpleTypeDefinitionAdapter adapter = (XSDSimpleTypeDefinitionAdapter)this.getModel();
        IType superType = adapter.getSuperType();
        if (superType != null && (referenceTypePart = (AbstractGraphicalEditPart)this.getTargetEditPart(superType)) != null) {
            connectionFigure = new TypeReferenceConnection();
            connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor(this.getFigure(), 0, 1));
            connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor(referenceTypePart.getFigure(), 1, 0, 0));
            connectionFigure.setHighlight(false);
        }
        return connectionFigure;
    }

    private EditPart getTargetEditPart(IType type) {
        ColumnEditPart columnEditPart = null;
        XSDSimpleTypeEditPart editPart = this;
        while (editPart != null) {
            if (editPart instanceof ColumnEditPart) {
                columnEditPart = (ColumnEditPart)((Object)editPart);
                break;
            }
            editPart = editPart.getParent();
        }
        if (columnEditPart != null) {
            Iterator i = columnEditPart.getChildren().iterator();
            while (i.hasNext()) {
                EditPart child = (EditPart)i.next();
                if (child.getModel() != type) continue;
                return child;
            }
        }
        return null;
    }
}

