/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.OperationType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.internal.impl.MessageReferenceImpl;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.ui.internal.commands.AddBaseParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddBindingCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddFaultCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddInputCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddInputParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddMessageCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOperationCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOutputCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddOutputParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddPartCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddPortCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddPortTypeCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddServiceCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDElementDeclarationCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateWSDLElementHelper {
    public static final String PART_INFO_ELEMENT_DECLARATION = "ELEMENT_DECLARATION";
    public static final String PART_INFO_TYPE_DEFINITION = "TYPE_DEFINITION";
    public static String serviceName = null;
    public static String portName = null;
    public static String bindingName = null;
    public static String portTypeName = null;
    public static String operationName = null;
    public static String inputName = null;
    public static String outputName = null;
    public static String faultName = null;
    public static String messageName = null;
    public static String partName = null;
    public static String PART_TYPE_OR_DEFINITION = "TYPE_DEFINITION";
    public static boolean CREATE_DOWN_TO_PART = true;

    public static Service createService(Definition definition) {
        if (serviceName == null || serviceName.trim().equals("")) {
            serviceName = NameUtil.buildUniqueServiceName(definition);
        }
        portTypeName = serviceName;
        AddServiceCommand addService = new AddServiceCommand(definition, serviceName, false);
        addService.run();
        Service service = (Service)addService.getWSDLElement();
        CreateWSDLElementHelper.createPort(service);
        return service;
    }

    public static Port createPort(Service service) {
        if (portName == null || portName.trim().equals("")) {
            portName = NameUtil.buildUniquePortName(service, null);
        }
        AddPortCommand addPort = new AddPortCommand(service, portName);
        addPort.run();
        Port port = (Port)addPort.getWSDLElement();
        Binding binding = CreateWSDLElementHelper.createBinding(port.getEnclosingDefinition(), port);
        port.setBinding((javax.wsdl.Binding)binding);
        return port;
    }

    public static Binding createBinding(Definition definition, Port port) {
        bindingName = port.getName();
        if (bindingName == null || bindingName.trim().equals("")) {
            bindingName = NameUtil.buildUniqueBindingName(definition, null);
        }
        AddBindingCommand addBinding = new AddBindingCommand(definition, bindingName);
        addBinding.run();
        Binding binding = (Binding)addBinding.getWSDLElement();
        PortType portType = CreateWSDLElementHelper.createPortType(binding.getEnclosingDefinition());
        binding.setPortType((javax.wsdl.PortType)portType);
        return binding;
    }

    public static PortType createPortType(Definition definition) {
        if (portTypeName == null || portTypeName.trim().equals("")) {
            portTypeName = NameUtil.buildUniquePortTypeName(definition, "PortType");
        }
        AddPortTypeCommand addPortTypeCommand = new AddPortTypeCommand(definition, portTypeName);
        addPortTypeCommand.run();
        PortType portType = (PortType)addPortTypeCommand.getWSDLElement();
        if (CREATE_DOWN_TO_PART) {
            CreateWSDLElementHelper.createOperation(portType);
        }
        return portType;
    }

    public static Operation createOperation(PortType portType) {
        if (operationName == null || operationName.trim().equals("")) {
            operationName = NameUtil.buildUniqueOperationName(portType);
        }
        AddOperationCommand action = new AddOperationCommand(portType, operationName);
        action.run();
        Operation operation = (Operation)action.getWSDLElement();
        int style = AddBaseParameterCommand.PART_ELEMENT_SEQ_ELEMENT;
        if (PART_TYPE_OR_DEFINITION == PART_INFO_TYPE_DEFINITION) {
            style = AddBaseParameterCommand.PART_SIMPLETYPE;
        } else if (PART_TYPE_OR_DEFINITION == PART_INFO_ELEMENT_DECLARATION) {
            style = AddBaseParameterCommand.PART_ELEMENT_SEQ_ELEMENT;
        }
        AddInputParameterCommand inputCommand = new AddInputParameterCommand(operation, style);
        inputCommand.run();
        AddOutputParameterCommand outputCommand = new AddOutputParameterCommand(operation, style);
        outputCommand.run();
        operation.setStyle(OperationType.REQUEST_RESPONSE);
        return operation;
    }

    public static Input createInput(PortType portType, Operation operation, String inputName) {
        if (inputName == null || inputName.trim().equals("")) {
            inputName = NameUtil.buildUniqueInputName(portType, operation.getName(), "");
        }
        AddInputCommand action = new AddInputCommand(operation, inputName);
        action.run();
        Input input = (Input)action.getWSDLElement();
        Message mess = CreateWSDLElementHelper.createMessage((MessageReference)input);
        input.setMessage((javax.wsdl.Message)mess);
        return input;
    }

    public static Output createOutput(PortType portType, Operation operation) {
        if (outputName == null || outputName.trim().equals("")) {
            outputName = NameUtil.buildUniqueOutputName(portType, operation.getName(), "");
        }
        AddOutputCommand action = new AddOutputCommand(operation, outputName);
        action.run();
        Output output = (Output)action.getWSDLElement();
        Message mess = CreateWSDLElementHelper.createMessage((MessageReference)output);
        output.setMessage((javax.wsdl.Message)mess);
        return output;
    }

    public static Fault createFault(Operation operation) {
        if (faultName == null || faultName.trim().equals("")) {
            faultName = NameUtil.buildUniqueFaultName(operation);
        }
        AddFaultCommand action = new AddFaultCommand(operation, faultName);
        action.run();
        Fault fault = (Fault)action.getWSDLElement();
        Message mess = CreateWSDLElementHelper.createMessage((MessageReference)fault);
        fault.setMessage((javax.wsdl.Message)mess);
        return fault;
    }

    public static Message createMessage(MessageReference iof) {
        if (messageName == null || messageName.trim().equals("")) {
            messageName = NameUtil.buildUniqueMessageName(iof.getEnclosingDefinition(), iof);
        }
        Definition def = iof.getEnclosingDefinition();
        AddMessageCommand action = new AddMessageCommand(def, messageName);
        action.run();
        Message message = (Message)action.getWSDLElement();
        CreateWSDLElementHelper.createPart(message);
        Element parentNode = message.getElement();
        if (parentNode instanceof IDOMNode) {
            FormatProcessorXML formatProcessorXML = new FormatProcessorXML();
            formatProcessorXML.formatNode((Node)((IDOMNode)parentNode));
        }
        messageName = null;
        return message;
    }

    public static Part createPart(Message message) {
        Definition def = message.getEnclosingDefinition();
        String name = NameUtil.buildUniquePartName(message, message.getQName().getLocalPart());
        AddPartCommand action = null;
        if (PART_TYPE_OR_DEFINITION == PART_INFO_TYPE_DEFINITION) {
            action = new AddPartCommand(message, name, "http://www.w3.org/2001/XMLSchema", "string", true);
        } else if (PART_TYPE_OR_DEFINITION == PART_INFO_ELEMENT_DECLARATION) {
            String elementName = CreateWSDLElementHelper.getNewNameHelper(name, def, false);
            AddXSDElementDeclarationCommand elementAction = new AddXSDElementDeclarationCommand(def, elementName);
            elementAction.run();
            action = new AddPartCommand(message, name, def.getTargetNamespace(), elementName, false);
        }
        action.run();
        return (Part)action.getWSDLElement();
    }

    private static String getNewNameHelper(String base, Definition def, boolean isType) {
        Iterator xsdsIterator;
        XSDSchemaExtensibilityElement xsdElement;
        XSDSchema schema;
        EList xsdsList;
        String name = base;
        int count = 0;
        List elementList = null;
        if (def.getETypes() != null && (xsdsList = def.getETypes().getEExtensibilityElements()) != null && (schema = (xsdElement = (XSDSchemaExtensibilityElement)(xsdsIterator = xsdsList.iterator()).next()).getSchema()) != null) {
            elementList = schema.getElementDeclarations();
        }
        if (elementList != null) {
            int index = 0;
            while (index < elementList.size()) {
                XSDElementDeclaration elementDeclaration = (XSDElementDeclaration)elementList.get(index);
                if (name.equals(elementDeclaration.getName())) {
                    name = String.valueOf(name) + ++count;
                    index = 0;
                    continue;
                }
                ++index;
            }
        }
        return name;
    }

    public static String getPartInfo(WSDLElement element) {
        String partInfo = null;
        if (element instanceof PortType) {
            partInfo = CreateWSDLElementHelper.getPartInfo((PortType)element);
        } else if (element instanceof Operation) {
            partInfo = CreateWSDLElementHelper.getPartInfo(((WSDLElementImpl)element).getContainer());
        } else if (element instanceof MessageReferenceImpl) {
            partInfo = CreateWSDLElementHelper.getPartInfo(((WSDLElementImpl)element).getContainer());
        }
        if (partInfo == null) {
            partInfo = PART_INFO_TYPE_DEFINITION;
        }
        return partInfo;
    }

    private static String getPartInfo(PortType portType) {
        String partInfo = null;
        if (portType.getOperations() != null) {
            Iterator operationIt = portType.getOperations().iterator();
            while (operationIt.hasNext()) {
                Operation op = (Operation)operationIt.next();
                if (op.getEInput() != null) {
                    partInfo = CreateWSDLElementHelper.getMessageRefPartInfo((MessageReferenceImpl)op.getEInput());
                }
                if (partInfo == null && op.getEOutput() != null) {
                    partInfo = CreateWSDLElementHelper.getMessageRefPartInfo((MessageReferenceImpl)op.getEOutput());
                }
                if (op.getEFaults() != null) {
                    Iterator faultIt = op.getEFaults().iterator();
                    while (partInfo == null && faultIt.hasNext()) {
                        Fault fault = (Fault)faultIt.next();
                        partInfo = CreateWSDLElementHelper.getMessageRefPartInfo((MessageReferenceImpl)fault);
                    }
                }
                if (partInfo != null) break;
            }
        }
        return partInfo;
    }

    private static String getMessageRefPartInfo(MessageReferenceImpl iof) {
        String partInfo = null;
        if (iof.getEMessage() != null && iof.getEMessage().getEParts() != null) {
            Iterator partIt = iof.getEMessage().getEParts().iterator();
            while (partInfo == null && partIt.hasNext()) {
                Part part = (Part)partIt.next();
                if (part.getTypeDefinition() != null) {
                    partInfo = PART_INFO_TYPE_DEFINITION;
                    continue;
                }
                if (part.getElementDeclaration() == null) continue;
                partInfo = PART_INFO_ELEMENT_DECLARATION;
            }
        }
        return partInfo;
    }
}

