/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.rubypeople.rdt.core.Flags;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;

public class MemberFilter
extends ViewerFilter {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_FIELDS = 4;
    public static final int FILTER_LOCALTYPES = 8;
    private int fFilterProperties;

    public final void addFilter(int n) {
        this.fFilterProperties |= n;
    }

    public final void removeFilter(int n) {
        this.fFilterProperties &= 0xFFFFFFFF ^ n;
    }

    public final boolean hasFilter(int n) {
        return (this.fFilterProperties & n) != 0;
    }

    public boolean isFilterProperty(Object object, Object object2) {
        return false;
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        if (object2 instanceof IMember) {
            IMember iMember = (IMember)object2;
            int n = iMember.getElementType();
            if (this.hasFilter(4) && (n == 8 || n == 7 || n == 9 || n == 10)) {
                return false;
            }
            if (iMember.isType(4)) {
                IMethod iMethod = (IMethod)iMember;
                try {
                    if (this.hasFilter(1) && !Flags.isPublic((int)iMethod.getVisibility())) {
                        return false;
                    }
                }
                catch (RubyModelException rubyModelException) {
                    return true;
                }
                if (this.hasFilter(2) && iMethod.isSingleton()) {
                    return false;
                }
            }
            if (this.hasFilter(8) && n == 3 && this.isLocalType((IType)iMember)) {
                return false;
            }
            if (iMember.getElementName().startsWith("<")) {
                return false;
            }
        }
        return true;
    }

    private boolean isLocalType(IType iType) {
        IRubyElement iRubyElement = iType.getParent();
        return iRubyElement instanceof IMember && !(iRubyElement instanceof IType);
    }

    private boolean isTopLevelType(IMember iMember) {
        IType iType = iMember.getDeclaringType();
        return iType == null;
    }
}

