/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.rubyeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;
import org.rubypeople.rdt.core.IProblemRequestor;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.parser.IProblem;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyAnnotation;
import org.rubypeople.rdt.internal.ui.rubyeditor.ISavePolicy;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyMarkerAnnotation;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyScriptAnnotationModelEvent;
import org.rubypeople.rdt.internal.ui.text.ruby.IProblemRequestorExtension;
import org.rubypeople.rdt.ui.PreferenceConstants;

public class RubyDocumentProvider
extends TextFileDocumentProvider {
    private static final String HANDLE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    private boolean fIsAboutToSave = false;
    private ISavePolicy fSavePolicy;
    private IPropertyChangeListener fPropertyListener;
    private GlobalAnnotationModelListener fGlobalAnnotationModelListener;

    public RubyDocumentProvider() {
        TextFileDocumentProvider textFileDocumentProvider = new TextFileDocumentProvider();
        this.setParentDocumentProvider((IDocumentProvider)textFileDocumentProvider);
        this.fGlobalAnnotationModelListener = new GlobalAnnotationModelListener();
        this.fPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (RubyDocumentProvider.HANDLE_TEMPORARY_PROBLEMS.equals(propertyChangeEvent.getProperty())) {
                    RubyDocumentProvider.this.enableHandlingTemporaryProblems();
                }
            }
        };
        RubyPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
    }

    protected IAnnotationModel createAnnotationModel(IFile iFile) {
        return new RubyScriptAnnotationModel((IResource)iFile);
    }

    protected IRubyScript createRubyScript(IFile iFile) {
        IRubyScript iRubyScript = RubyCore.create((IFile)iFile);
        if (iRubyScript instanceof IRubyScript) {
            return iRubyScript;
        }
        return null;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new RubyScriptInfo();
    }

    protected void enableHandlingTemporaryProblems() {
        boolean bl = this.isHandlingTemporaryProblems();
        Iterator iterator = this.getFileInfosIterator();
        while (iterator.hasNext()) {
            TextFileDocumentProvider.FileInfo fileInfo = (TextFileDocumentProvider.FileInfo)iterator.next();
            if (!(fileInfo.fModel instanceof IProblemRequestorExtension)) continue;
            IProblemRequestorExtension iProblemRequestorExtension = (IProblemRequestorExtension)fileInfo.fModel;
            iProblemRequestorExtension.setIsHandlingTemporaryProblems(bl);
        }
    }

    public void addGlobalAnnotationModelListener(IAnnotationModelListener iAnnotationModelListener) {
        this.fGlobalAnnotationModelListener.addListener(iAnnotationModelListener);
    }

    public void removeGlobalAnnotationModelListener(IAnnotationModelListener iAnnotationModelListener) {
        this.fGlobalAnnotationModelListener.removeListener(iAnnotationModelListener);
    }

    protected TextFileDocumentProvider.FileInfo createFileInfo(Object object) throws CoreException {
        IProblemRequestorExtension iProblemRequestorExtension;
        IProblemRequestor iProblemRequestor;
        if (!(object instanceof IFileEditorInput)) {
            return null;
        }
        IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
        IRubyScript iRubyScript = this.createRubyScript(iFileEditorInput.getFile());
        if (iRubyScript == null) {
            return null;
        }
        TextFileDocumentProvider.FileInfo fileInfo = super.createFileInfo(object);
        if (!(fileInfo instanceof RubyScriptInfo)) {
            return null;
        }
        RubyScriptInfo rubyScriptInfo = (RubyScriptInfo)fileInfo;
        this.setUpSynchronization(rubyScriptInfo);
        IProblemRequestor iProblemRequestor2 = iProblemRequestor = rubyScriptInfo.fModel instanceof IProblemRequestor ? (IProblemRequestor)rubyScriptInfo.fModel : null;
        if (iProblemRequestor instanceof IProblemRequestorExtension) {
            iProblemRequestorExtension = (IProblemRequestorExtension)iProblemRequestor;
            iProblemRequestorExtension.setIsActive(false);
            iProblemRequestorExtension.setIsHandlingTemporaryProblems(this.isHandlingTemporaryProblems());
        }
        iRubyScript.becomeWorkingCopy(iProblemRequestor, this.getProgressMonitor());
        rubyScriptInfo.fCopy = iRubyScript;
        if (rubyScriptInfo.fModel instanceof RubyScriptAnnotationModel) {
            iProblemRequestorExtension = (RubyScriptAnnotationModel)rubyScriptInfo.fModel;
            ((RubyScriptAnnotationModel)iProblemRequestorExtension).setRubyScript(rubyScriptInfo.fCopy);
        }
        if (rubyScriptInfo.fModel != null) {
            rubyScriptInfo.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
        }
        return rubyScriptInfo;
    }

    protected boolean isHandlingTemporaryProblems() {
        IPreferenceStore iPreferenceStore = RubyPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getBoolean(HANDLE_TEMPORARY_PROBLEMS);
    }

    public void saveDocumentContent(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        if (!this.fIsAboutToSave) {
            return;
        }
        super.saveDocument(iProgressMonitor, object, iDocument, bl);
    }

    private void setUpSynchronization(RubyScriptInfo rubyScriptInfo) {
        IDocument iDocument = rubyScriptInfo.fTextFileBuffer.getDocument();
        IAnnotationModel iAnnotationModel = rubyScriptInfo.fModel;
        if (iDocument instanceof ISynchronizable && iAnnotationModel instanceof ISynchronizable) {
            Object object = ((ISynchronizable)iDocument).getLockObject();
            ((ISynchronizable)iAnnotationModel).setLockObject(object);
        }
    }

    protected void disposeFileInfo(Object object, TextFileDocumentProvider.FileInfo fileInfo) {
        if (fileInfo instanceof RubyScriptInfo) {
            RubyScriptInfo rubyScriptInfo = (RubyScriptInfo)fileInfo;
            try {
                rubyScriptInfo.fCopy.discardWorkingCopy();
            }
            catch (RubyModelException rubyModelException) {
                this.handleCoreException((CoreException)((Object)rubyModelException), rubyModelException.getMessage());
            }
            if (rubyScriptInfo.fModel != null) {
                rubyScriptInfo.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fGlobalAnnotationModelListener);
            }
        }
        super.disposeFileInfo(object, fileInfo);
    }

    protected TextFileDocumentProvider.DocumentProviderOperation createSaveOperation(final Object object, IDocument iDocument, final boolean bl) throws CoreException {
        final TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(object);
        if (fileInfo instanceof RubyScriptInfo) {
            return new TextFileDocumentProvider.DocumentProviderOperation(){

                protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                    RubyDocumentProvider.this.commitWorkingCopy(iProgressMonitor, object, (RubyScriptInfo)fileInfo, bl);
                }

                public ISchedulingRule getSchedulingRule() {
                    if (fileInfo.fElement instanceof IFileEditorInput) {
                        IFile iFile = ((IFileEditorInput)fileInfo.fElement).getFile();
                        return RubyDocumentProvider.this.computeSchedulingRule((IResource)iFile);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void commitWorkingCopy(IProgressMonitor iProgressMonitor, Object object, RubyScriptInfo rubyScriptInfo, boolean bl) throws CoreException {
        block27: {
            block26: {
                if (iProgressMonitor == null) {
                    iProgressMonitor = new NullProgressMonitor();
                }
                iProgressMonitor.beginTask("", 100);
                try {
                    IMarker[] iMarkerArray;
                    AbstractMarkerAnnotationModel abstractMarkerAnnotationModel;
                    IResource iResource;
                    IResource iResource2;
                    IRubyScript iRubyScript;
                    IProgressMonitor iProgressMonitor2 = this.getSubProgressMonitor(iProgressMonitor, 50);
                    try {
                        try {
                            iRubyScript = rubyScriptInfo.fCopy;
                            synchronized (iRubyScript) {
                                rubyScriptInfo.fCopy.reconcile(false, null, iProgressMonitor2);
                            }
                        }
                        catch (RubyModelException rubyModelException) {}
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        iProgressMonitor2.done();
                        throw throwable;
                    }
                    {
                        iResource2 = null;
                    }
                    iProgressMonitor2.done();
                    iRubyScript = rubyScriptInfo.fTextFileBuffer.getDocument();
                    iResource2 = rubyScriptInfo.fCopy.getResource();
                    Assert.isTrue((boolean)(iResource2 instanceof IFile));
                    if (!iResource2.exists()) {
                        iProgressMonitor2 = this.getSubProgressMonitor(iProgressMonitor, 50);
                        try {
                            this.createFileFromDocument(iProgressMonitor2, (IFile)iResource2, (IDocument)iRubyScript);
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            iProgressMonitor2.done();
                            throw throwable;
                        }
                        {
                            Object var8_9 = null;
                        }
                        iProgressMonitor2.done();
                        Object var13_18 = null;
                        break block26;
                    }
                    if (this.fSavePolicy != null) {
                        this.fSavePolicy.preSave(rubyScriptInfo.fCopy);
                    }
                    try {
                        try {
                            iProgressMonitor2 = this.getSubProgressMonitor(iProgressMonitor, 50);
                            this.fIsAboutToSave = true;
                            rubyScriptInfo.fCopy.commitWorkingCopy(bl, iProgressMonitor2);
                        }
                        catch (CoreException coreException) {
                            this.fireElementStateChangeFailed(object);
                            throw coreException;
                        }
                        catch (RuntimeException runtimeException) {
                            this.fireElementStateChangeFailed(object);
                            throw runtimeException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        this.fIsAboutToSave = false;
                        iProgressMonitor2.done();
                        throw throwable;
                    }
                    {
                        iResource = null;
                        this.fIsAboutToSave = false;
                    }
                    iProgressMonitor2.done();
                    if (rubyScriptInfo.fModel instanceof AbstractMarkerAnnotationModel) {
                        abstractMarkerAnnotationModel = (AbstractMarkerAnnotationModel)rubyScriptInfo.fModel;
                        abstractMarkerAnnotationModel.updateMarkers((IDocument)iRubyScript);
                    }
                    if (this.fSavePolicy != null && (abstractMarkerAnnotationModel = this.fSavePolicy.postSave(rubyScriptInfo.fCopy)) != null && rubyScriptInfo.fModel instanceof AbstractMarkerAnnotationModel && (iMarkerArray = (iResource = abstractMarkerAnnotationModel.getResource()).findMarkers("org.eclipse.core.resources.marker", true, 0)) != null && iMarkerArray.length > 0) {
                        AbstractMarkerAnnotationModel abstractMarkerAnnotationModel2 = (AbstractMarkerAnnotationModel)rubyScriptInfo.fModel;
                        int n = 0;
                        while (n < iMarkerArray.length) {
                            abstractMarkerAnnotationModel2.updateMarker((IDocument)iRubyScript, iMarkerArray[n], null);
                            ++n;
                        }
                    }
                    break block27;
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
            }
            iProgressMonitor.done();
            return;
        }
        Object var13_20 = null;
        iProgressMonitor.done();
    }

    private IProgressMonitor getSubProgressMonitor(IProgressMonitor iProgressMonitor, int n) {
        if (iProgressMonitor != null) {
            return new SubProgressMonitor(iProgressMonitor, n, 4);
        }
        return new NullProgressMonitor();
    }

    public IRubyScript getWorkingCopy(Object object) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(object);
        if (fileInfo instanceof RubyScriptInfo) {
            RubyScriptInfo rubyScriptInfo = (RubyScriptInfo)fileInfo;
            return rubyScriptInfo.fCopy;
        }
        return null;
    }

    public void shutdown() {
        Iterator iterator = this.getConnectedElementsIterator();
        while (iterator.hasNext()) {
            this.disconnect(iterator.next());
        }
    }

    protected static class RubyScriptInfo
    extends TextFileDocumentProvider.FileInfo {
        public IRubyScript fCopy;

        protected RubyScriptInfo() {
        }
    }

    protected static class GlobalAnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private ListenerList fListenerList = new ListenerList();

        public void modelChanged(IAnnotationModel iAnnotationModel) {
            Object[] objectArray = this.fListenerList.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                ((IAnnotationModelListener)objectArray[n]).modelChanged(iAnnotationModel);
                ++n;
            }
        }

        public void modelChanged(AnnotationModelEvent annotationModelEvent) {
            Object[] objectArray = this.fListenerList.getListeners();
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)object).modelChanged(annotationModelEvent);
                }
                ++n;
            }
        }

        public void addListener(IAnnotationModelListener iAnnotationModelListener) {
            this.fListenerList.add((Object)iAnnotationModelListener);
        }

        public void removeListener(IAnnotationModelListener iAnnotationModelListener) {
            this.fListenerList.remove((Object)iAnnotationModelListener);
        }
    }

    public static class ProblemAnnotation
    extends Annotation
    implements IRubyAnnotation,
    IAnnotationPresentation {
        public static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
        private static final int TASK_LAYER;
        private static final int INFO_LAYER;
        private static final int WARNING_LAYER;
        private static final int ERROR_LAYER;
        private static Image fgQuickFixImage;
        private static Image fgQuickFixErrorImage;
        private static boolean fgQuickFixImagesInitialized;
        private IRubyScript fRubyScript;
        private List fOverlaids;
        private IProblem fProblem;
        private Image fImage;
        private boolean fQuickFixImagesInitialized = false;
        private int fLayer = 0;

        static {
            AnnotationPreferenceLookup annotationPreferenceLookup = EditorsUI.getAnnotationPreferenceLookup();
            TASK_LAYER = ProblemAnnotation.computeLayer("org.eclipse.ui.workbench.texteditor.task", annotationPreferenceLookup);
            INFO_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.info", annotationPreferenceLookup);
            WARNING_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.warning", annotationPreferenceLookup);
            ERROR_LAYER = ProblemAnnotation.computeLayer("org.eclipse.jdt.ui.error", annotationPreferenceLookup);
            fgQuickFixImagesInitialized = false;
        }

        private static int computeLayer(String string, AnnotationPreferenceLookup annotationPreferenceLookup) {
            Annotation annotation = new Annotation(string, false, null);
            AnnotationPreference annotationPreference = annotationPreferenceLookup.getAnnotationPreference(annotation);
            if (annotationPreference != null) {
                return annotationPreference.getPresentationLayer() + 1;
            }
            return 1;
        }

        public ProblemAnnotation(IProblem iProblem, IRubyScript iRubyScript) {
            this.fProblem = iProblem;
            this.fRubyScript = iRubyScript;
            if (this.fProblem.isTask()) {
                this.setType("org.eclipse.ui.workbench.texteditor.task");
                this.fLayer = TASK_LAYER;
            } else if (this.fProblem.isWarning()) {
                this.setType("org.rubypeople.rdt.ui.warning");
                this.fLayer = WARNING_LAYER;
            } else if (this.fProblem.isError()) {
                this.setType("org.rubypeople.rdt.ui.error");
                this.fLayer = ERROR_LAYER;
            } else {
                this.setType("org.rubypeople.rdt.ui.info");
                this.fLayer = INFO_LAYER;
            }
        }

        public int getLayer() {
            return this.fLayer;
        }

        private void initializeImages() {
            if (!this.fQuickFixImagesInitialized) {
                if (this.isProblem() && this.indicateQuixFixableProblems()) {
                    if (!fgQuickFixImagesInitialized) {
                        fgQuickFixImage = RubyPluginImages.get("org.rubypeople.rdt.ui.warning_obj.gif");
                        fgQuickFixErrorImage = RubyPluginImages.get("org.rubypeople.rdt.ui.error_obj.gif");
                        fgQuickFixImage = RubyPluginImages.get("org.rubypeople.rdt.ui.quickfix_warning_obj.gif");
                        fgQuickFixImagesInitialized = true;
                    }
                    this.fImage = "org.rubypeople.rdt.ui.error".equals(this.getType()) ? fgQuickFixErrorImage : fgQuickFixImage;
                }
                this.fQuickFixImagesInitialized = true;
            }
        }

        private boolean indicateQuixFixableProblems() {
            return PreferenceConstants.getPreferenceStore().getBoolean("RubyEditor.ShowTemporaryProblem");
        }

        public void paint(GC gC, Canvas canvas, Rectangle rectangle) {
            this.initializeImages();
            if (this.fImage != null) {
                ImageUtilities.drawImage((Image)this.fImage, (GC)gC, (Canvas)canvas, (Rectangle)rectangle, (int)0x1000000, (int)128);
            }
        }

        public Image getImage(Display display) {
            this.initializeImages();
            return this.fImage;
        }

        public String getText() {
            return this.fProblem.getMessage();
        }

        public boolean isProblem() {
            String string = this.getType();
            return "org.rubypeople.rdt.ui.warning".equals(string) || "org.rubypeople.rdt.ui.error".equals(string) || SPELLING_ANNOTATION_TYPE.equals(string);
        }

        public boolean hasOverlay() {
            return false;
        }

        public IRubyAnnotation getOverlay() {
            return null;
        }

        public void addOverlaid(IRubyAnnotation iRubyAnnotation) {
            if (this.fOverlaids == null) {
                this.fOverlaids = new ArrayList(1);
            }
            this.fOverlaids.add(iRubyAnnotation);
        }

        public void removeOverlaid(IRubyAnnotation iRubyAnnotation) {
            if (this.fOverlaids != null) {
                this.fOverlaids.remove(iRubyAnnotation);
                if (this.fOverlaids.size() == 0) {
                    this.fOverlaids = null;
                }
            }
        }

        public Iterator getOverlaidIterator() {
            if (this.fOverlaids != null) {
                return this.fOverlaids.iterator();
            }
            return null;
        }

        public IRubyScript getRubyScript() {
            return this.fRubyScript;
        }
    }

    protected static class ReverseMap {
        private List fList = new ArrayList(2);
        private int fAnchor = 0;

        public Object get(Position position) {
            Entry entry;
            int n = this.fList.size();
            int n2 = this.fAnchor;
            while (n2 < n) {
                entry = (Entry)this.fList.get(n2);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = n2;
                    return entry.fValue;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.fAnchor) {
                entry = (Entry)this.fList.get(n2);
                if (entry.fPosition.equals((Object)position)) {
                    this.fAnchor = n2;
                    return entry.fValue;
                }
                ++n2;
            }
            return null;
        }

        private int getIndex(Position position) {
            int n = this.fList.size();
            int n2 = 0;
            while (n2 < n) {
                Entry entry = (Entry)this.fList.get(n2);
                if (entry.fPosition.equals((Object)position)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        public void put(Position position, Object object) {
            int n = this.getIndex(position);
            if (n == -1) {
                Entry entry = new Entry();
                entry.fPosition = position;
                entry.fValue = object;
                this.fList.add(entry);
            } else {
                Entry entry = (Entry)this.fList.get(n);
                entry.fValue = object;
            }
        }

        public void remove(Position position) {
            int n = this.getIndex(position);
            if (n > -1) {
                this.fList.remove(n);
            }
        }

        public void clear() {
            this.fList.clear();
        }

        static class Entry {
            Position fPosition;
            Object fValue;

            Entry() {
            }
        }
    }

    protected static class RubyScriptAnnotationModel
    extends ResourceMarkerAnnotationModel
    implements IProblemRequestor,
    IProblemRequestorExtension {
        private ThreadLocal fProblemRequestorState = new ThreadLocal();
        private int fStateCount = 0;
        private IRubyScript fRubyScript;
        private List fGeneratedAnnotations;
        private IProgressMonitor fProgressMonitor;
        private boolean fIsActive = false;
        private boolean fIsHandlingTemporaryProblems;
        private ReverseMap fReverseMap = new ReverseMap();
        private List fPreviouslyOverlaid = null;
        private List fCurrentlyOverlaid = new ArrayList();

        public RubyScriptAnnotationModel(IResource iResource) {
            super(iResource);
        }

        public void setRubyScript(IRubyScript iRubyScript) {
            this.fRubyScript = iRubyScript;
        }

        protected MarkerAnnotation createMarkerAnnotation(IMarker iMarker) {
            String string = MarkerUtilities.getMarkerType((IMarker)iMarker);
            if (string != null && string.startsWith("org.rubypeople.rdt")) {
                return new RubyMarkerAnnotation(iMarker);
            }
            return super.createMarkerAnnotation(iMarker);
        }

        protected AnnotationModelEvent createAnnotationModelEvent() {
            return new RubyScriptAnnotationModelEvent((IAnnotationModel)this, this.getResource());
        }

        protected Position createPositionFromProblem(IProblem iProblem) {
            int n = iProblem.getSourceStart();
            if (n < 0) {
                return null;
            }
            int n2 = iProblem.getSourceEnd() - iProblem.getSourceStart() + 1;
            if (n2 < 0) {
                return null;
            }
            return new Position(n, n2);
        }

        public void beginReporting() {
            ProblemRequestorState problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (problemRequestorState == null) {
                this.internalBeginReporting(false);
            }
        }

        public void beginReportingSequence() {
            ProblemRequestorState problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (problemRequestorState == null) {
                this.internalBeginReporting(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalBeginReporting(boolean bl) {
            if (this.fRubyScript != null) {
                ProblemRequestorState problemRequestorState = new ProblemRequestorState();
                problemRequestorState.fInsideReportingSequence = bl;
                problemRequestorState.fReportedProblems = new ArrayList();
                Object object = this.getLockObject();
                synchronized (object) {
                    this.fProblemRequestorState.set(problemRequestorState);
                    ++this.fStateCount;
                }
            }
        }

        public void acceptProblem(IProblem iProblem) {
            ProblemRequestorState problemRequestorState;
            if (this.fIsHandlingTemporaryProblems && (problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get()) != null) {
                problemRequestorState.fReportedProblems.add(iProblem);
            }
        }

        public void endReporting() {
            ProblemRequestorState problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (problemRequestorState != null && !problemRequestorState.fInsideReportingSequence) {
                this.internalEndReporting(problemRequestorState);
            }
        }

        public void endReportingSequence() {
            ProblemRequestorState problemRequestorState = (ProblemRequestorState)this.fProblemRequestorState.get();
            if (problemRequestorState != null && problemRequestorState.fInsideReportingSequence) {
                this.internalEndReporting(problemRequestorState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void internalEndReporting(ProblemRequestorState problemRequestorState) {
            int n = 0;
            Object object = this.getLockObject();
            synchronized (object) {
                --this.fStateCount;
                n = this.fStateCount;
                this.fProblemRequestorState.set(null);
            }
            if (n == 0 && this.fIsHandlingTemporaryProblems) {
                this.reportProblems(problemRequestorState.fReportedProblems);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reportProblems(List list) {
            if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                return;
            }
            boolean bl = false;
            Object object = this.getLockObject();
            synchronized (object) {
                boolean bl2 = false;
                this.fPreviouslyOverlaid = this.fCurrentlyOverlaid;
                this.fCurrentlyOverlaid = new ArrayList();
                if (this.fGeneratedAnnotations.size() > 0) {
                    bl = true;
                    this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                    this.fGeneratedAnnotations.clear();
                }
                if (list != null && list.size() > 0) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
                            bl2 = true;
                            break;
                        }
                        IProblem iProblem = (IProblem)iterator.next();
                        Position position = this.createPositionFromProblem(iProblem);
                        if (position == null) continue;
                        try {
                            ProblemAnnotation problemAnnotation = new ProblemAnnotation(iProblem, this.fRubyScript);
                            this.overlayMarkers(position, problemAnnotation);
                            this.addAnnotation(problemAnnotation, position, false);
                            this.fGeneratedAnnotations.add(problemAnnotation);
                            bl = true;
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                }
                this.removeMarkerOverlays(bl2);
                this.fPreviouslyOverlaid = null;
            }
            if (bl) {
                this.fireModelChanged();
            }
        }

        private void removeMarkerOverlays(boolean bl) {
            if (bl) {
                this.fCurrentlyOverlaid.addAll(this.fPreviouslyOverlaid);
            } else if (this.fPreviouslyOverlaid != null) {
                Iterator iterator = this.fPreviouslyOverlaid.iterator();
                while (iterator.hasNext()) {
                    RubyMarkerAnnotation rubyMarkerAnnotation = (RubyMarkerAnnotation)iterator.next();
                    rubyMarkerAnnotation.setOverlay(null);
                }
            }
        }

        private void setOverlay(Object object, ProblemAnnotation problemAnnotation) {
            RubyMarkerAnnotation rubyMarkerAnnotation;
            if (object instanceof RubyMarkerAnnotation && (rubyMarkerAnnotation = (RubyMarkerAnnotation)object).isProblem()) {
                rubyMarkerAnnotation.setOverlay(problemAnnotation);
                this.fPreviouslyOverlaid.remove(rubyMarkerAnnotation);
                this.fCurrentlyOverlaid.add(rubyMarkerAnnotation);
            }
        }

        private void overlayMarkers(Position position, ProblemAnnotation problemAnnotation) {
            Object object = this.getAnnotations(position);
            if (object instanceof List) {
                List list = (List)object;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.setOverlay(iterator.next(), problemAnnotation);
                }
            } else {
                this.setOverlay(object, problemAnnotation);
            }
        }

        private void startCollectingProblems() {
            this.fGeneratedAnnotations = new ArrayList();
        }

        private void stopCollectingProblems() {
            if (this.fGeneratedAnnotations != null) {
                this.removeAnnotations(this.fGeneratedAnnotations, true, true);
            }
            this.fGeneratedAnnotations = null;
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
            this.fProgressMonitor = iProgressMonitor;
        }

        public void setIsActive(boolean bl) {
            this.fIsActive = bl;
        }

        public void setIsHandlingTemporaryProblems(boolean bl) {
            if (this.fIsHandlingTemporaryProblems != bl) {
                this.fIsHandlingTemporaryProblems = bl;
                if (this.fIsHandlingTemporaryProblems) {
                    this.startCollectingProblems();
                } else {
                    this.stopCollectingProblems();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object getAnnotations(Position position) {
            Object object = this.getLockObject();
            synchronized (object) {
                return this.fReverseMap.get(position);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addAnnotation(Annotation annotation, Position position, boolean bl) throws BadLocationException {
            super.addAnnotation(annotation, position, bl);
            Object object = this.getLockObject();
            synchronized (object) {
                Object object2 = this.fReverseMap.get(position);
                if (object2 == null) {
                    this.fReverseMap.put(position, annotation);
                } else if (object2 instanceof List) {
                    List list = (List)object2;
                    list.add(annotation);
                } else if (object2 instanceof Annotation) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(2);
                    arrayList.add(object2);
                    arrayList.add(annotation);
                    this.fReverseMap.put(position, arrayList);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAllAnnotations(boolean bl) {
            super.removeAllAnnotations(bl);
            Object object = this.getLockObject();
            synchronized (object) {
                this.fReverseMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAnnotation(Annotation annotation, boolean bl) {
            Position position = this.getPosition(annotation);
            Object object = this.getLockObject();
            synchronized (object) {
                Object object2 = this.fReverseMap.get(position);
                if (object2 instanceof List) {
                    List list = (List)object2;
                    list.remove(annotation);
                    if (list.size() == 1) {
                        this.fReverseMap.put(position, list.get(0));
                        list.clear();
                    }
                } else if (object2 instanceof Annotation) {
                    this.fReverseMap.remove(position);
                }
            }
            super.removeAnnotation(annotation, bl);
        }

        private static class ProblemRequestorState {
            boolean fInsideReportingSequence = false;
            List fReportedProblems;

            ProblemRequestorState() {
            }
        }
    }
}

