/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.help.WorkbenchHelp;
import org.osgi.service.prefs.BackingStoreException;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.preferences.MockupPreferenceStore;
import org.rubypeople.rdt.internal.ui.preferences.ScrolledPageContent;
import org.rubypeople.rdt.internal.ui.wizards.IStatusChangeListener;

public abstract class OptionsConfigurationBlock {
    private Map fWorkingValues;
    protected final ArrayList fCheckBoxes;
    protected final ArrayList fComboBoxes;
    protected final ArrayList fTextBoxes;
    protected final HashMap fLabels;
    protected final ArrayList fExpandedComposites;
    private SelectionListener fSelectionListener;
    private ModifyListener fTextModifyListener;
    protected IStatusChangeListener fContext;
    protected final IProject fProject;
    protected final Key[] fAllKeys;
    private IScopeContext[] fLookupOrder;
    private Shell fShell;

    public OptionsConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, Key[] keyArray) {
        this.fContext = iStatusChangeListener;
        this.fProject = iProject;
        this.fAllKeys = keyArray;
        this.fLookupOrder = this.fProject != null ? new IScopeContext[]{new ProjectScope(this.fProject), new InstanceScope(), new DefaultScope()} : new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        this.fWorkingValues = this.getOptions();
        this.testIfOptionsComplete(this.fWorkingValues, keyArray);
        this.fCheckBoxes = new ArrayList();
        this.fComboBoxes = new ArrayList();
        this.fTextBoxes = new ArrayList(2);
        this.fLabels = new HashMap();
        this.fExpandedComposites = new ArrayList();
    }

    protected static Key getKey(String string, String string2) {
        return new Key(string, string2);
    }

    protected static final Key getJDTCoreKey(String string) {
        return OptionsConfigurationBlock.getKey("org.rubypeople.rdt.core", string);
    }

    protected static final Key getJDTUIKey(String string) {
        return OptionsConfigurationBlock.getKey("org.rubypeople.rdt.ui", string);
    }

    private void testIfOptionsComplete(Map map, Key[] keyArray) {
        int n = 0;
        while (n < keyArray.length) {
            if (map.get(keyArray[n]) == null) {
                RubyCore.log((String)("preference option missing: " + keyArray[n] + " (" + this.getClass().getName() + ')'));
            }
            ++n;
        }
    }

    protected Map getOptions() {
        HashMap<Key, String> hashMap = new HashMap<Key, String>();
        int n = 0;
        while (n < this.fAllKeys.length) {
            Key key = this.fAllKeys[n];
            hashMap.put(key, key.getStoredValue(this.fLookupOrder));
            ++n;
        }
        return hashMap;
    }

    protected Map getDefaultOptions() {
        HashMap<Key, String> hashMap = new HashMap<Key, String>();
        DefaultScope defaultScope = new DefaultScope();
        int n = 0;
        while (n < this.fAllKeys.length) {
            Key key = this.fAllKeys[n];
            hashMap.put(key, key.getStoredValue((IScopeContext)defaultScope));
            ++n;
        }
        return hashMap;
    }

    public final boolean hasProjectSpecificOptions() {
        if (this.fProject != null) {
            ProjectScope projectScope = new ProjectScope(this.fProject);
            Key[] keyArray = this.fAllKeys;
            int n = 0;
            while (n < keyArray.length) {
                if (keyArray[n].getStoredValue((IScopeContext)projectScope) != null) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    protected Shell getShell() {
        return this.fShell;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected abstract Control createContents(Composite var1);

    protected Button addCheckBox(Composite composite, String string, Key key, String[] stringArray, int n) {
        ControlData controlData = new ControlData(key, stringArray);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = n;
        Button button = new Button(composite, 32);
        button.setText(string);
        button.setData((Object)controlData);
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(this.getSelectionListener());
        this.makeScrollableCompositeAware((Control)button);
        String string2 = this.getValue(key);
        button.setSelection(controlData.getSelection(string2) == 0);
        this.fCheckBoxes.add(button);
        return button;
    }

    protected Combo addComboBox(Composite composite, String string, Key key, String[] stringArray, String[] stringArray2, int n) {
        GridData gridData = new GridData(4, 2, true, false, 2, 1);
        gridData.horizontalIndent = n;
        Label label = new Label(composite, 16448);
        label.setText(string);
        label.setLayoutData((Object)gridData);
        Combo combo = this.newComboControl(composite, key, stringArray, stringArray2);
        combo.setLayoutData((Object)new GridData(256));
        this.fLabels.put(combo, label);
        return combo;
    }

    protected Combo addInversedComboBox(Composite composite, String string, Key key, String[] stringArray, String[] stringArray2, int n) {
        GridData gridData = new GridData(32);
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 3;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Combo combo = this.newComboControl(composite2, key, stringArray, stringArray2);
        combo.setLayoutData((Object)new GridData(256));
        Label label = new Label(composite2, 16448);
        label.setText(string);
        label.setLayoutData((Object)new GridData());
        this.fLabels.put(combo, label);
        return combo;
    }

    protected Combo newComboControl(Composite composite, Key key, String[] stringArray, String[] stringArray2) {
        ControlData controlData = new ControlData(key, stringArray);
        Combo combo = new Combo(composite, 8);
        combo.setItems(stringArray2);
        combo.setData((Object)controlData);
        combo.addSelectionListener(this.getSelectionListener());
        this.makeScrollableCompositeAware((Control)combo);
        String string = this.getValue(key);
        combo.select(controlData.getSelection(string));
        this.fComboBoxes.add(combo);
        return combo;
    }

    protected Text addTextField(Composite composite, String string, Key key, int n, int n2) {
        Label label = new Label(composite, 64);
        label.setText(string);
        label.setLayoutData((Object)new GridData());
        Text text = new Text(composite, 2052);
        text.setData((Object)key);
        text.setLayoutData((Object)new GridData());
        this.makeScrollableCompositeAware((Control)text);
        this.fLabels.put(text, label);
        String string2 = this.getValue(key);
        if (string2 != null) {
            text.setText(string2);
        }
        text.addModifyListener(this.getTextModifyListener());
        GridData gridData = new GridData(256);
        if (n2 != 0) {
            gridData.widthHint = n2;
        }
        gridData.horizontalIndent = n;
        gridData.horizontalSpan = 2;
        text.setLayoutData((Object)gridData);
        this.fTextBoxes.add(text);
        return text;
    }

    protected ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ScrolledPageContent) && composite != null) {
            composite = composite.getParent();
        }
        if (composite instanceof ScrolledPageContent) {
            return (ScrolledPageContent)composite;
        }
        return null;
    }

    private void makeScrollableCompositeAware(Control control) {
        ScrolledPageContent scrolledPageContent = this.getParentScrolledComposite(control);
        if (scrolledPageContent != null) {
            scrolledPageContent.adaptChild(control);
        }
    }

    protected ExpandableComposite createStyleSection(Composite composite, String string, int n) {
        final ExpandableComposite expandableComposite = new ExpandableComposite(composite, 0, 18);
        expandableComposite.setText(string);
        expandableComposite.setExpanded(false);
        expandableComposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        expandableComposite.setLayoutData((Object)new GridData(4, 4, true, false, n, 1));
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                OptionsConfigurationBlock.this.updateSectionStyle((ExpandableComposite)expansionEvent.getSource());
                ScrolledPageContent scrolledPageContent = OptionsConfigurationBlock.this.getParentScrolledComposite((Control)expandableComposite);
                if (scrolledPageContent != null) {
                    scrolledPageContent.reflow(true);
                }
            }
        });
        this.updateSectionStyle(expandableComposite);
        this.fExpandedComposites.add(expandableComposite);
        return expandableComposite;
    }

    protected void updateSectionStyle(ExpandableComposite expandableComposite) {
        if (expandableComposite.isExpanded()) {
            int n = 0;
            while (n < this.fExpandedComposites.size()) {
                ExpandableComposite expandableComposite2 = (ExpandableComposite)this.fExpandedComposites.get(n);
                if (expandableComposite2 != expandableComposite && expandableComposite.isExpanded()) {
                    expandableComposite2.setExpanded(false);
                }
                ++n;
            }
        }
    }

    protected ImageHyperlink createHelpLink(Composite composite, final String string) {
        ImageHyperlink imageHyperlink = new ImageHyperlink(composite, 0);
        this.makeScrollableCompositeAware((Control)imageHyperlink);
        Image image = RubyPluginImages.get("org.rubypeople.rdt.ui.help.gif");
        imageHyperlink.setImage(image);
        imageHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                WorkbenchHelp.displayHelpResource((String)string);
            }
        });
        return imageHyperlink;
    }

    protected SelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    OptionsConfigurationBlock.this.controlChanged(selectionEvent.widget);
                }
            };
        }
        return this.fSelectionListener;
    }

    protected ModifyListener getTextModifyListener() {
        if (this.fTextModifyListener == null) {
            this.fTextModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    OptionsConfigurationBlock.this.textChanged((Text)modifyEvent.widget);
                }
            };
        }
        return this.fTextModifyListener;
    }

    protected void controlChanged(Widget widget) {
        ControlData controlData = (ControlData)widget.getData();
        String string = null;
        if (widget instanceof Button) {
            string = controlData.getValue(((Button)widget).getSelection());
        } else if (widget instanceof Combo) {
            string = controlData.getValue(((Combo)widget).getSelectionIndex());
        } else {
            return;
        }
        String string2 = this.setValue(controlData.getKey(), string);
        this.validateSettings(controlData.getKey(), string2, string);
    }

    protected void textChanged(Text text) {
        Key key = (Key)text.getData();
        String string = text.getText();
        String string2 = this.setValue(key, string);
        this.validateSettings(key, string2, string);
    }

    protected boolean checkValue(Key key, String string) {
        return string.equals(this.getValue(key));
    }

    protected String getValue(Key key) {
        return (String)this.fWorkingValues.get(key);
    }

    protected boolean getBooleanValue(Key key) {
        return Boolean.valueOf(this.getValue(key));
    }

    protected String setValue(Key key, String string) {
        return this.fWorkingValues.put(key, string);
    }

    protected String setValue(Key key, boolean bl) {
        return this.setValue(key, String.valueOf(bl));
    }

    protected abstract void validateSettings(Key var1, String var2, String var3);

    protected String[] getTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = stringTokenizer.nextToken().trim();
            ++n2;
        }
        return stringArray;
    }

    private boolean hasChanges(IScopeContext iScopeContext, boolean bl) {
        int n = 0;
        while (n < this.fAllKeys.length) {
            Key key = this.fAllKeys[n];
            String string = key.getStoredValue(iScopeContext);
            String string2 = null;
            if (bl ? (string2 = this.getValue(key)) != null && !string2.equals(string) : string != null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean performOk(boolean bl) {
        Object object;
        MockupPreferenceStore mockupPreferenceStore;
        IScopeContext iScopeContext = this.fLookupOrder[0];
        boolean bl2 = this.hasChanges(iScopeContext, bl);
        if (!bl2) {
            return true;
        }
        boolean bl3 = false;
        String[] stringArray = this.getFullBuildDialogStrings(this.fProject == null);
        if (stringArray != null) {
            mockupPreferenceStore = new MessageDialog(this.getShell(), stringArray[0], null, stringArray[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int n = mockupPreferenceStore.open();
            if (n == 0) {
                bl3 = true;
            } else if (n != 1) {
                return false;
            }
        }
        mockupPreferenceStore = RubyPlugin.getDefault().getMockupPreferenceStore();
        Key[] keyArray = this.fAllKeys;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < keyArray.length) {
            object = keyArray[n];
            String string = ((Key)object).getStoredValue(iScopeContext);
            if (bl) {
                String string2 = this.getValue((Key)object);
                if (string2 != null && !string2.equals(string)) {
                    ((Key)object).setStoredValue(iScopeContext, string2);
                    if (this.fProject != null) {
                        mockupPreferenceStore.firePropertyChangeEvent(this.fProject, ((Key)object).getName(), string, string2);
                    }
                }
            } else if (string != null) {
                ((Key)object).removeFromStore(iScopeContext);
                if (this.fProject != null) {
                    mockupPreferenceStore.firePropertyChangeEvent(this.fProject, ((Key)object).getName(), string, null);
                }
            }
            arrayList.add(((Key)object).getQualifier());
            ++n;
        }
        n = 0;
        while (n < arrayList.size()) {
            try {
                object = (String)arrayList.get(n);
                iScopeContext.getNode((String)object).flush();
            }
            catch (BackingStoreException backingStoreException) {
                RubyCore.log((Exception)((Object)backingStoreException));
            }
            ++n;
        }
        return !bl3 || (n = (int)(this.doFullBuild() ? 1 : 0)) != 0;
    }

    protected abstract String[] getFullBuildDialogStrings(boolean var1);

    protected boolean doFullBuild() {
        return true;
    }

    public void performDefaults() {
        this.fWorkingValues = this.getDefaultOptions();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void performRevert() {
        this.fWorkingValues = this.getOptions();
        this.updateControls();
        this.validateSettings(null, null, null);
    }

    public void dispose() {
    }

    protected void updateControls() {
        int n = this.fCheckBoxes.size() - 1;
        while (n >= 0) {
            this.updateCheckBox((Button)this.fCheckBoxes.get(n));
            --n;
        }
        n = this.fComboBoxes.size() - 1;
        while (n >= 0) {
            this.updateCombo((Combo)this.fComboBoxes.get(n));
            --n;
        }
        n = this.fTextBoxes.size() - 1;
        while (n >= 0) {
            this.updateText((Text)this.fTextBoxes.get(n));
            --n;
        }
    }

    protected void updateCombo(Combo combo) {
        ControlData controlData = (ControlData)combo.getData();
        String string = this.getValue(controlData.getKey());
        combo.select(controlData.getSelection(string));
    }

    protected void updateCheckBox(Button button) {
        String string;
        ControlData controlData = (ControlData)button.getData();
        button.setSelection(controlData.getSelection(string = this.getValue(controlData.getKey())) == 0);
    }

    protected void updateText(Text text) {
        Key key = (Key)text.getData();
        String string = this.getValue(key);
        if (string != null) {
            text.setText(string);
        }
    }

    protected Button getCheckBox(Key key) {
        int n = this.fCheckBoxes.size() - 1;
        while (n >= 0) {
            Button button = (Button)this.fCheckBoxes.get(n);
            ControlData controlData = (ControlData)button.getData();
            if (key.equals(controlData.getKey())) {
                return button;
            }
            --n;
        }
        return null;
    }

    protected Combo getComboBox(Key key) {
        int n = this.fComboBoxes.size() - 1;
        while (n >= 0) {
            Combo combo = (Combo)this.fComboBoxes.get(n);
            ControlData controlData = (ControlData)combo.getData();
            if (key.equals(controlData.getKey())) {
                return combo;
            }
            --n;
        }
        return null;
    }

    protected void setComboEnabled(Key key, boolean bl) {
        Combo combo = this.getComboBox(key);
        Label label = (Label)this.fLabels.get(combo);
        combo.setEnabled(bl);
        label.setEnabled(bl);
    }

    public static final class Key {
        private String fQualifier;
        private String fKey;

        public Key(String string, String string2) {
            this.fQualifier = string;
            this.fKey = string2;
        }

        public String getName() {
            return this.fKey;
        }

        public String getStoredValue(IScopeContext iScopeContext) {
            return iScopeContext.getNode(this.fQualifier).get(this.fKey, null);
        }

        public String getStoredValue(IScopeContext[] iScopeContextArray) {
            int n = 0;
            while (n < iScopeContextArray.length) {
                String string = this.getStoredValue(iScopeContextArray[n]);
                if (string != null) {
                    return string;
                }
                ++n;
            }
            return null;
        }

        public void setStoredValue(IScopeContext iScopeContext, String string) {
            iScopeContext.getNode(this.fQualifier).put(this.fKey, string);
        }

        public void removeFromStore(IScopeContext iScopeContext) {
            iScopeContext.getNode(this.fQualifier).remove(this.fKey);
        }

        public String toString() {
            return String.valueOf(this.fQualifier) + '/' + this.fKey;
        }

        public String getQualifier() {
            return this.fQualifier;
        }
    }

    protected static class ControlData {
        private Key fKey;
        private String[] fValues;

        public ControlData(Key key, String[] stringArray) {
            this.fKey = key;
            this.fValues = stringArray;
        }

        public Key getKey() {
            return this.fKey;
        }

        public String getValue(boolean bl) {
            int n = bl ? 0 : 1;
            return this.fValues[n];
        }

        public String getValue(int n) {
            return this.fValues[n];
        }

        public int getSelection(String string) {
            if (string != null) {
                int n = 0;
                while (n < this.fValues.length) {
                    if (string.equals(this.fValues[n])) {
                        return n;
                    }
                    ++n;
                }
            }
            return this.fValues.length - 1;
        }
    }
}

