/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.dialogs;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.rubypeople.rdt.internal.ui.JDTOriginally;
import org.rubypeople.rdt.internal.ui.dialogs.MessageLine;

public abstract class SelectionStatusDialog
extends SelectionDialog
implements JDTOriginally {
    private MessageLine fStatusLine;
    private IStatus fLastStatus;
    private Image fImage;
    private boolean fStatusLineAboveButtons = false;

    public SelectionStatusDialog(Shell shell) {
        super(shell);
    }

    public void setStatusLineAboveButtons(boolean bl) {
        this.fStatusLineAboveButtons = bl;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public Object getFirstResult() {
        Object[] objectArray = this.getResult();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return objectArray[0];
    }

    protected void setResult(int n, Object object) {
        Object[] objectArray = this.getResult();
        objectArray[n] = object;
        this.setResult(Arrays.asList(objectArray));
    }

    protected abstract void computeResult();

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fImage != null) {
            shell.setImage(this.fImage);
        }
    }

    protected void updateStatus(IStatus iStatus) {
        this.fLastStatus = iStatus;
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(iStatus);
            this.fStatusLine.setErrorStatus(iStatus);
        }
    }

    protected void updateButtonsEnableState(IStatus iStatus) {
        Button button = this.getOkButton();
        if (button != null && !button.isDisposed()) {
            button.setEnabled(!iStatus.matches(4));
        }
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    public void create() {
        super.create();
        if (this.fLastStatus != null) {
            this.updateStatus(this.fLastStatus);
        }
    }

    protected Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        if (this.fStatusLineAboveButtons) {
            gridLayout.marginWidth = 5;
        } else {
            gridLayout.numColumns = 2;
        }
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(768));
        this.fStatusLine = new MessageLine(composite2);
        this.fStatusLine.setAlignment(16384);
        this.fStatusLine.setLayoutData(new GridData(768));
        this.fStatusLine.setErrorStatus(null);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = this.convertWidthInCharsToPixels(1);
        this.fStatusLine.setLayoutData(gridData);
        super.createButtonBar(composite2);
        return composite2;
    }
}

