/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.browsing;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.RubyUI;

public class RubyBrowsingPerspectiveFactory
implements IPerspectiveFactory {
    static IRubyElement fgRubyElementFromAction;

    public void createInitialLayout(IPageLayout iPageLayout) {
        if (this.stackBrowsingViewsVertically()) {
            this.createVerticalLayout(iPageLayout);
        } else {
            this.createHorizontalLayout(iPageLayout);
        }
        iPageLayout.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
        iPageLayout.addActionSet(RubyUI.ID_ACTION_SET);
        iPageLayout.addActionSet("org.rubypeople.rdt.ui.RubyElementCreationActionSet");
        iPageLayout.addActionSet("org.eclipse.ui.NavigateActionSet");
        iPageLayout.addShowViewShortcut(RubyUI.ID_PROJECTS_VIEW);
        iPageLayout.addShowViewShortcut(RubyUI.ID_TYPES_VIEW);
        iPageLayout.addShowViewShortcut(RubyUI.ID_MEMBERS_VIEW);
        iPageLayout.addShowViewShortcut("org.eclipse.search.ui.views.SearchView");
        iPageLayout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
        iPageLayout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        iPageLayout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        iPageLayout.addShowViewShortcut("org.eclipse.ui.views.ResourceNavigator");
        iPageLayout.addNewWizardShortcut("org.rubypeople.rdt.ui.wizards.NewProjectCreationWizard");
        iPageLayout.addNewWizardShortcut("org.rubypeople.rdt.ui.wizards.NewClassCreationWizard");
        iPageLayout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        iPageLayout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
        iPageLayout.addNewWizardShortcut("org.eclipse.ui.editors.wizards.UntitledTextFileWizard");
    }

    private void createVerticalLayout(IPageLayout iPageLayout) {
        String string = "org.eclipse.ui.editorss";
        int n = 1;
        IPlaceholderFolderLayout iPlaceholderFolderLayout = iPageLayout.createPlaceholderFolder("left", 1, 0.25f, "org.eclipse.ui.editorss");
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.ui.views.ContentOutline");
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.ui.views.ResourceNavigator");
        if (this.shouldShowProjectsView()) {
            iPageLayout.addView(RubyUI.ID_PROJECTS_VIEW, 1, 0.25f, "org.eclipse.ui.editorss");
            string = RubyUI.ID_PROJECTS_VIEW;
            n = 4;
        }
        iPageLayout.addView(RubyUI.ID_TYPES_VIEW, n, 0.33f, string);
        iPageLayout.addView(RubyUI.ID_MEMBERS_VIEW, 4, 0.5f, RubyUI.ID_TYPES_VIEW);
        IPlaceholderFolderLayout iPlaceholderFolderLayout2 = iPageLayout.createPlaceholderFolder("bottom", 4, 0.75f, "org.eclipse.ui.editorss");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.ui.views.ProblemView");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.ui.console.ConsoleView");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.ui.views.ProgressView");
    }

    private void createHorizontalLayout(IPageLayout iPageLayout) {
        String string = "org.eclipse.ui.editorss";
        int n = 3;
        if (this.shouldShowProjectsView()) {
            iPageLayout.addView(RubyUI.ID_PROJECTS_VIEW, 3, 0.25f, "org.eclipse.ui.editorss");
            string = RubyUI.ID_PROJECTS_VIEW;
            n = 2;
        }
        iPageLayout.addView(RubyUI.ID_TYPES_VIEW, n, 0.33f, string);
        iPageLayout.addView(RubyUI.ID_MEMBERS_VIEW, 2, 0.5f, RubyUI.ID_TYPES_VIEW);
        IPlaceholderFolderLayout iPlaceholderFolderLayout = iPageLayout.createPlaceholderFolder("left", 1, 0.25f, "org.eclipse.ui.editorss");
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.ui.views.ContentOutline");
        iPlaceholderFolderLayout.addPlaceholder("org.eclipse.ui.views.ResourceNavigator");
        IPlaceholderFolderLayout iPlaceholderFolderLayout2 = iPageLayout.createPlaceholderFolder("bottom", 4, 0.75f, "org.eclipse.ui.editorss");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.ui.views.ProblemView");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.ui.console.ConsoleView");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        iPlaceholderFolderLayout2.addPlaceholder("org.eclipse.ui.views.ProgressView");
    }

    private boolean shouldShowProjectsView() {
        return fgRubyElementFromAction == null || fgRubyElementFromAction.getElementType() == 0;
    }

    private boolean stackBrowsingViewsVertically() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.rubypeople.rdt.ui.browsing.stackVertically");
    }

    static void setInputFromAction(IAdaptable iAdaptable) {
        fgRubyElementFromAction = iAdaptable instanceof IRubyElement ? (IRubyElement)iAdaptable : null;
    }
}

