/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.interproc;

import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabase;
import edu.umd.cs.findbugs.ba.interproc.PropertyDatabaseFormatException;
import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldPropertyDatabase<Property>
extends PropertyDatabase<XField, Property> {
    @Override
    protected XField parseKey(String s) throws PropertyDatabaseFormatException {
        int accessFlags;
        String[] tuple = s.split(",");
        if (tuple.length != 4) {
            throw new PropertyDatabaseFormatException(new StringBuffer().append("Invalid field tuple: ").append(s).toString());
        }
        String className = XFactory.canonicalizeString(tuple[0]);
        String fieldName = XFactory.canonicalizeString(tuple[1]);
        String signature = XFactory.canonicalizeString(tuple[2]);
        try {
            accessFlags = Integer.parseInt(tuple[3]);
        }
        catch (NumberFormatException e) {
            throw new PropertyDatabaseFormatException(new StringBuffer().append("Invalid field access flags: ").append(tuple[3]).toString());
        }
        return XFactory.createXField(className, fieldName, signature, accessFlags);
    }

    @Override
    protected void writeKey(Writer writer, XField key) throws IOException {
        writer.write(key.getClassName());
        writer.write(",");
        writer.write(key.getName());
        writer.write(",");
        writer.write(key.getSignature());
        writer.write(",");
        writer.write(String.valueOf(key.getAccessFlags()));
    }

    @Override
    protected /* synthetic */ void writeKey(Writer x0, ClassMember x1) throws IOException {
        this.writeKey(x0, (XField)x1);
    }

    @Override
    protected /* synthetic */ ClassMember parseKey(String x0) throws PropertyDatabaseFormatException {
        return this.parseKey(x0);
    }
}

