/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import java.util.IdentityHashMap;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

public class LineNumberMap {
    private static final boolean DEBUG = SystemProperties.getBoolean("lnm.debug");
    private static final boolean LINE_NUMBER_BUG = SystemProperties.getBoolean("lineNumberBug");
    private MethodGen methodGen;
    private IdentityHashMap<InstructionHandle, LineNumber> lineNumberMap;
    private boolean hasLineNumbers;

    public LineNumberMap(MethodGen methodGen) {
        this.methodGen = methodGen;
        this.lineNumberMap = new IdentityHashMap();
        this.hasLineNumbers = false;
    }

    public void build() {
        LineNumberTable table;
        int numGood = 0;
        int numBytecodes = 0;
        if (DEBUG) {
            System.out.println("Method: " + this.methodGen.getName() + " - " + this.methodGen.getSignature() + "in class " + this.methodGen.getClassName());
        }
        if ((table = this.methodGen.getLineNumberTable(this.methodGen.getConstantPool())) != null && table.getTableLength() > 0) {
            this.checkTable(table);
            InstructionHandle handle = this.methodGen.getInstructionList().getStart();
            while (handle != null) {
                int sourceLine;
                int bytecodeOffset = handle.getPosition();
                if (bytecodeOffset < 0) {
                    throw new IllegalStateException("Bad bytecode offset: " + bytecodeOffset);
                }
                if (DEBUG) {
                    System.out.println("Looking for source line for bytecode offset " + bytecodeOffset);
                }
                try {
                    sourceLine = table.getSourceLine(bytecodeOffset);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (LINE_NUMBER_BUG) {
                        throw e;
                    }
                    sourceLine = -1;
                }
                if (sourceLine >= 0) {
                    ++numGood;
                }
                this.lineNumberMap.put(handle, new LineNumber(bytecodeOffset, sourceLine));
                handle = handle.getNext();
                ++numBytecodes;
            }
            this.hasLineNumbers = true;
            if (DEBUG) {
                System.out.println("\t" + numGood + "/" + numBytecodes + " had valid line numbers");
            }
        }
    }

    private void checkTable(LineNumberTable table) {
        if (DEBUG) {
            System.out.println("line number table has length " + table.getTableLength());
        }
        LineNumber[] entries = table.getLineNumberTable();
        int lastBytecode = -1;
        for (int i = 0; i < entries.length; ++i) {
            int pc;
            LineNumber ln = entries[i];
            if (DEBUG) {
                System.out.println("Entry " + i + ": pc=" + ln.getStartPC() + ", line=" + ln.getLineNumber());
            }
            if ((pc = ln.getStartPC()) > lastBytecode) continue;
            throw new IllegalStateException("LineNumberTable is not sorted");
        }
    }

    public boolean hasLineNumbers() {
        return this.hasLineNumbers;
    }

    public LineNumber lookupLineNumber(InstructionHandle handle) {
        return this.lineNumberMap.get(handle);
    }
}

