/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.actions;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.actions.PerlEditorAction;
import org.epic.perleditor.editors.PerlEditor;
import org.epic.perleditor.editors.util.SourceFormatter;

public class ExportHtmlSourceAction
extends PerlEditorAction {
    private static String lastSelectedDir;

    public ExportHtmlSourceAction(PerlEditor editor) {
        super(editor);
    }

    protected void doRun() {
        PerlEditor editor = this.getEditor();
        IFileEditorInput editorInput = (IFileEditorInput)editor.getEditorInput();
        String filePath = editorInput.getFile().getLocation().makeAbsolute().toString();
        DirectoryDialog directoryDialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        directoryDialog.setText("Select Output Directory");
        directoryDialog.setMessage("HTML Export...");
        directoryDialog.setFilterPath(lastSelectedDir);
        String outputDir = directoryDialog.open();
        if (outputDir != null) {
            lastSelectedDir = outputDir;
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("-html");
            cmdList.add("-opath");
            cmdList.add(outputDir);
            IPreferenceStore store = PerlEditorPlugin.getDefault().getPreferenceStore();
            StringTokenizer st = new StringTokenizer(store.getString("Formatter.htmlExportOptions"));
            while (st.hasMoreTokens()) {
                cmdList.add(st.nextToken());
            }
            cmdList.add(filePath);
            SourceFormatter.format(editor.getViewer().getDocument().get(), cmdList, this.getLog());
        }
    }

    protected String getPerlEditorActionId() {
        return "org.epic.perleditor.actions.ExportHtmlAction";
    }
}

